/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.undoredo;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOWrapperOwner;
import com.mathworks.toolbox.matlab.guide.undoredo.LayoutUndoableEdit;
import java.awt.Point;
import java.util.List;
import java.util.Vector;

public class UndoMove
extends LayoutUndoableEdit {
    private LayoutArea fLayout;
    private int fNumWrappers;
    private LOControlWrapper[] fWrappers;
    private Point[] fStartLocations;
    private Point[] fFinalLocations;
    private LOWrapperOwner[] fStartOwners;
    private int[] fStartIndexs;
    private LOWrapperOwner[] fFinalOwners;
    private Object[] fOldValues;
    private Object[] fNewValues;

    public UndoMove(LayoutArea layoutArea, List<?> list) {
        this.fLayout = layoutArea;
        this.fNumWrappers = list.size();
        this.fWrappers = new LOControlWrapper[this.fNumWrappers];
        this.fStartLocations = new Point[this.fNumWrappers];
        this.fFinalLocations = new Point[this.fNumWrappers];
        this.fStartOwners = new LOWrapperOwner[this.fNumWrappers];
        this.fStartIndexs = new int[this.fNumWrappers];
        this.fFinalOwners = new LOWrapperOwner[this.fNumWrappers];
        this.fOldValues = new Object[this.fNumWrappers];
        this.fNewValues = new Object[this.fNumWrappers];
        for (int i = 0; i < this.fNumWrappers; ++i) {
            this.fWrappers[i] = (LOControlWrapper)list.get(i);
            this.fStartLocations[i] = this.fWrappers[i].getControl().getLocation();
            this.fStartOwners[i] = this.fWrappers[i].getParent();
            if (this.fStartOwners[i] == null) {
                this.fStartOwners[i] = this.fLayout;
            }
            this.fStartIndexs[i] = this.fStartOwners[i].getIndexOfWrapper(this.fWrappers[i]);
            if (!this.fWrappers[i].isGObject()) continue;
            this.fOldValues[i] = ((GObjectWrapper)this.fWrappers[i]).getProperties();
        }
    }

    public boolean moveComplete() {
        boolean bl = false;
        for (int i = 0; i < this.fNumWrappers; ++i) {
            this.fFinalLocations[i] = this.fWrappers[i].getControl().getLocation();
            this.fFinalOwners[i] = this.fWrappers[i].getParent();
            if (this.fFinalOwners[i] == null) {
                this.fFinalOwners[i] = this.fLayout;
            }
            if (this.fStartLocations[i].x == this.fFinalLocations[i].x && this.fStartLocations[i].y == this.fFinalLocations[i].y && this.fStartOwners[i] == this.fFinalOwners[i]) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void undo() {
        this.fLayout.selectAll(false);
        Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>();
        boolean bl = false;
        for (int i = 0; i < this.fNumWrappers; ++i) {
            if (this.fFinalOwners[i] != this.fStartOwners[i]) {
                this.fFinalOwners[i].removeWrapper(this.fWrappers[i], false);
                this.fStartOwners[i].addWrapper(this.fWrappers[i], this.fStartIndexs[i], false);
                bl = true;
            }
            this.fWrappers[i].getControl().setLocation(this.fStartLocations[i]);
            this.fLayout.selectObject(this.fWrappers[i], true);
            vector.addElement(this.fWrappers[i]);
            if (!this.fWrappers[i].isGObject()) continue;
            this.fNewValues[i] = ((GObjectWrapper)this.fWrappers[i]).getProperties();
            Object[] objectArray = (Object[])this.fOldValues[i];
            ((GObjectWrapper)this.fWrappers[i]).setProperties(objectArray);
        }
        if (this.fLayout.getFigure() != null) {
            if (bl) {
                LayoutLooper.changeParent(vector, this.fLayout, this.fStartIndexs, null);
            }
            LayoutLooper.requestMove(vector, this.fLayout);
        } else {
            this.fLayout.fireObjectChangedEvent(vector);
        }
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    public void redo() {
        this.fLayout.selectAll(false);
        Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>();
        boolean bl = false;
        for (int i = 0; i < this.fNumWrappers; ++i) {
            if (this.fFinalOwners[i] != this.fStartOwners[i]) {
                this.fStartOwners[i].removeWrapper(this.fWrappers[i], false);
                this.fFinalOwners[i].addWrapper(this.fWrappers[i], -1, false);
                bl = true;
            }
            this.fWrappers[i].getControl().setLocation(this.fFinalLocations[i]);
            this.fLayout.selectObject(this.fWrappers[i], true);
            vector.addElement(this.fWrappers[i]);
            if (!this.fWrappers[i].isGObject()) continue;
            Object[] objectArray = (Object[])this.fNewValues[i];
            ((GObjectWrapper)this.fWrappers[i]).setProperties(objectArray);
        }
        if (this.fLayout.getFigure() != null) {
            if (bl) {
                LayoutLooper.changeParent(vector, this.fLayout, null, null);
            }
            LayoutLooper.requestMove(vector, this.fLayout);
        } else {
            this.fLayout.fireObjectChangedEvent(vector);
        }
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    String getUndoTypeKey() {
        return "undo.move";
    }
}

