/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.palette;

import com.jgoodies.forms.factories.Borders;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.matlab.guide.dragdrop.DragListener;
import com.mathworks.toolbox.matlab.guide.palette.ObjectFactory;
import com.mathworks.toolbox.matlab.guide.palette.ToolPaletteButton;
import com.mathworks.toolbox.matlab.guide.palette.ToolRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;

public class ToolPalette
extends MJPanel {
    public static final int SELECT_TOOL = 0;
    private ToolRegistry fToolRegistry;
    private ToolPage fCurrentPage;
    private MJPanel fPageHolder;
    private boolean fFixedWidth = true;
    private int fStandardWidth;
    private boolean fShowNames;
    private DragListener fDragListener;

    public ToolPalette(ToolRegistry toolRegistry, boolean bl, DragListener dragListener) {
        this.fToolRegistry = toolRegistry;
        this.fShowNames = bl;
        this.fDragListener = dragListener;
        this.setLayout(new BorderLayout());
        this.fPageHolder = new PagePanel();
        this.fPageHolder.add(Box.createRigidArea(new Dimension(1, 1)), (Object)"Center");
        this.add((Component)this.fPageHolder, "Center");
        this.buildDefaultPanel();
    }

    private void buildDefaultPanel() {
        int[] nArray = this.fToolRegistry.getDefaultPage();
        this.fCurrentPage = new ToolPage(nArray, this.fShowNames, this.fDragListener);
        this.fPageHolder.add((Component)((Object)this.fCurrentPage), (Object)"North");
    }

    public Dimension getPreferredSize() {
        if (this.fFixedWidth) {
            if (this.fStandardWidth == 0) {
                Dimension dimension = super.getPreferredSize();
                this.fStandardWidth = dimension.width;
                return dimension;
            }
            return new Dimension(this.fStandardWidth, super.getPreferredSize().height);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public final int getSelectedButtonIndex() {
        return this.fCurrentPage.getToolID();
    }

    public void resetToSelectTool() {
        this.fCurrentPage.initialState();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ToolPalette.enableComponents((Container)((Object)this), bl);
    }

    private static void enableComponents(Container container, boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = container.getComponents()) {
            if (component instanceof Container) {
                ToolPalette.enableComponents((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    private static class ToolPage
    extends MJPanel
    implements ItemListener {
        private int fCurrentID;

        ToolPage(int[] nArray, boolean bl, DragListener dragListener) {
            boolean bl2;
            this.setLayout(new ToolLayout());
            this.setOpaque(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            if (bl) {
                this.add((Component)((Object)new OldToolPanel(ToolRegistry.getSpecialPage(), buttonGroup, this, null)));
            } else {
                this.add((Component)((Object)new ToolPanel(ToolRegistry.getSpecialPage(), buttonGroup, this, null)));
            }
            boolean bl3 = bl2 = nArray.length != 0;
            if (bl2) {
                this.add(Box.createRigidArea(new Dimension(4, 4)));
                if (bl) {
                    this.add((Component)((Object)new OldToolPanel(nArray, buttonGroup, this, dragListener)));
                } else {
                    this.add((Component)((Object)new ToolPanel(nArray, buttonGroup, this, dragListener)));
                }
            }
            this.initialState();
        }

        int getToolID() {
            return this.fCurrentID;
        }

        private static ToolPaletteButton findButton(Container container, int n) {
            Component[] componentArray;
            for (Component component : componentArray = container.getComponents()) {
                ToolPaletteButton toolPaletteButton;
                if (!(component instanceof ToolPaletteButton ? (toolPaletteButton = (ToolPaletteButton)((Object)component)).getID() == n : component instanceof Container && (toolPaletteButton = ToolPage.findButton((Container)component, n)) != null)) continue;
                return toolPaletteButton;
            }
            return null;
        }

        void initialState() {
            ToolPaletteButton toolPaletteButton = ToolPage.findButton((Container)((Object)this), 0);
            if (toolPaletteButton != null) {
                toolPaletteButton.setSelected(true);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                ToolPaletteButton toolPaletteButton = (ToolPaletteButton)itemEvent.getSource();
                this.fCurrentID = toolPaletteButton.getID();
            }
        }

        private static class ToolLayout
        implements LayoutManager {
            private ToolLayout() {
            }

            @Override
            public void addLayoutComponent(String string, Component component) {
            }

            @Override
            public void removeLayoutComponent(Component component) {
            }

            @Override
            public Dimension preferredLayoutSize(Container container) {
                Dimension dimension = new Dimension(0, 0);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension2 = component.getPreferredSize();
                    dimension.height += dimension2.height;
                    dimension.width = Math.max(dimension.width, dimension2.width);
                }
                return dimension;
            }

            @Override
            public Dimension minimumLayoutSize(Container container) {
                Dimension dimension = new Dimension(0, 0);
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension2 = component.getMinimumSize();
                    dimension.height += dimension2.height;
                    dimension.width = Math.max(dimension.width, dimension2.width);
                }
                return dimension;
            }

            @Override
            public void layoutContainer(Container container) {
                Dimension dimension = container.getSize();
                int n = container.getComponentCount();
                Point point = new Point(0, 0);
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension2 = component.getPreferredSize();
                    dimension2.width = dimension.width;
                    component.setLocation(point);
                    component.setSize(dimension2);
                    point.y += dimension2.height;
                }
            }
        }

        private static class OldToolPanel
        extends MJPanel {
            OldToolPanel(int[] nArray, ButtonGroup buttonGroup, ItemListener itemListener, DragListener dragListener) {
                this.setLayout(new ToolLayout());
                for (int n : nArray) {
                    if (!ToolRegistry.isPaletteEntry(n)) continue;
                    ObjectFactory objectFactory = ToolRegistry.getObjectFactory(n);
                    ImageIcon imageIcon = objectFactory.getIcon();
                    String string = ToolRegistry.getName(n);
                    ToolPaletteButton toolPaletteButton = new ToolPaletteButton(imageIcon, string, buttonGroup, n);
                    toolPaletteButton.addItemListener(itemListener);
                    toolPaletteButton.setName(string);
                    if (dragListener != null) {
                        try {
                            toolPaletteButton.addDragListener(dragListener);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    this.add((Component)((Object)toolPaletteButton));
                }
            }
        }

        private static class ToolPanel
        extends MJPanel {
            private static int kColumnCount = 2;
            private static int kMargin = 0;

            ToolPanel(int[] nArray, ButtonGroup buttonGroup, ItemListener itemListener, DragListener dragListener) {
                this.setLayout(new ColumnLayout(kColumnCount, kMargin));
                for (int n : nArray) {
                    if (!ToolRegistry.isPaletteEntry(n)) continue;
                    ObjectFactory objectFactory = ToolRegistry.getObjectFactory(n);
                    ImageIcon imageIcon = objectFactory.getIcon();
                    ToolPaletteButton toolPaletteButton = new ToolPaletteButton(imageIcon, buttonGroup, n);
                    toolPaletteButton.addItemListener(itemListener);
                    if (dragListener != null) {
                        try {
                            toolPaletteButton.addDragListener(dragListener);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    this.add((Component)((Object)toolPaletteButton));
                    toolPaletteButton.setToolTipText(ToolRegistry.getName(n));
                    toolPaletteButton.setName(ToolRegistry.getObjectFactory(n).getKey());
                }
                if ((this.getComponentCount() & 1) != 0) {
                    this.add(Box.createRigidArea(new Dimension(4, 4)));
                }
            }

            private static class ColumnLayout
            implements LayoutManager {
                private int fColumns;
                private int fMargin;

                ColumnLayout(int n, int n2) {
                    this.fColumns = n;
                    this.fMargin = n2;
                }

                @Override
                public void addLayoutComponent(String string, Component component) {
                }

                @Override
                public void removeLayoutComponent(Component component) {
                }

                @Override
                public Dimension preferredLayoutSize(Container container) {
                    Dimension dimension = new Dimension(0, 0);
                    int n = container.getComponentCount();
                    if (n > 0) {
                        Component component = container.getComponent(0);
                        Dimension dimension2 = component.getPreferredSize();
                        dimension.width = this.fMargin + this.fColumns * (dimension2.width + this.fMargin);
                        int n2 = n % this.fColumns == 0 ? 0 : 1;
                        int n3 = n / this.fColumns + n2;
                        dimension.height = this.fMargin + n3 * (dimension2.height + this.fMargin);
                    }
                    return dimension;
                }

                @Override
                public Dimension minimumLayoutSize(Container container) {
                    Dimension dimension = new Dimension(0, 0);
                    int n = container.getComponentCount();
                    if (n > 0) {
                        Component component = container.getComponent(0);
                        Dimension dimension2 = component.getMinimumSize();
                        dimension.width = this.fMargin + this.fColumns * (dimension2.width + this.fMargin);
                        int n2 = n % this.fColumns == 0 ? 0 : 1;
                        int n3 = n / this.fColumns + n2;
                        dimension.height = this.fMargin + n3 * (dimension2.height + this.fMargin);
                    }
                    return dimension;
                }

                @Override
                public void layoutContainer(Container container) {
                    int n = container.getComponentCount();
                    Point point = new Point(0, 0);
                    if (n > 0) {
                        Component component = container.getComponent(0);
                        Dimension dimension = component.getPreferredSize();
                        for (int i = 0; i < n; ++i) {
                            component = container.getComponent(i);
                            point.x = this.fMargin + i % this.fColumns * (dimension.width + this.fMargin);
                            point.y = this.fMargin + i / this.fColumns * (dimension.height + this.fMargin);
                            component.setLocation(point);
                            component.setSize(dimension);
                        }
                    }
                }
            }
        }
    }

    private static class PagePanel
    extends MJPanel {
        PagePanel() {
            super((LayoutManager)new BorderLayout());
            this.setBorder(Borders.createEmptyBorder((String)"2dlu, 3dlu, 2dlu, 3dlu"));
        }
    }
}

