/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.objectbrowser;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.icons.GuideIcon;
import com.mathworks.toolbox.matlab.guide.objectbrowser.ObjectView;
import com.mathworks.widgets.desk.DTWindowHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;

public class ObjectBrowser
extends MJPanel {
    private static ResourceBundle fObjBrowsBundle = ResourceBundle.getBundle("com.mathworks.toolbox.matlab.guide.objectbrowser.resources.RES_ObjBrows");
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 300;
    private static MJFrame sBrowserWin = null;
    private static ObjectBrowser sBrowser = null;
    private static Rectangle sWindowBounds = null;
    private ObjectView fObjView;
    private MJFrame fFrame;

    public ObjectBrowser(MJFrame mJFrame, ObjectRegistry objectRegistry) {
        this.fFrame = mJFrame;
        this.setLayout(new BorderLayout());
        this.fObjView = new ObjectView(objectRegistry);
        this.add("Center", (Component)((Object)this.fObjView));
        this.setName(this.getWindowTitle());
        if (this.fFrame != null) {
            this.fFrame.setName(this.getName());
            new WindowHandler((Window)this.fFrame);
        }
    }

    public ObjectBrowser() {
        this(null, ObjectRegistry.getRegistry());
    }

    public String getWindowTitle() {
        return fObjBrowsBundle.getString("title.object_browser");
    }

    public int closeWindow() {
        if (this.fFrame != null) {
            if (this.fFrame == sBrowserWin) {
                sWindowBounds = sBrowserWin.getBounds();
                sBrowserWin = null;
            }
            if (this == sBrowser) {
                sBrowser = null;
            }
            this.fFrame.dispose();
        }
        this.fObjView.setRegistry(null);
        return 0;
    }

    public void setActive(boolean bl) {
        if (bl) {
            this.fObjView.requestFocus();
        }
    }

    private static void createObjectBrowser() {
        if (sBrowser == null || sBrowserWin == null) {
            Cloneable cloneable;
            sBrowserWin = new MJFrame();
            sBrowser = new ObjectBrowser(sBrowserWin, ObjectRegistry.getLayoutRegistry());
            sBrowserWin.setTitle(sBrowser.getWindowTitle());
            sBrowserWin.setIconImage(GuideIcon.OBJECT_BROWSER.getIcon().getImage());
            sBrowserWin.setContentPane((Container)((Object)sBrowser));
            sBrowserWin.setName(ResourceManager.getUntranslatedString("windowname.objectbrowser"));
            if (sWindowBounds == null) {
                cloneable = MJUtilities.getScreenBounds();
                Dimension dimension = sBrowser.getPreferredSize();
                if (dimension.width == 0 || dimension.height == 0) {
                    dimension.width = 300;
                    dimension.height = 300;
                }
                Rectangle rectangle = new Rectangle(cloneable.width - dimension.width, 0, dimension.width, dimension.height);
                sBrowserWin.setLocation(rectangle.x, rectangle.y);
                sBrowserWin.setBounds(rectangle);
                sWindowBounds = sBrowserWin.getBounds();
            }
            cloneable = MJUtilities.ensureOnScreen((Point)new Point(ObjectBrowser.sWindowBounds.x, ObjectBrowser.sWindowBounds.y), (Dimension)new Dimension(ObjectBrowser.sWindowBounds.width, ObjectBrowser.sWindowBounds.height), (int)10);
            sBrowserWin.setBounds(((Point)cloneable).x, ((Point)cloneable).y, ObjectBrowser.sWindowBounds.width, ObjectBrowser.sWindowBounds.height);
        }
    }

    public static ObjectBrowser getObjectBrowser() {
        return sBrowser;
    }

    public static void activateObjectBrowser() {
        if (sBrowserWin == null || sBrowser == null) {
            ObjectBrowser.createObjectBrowser();
        }
        if (!sBrowserWin.isVisible()) {
            sBrowserWin.setVisible(true);
        }
        sBrowserWin.toFront();
    }

    public static void main(String[] stringArray) {
        try {
            ObjectBrowser.activateObjectBrowser();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean isObjectBrowserOpen() {
        return sBrowserWin != null && sBrowser != null;
    }

    private class WindowHandler
    extends DTWindowHandler {
        WindowHandler(Window window) {
            super(window);
        }

        public void close() {
            ObjectBrowser.this.closeWindow();
        }

        public void windowActivated(WindowEvent windowEvent) {
            ObjectBrowser.this.setActive(true);
            ObjectBrowser.this.fObjView.getObjectTree().requestFocusInWindow();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            ObjectBrowser.this.setActive(false);
        }
    }
}

