/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.menueditor;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.Sizes;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.ObjectOwner;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import com.mathworks.toolbox.matlab.guide.LayoutEditor;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.icons.GuideIcon;
import com.mathworks.toolbox.matlab.guide.icons.MenuEditorIcon;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditorAction;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditorActionManager;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditorCommand;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditorLooper;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditorUtils;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuNode;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuNodeType;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuPropertyPanel;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuTreeNode;
import com.mathworks.toolbox.matlab.guide.utils.BottomBorder;
import com.mathworks.util.QueueEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MenuEditor
extends MJPanel {
    protected static final int TREES = 1;
    protected static final int PANELS = 2;
    protected static final int COMMANDS = 4;
    protected static final int SELECTION = 8;
    protected static final int REGISTRY = 16;
    protected static final int ALL = 255;
    private static final String CARD_PREFIX = "panel";
    private static final int MENU = 0;
    private static final int CMNU = 1;
    private static final int NUM_TREES = 2;
    private double fFigHandle;
    private Object fFigBean;
    private MJFrame fFrame;
    private MJTree[] fTrees;
    private MenuTreePanel[] fTreePanels;
    private boolean[] fHasItems;
    private MJPanel fCardPanel;
    private MenuPropertyPanel[] fPanel;
    private MJTabbedPane fTabPanel;
    private JSplitPane fSplitPane;
    private MJButton fOk;
    private MJButton fHelp;
    private EventHandler fHandler;
    private int fUntitledCount;
    private List<MenuNode> fExpandedMenuObjects = new LinkedList<MenuNode>();
    private List<MenuNode> fExpandedContextObjects = new LinkedList<MenuNode>();
    private ObjectRegistry fRegistry;
    private RegistryHandler fRegistryListener;
    private LayoutEditor fLayout;
    private MenuEditorActionManager fActionManager;
    private WindowListener fWindowListener;
    private ComponentListener fComponentListener;

    public MenuEditor(LayoutEditor layoutEditor, double d) {
        this.fLayout = layoutEditor;
        this.fFigHandle = d;
        this.fUntitledCount = 0;
        this.fActionManager = new MenuEditorActionManager(this);
        this.fHandler = new EventHandler();
        this.fTabPanel = new MJTabbedPane(3);
        this.fTabPanel.setName("tabPanel");
        this.fHasItems = new boolean[2];
        this.fTrees = new MJTree[2];
        this.fTrees[0] = this.buildNewTree();
        this.fTrees[0].setName("menuTree");
        this.fTrees[1] = this.buildNewTree();
        this.fTrees[1].setName("contextMenuTree");
        this.attachTreeListeners(0, this.fTrees[0]);
        this.attachTreeListeners(1, this.fTrees[1]);
        this.fTreePanels = new MenuTreePanel[2];
        this.addTabPane(0, this.fTrees[0]);
        this.addTabPane(1, this.fTrees[1]);
        this.fTabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MenuEditor.this.updateControls(6);
            }
        });
        this.fCardPanel = new MJPanel();
        CardLayout cardLayout = new CardLayout();
        this.fCardPanel.setLayout((LayoutManager)cardLayout);
        this.fPanel = new MenuPropertyPanel[3];
        for (int i = 0; i < this.fPanel.length; ++i) {
            this.fPanel[i] = new MenuPropertyPanel(this, i);
            this.fCardPanel.add(CARD_PREFIX + i, (Component)((Object)this.fPanel[i]));
        }
        this.fSplitPane = new JSplitPane(1, (Component)this.fTabPanel, (Component)this.fCardPanel);
        this.fSplitPane.setDividerLocation(0.5);
        this.fSplitPane.setResizeWeight(0.5);
        this.fSplitPane.setDividerSize(Sizes.dialogUnitXAsPixel((int)4, (Component)this.fSplitPane));
        BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)this.fSplitPane.getUI();
        basicSplitPaneUI.getDivider().setBorder(Borders.EMPTY_BORDER);
        this.fSplitPane.setBorder(Borders.createEmptyBorder((String)"0dlu, 0dlu, 4dlu, 0dlu"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)this.fSplitPane, (Object)"Center");
        mJPanel.add((Component)this.buildButtonBar(), (Object)"South");
        mJPanel.setBorder(Borders.DIALOG_BORDER);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)mJPanel, "Center");
        this.setPreferredSize(new Dimension(540, 420));
        String string = MenuEditorUtils.getResource("frame.title");
        this.setName(string);
        this.fFrame = new MJFrame(string);
        this.fFrame.setName(ResourceManager.getUntranslatedString("windowname.menueditor"));
        this.fFrame.add((Component)((Object)this), (Object)"Center");
        this.fFrame.setIconImage(GuideIcon.MENU_EDITOR.getIcon().getImage());
        this.fFrame.pack();
        this.fRegistry = ObjectRegistry.getLayoutRegistry();
        this.fRegistryListener = new RegistryHandler();
        if (this.fRegistry != null) {
            this.fRegistry.addObjectRegistryListener((ObjectRegistryListener)this.fRegistryListener);
            this.fRegistry.addItemListener((ItemListener)this.fRegistryListener);
        }
        MenuEditorLooper.invoke(this);
    }

    private JPanel buildButtonBar() {
        String string = MenuEditorUtils.getResource("button.ok");
        this.fOk = new MJButton(string);
        this.fOk.setName("menu.editor.ok");
        this.fOk.addActionListener((ActionListener)this.fHandler);
        String string2 = MenuEditorUtils.getResource("button.help");
        this.fHelp = new MJButton(string2);
        this.fHelp.setName("menu.editor.help");
        this.fHelp.addActionListener((ActionListener)this.fHandler);
        return ButtonBarFactory.buildOKHelpBar((JButton)this.fOk, (JButton)this.fHelp);
    }

    private MJTree buildNewTree() {
        MJTree mJTree = new MJTree();
        mJTree.setRootVisible(false);
        mJTree.setShowsRootHandles(true);
        mJTree.setExpandsSelectedPaths(false);
        MenuEditorTreeCellRenderer menuEditorTreeCellRenderer = new MenuEditorTreeCellRenderer();
        mJTree.setCellRenderer((TreeCellRenderer)menuEditorTreeCellRenderer);
        mJTree.setCellEditor((TreeCellEditor)new DefaultTreeCellEditor((JTree)mJTree, menuEditorTreeCellRenderer));
        mJTree.setEditable(false);
        mJTree.getSelectionModel().setSelectionMode(1);
        MenuTreeNode menuTreeNode = new MenuTreeNode(MenuNodeType.ROOT, null);
        mJTree.setModel((TreeModel)new DefaultTreeModel(menuTreeNode, true));
        mJTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MenuNode menuNode = MenuEditor.this.getSelectedMenuItem();
                if (menuNode != null) {
                    MenuEditor.this.fRegistry.setSelected(new Object[]{menuNode.getUDDNode()}, true);
                }
                MenuEditor.this.updateControls(6);
            }
        });
        return mJTree;
    }

    private void addTabPane(int n, MJTree mJTree) {
        String string = n == 0 ? MenuEditorUtils.getResource("tab.MenuBar") : MenuEditorUtils.getResource("tab.ContextMenus");
        String string2 = n == 0 ? MenuEditorUtils.getResource("tab.ClickMenu") : MenuEditorUtils.getResource("tab.ClickContext");
        ImageIcon imageIcon = n == 0 ? MenuEditorIcon.NEW_MENU.getIcon() : MenuEditorIcon.NEW_CONTEXTMENU.getIcon();
        MenuEditorAction menuEditorAction = n == 0 ? this.fActionManager.getAction(MenuEditorCommand.NEW_MENU) : this.fActionManager.getAction(MenuEditorCommand.NEW_CONTEXTMENU);
        MJButton mJButton = new MJButton((Action)((Object)menuEditorAction));
        mJButton.setText(string2);
        mJButton.setIcon((Icon)imageIcon);
        mJButton.setIconTextGap(Math.round((float)mJButton.getIconTextGap() * 1.5f));
        mJButton.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        mJButton.setFocusable(false);
        mJButton.setFocusTraversable(false);
        mJButton.setHorizontalAlignment(10);
        mJButton.setContentAreaFilled(false);
        MenuTreePanel menuTreePanel = new MenuTreePanel(mJTree, mJButton);
        menuTreePanel.setTreeVisible(false);
        this.fTreePanels[n] = menuTreePanel;
        this.fTabPanel.add(string, (Component)((Object)menuTreePanel));
    }

    private void doNewMenu() {
        MenuEditorLooper.doNew(this, 1, this.fFigHandle, this.untitled(), true, 0);
    }

    private void doNewMenuItem() {
        MenuNode menuNode;
        MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
        if (menuTreeNode != null && (menuNode = (MenuNode)menuTreeNode.getUserObject()) != null) {
            MenuEditorLooper.doNew(this, 1, menuNode.getHandle(), this.untitled(), false, this.fTabPanel.getSelectedIndex());
        }
    }

    private void doNewContextMenu() {
        MenuEditorLooper.doNew(this, 2, this.fFigHandle, this.untitled(), true, 1);
    }

    private void doDelete() {
        MenuNode menuNode;
        MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
        if (menuTreeNode != null && (menuNode = (MenuNode)menuTreeNode.getUserObject()) != null) {
            int n = this.fTabPanel.getSelectedIndex();
            boolean bl = this.fTrees[n].getRowCount() == 1;
            ((DefaultTreeModel)this.fTrees[n].getModel()).removeNodeFromParent(menuTreeNode);
            if (bl) {
                this.fHasItems[n] = false;
                this.fTreePanels[n].setTreeVisible(false);
            }
            MenuEditorLooper.doDelete(menuNode);
            this.fLayout.contentChanged(null);
            this.updateControls(6);
            this.fRegistry.setSelected(new Object[]{this.fFigBean}, true);
        }
    }

    private boolean canMoveHorizontal(MenuMovement menuMovement) {
        MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
        if (menuTreeNode == null) {
            return false;
        }
        MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getParent();
        int n = this.fTabPanel.getSelectedIndex();
        if (n == 1 && menuTreeNode2.isRoot()) {
            return false;
        }
        if (menuMovement == MenuMovement.MOVE_BACKWARD) {
            if (n == 1 && menuTreeNode2.getType() == MenuNodeType.CONTEXTMENU) {
                return false;
            }
            return !menuTreeNode2.isRoot();
        }
        return menuTreeNode.getSiblingCount() > 1 && menuTreeNode.getPreviousSibling() != null;
    }

    private boolean canMoveVertical(MenuMovement menuMovement) {
        MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
        if (menuTreeNode == null) {
            return false;
        }
        if (menuMovement == MenuMovement.MOVE_UP) {
            if (menuTreeNode.getPreviousSibling() != null) {
                return true;
            }
            MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getParent();
            return !menuTreeNode2.isRoot() && menuTreeNode2.getPreviousSibling() != null;
        }
        if (menuTreeNode.getNextSibling() != null) {
            return true;
        }
        MenuTreeNode menuTreeNode3 = (MenuTreeNode)menuTreeNode.getParent();
        return !menuTreeNode3.isRoot() && menuTreeNode3.getNextSibling() != null;
    }

    private void doMoveForward() {
        MenuNode menuNode;
        MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
        if (menuTreeNode != null && (menuNode = (MenuNode)menuTreeNode.getUserObject()) != null) {
            MenuEditorLooper.doMoveForward(this, this.fFigHandle, menuNode.getHandle(), menuTreeNode, this.fTabPanel.getSelectedIndex());
        }
    }

    private void doMoveBackward() {
        MenuNode menuNode;
        MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
        if (menuTreeNode != null && (menuNode = (MenuNode)menuTreeNode.getUserObject()) != null) {
            MenuEditorLooper.doMoveBackward(this, this.fFigHandle, menuNode.getHandle(), menuTreeNode, this.fTabPanel.getSelectedIndex());
        }
    }

    private void doMoveUp() {
        MenuNode menuNode;
        MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
        if (menuTreeNode != null && (menuNode = (MenuNode)menuTreeNode.getUserObject()) != null) {
            MenuEditorLooper.doMoveUp(this, this.fFigHandle, menuNode.getHandle(), menuTreeNode, this.fTabPanel.getSelectedIndex());
        }
    }

    private void doMoveDown() {
        MenuNode menuNode;
        MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
        if (menuTreeNode != null && (menuNode = (MenuNode)menuTreeNode.getUserObject()) != null) {
            MenuEditorLooper.doMoveDown(this, this.fFigHandle, menuNode.getHandle(), menuTreeNode, this.fTabPanel.getSelectedIndex());
        }
    }

    public void doCommand(MenuEditorCommand menuEditorCommand) {
        switch (menuEditorCommand) {
            case NEW_MENU: {
                this.doNewMenu();
                break;
            }
            case NEW_MENUITEM: {
                this.doNewMenuItem();
                break;
            }
            case NEW_CONTEXTMENU: {
                this.doNewContextMenu();
                break;
            }
            case MOVE_FORWARD: {
                this.doMoveForward();
                break;
            }
            case MOVE_BACKWARD: {
                this.doMoveBackward();
                break;
            }
            case MOVE_UP: {
                this.doMoveUp();
                break;
            }
            case MOVE_DOWN: {
                this.doMoveDown();
                break;
            }
            case DELETE: {
                this.doDelete();
            }
        }
    }

    public boolean isCommandEnabled(MenuEditorCommand menuEditorCommand) {
        switch (menuEditorCommand) {
            case NEW_MENU: {
                return this.fTabPanel.getSelectedIndex() == 0;
            }
            case NEW_MENUITEM: {
                MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
                return menuTreeNode != null;
            }
            case NEW_CONTEXTMENU: {
                return this.fTabPanel.getSelectedIndex() == 1;
            }
            case MOVE_FORWARD: {
                return this.canMoveHorizontal(MenuMovement.MOVE_FORWARD);
            }
            case MOVE_BACKWARD: {
                return this.canMoveHorizontal(MenuMovement.MOVE_BACKWARD);
            }
            case MOVE_UP: {
                return this.canMoveVertical(MenuMovement.MOVE_UP);
            }
            case MOVE_DOWN: {
                return this.canMoveVertical(MenuMovement.MOVE_DOWN);
            }
            case DELETE: {
                MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
                return menuTreeNode != null;
            }
        }
        return true;
    }

    private MenuTreeNode getSelectedTreeNode() {
        return this.getSelectedTreeNode(this.fTabPanel.getSelectedIndex());
    }

    private MenuTreeNode getSelectedTreeNode(int n) {
        Object object;
        MenuTreeNode menuTreeNode = null;
        TreePath treePath = this.fTrees[n].getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof MenuTreeNode) {
            menuTreeNode = (MenuTreeNode)treePath.getLastPathComponent();
        }
        return menuTreeNode;
    }

    public void closeWindow() {
        if (this.fRegistry != null) {
            this.fRegistry.removeItemListener((ItemListener)this.fRegistryListener);
            this.fRegistry.removeObjectRegistryListener((ObjectRegistryListener)this.fRegistryListener);
        }
        this.fFrame.removeWindowListener(this.fWindowListener);
        this.fFrame.removeComponentListener(this.fComponentListener);
        this.fLayout = null;
        this.fFrame.setVisible(false);
        this.fFrame.dispose();
    }

    protected double getFigHandle() {
        return this.fFigHandle;
    }

    ObjectOwner getLayoutOwner() {
        return this.fLayout;
    }

    protected void completeNew(boolean bl, MenuNode menuNode, final int n) {
        if (menuNode != null) {
            if (!this.fHasItems[n]) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuEditor.this.fTreePanels[n].setTreeVisible(true);
                    }
                });
            }
            this.fHasItems[n] = true;
            MenuTreeNode menuTreeNode = bl ? (MenuTreeNode)this.fTrees[n].getModel().getRoot() : this.getSelectedTreeNode(n);
            if (menuTreeNode != null) {
                menuNode.setTarget(this.fLayout);
                MenuNodeType menuNodeType = MenuNodeType.MENU;
                if (menuTreeNode.getType() == MenuNodeType.ROOT && n == 1) {
                    menuNodeType = MenuNodeType.CONTEXTMENU;
                }
                MenuTreeNode menuTreeNode2 = new MenuTreeNode(menuNodeType, menuNode);
                this.addNewChildToParent(this.fTrees[n], menuTreeNode, menuTreeNode2);
            }
            this.fLayout.contentChanged(null);
        }
    }

    private void addNewChildToParent(final MJTree mJTree, final MenuTreeNode menuTreeNode, final MenuTreeNode menuTreeNode2) {
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    int n = menuTreeNode.getChildCount();
                    ((DefaultTreeModel)mJTree.getModel()).insertNodeInto(menuTreeNode2, menuTreeNode, n);
                    TreePath treePath = new TreePath(menuTreeNode.getPath());
                    if (!mJTree.isExpanded(treePath)) {
                        mJTree.expandPath(treePath);
                    }
                    TreePath treePath2 = new TreePath(menuTreeNode2.getPath());
                    mJTree.scrollPathToVisible(treePath2);
                    if (!mJTree.isExpanded(treePath2)) {
                        mJTree.expandPath(treePath2);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String string = MenuEditorUtils.getResource("error.cannot_add_child");
            MJOptionPane.showMessageDialog((Component)MJOptionPane.getFrameForComponent((Component)this.fOk), (Object)string, (String)MJOptionPane.getFrameForComponent((Component)this.fOk).getTitle(), (int)2);
        }
    }

    protected void completeMove(final MenuTreeNode menuTreeNode, final int n, final MenuMovement menuMovement) {
        if (EventQueue.isDispatchThread()) {
            this.dispatchAction(menuTreeNode, n, menuMovement);
        } else {
            QueueEvent.postQueueEvent((QueueEvent)new QueueEvent(){

                public void dispatch() {
                    MenuEditor.this.dispatchAction(menuTreeNode, n, menuMovement);
                }
            });
        }
    }

    private void dispatchAction(MenuTreeNode menuTreeNode, int n, MenuMovement menuMovement) {
        if (menuTreeNode == null) {
            return;
        }
        MenuNode menuNode = (MenuNode)menuTreeNode.getUserObject();
        if (menuNode == null) {
            return;
        }
        MJTree mJTree = this.fTrees[n];
        boolean bl = false;
        switch (menuMovement) {
            case MOVE_UP: {
                bl = MenuEditor.moveMenuUp(menuTreeNode);
                break;
            }
            case MOVE_DOWN: {
                bl = MenuEditor.moveMenuDown(menuTreeNode);
                break;
            }
            case MOVE_BACKWARD: {
                bl = MenuEditor.moveMenuBackward(menuTreeNode);
                break;
            }
            case MOVE_FORWARD: {
                bl = this.moveMenuForward(n, menuTreeNode);
            }
        }
        if (bl) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)mJTree.getModel();
            defaultTreeModel.reload();
            MenuTreeNode menuTreeNode2 = (MenuTreeNode)mJTree.getModel().getRoot();
            this.restoreTreeExpansions(n, (JTree)mJTree, new TreePath(menuTreeNode2), null);
            mJTree.setSelectionPath(new TreePath(menuTreeNode.getPath()));
            this.fLayout.contentChanged(null);
            MenuTreeNode menuTreeNode3 = (MenuTreeNode)menuTreeNode.getParent();
            int n2 = menuTreeNode3.getIndex(menuTreeNode);
            MenuNode menuNode2 = (MenuNode)menuTreeNode3.getUserObject();
            Object object = menuNode2 == null ? this.fFigBean : menuNode2.getUDDNode();
            this.fRegistry.move(new Object[]{menuNode.getUDDNode()}, object, n2);
        }
    }

    private static boolean moveMenuUp(MenuTreeNode menuTreeNode) {
        boolean bl = false;
        MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getParent();
        int n = menuTreeNode2.getIndex(menuTreeNode);
        if (n >= 0) {
            int n2 = n - 1;
            if (n > 0) {
                menuTreeNode2.insert(menuTreeNode, n2);
                bl = true;
            } else if ((menuTreeNode2 = (MenuTreeNode)menuTreeNode2.getPreviousSibling()) != null) {
                int n3 = menuTreeNode2.getChildCount();
                menuTreeNode2.insert(menuTreeNode, n3);
                bl = true;
            }
        }
        return bl;
    }

    private static boolean moveMenuDown(MenuTreeNode menuTreeNode) {
        boolean bl = false;
        MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getParent();
        int n = menuTreeNode2.getIndex(menuTreeNode);
        if (n >= 0) {
            int n2 = n + 1;
            if (n2 < menuTreeNode2.getChildCount()) {
                menuTreeNode2.insert(menuTreeNode, n2);
                bl = true;
            } else if ((menuTreeNode2 = (MenuTreeNode)menuTreeNode2.getNextSibling()) != null) {
                int n3 = 0;
                menuTreeNode2.insert(menuTreeNode, n3);
                bl = true;
            }
        }
        return bl;
    }

    private static boolean moveMenuBackward(MenuTreeNode menuTreeNode) {
        boolean bl = false;
        MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getParent();
        MenuTreeNode menuTreeNode3 = (MenuTreeNode)menuTreeNode2.getParent();
        if (menuTreeNode3 != null) {
            int n = menuTreeNode3.getIndex(menuTreeNode2);
            int n2 = n + 1;
            menuTreeNode3.insert(menuTreeNode, n2);
            bl = true;
        }
        return bl;
    }

    private boolean moveMenuForward(int n, MenuTreeNode menuTreeNode) {
        boolean bl = false;
        MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getParent();
        MenuTreeNode menuTreeNode3 = (MenuTreeNode)menuTreeNode.getPreviousSibling();
        if (menuTreeNode3 != null) {
            int n2 = menuTreeNode3.getChildCount();
            menuTreeNode3.insert(menuTreeNode, n2);
            this.addExpandedNode(n, menuTreeNode3);
            bl = true;
        } else {
            MenuTreeNode menuTreeNode4 = (MenuTreeNode)menuTreeNode2.getPreviousSibling();
            if (menuTreeNode4 == null) {
                menuTreeNode4 = (MenuTreeNode)menuTreeNode2.getNextSibling();
            }
            if (menuTreeNode4 != null) {
                int n3 = menuTreeNode4.getChildCount();
                menuTreeNode4.insert(menuTreeNode, n3);
                this.addExpandedNode(n, menuTreeNode4);
                bl = true;
            }
        }
        return bl;
    }

    private void selectMenuItem(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        for (int i = 0; i < this.fTrees.length; ++i) {
            MJTree mJTree = this.fTrees[i];
            MenuTreeNode menuTreeNode = (MenuTreeNode)mJTree.getModel().getRoot();
            MenuTreeNode menuTreeNode2 = MenuEditor.findSelectedNode(menuTreeNode, objectArray[0]);
            if (menuTreeNode2 == null) continue;
            this.fTabPanel.setSelectedIndex(i);
            TreePath treePath = new TreePath(menuTreeNode2.getPath());
            mJTree.setSelectionPath(treePath);
            mJTree.expandPath(treePath);
            break;
        }
    }

    private static MenuTreeNode findSelectedNode(MenuTreeNode menuTreeNode, Object object) {
        for (int i = 0; i < menuTreeNode.getChildCount(); ++i) {
            MenuTreeNode menuTreeNode2 = (MenuTreeNode)menuTreeNode.getChildAt(i);
            MenuNode menuNode = (MenuNode)menuTreeNode2.getUserObject();
            MenuTreeNode menuTreeNode3 = menuNode.getUDDNode().equals(object) ? menuTreeNode2 : MenuEditor.findSelectedNode(menuTreeNode2, object);
            if (menuTreeNode3 == null) continue;
            return menuTreeNode3;
        }
        return null;
    }

    private MenuNode getSelectedMenuItem() {
        MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
        if (menuTreeNode != null) {
            return (MenuNode)menuTreeNode.getUserObject();
        }
        return null;
    }

    protected void fireNodeChange() {
        MenuTreeNode menuTreeNode = this.getSelectedTreeNode();
        this.fireNodeChange(menuTreeNode);
    }

    protected void fireNodeChange(MenuTreeNode menuTreeNode) {
        int n = this.fTabPanel.getSelectedIndex();
        ((DefaultTreeModel)this.fTrees[n].getModel()).nodeChanged(menuTreeNode);
    }

    protected void completeInvoke(Object object, MenuNode menuNode, MenuNode menuNode2, int n) {
        this.fFrame.setName(ResourceManager.getUntranslatedString("windowname.menueditor"));
        this.fFigBean = object;
        this.fUntitledCount = n;
        this.populate(menuNode, menuNode2);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MenuEditor.this.closeWindow();
            }
        };
        this.fFrame.addWindowListener(this.fWindowListener);
        this.fComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = MenuEditor.this.fFrame.getPreferredSize();
                Dimension dimension2 = MenuEditor.this.fFrame.getSize();
                MenuEditor.this.fFrame.setSize(dimension2.width < dimension.width ? dimension.width : dimension2.width, dimension2.height < dimension.height ? dimension.height : dimension2.height);
            }
        };
        this.fFrame.addComponentListener(this.fComponentListener);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fFrame.getPreferredSize();
        int n2 = (dimension.width - dimension2.width) / 2 > 0 ? (dimension.width - dimension2.width) / 2 : 0;
        int n3 = (dimension.height - dimension2.height) / 3 > 0 ? (dimension.height - dimension2.height) / 3 : 0;
        Point point = WindowUtils.ensureOnScreen((Point)new Point(n2, n3), (Dimension)dimension2, (int)0);
        this.fFrame.setBounds(point.x, point.y, dimension2.width, dimension2.height);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MenuEditor.this.fSplitPane.setDividerLocation(0.5);
            }
        });
        this.fFrame.setVisible(true);
    }

    private String untitled() {
        ++this.fUntitledCount;
        return MenuEditorUtils.getResource("string.Untitled", this.fUntitledCount);
    }

    private MJToolBar buildToolbar() {
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setFloatable(false);
        mJToolBar.setBorder((Border)new BottomBorder());
        mJToolBar.addGap(4);
        this.addToolbarButton(mJToolBar, MenuEditorCommand.NEW_MENU);
        this.addToolbarButton(mJToolBar, MenuEditorCommand.NEW_MENUITEM);
        this.addToolbarButton(mJToolBar, MenuEditorCommand.NEW_CONTEXTMENU);
        mJToolBar.addSeparator();
        this.addToolbarButton(mJToolBar, MenuEditorCommand.MOVE_BACKWARD);
        this.addToolbarButton(mJToolBar, MenuEditorCommand.MOVE_FORWARD);
        this.addToolbarButton(mJToolBar, MenuEditorCommand.MOVE_UP);
        this.addToolbarButton(mJToolBar, MenuEditorCommand.MOVE_DOWN);
        mJToolBar.addSeparator();
        this.addToolbarButton(mJToolBar, MenuEditorCommand.DELETE);
        return mJToolBar;
    }

    private void addToolbarButton(MJToolBar mJToolBar, MenuEditorCommand menuEditorCommand) {
        MenuEditorAction menuEditorAction = this.fActionManager.getAction(menuEditorCommand);
        String string = menuEditorAction.getName();
        MJButton mJButton = new MJButton((Action)((Object)menuEditorAction));
        MJToolBar.configureButton((MJButton)mJButton);
        mJButton.setName(string);
        mJToolBar.add((Component)mJButton);
    }

    void updateControls(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdate(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuEditor.this.doUpdate(n);
                }
            });
        }
    }

    private void doUpdate(int n) {
        int n2 = this.fTabPanel.getSelectedIndex();
        if ((n & 8) != 0) {
            this.selectMenuItem(this.fRegistry.getSelectedObjects());
        }
        if ((n & 1) != 0) {
            this.fTrees[n2].repaint();
        }
        if ((n & 4) != 0) {
            for (int i = 0; i < this.fTrees.length; ++i) {
                if (this.fHasItems[i]) continue;
                this.fTrees[i].getSelectionModel().clearSelection();
            }
            this.updateAction(MenuEditorCommand.NEW_MENU);
            this.updateAction(MenuEditorCommand.NEW_CONTEXTMENU);
            this.updateAction(MenuEditorCommand.NEW_MENUITEM);
            this.updateAction(MenuEditorCommand.MOVE_BACKWARD);
            this.updateAction(MenuEditorCommand.MOVE_FORWARD);
            this.updateAction(MenuEditorCommand.MOVE_UP);
            this.updateAction(MenuEditorCommand.MOVE_DOWN);
            this.updateAction(MenuEditorCommand.DELETE);
        }
        this.updateNewPropertyPanels(n, n2);
    }

    private void updateNewPropertyPanels(int n, int n2) {
        if ((n & 2) != 0) {
            Object object;
            int n3 = 0;
            final MenuTreeNode menuTreeNode = this.getSelectedTreeNode(n2);
            if (menuTreeNode != null && (object = (MenuNode)menuTreeNode.getUserObject()) != null) {
                int n4;
                n3 = n4 = ((MenuNode)object).getType();
                switch (n4) {
                    case 1: {
                        EventQueue.invokeLater(new Runnable((MenuNode)object){
                            final /* synthetic */ MenuNode val$menuData;
                            {
                                this.val$menuData = menuNode;
                            }

                            @Override
                            public void run() {
                                MenuEditor.this.fPanel[n4].synchToNode(menuTreeNode, this.val$menuData);
                                if (MenuEditor.this.fTabPanel.getSelectedIndex() == 1) {
                                    MenuEditor.this.fPanel[n4].enableAcceleratorPanel(false);
                                } else {
                                    MenuEditor.this.fPanel[n4].enableAcceleratorPanel(true);
                                }
                            }
                        });
                        break;
                    }
                    case 2: {
                        EventQueue.invokeLater(new Runnable((MenuNode)object){
                            final /* synthetic */ MenuNode val$menuData;
                            {
                                this.val$menuData = menuNode;
                            }

                            @Override
                            public void run() {
                                MenuEditor.this.fPanel[n4].synchToNode(menuTreeNode, this.val$menuData);
                            }
                        });
                        break;
                    }
                }
            }
            if ((n & 0x10) == 0) {
                object = (CardLayout)this.fCardPanel.getLayout();
                String string = CARD_PREFIX + n3;
                ((CardLayout)object).show((Container)this.fCardPanel, string);
            }
        }
    }

    private void updateAction(MenuEditorCommand menuEditorCommand) {
        MenuEditorAction menuEditorAction = this.fActionManager.getAction(menuEditorCommand);
        if (menuEditorAction != null) {
            menuEditorAction.setEnabled(this.isCommandEnabled(menuEditorCommand));
        }
    }

    private void commitButton(Object object) {
        if (object.equals(this.fOk)) {
            this.closeWindow();
        } else if (object.equals(this.fHelp)) {
            String string = MLHelpServices.getDocRoot() + "/techdoc/creating_guis/creating_guis.map";
            MLHelpServices.cshDisplayTopic((Object)this.getParent(), (String)string, (String)"menu_editor");
        }
    }

    private void populate(MenuNode menuNode, MenuNode menuNode2) {
        this.fHasItems[0] = this.populateHelper(0, this.fTrees[0], (MenuTreeNode)this.fTrees[0].getModel().getRoot(), menuNode);
        this.fTreePanels[0].setTreeVisible(this.fHasItems[0]);
        this.fHasItems[1] = this.populateHelper(1, this.fTrees[1], (MenuTreeNode)this.fTrees[1].getModel().getRoot(), menuNode2);
        this.fTreePanels[1].setTreeVisible(this.fHasItems[1]);
        this.updateControls(15);
    }

    private boolean populateHelper(int n, MJTree mJTree, MenuTreeNode menuTreeNode, MenuNode menuNode) {
        boolean bl = false;
        List<MenuNode> list = menuNode.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            TreePath treePath;
            MenuNode menuNode2 = list.get(i);
            bl = true;
            MenuNodeType menuNodeType = MenuNodeType.MENU;
            if (menuTreeNode.getType() == MenuNodeType.ROOT && n == 1) {
                menuNodeType = MenuNodeType.CONTEXTMENU;
            }
            MenuTreeNode menuTreeNode2 = new MenuTreeNode(menuNodeType, menuNode2);
            ((DefaultTreeModel)mJTree.getModel()).insertNodeInto(menuTreeNode2, menuTreeNode, i);
            menuNode2.setTarget(this.fLayout);
            this.populateHelper(n, mJTree, menuTreeNode2, menuNode2);
            TreePath treePath2 = new TreePath(menuTreeNode.getPath());
            if (!mJTree.isExpanded(treePath2)) {
                mJTree.expandPath(treePath2);
            }
            if (mJTree.isExpanded(treePath = new TreePath(menuTreeNode2.getPath()))) continue;
            mJTree.expandPath(treePath);
        }
        return bl;
    }

    private void attachTreeListeners(final int n, MJTree mJTree) {
        mJTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                MenuEditor.this.processTreeExpansion(n, treeExpansionEvent);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                MenuEditor.this.processTreeCollapse(n, treeExpansionEvent);
            }
        });
    }

    private void processTreeExpansion(int n, TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        Object[] objectArray = treePath.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[objectArray.length - 1];
        MenuNode menuNode = (MenuNode)defaultMutableTreeNode.getUserObject();
        if (n == 0) {
            this.fExpandedMenuObjects.add(menuNode);
        } else {
            this.fExpandedContextObjects.add(menuNode);
        }
    }

    private void processTreeCollapse(int n, TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        Object[] objectArray = treePath.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[objectArray.length - 1];
        MenuNode menuNode = (MenuNode)defaultMutableTreeNode.getUserObject();
        if (n == 0) {
            this.fExpandedMenuObjects.remove(menuNode);
        } else {
            this.fExpandedContextObjects.remove(menuNode);
        }
    }

    private void addExpandedNode(int n, MenuTreeNode menuTreeNode) {
        MJTree mJTree = this.fTrees[n];
        TreePath treePath = new TreePath(menuTreeNode.getPath());
        if (!mJTree.isExpanded(treePath)) {
            MenuNode menuNode = (MenuNode)menuTreeNode.getUserObject();
            if (n == 0) {
                this.fExpandedMenuObjects.add(menuNode);
            } else {
                this.fExpandedContextObjects.add(menuNode);
            }
        }
    }

    private void restoreTreeExpansions(int n, JTree jTree, TreePath treePath, MenuTreeNode menuTreeNode) {
        Object object;
        MenuTreeNode menuTreeNode2 = (MenuTreeNode)treePath.getLastPathComponent();
        if (menuTreeNode2.getChildCount() >= 0) {
            object = menuTreeNode2.children();
            while (object.hasMoreElements()) {
                MenuTreeNode menuTreeNode3 = (MenuTreeNode)object.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(menuTreeNode3);
                this.restoreTreeExpansions(n, jTree, treePath2, menuTreeNode3);
            }
        }
        if (menuTreeNode != null) {
            object = (MenuNode)menuTreeNode.getUserObject();
            if (n == 0) {
                if (this.fExpandedMenuObjects.contains(object)) {
                    jTree.expandPath(treePath);
                }
            } else if (this.fExpandedContextObjects.contains(object)) {
                jTree.expandPath(treePath);
            }
        }
    }

    private static class MenuEditorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MenuTreeNode fTreeNode = null;

        private MenuEditorTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.fTreeNode = (MenuTreeNode)object;
            jLabel.setIcon(this.getLeafIcon());
            jLabel.setText(this.fTreeNode.toString());
            return jLabel;
        }

        @Override
        public Icon getLeafIcon() {
            return this.getIcon();
        }

        @Override
        public Icon getOpenIcon() {
            return this.getIcon();
        }

        @Override
        public Icon getClosedIcon() {
            return this.getIcon();
        }

        @Override
        public Icon getIcon() {
            if (this.fTreeNode != null) {
                return this.fTreeNode.getIcon();
            }
            return super.getLeafIcon();
        }
    }

    private static class MenuTreePanel
    extends MJPanel {
        private MJButton fButton;
        private MJScrollPane fScrollPane;
        private MJTree fTree;

        private MenuTreePanel(MJTree mJTree, MJButton mJButton) {
            this.fTree = mJTree;
            this.fButton = mJButton;
            this.buildPanel();
        }

        public void setTreeVisible(boolean bl) {
            this.fButton.setVisible(!bl);
            this.fScrollPane.setVisible(bl);
        }

        private void buildPanel() {
            this.fTree.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
            this.fScrollPane = new MJScrollPane((Component)this.fTree);
            this.fScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.setLayout(new BorderLayout());
            this.add((Component)this.fButton, "North");
            this.add((Component)this.fScrollPane, "Center");
            this.setBackground(this.fTree.getBackground());
            this.setName(this.fTree.getName() + "Panel");
        }
    }

    private class RegistryHandler
    implements ObjectRegistryListener,
    ItemListener {
        private RegistryHandler() {
        }

        public void objectChanged(ObjectRegistryEvent objectRegistryEvent) {
            MenuNode menuNode = MenuEditor.this.getSelectedMenuItem();
            Object[] objectArray = objectRegistryEvent.getObjects();
            if (objectArray != null && menuNode != null && objectArray[0].equals(menuNode.getUDDNode())) {
                menuNode.updateMenuNode(MenuEditor.this);
            }
        }

        public void objectMoved(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void objectRegistered(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void objectUnregistered(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionEnded(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionStarted(ObjectRegistryEvent objectRegistryEvent) {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Object[] objectArray = MenuEditor.this.fRegistry.getSelectedObjects();
                MenuNode menuNode = MenuEditor.this.getSelectedMenuItem();
                if (objectArray != null && objectArray.length == 1) {
                    if (menuNode == null || !objectArray[0].equals(menuNode.getUDDNode())) {
                        MenuEditor.this.updateControls(30);
                    } else if (objectArray[0].equals(menuNode.getUDDNode())) {
                        menuNode.updateMenuNode(MenuEditor.this);
                        if (SwingUtilities.isEventDispatchThread()) {
                            MenuEditor.this.fireNodeChange();
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MenuEditor.this.fireNodeChange();
                                }
                            });
                        }
                    }
                }
            }
        }
    }

    private class EventHandler
    implements ActionListener {
        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuEditor.this.commitButton(actionEvent.getSource());
        }
    }

    protected static enum MenuMovement {
        MOVE_UP,
        MOVE_DOWN,
        MOVE_BACKWARD,
        MOVE_FORWARD;

    }
}

