/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.dragdrop;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.dragdrop.DragTracker;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.RulerGuide;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public final class RulerGuideDrag
extends DragTracker {
    private RulerGuide fGuide;
    private Point fCurrentPt;
    private int fOrientation;

    public RulerGuideDrag(LayoutArea layoutArea, int n) {
        super(layoutArea);
        this.fOrientation = n;
    }

    public RulerGuideDrag(LayoutArea layoutArea, RulerGuide rulerGuide) {
        super(layoutArea);
        this.fGuide = rulerGuide;
        this.fOrientation = rulerGuide.getOrientation();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics(true);
        this.drawDragGuide(graphics);
        this.fCurrentPt = mouseEvent.getPoint();
        if (!mouseEvent.getComponent().equals(this.fLayoutArea)) {
            this.fCurrentPt = SwingUtilities.convertPoint(mouseEvent.getComponent(), this.fCurrentPt, this.fLayoutArea);
        }
        this.drawDragGuide(graphics);
        graphics.dispose();
        if (this.fLayoutArea.getLayoutStatusBar() != null) {
            this.fLayoutArea.getLayoutStatusBar().setCurrentPoint(this.fCurrentPt);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics(true);
        this.drawDragGuide(graphics);
        graphics.dispose();
        this.fCurrentPt = mouseEvent.getPoint();
        if (!mouseEvent.getComponent().equals(this.fLayoutArea)) {
            this.fCurrentPt = SwingUtilities.convertPoint(mouseEvent.getComponent(), this.fCurrentPt, this.fLayoutArea);
        }
        if (this.fOrientation == 0) {
            if (this.fCurrentPt.x > 0) {
                if (this.fGuide == null) {
                    this.fGuide = new RulerGuide(this.fCurrentPt.x, this.fOrientation);
                    this.fLayoutArea.getGrid().addGuide(this.fGuide);
                } else {
                    this.fGuide.setLocation(this.fCurrentPt.x);
                }
                this.fLayoutArea.repaint();
            } else if (this.fGuide != null) {
                this.fLayoutArea.getGrid().removeGuide(this.fGuide);
                this.fLayoutArea.repaint();
            }
        } else if (this.fCurrentPt.y > 0) {
            if (this.fGuide == null) {
                this.fGuide = new RulerGuide(this.fCurrentPt.y, this.fOrientation);
                this.fLayoutArea.getGrid().addGuide(this.fGuide);
            } else {
                this.fGuide.setLocation(this.fCurrentPt.y);
            }
            this.fLayoutArea.repaint();
        } else if (this.fGuide != null) {
            this.fLayoutArea.getGrid().removeGuide(this.fGuide);
            this.fLayoutArea.repaint();
        }
    }

    private void drawDragGuide(Graphics graphics) {
        if (this.fCurrentPt != null) {
            if (this.fOrientation == 0) {
                graphics.drawLine(this.fCurrentPt.x, 0, this.fCurrentPt.x, this.fLayoutArea.getSize().height);
            } else {
                graphics.drawLine(0, this.fCurrentPt.y, this.fLayoutArea.getSize().width, this.fCurrentPt.y);
            }
        }
    }
}

