/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.mathworks.toolbox.matlab.guide.LayoutStackingArea;
import com.mathworks.toolbox.matlab.guide.MWTPanel;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LayoutWrapperOwner;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class StackingPanel
extends MWTPanel
implements LayoutStackingArea {
    public StackingPanel() {
        this.setLayout(new CustomLayout());
        this.setFont(UIManager.getFont("Panel.font"));
        for (int i = 0; i < LayoutWrapperOwner.getNumberOfLayers(); ++i) {
            this.add(new StackingLayer("Stacking Layer " + i));
        }
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.isVisible()) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    @Override
    public boolean isShowing() {
        return true;
    }

    @Override
    public void addToLayer(final LOControlWrapper lOControlWrapper, final int n) {
        final int n2 = LayoutWrapperOwner.getNumberOfLayers() - 1 - LayoutWrapperOwner.getLayerIndexOfWrapper(lOControlWrapper);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (lOControlWrapper.getControl() != null) {
                    Container container = (Container)StackingPanel.this.getComponent(n2);
                    container.add(lOControlWrapper.getControl(), n);
                    StackingPanel.this.validate();
                    StackingPanel.this.repaint();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void removeFromLayer(final LOControlWrapper lOControlWrapper) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (lOControlWrapper.getControl() != null && lOControlWrapper.getControl().getParent() != null) {
                    lOControlWrapper.getControl().getParent().remove(lOControlWrapper.getControl());
                    StackingPanel.this.validate();
                    StackingPanel.this.repaint();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static class CustomLayout
    implements LayoutManager {
        private CustomLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            int n3 = container.getComponentCount();
            for (int i = 0; i < n3; ++i) {
                Component component = container.getComponent(i);
                int n4 = component.getPreferredSize().width;
                int n5 = component.getPreferredSize().height;
                if (i == 0) {
                    n = n4;
                    n2 = n5;
                    continue;
                }
                n = n4 > n ? n4 : n;
                n2 = n5 > n2 ? n5 : n2;
            }
            return new Dimension(n, n2);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            int n3 = container.getComponentCount();
            for (int i = 0; i < n3; ++i) {
                Component component = container.getComponent(i);
                int n4 = component.getMinimumSize().width;
                int n5 = component.getMinimumSize().height;
                if (i == 0) {
                    n = n4;
                    n2 = n5;
                    continue;
                }
                n = n4 < n ? n4 : n;
                n2 = n5 < n2 ? n5 : n2;
            }
            return new Dimension(n, n2);
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                component.setLocation(0, 0);
                component.setSize(dimension.width, dimension.height);
            }
        }
    }

    protected static class StackingLayer
    extends Container {
        StackingLayer(String string) {
            this.setName(string);
            this.setLayout(null);
        }
    }
}

