/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGRectangle;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.services.ObjectOwner;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.toolbox.matlab.guide.HGControl;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutClipboard;
import com.mathworks.toolbox.matlab.guide.LayoutEditor;
import com.mathworks.toolbox.matlab.guide.RuntimeArea;
import com.mathworks.toolbox.matlab.guide.layouttool.LayoutToolInfo;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOWrapperOwner;
import com.mathworks.toolbox.matlab.guide.palette.MObjectProxy;
import com.mathworks.toolbox.matlab.guide.palette.MObjectWrapper;
import com.mathworks.toolbox.matlab.guide.utils.LayoutWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;

public final class LayoutLooper {
    private static boolean sAvailable;
    private static final String HELPER_FUNCTION = "guidefunc";
    private static final String NEW_FIGURE = "newFigure";
    private static final String NEW_GOBJECT = "newGObject";
    private static final String READ_FIGURE = "readFigure";
    private static final String DUPLICATE = "duplicate";
    private static final String COPY = "copy";
    private static final String PASTE = "paste";
    private static final String ACTIVATE_FIGURE = "activateFigure";
    private static final String SNAPSHOT_FIGURE = "snapshotFigure";
    private static final String DELETE_FIGURE = "deleteFigure";
    private static final String DELETE_GOBJECT = "deleteGObject";
    private static final String MOVE = "move";
    private static final String MOVE_TO_FRONT = "moveToFront";
    private static final String MOVE_TO_BACK = "moveToBack";
    private static final String MOVE_FORWARD = "moveForward";
    private static final String MOVE_BACKWARD = "moveBackward";
    private static final String MOVE_NFORWARD = "moveNForward";
    private static final String MOVE_NBACKWARD = "moveNBackward";
    private static final String RESIZE_FIGURE = "resizeFigure";
    public static final String NEW_LAYOUT = "newLayout";
    public static final String OPEN_FIGURE = "openFigure";
    public static final String OPEN_CALLBACK_EDITOR = "openCallbackEditor";
    public static final String PRELOAD = "preload";
    public static final String GETTING_STARTED = "helpGettingStarted";
    public static final String HELP_LAYING_OUT_GUIS = "helpLayingOutGUIs";
    public static final String HELP_PROGRAMMING_GUIS = "helpProgrammingGUIs";
    public static final String EXAMPLE_GUIS = "helpExampleGUIs";
    public static final String ONLINE_DEMOS = "helpOnlineDemos";
    public static final String SAVE = "save";
    public static final String SAVE_AS = "saveAs";
    public static final String EXPORT = "export";
    private static final String APPLICATION_OPTIONS = "applicationOptions";
    private static final String EDIT_CALLBACK = "editCallback";
    private static final String GET_PROPERTIES = "getProperties";
    private static final String SYNC_WITHOBJECTS = "syncWithObjects";
    private static final String SET_PROPERTIES = "setProperties";
    private static final String SHOW_PROPERTYPAGE = "showPropertyPage";
    private static final String UPDATE_TAG = "updateTag";
    private static final String ACTIVEX_CONTROLS = "activexControl";
    private static final String PREPARE_PROXY = "prepareProxy";
    private static final String CHANGE_PARENT = "changeparent";
    private static final String CHILDREN_POSITION = "updateChildrenPosition";
    private static final String SET_OPTION = "setOption";

    static boolean isAvailable() {
        return sAvailable;
    }

    static void requestEval(String string) {
        if (sAvailable) {
            new Matlab().evalNoOutput(string);
        }
    }

    public static boolean isContainer(UDDObject uDDObject) {
        boolean bl = false;
        if (sAvailable) {
            try {
                Object object = Matlab.mtFeval((String)"isa", (Object[])new Object[]{uDDObject, HGControl.CONTAINER.getClassName()}, (int)1);
                if (object != null && object instanceof boolean[] && ((boolean[])object).length > 0) {
                    bl = ((boolean[])object)[0];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean isAxes(UDDObject uDDObject) {
        boolean bl = false;
        if (sAvailable) {
            try {
                Object object = Matlab.mtFeval((String)"isa", (Object[])new Object[]{uDDObject, HGControl.AXES.getClassName()}, (int)1);
                if (object != null && object instanceof boolean[] && ((boolean[])object).length > 0) {
                    bl = ((boolean[])object)[0];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    static void requestFigure(CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = NEW_FIGURE;
            objectArray[n++] = (LayoutEditor)completionObserver;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 9, completionObserver);
        } else {
            completionObserver.completed(-1, null);
        }
    }

    public static void requestPreload(String string) {
        if (sAvailable) {
            Object[] objectArray = new Object[]{PRELOAD, string};
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, null);
        }
    }

    static void deleteFigure(Object object, CompletionObserver completionObserver) {
        if (sAvailable && object != null) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = DELETE_FIGURE;
            objectArray[n++] = object;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, completionObserver);
        }
    }

    public static void deleteGObjects(GObjectWrapper[] gObjectWrapperArray, LayoutArea layoutArea) {
        if (sAvailable && gObjectWrapperArray.length > 0) {
            Vector<GObjectWrapper> vector = new Vector<GObjectWrapper>(gObjectWrapperArray.length);
            Vector<Object> vector2 = new Vector<Object>(gObjectWrapperArray.length + 1);
            GObjectWrapper gObjectWrapper = null;
            for (int i = 0; i < gObjectWrapperArray.length; ++i) {
                vector.insertElementAt(gObjectWrapperArray[i], 0);
                vector2.insertElementAt(gObjectWrapperArray[i].getHandle(), 0);
                gObjectWrapperArray[i].setHandle(null);
                gObjectWrapperArray[i].setBean(null);
                gObjectWrapperArray[i].setPeerBean(null);
                if (!gObjectWrapperArray[i].isEnclosure()) continue;
                Enumeration enumeration = gObjectWrapperArray[i].wrappers();
                while (enumeration.hasMoreElements()) {
                    gObjectWrapper = (GObjectWrapper)enumeration.nextElement();
                    vector.insertElementAt(gObjectWrapper, 0);
                    vector2.insertElementAt(gObjectWrapper.getHandle(), 0);
                    gObjectWrapper.setHandle(null);
                    gObjectWrapper.setBean(null);
                    gObjectWrapper.setPeerBean(null);
                }
            }
            vector2.insertElementAt(DELETE_GOBJECT, 0);
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, vector2.toArray(), 2 * vector.size(), new DeleteGObjectObserver(vector, layoutArea));
        }
    }

    public static void changeParent(Vector vector, LayoutArea layoutArea, int[] nArray, CompletionObserver completionObserver) {
        if (sAvailable) {
            if (completionObserver == null) {
                completionObserver = new ChangeParentObserver(vector, layoutArea, nArray);
            }
            GObjectWrapper gObjectWrapper = null;
            Object[] objectArray = new Object[vector.size()];
            Object[] objectArray2 = new Object[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                gObjectWrapper = (GObjectWrapper)vector.elementAt(i);
                Object object = gObjectWrapper.getParent();
                object = object == null ? layoutArea.getFigure() : ((GObjectWrapper)object).getBean();
                objectArray2[i] = object;
                objectArray[i] = gObjectWrapper.getBean();
            }
            Object[] objectArray3 = new Object[3];
            int n = 0;
            objectArray3[n++] = CHANGE_PARENT;
            objectArray3[n++] = objectArray;
            objectArray3[n++] = objectArray2;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray3, 0, completionObserver);
        }
    }

    static void activateFigure(Object object, CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = ACTIVATE_FIGURE;
            objectArray[n++] = object;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, completionObserver);
        }
    }

    static void applicationOptions(Object object) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = APPLICATION_OPTIONS;
            objectArray[n++] = object;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, null);
        }
    }

    public static void requestGObjects(LOWrapperOwner[] lOWrapperOwnerArray, GObjectWrapper[] gObjectWrapperArray, LayoutArea layoutArea) {
        if (sAvailable && gObjectWrapperArray.length > 0) {
            Vector<GObjectWrapper> vector = new Vector<GObjectWrapper>(gObjectWrapperArray.length);
            Vector<Object> vector2 = new Vector<Object>(gObjectWrapperArray.length * 8 + 1);
            vector2.addElement(NEW_GOBJECT);
            for (int i = 0; i < gObjectWrapperArray.length; ++i) {
                vector.addElement(gObjectWrapperArray[i]);
                Object[] objectArray = gObjectWrapperArray[i].getProperties();
                MObjectProxy mObjectProxy = (MObjectProxy)gObjectWrapperArray[i].getControl();
                Object object = null;
                object = lOWrapperOwnerArray[i] instanceof LayoutArea ? ((LayoutArea)lOWrapperOwnerArray[i]).getFigure() : ((LOControlWrapper)lOWrapperOwnerArray[i]).getBean();
                vector2.addElement(object);
                vector2.addElement(mObjectProxy.getTypeString());
                vector2.addElement(mObjectProxy);
                vector2.addElement(LayoutLooper.calcPosition(mObjectProxy));
                vector2.addElement(mObjectProxy.getStyleString());
                vector2.addElement(mObjectProxy.getProxyData());
                vector2.addElement(objectArray == null ? null : objectArray[0]);
                vector2.addElement(objectArray == null ? null : objectArray[1]);
                GObjectWrapper gObjectWrapper = null;
                if (!gObjectWrapperArray[i].isEnclosure()) continue;
                Enumeration enumeration = gObjectWrapperArray[i].wrappers();
                while (enumeration.hasMoreElements()) {
                    gObjectWrapper = (GObjectWrapper)enumeration.nextElement();
                    vector.addElement(gObjectWrapper);
                    objectArray = gObjectWrapper.getProperties();
                    mObjectProxy = (MObjectProxy)gObjectWrapper.getControl();
                    vector2.addElement(Integer.toString(vector.indexOf(gObjectWrapper.getParent()) + 1));
                    vector2.addElement(mObjectProxy.getTypeString());
                    vector2.addElement(mObjectProxy);
                    vector2.addElement(LayoutLooper.calcPosition(mObjectProxy));
                    vector2.addElement(mObjectProxy.getStyleString());
                    vector2.addElement(mObjectProxy.getProxyData());
                    vector2.addElement(objectArray == null ? null : objectArray[0]);
                    vector2.addElement(objectArray == null ? null : objectArray[1]);
                }
            }
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, vector2.toArray(), 6 * vector.size(), new AddGObjectObserver(lOWrapperOwnerArray, vector, layoutArea));
        }
    }

    public static void requestMove(Vector vector, LayoutArea layoutArea) {
        LayoutLooper.requestMove(vector, layoutArea, null);
    }

    static void requestMove(Vector vector, LayoutArea layoutArea, Point point) {
        MoveCompleted moveCompleted = new MoveCompleted(vector, layoutArea);
        if (sAvailable) {
            int n = vector.size();
            Object[] objectArray = new Object[n];
            Object[] objectArray2 = new Object[n];
            Object[] objectArray3 = new Object[n];
            double[] dArray = point != null ? new double[]{point.x, point.y} : new double[n * 4];
            for (int i = 0; i < n; ++i) {
                GObjectWrapper gObjectWrapper = (GObjectWrapper)vector.elementAt(i);
                objectArray[i] = gObjectWrapper.getHandle();
                objectArray2[i] = ((MObjectProxy)gObjectWrapper.getControl()).getTypeString();
                objectArray3[i] = ((MObjectProxy)gObjectWrapper.getControl()).getStyleString();
                if (point != null) continue;
                double[] dArray2 = LayoutLooper.calcPosition(gObjectWrapper.getControl());
                for (int j = 0; j < 4; ++j) {
                    dArray[i * 4 + j] = dArray2[j];
                }
            }
            Object[] objectArray4 = new Object[5];
            int n2 = 0;
            objectArray4[n2++] = MOVE;
            objectArray4[n2++] = objectArray;
            objectArray4[n2++] = objectArray2;
            objectArray4[n2++] = objectArray3;
            objectArray4[n2++] = dArray;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray4, 2 * n, moveCompleted);
        } else {
            moveCompleted.completed(-1, null);
        }
    }

    static void moveToFront(GObjectWrapper gObjectWrapper, LayoutArea layoutArea) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = MOVE_TO_FRONT;
            objectArray[n++] = gObjectWrapper.getHandle();
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, new ReorderCompleted(new LOControlWrapper[]{gObjectWrapper}, layoutArea));
        }
    }

    static void moveToBack(GObjectWrapper gObjectWrapper, LayoutArea layoutArea) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = MOVE_TO_BACK;
            objectArray[n++] = gObjectWrapper.getHandle();
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, new ReorderCompleted(new LOControlWrapper[]{gObjectWrapper}, layoutArea));
        }
    }

    static void moveForward(GObjectWrapper gObjectWrapper, LayoutArea layoutArea) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = MOVE_FORWARD;
            objectArray[n++] = gObjectWrapper.getHandle();
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, new ReorderCompleted(new LOControlWrapper[]{gObjectWrapper}, layoutArea));
        }
    }

    public static void moveNForward(GObjectWrapper[] gObjectWrapperArray, Integer[] integerArray, LayoutArea layoutArea) {
        if (sAvailable && gObjectWrapperArray.length > 0) {
            Object[] objectArray = new Object[1 + 2 * gObjectWrapperArray.length];
            int n = 0;
            objectArray[n++] = MOVE_NFORWARD;
            for (int i = 0; i < gObjectWrapperArray.length; ++i) {
                objectArray[n++] = gObjectWrapperArray[i].getHandle();
                objectArray[n++] = integerArray[i];
            }
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, new ReorderCompleted(gObjectWrapperArray, layoutArea));
        }
    }

    static void moveBackward(GObjectWrapper gObjectWrapper, LayoutArea layoutArea) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = MOVE_BACKWARD;
            objectArray[n++] = gObjectWrapper.getHandle();
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, new ReorderCompleted(new LOControlWrapper[]{gObjectWrapper}, layoutArea));
        }
    }

    public static void moveNBackward(GObjectWrapper[] gObjectWrapperArray, Integer[] integerArray, LayoutArea layoutArea) {
        if (sAvailable && gObjectWrapperArray.length > 0) {
            Object[] objectArray = new Object[1 + 2 * gObjectWrapperArray.length];
            int n = 0;
            objectArray[n++] = MOVE_NBACKWARD;
            for (int i = 0; i < gObjectWrapperArray.length; ++i) {
                objectArray[n++] = gObjectWrapperArray[i].getHandle();
                objectArray[n++] = integerArray[i];
            }
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, new ReorderCompleted(gObjectWrapperArray, layoutArea));
        }
    }

    private static double[] calcPosition(Component component) {
        Rectangle rectangle = component.getBounds();
        Dimension dimension = component.getParent().getSize();
        double[] dArray = new double[]{rectangle.x, dimension.height - rectangle.y - rectangle.height, rectangle.width, rectangle.height};
        return dArray;
    }

    public static void readFigure(String string, LayoutEditor layoutEditor, CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray = new Object[3];
            int n = 0;
            objectArray[n++] = READ_FIGURE;
            objectArray[n++] = layoutEditor;
            objectArray[n++] = string;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 18, completionObserver);
        } else {
            completionObserver.completed(-1, null);
        }
    }

    static void snapshotFigure(double d, CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray = new Object[3];
            int n = 0;
            objectArray[n++] = SNAPSHOT_FIGURE;
            objectArray[n++] = (LayoutEditor)completionObserver;
            objectArray[n++] = new Double(d);
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 18, completionObserver);
        } else {
            completionObserver.completed(-1, null);
        }
    }

    static void duplicate(Object object, Vector vector, Point point, CompletionObserver completionObserver) {
        if (sAvailable) {
            int n = vector.size();
            Object[] objectArray = new Object[n];
            double[] dArray = new double[2];
            for (int i = 0; i < n; ++i) {
                GObjectWrapper gObjectWrapper = (GObjectWrapper)vector.elementAt(i);
                objectArray[i] = gObjectWrapper.getHandle();
            }
            dArray[0] = point.x;
            dArray[1] = point.y;
            Object[] objectArray2 = new Object[5];
            int n2 = 0;
            objectArray2[n2++] = DUPLICATE;
            objectArray2[n2++] = objectArray;
            objectArray2[n2++] = object;
            objectArray2[n2++] = dArray;
            objectArray2[n2++] = DUPLICATE;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray2, 6, completionObserver);
        } else {
            completionObserver.completed(-1, null);
        }
    }

    static void copy(Object[] objectArray, CompletionObserver completionObserver) {
        if (sAvailable) {
            int n = objectArray.length;
            Object[] objectArray2 = new Object[n];
            for (int i = 0; i < n; ++i) {
                GObjectWrapper gObjectWrapper = (GObjectWrapper)objectArray[i];
                objectArray2[i] = gObjectWrapper.getHandle();
            }
            Object[] objectArray3 = new Object[3];
            int n2 = 0;
            objectArray3[n2++] = COPY;
            objectArray3[n2++] = objectArray2;
            objectArray3[n2++] = LayoutClipboard.getClipboard().getBufferFigure();
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray3, 2, completionObserver);
        } else {
            completionObserver.completed(-1, null);
        }
    }

    static void paste(Object[] objectArray, Object object, int[] nArray, CompletionObserver completionObserver) {
        if (sAvailable) {
            double[] dArray = new double[]{nArray[0], nArray[1]};
            Object[] objectArray2 = new Object[5];
            int n = 0;
            objectArray2[n++] = DUPLICATE;
            objectArray2[n++] = objectArray;
            objectArray2[n++] = object;
            objectArray2[n++] = dArray;
            objectArray2[n++] = PASTE;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray2, 6, completionObserver);
        } else {
            completionObserver.completed(-1, null);
        }
    }

    static void editCallback(Object object, Object[] objectArray, String string) {
        if (sAvailable) {
            Object[] objectArray2 = new Object[4];
            int n = 0;
            objectArray2[n++] = EDIT_CALLBACK;
            objectArray2[n++] = object;
            objectArray2[n++] = objectArray;
            objectArray2[n++] = string;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray2, 0, null);
        }
    }

    public static void doToolAction(String string, LayoutEditor layoutEditor, Object object, LayoutToolInfo layoutToolInfo, Object[] objectArray) {
        if (sAvailable) {
            Object[] objectArray2 = new Object[6];
            int n = 0;
            objectArray2[n++] = "GUIDE2ToolInterface";
            objectArray2[n++] = string;
            objectArray2[n++] = layoutToolInfo;
            objectArray2[n++] = layoutEditor;
            objectArray2[n++] = object;
            objectArray2[n++] = objectArray;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray2, 0, null);
        }
    }

    static void showPropertyPage(Object object) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = SHOW_PROPERTYPAGE;
            objectArray[n++] = object;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, null);
        }
    }

    static void updateObject(LOWrapperOwner lOWrapperOwner, LayoutArea layoutArea) {
        if (sAvailable) {
            UpdateObjectWorker updateObjectWorker = new UpdateObjectWorker(lOWrapperOwner, layoutArea);
            updateObjectWorker.start();
        }
    }

    public static void updateChildrenPosition(LOWrapperOwner[] lOWrapperOwnerArray, LayoutArea layoutArea) {
        if (sAvailable) {
            int n;
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = new Object[lOWrapperOwnerArray.length];
            Object[] objectArray3 = new Object[lOWrapperOwnerArray.length];
            GObjectWrapper gObjectWrapper = null;
            Rectangle rectangle = null;
            for (n = 0; n < lOWrapperOwnerArray.length; ++n) {
                if (lOWrapperOwnerArray[n] == layoutArea) {
                    objectArray2[n] = layoutArea.getRootObject();
                    rectangle = layoutArea.getBounds();
                } else {
                    gObjectWrapper = (GObjectWrapper)lOWrapperOwnerArray[n];
                    objectArray2[n] = gObjectWrapper.getPeerBean();
                    rectangle = gObjectWrapper.getControl().getBounds();
                }
                objectArray3[n] = new double[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
            }
            n = 0;
            objectArray[n++] = CHILDREN_POSITION;
            objectArray[n++] = objectArray2;
            objectArray[n++] = objectArray3;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 1, new ChildrenPositionUpdated(lOWrapperOwnerArray, layoutArea));
        }
    }

    static void refreshChildrenPosition(LOWrapperOwner[] lOWrapperOwnerArray, LayoutArea layoutArea) {
        if (sAvailable) {
            RefreshChildrenPosition refreshChildrenPosition = new RefreshChildrenPosition(lOWrapperOwnerArray, layoutArea);
            Matlab.whenMatlabReady((Runnable)refreshChildrenPosition);
        }
    }

    static void updateFigure(LayoutArea layoutArea) {
        if (sAvailable) {
            UpdateFigure updateFigure = new UpdateFigure(layoutArea);
            Matlab.whenMatlabReady((Runnable)updateFigure);
        }
    }

    private static void updateFigureAppearance(final LayoutArea layoutArea, final Color color, final Rectangle rectangle) {
        if (SwingUtilities.isEventDispatchThread()) {
            LayoutLooper.updateFigureAppearanceAWT(layoutArea, color, rectangle);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LayoutLooper.updateFigureAppearanceAWT(layoutArea, color, rectangle);
                }
            });
        }
    }

    private static void updateFigureAppearanceAWT(LayoutArea layoutArea, Color color, Rectangle rectangle) {
        boolean bl = false;
        if (color != null && !layoutArea.getBackground().equals(color)) {
            layoutArea.setBackground(color);
            bl = true;
        }
        RuntimeArea runtimeArea = layoutArea.getRuntimeArea();
        Rectangle rectangle2 = runtimeArea.getDocumentBounds();
        if (rectangle != null && (rectangle2.width != rectangle.width || rectangle2.height != rectangle.height)) {
            runtimeArea.setRuntimeBounds(rectangle);
            LayoutArea.forceLayout(runtimeArea);
            layoutArea.getVRuler().setLabelStart(rectangle.height);
            layoutArea.getVRuler().repaint(5L);
            LayoutLooper.refreshChildrenPosition(new LOWrapperOwner[]{layoutArea}, layoutArea);
            bl = true;
        }
        runtimeArea.setInRuntimeResize(false);
        layoutArea.figureChanged();
        if (bl) {
            layoutArea.repaint(5L);
        }
    }

    public static void resizeFigure(Object object, Point point, CompletionObserver completionObserver) {
        if (sAvailable) {
            double[] dArray = new double[]{point.x, point.y};
            Object[] objectArray = new Object[3];
            int n = 0;
            objectArray[n++] = RESIZE_FIGURE;
            objectArray[n++] = object;
            objectArray[n++] = dArray;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 2, completionObserver);
        } else {
            completionObserver.completed(-1, null);
        }
    }

    static void executeInM(String string, CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray = new Object[]{string};
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, completionObserver);
        }
    }

    static void executeInM(String string) {
        if (sAvailable) {
            Object[] objectArray = new Object[]{string};
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, null);
        }
    }

    public static void executeInM(String string, Object object) {
        if (sAvailable) {
            Object[] objectArray = new Object[]{string, object};
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, null);
        }
    }

    static void getProperty(Vector vector, CompletionObserver completionObserver) {
        if (completionObserver == null) {
            completionObserver = new GetPropertyCompleted(vector);
        }
        if (sAvailable) {
            int n = vector.size();
            Object[] objectArray = new Object[n];
            if (n == 1 && vector.elementAt(0) instanceof LayoutArea) {
                objectArray[0] = ((LayoutArea)vector.elementAt(0)).getFigure();
            } else {
                for (int i = 0; i < n; ++i) {
                    GObjectWrapper gObjectWrapper = (GObjectWrapper)vector.elementAt(i);
                    objectArray[i] = gObjectWrapper.getHandle();
                }
            }
            Object[] objectArray2 = new Object[3];
            int n2 = 0;
            objectArray2[n2++] = GET_PROPERTIES;
            objectArray2[n2++] = objectArray;
            objectArray2[n2++] = new Integer(n);
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray2, 2 * n, completionObserver);
        } else {
            completionObserver.completed(-1, null);
        }
    }

    public static void syncWithObjects(Vector vector, CompletionObserver completionObserver) {
        if (completionObserver == null) {
            completionObserver = new syncWithObjectsCompleted(vector);
        }
        if (sAvailable) {
            int n = vector.size();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                MObjectWrapper mObjectWrapper = (MObjectWrapper)vector.elementAt(i);
                objectArray[i] = mObjectWrapper.getHandle();
            }
            Object[] objectArray2 = new Object[3];
            int n2 = 0;
            objectArray2[n2++] = SYNC_WITHOBJECTS;
            objectArray2[n2++] = objectArray;
            objectArray2[n2++] = new Integer(n);
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray2, 3 * n, completionObserver);
        } else {
            completionObserver.completed(-1, null);
        }
    }

    static void updateTagProperty(Vector vector) {
        if (sAvailable) {
            int n = vector.size();
            Object[] objectArray = new Object[n];
            Object[] objectArray2 = new Object[n];
            Object[] objectArray3 = new Object[n];
            if (n == 1 && vector.elementAt(0) instanceof LayoutArea) {
                objectArray[0] = ((LayoutArea)vector.elementAt(0)).getFigure();
                objectArray2[0] = "figure";
                objectArray3[0] = "figure";
            } else {
                for (int i = 0; i < vector.size(); ++i) {
                    GObjectWrapper gObjectWrapper = (GObjectWrapper)vector.elementAt(i);
                    objectArray[i] = gObjectWrapper.getHandle();
                    objectArray2[i] = ((MObjectProxy)gObjectWrapper.getControl()).getTypeString();
                    objectArray3[i] = ((MObjectProxy)gObjectWrapper.getControl()).getStyleString();
                }
            }
            Object[] objectArray4 = new Object[4];
            int n2 = 0;
            objectArray4[n2++] = UPDATE_TAG;
            objectArray4[n2++] = objectArray;
            objectArray4[n2++] = objectArray2;
            objectArray4[n2++] = objectArray3;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray4, 0, null);
        }
    }

    public static void setProperty(Vector vector, Object[] objectArray, LayoutArea layoutArea) {
        SetPropertyCompleted setPropertyCompleted = new SetPropertyCompleted(vector, layoutArea);
        if (sAvailable) {
            int n = vector.size();
            Object[] objectArray2 = new Object[n];
            if (n == 1 && vector.elementAt(0) instanceof LayoutArea) {
                objectArray2[0] = ((LayoutArea)vector.elementAt(0)).getFigure();
            } else {
                for (int i = 0; i < vector.size(); ++i) {
                    GObjectWrapper gObjectWrapper = (GObjectWrapper)vector.elementAt(i);
                    objectArray2[i] = gObjectWrapper.getHandle();
                }
            }
            Object[] objectArray3 = new Object[n * 2 + 2];
            int n2 = 0;
            objectArray3[n2++] = SET_PROPERTIES;
            objectArray3[n2++] = objectArray2;
            for (int i = 0; i < vector.size(); ++i) {
                Object[] objectArray4 = (Object[])objectArray[i];
                objectArray3[n2++] = objectArray4[0];
                objectArray3[n2++] = objectArray4[1];
            }
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray3, 1, setPropertyCompleted);
        } else {
            setPropertyCompleted.completed(-1, null);
        }
    }

    static void setOption(LayoutArea layoutArea, String string, Object object) {
        Object object2 = layoutArea.getFigure();
        if (object2 != null && sAvailable && string != null && object != null) {
            Object[] objectArray = new Object[4];
            int n = 0;
            objectArray[n++] = SET_OPTION;
            objectArray[n++] = object2;
            objectArray[n++] = string;
            objectArray[n++] = object;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 0, null);
        }
    }

    static void getActiveXControlList(CompletionObserver completionObserver) {
        if (sAvailable) {
            Object[] objectArray = new Object[1];
            int n = 0;
            objectArray[n++] = ACTIVEX_CONTROLS;
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 2, completionObserver);
        } else {
            completionObserver.completed(-1, null);
        }
    }

    static void prepareProxy(LayoutArea layoutArea, MObjectProxy mObjectProxy, Rectangle rectangle, LOWrapperOwner lOWrapperOwner) {
        PrepareProxyCompleted prepareProxyCompleted = new PrepareProxyCompleted(layoutArea, mObjectProxy, rectangle, lOWrapperOwner);
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            objectArray[n++] = PREPARE_PROXY;
            objectArray[n++] = mObjectProxy.getTypeString();
            LayoutWorker.fevalConsoleOutput(HELPER_FUNCTION, objectArray, 1, prepareProxyCompleted);
        } else {
            prepareProxyCompleted.completed(-1, null);
        }
    }

    static {
        if (Matlab.isMatlabAvailable()) {
            sAvailable = true;
        }
    }

    private static class PrepareProxyCompleted
    implements CompletionObserver {
        LayoutArea fLayoutArea;
        MObjectProxy fProxy;
        Rectangle fBounds;
        LOWrapperOwner fParent;

        PrepareProxyCompleted(LayoutArea layoutArea, MObjectProxy mObjectProxy, Rectangle rectangle, LOWrapperOwner lOWrapperOwner) {
            this.fLayoutArea = layoutArea;
            this.fProxy = mObjectProxy;
            this.fBounds = rectangle;
            this.fParent = lOWrapperOwner;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null) {
                Object[] objectArray = (Object[])object;
                this.fProxy.setProxyData(objectArray);
                if (this.fProxy.isProxyCreated()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PrepareProxyCompleted.this.fLayoutArea.addObject(PrepareProxyCompleted.this.fProxy.getType(), PrepareProxyCompleted.this.fProxy, PrepareProxyCompleted.this.fBounds, PrepareProxyCompleted.this.fParent);
                        }
                    });
                }
            }
        }
    }

    private static class SetPropertyCompleted
    implements CompletionObserver {
        Vector fSelection;
        LayoutArea fLayout;

        SetPropertyCompleted(Vector vector, LayoutArea layoutArea) {
            this.fSelection = vector;
            this.fLayout = layoutArea;
        }

        public void completed(int n, Object object) {
            int n2 = this.fSelection.size();
            Object[] objectArray = new Object[n2];
            if (n2 == 1 && this.fSelection.elementAt(0) instanceof LayoutArea) {
                LayoutArea layoutArea = (LayoutArea)this.fSelection.elementAt(0);
                objectArray[0] = layoutArea.getFigure();
                LayoutLooper.updateFigure(this.fLayout);
                ObjectRegistry.getLayoutRegistry().change(objectArray);
            } else {
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = ((GObjectWrapper)this.fSelection.elementAt(i)).getBean();
                    this.fLayout.selectObject((GObjectWrapper)this.fSelection.elementAt(i), true);
                }
                ObjectRegistry.getLayoutRegistry().change(objectArray);
            }
            LayoutLooper.updateTagProperty(this.fSelection);
        }
    }

    private static class syncWithObjectsCompleted
    implements CompletionObserver {
        Vector fSelection;

        syncWithObjectsCompleted(Vector vector) {
            this.fSelection = vector;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null) {
                Object[] objectArray = (Object[])object;
                int n2 = this.fSelection.size();
                for (int i = 0; i < n2; ++i) {
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)this.fSelection.elementAt(i);
                    if (!lOControlWrapper.isGObject()) continue;
                    Object[] objectArray2 = new Object[]{objectArray[3 * i], objectArray[3 * i + 1]};
                    ((MObjectWrapper)lOControlWrapper).setProperties(objectArray2);
                    String[] stringArray = null;
                    if (objectArray[3 * i + 2] != null && objectArray[3 * i + 2] instanceof String[]) {
                        stringArray = (String[])objectArray[3 * i + 2];
                    }
                    ((MObjectWrapper)lOControlWrapper).setCallbackNames(stringArray);
                }
            }
        }
    }

    private static class GetPropertyCompleted
    implements CompletionObserver {
        Vector fSelection;

        GetPropertyCompleted(Vector vector) {
            this.fSelection = vector;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null) {
                Object[] objectArray = (Object[])object;
                int n2 = this.fSelection.size();
                if (n2 == 1 && this.fSelection.elementAt(0) instanceof LayoutArea) {
                    if (((LayoutArea)this.fSelection.elementAt(0)).getFigure() != null) {
                        Object[] objectArray2 = new Object[]{(Object[])objectArray[0], (Object[])objectArray[1]};
                        ((LayoutArea)this.fSelection.elementAt(0)).setProperties(objectArray2);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        LOControlWrapper lOControlWrapper = (LOControlWrapper)this.fSelection.elementAt(i);
                        if (!lOControlWrapper.isGObject()) continue;
                        Object[] objectArray3 = new Object[]{objectArray[2 * i], objectArray[2 * i + 1]};
                        ((GObjectWrapper)lOControlWrapper).setProperties(objectArray3);
                    }
                }
            }
        }
    }

    private static class UpdateFigure
    implements Runnable {
        private LayoutArea fLayout;
        private UDDObject fAdapter;

        UpdateFigure(LayoutArea layoutArea) {
            this.fLayout = layoutArea;
            this.fAdapter = (UDDObject)layoutArea.getRootObject();
        }

        @Override
        public void run() {
            HGRectangle hGRectangle;
            Color color = null;
            Rectangle rectangle = null;
            int n = 4;
            Object object = HGControl.getPropertyValueForCompatibility(this.fAdapter, "Units");
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            if (n != 4) {
                HGControl.setPropertyValueForCompatibility(this.fAdapter, "Units", new Integer(4));
            }
            if ((object = HGControl.getPropertyValueForCompatibility(this.fAdapter, "Position")) != null && object instanceof HGRectangle) {
                hGRectangle = (HGRectangle)object;
                rectangle = new Rectangle((int)hGRectangle.getX(), (int)hGRectangle.getY(), (int)hGRectangle.getWidth(), (int)hGRectangle.getHeight());
            }
            if (n != 4) {
                HGControl.setPropertyValueForCompatibility(this.fAdapter, "Units", new Integer(n));
            }
            if ((object = HGControl.getPropertyValueForCompatibility(this.fAdapter, "Color")) != null && object instanceof HGColor) {
                hGRectangle = (HGColor)object;
                color = HGColor.getColor((HGColor)hGRectangle);
            }
            LayoutLooper.updateFigureAppearance(this.fLayout, color, rectangle);
        }
    }

    private static class RefreshChildrenPosition
    implements Runnable {
        private LayoutArea fLayout;
        private LOWrapperOwner[] fWrappers;

        RefreshChildrenPosition(LOWrapperOwner[] lOWrapperOwnerArray, LayoutArea layoutArea) {
            this.fWrappers = lOWrapperOwnerArray;
            this.fLayout = layoutArea;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.fWrappers.length; ++i) {
                Enumeration enumeration = null;
                if (this.fWrappers[i] instanceof LayoutArea) {
                    enumeration = ((LayoutArea)this.fWrappers[i]).wrappers();
                } else if (((GObjectWrapper)this.fWrappers[i]).isEnclosure()) {
                    enumeration = ((GObjectWrapper)this.fWrappers[i]).wrappers();
                }
                if (enumeration == null) continue;
                while (enumeration.hasMoreElements()) {
                    GObjectWrapper gObjectWrapper = (GObjectWrapper)enumeration.nextElement();
                    ((MObjectProxy)gObjectWrapper.getControl()).updatePosition((UDDObject)gObjectWrapper.getPeerBean());
                }
            }
            if (this.fLayout != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.fLayout.repaint();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RefreshChildrenPosition.this.fLayout.repaint();
                        }
                    });
                }
            }
        }
    }

    private static class ChildrenPositionUpdated
    implements CompletionObserver {
        LOWrapperOwner[] fOwners;
        LayoutArea fLayout;

        ChildrenPositionUpdated(LOWrapperOwner[] lOWrapperOwnerArray, LayoutArea layoutArea) {
            this.fLayout = layoutArea;
            this.fOwners = lOWrapperOwnerArray;
        }

        public void completed(int n, Object object) {
            double[] dArray;
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null && (dArray = (double[])object)[0] > 0.0) {
                LayoutLooper.refreshChildrenPosition(this.fOwners, this.fLayout);
            }
        }
    }

    private static class UpdateObjectWorker
    extends MatlabWorker {
        private LayoutArea fLayout;
        private LOWrapperOwner fWrapper;

        UpdateObjectWorker(LOWrapperOwner lOWrapperOwner, LayoutArea layoutArea) {
            this.fWrapper = lOWrapperOwner;
            this.fLayout = layoutArea;
        }

        public Object runOnMatlabThread() throws Exception {
            GObjectWrapper gObjectWrapper = (GObjectWrapper)this.fWrapper;
            ((MObjectProxy)gObjectWrapper.getControl()).updateProxy(gObjectWrapper.getPeerBean());
            return null;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (this.fLayout.getLayoutStatusBar() != null) {
                this.fLayout.getLayoutStatusBar().updateSelectionCoord();
            }
            this.fLayout.repaint();
        }
    }

    private static class ReorderCompleted
    implements CompletionObserver {
        LOControlWrapper[] fWrappers;
        LayoutArea fLayout;

        ReorderCompleted(LOControlWrapper[] lOControlWrapperArray, LayoutArea layoutArea) {
            this.fWrappers = lOControlWrapperArray;
            this.fLayout = layoutArea;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                LOControlWrapper lOControlWrapper = this.fWrappers[0].getParent();
                Enumeration enumeration = lOControlWrapper == null ? this.fLayout.baseWrappers() : lOControlWrapper.baseWrappers();
                while (enumeration.hasMoreElements()) {
                    LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
                    if (lOControlWrapper2.getControlType() != 1) continue;
                    lOControlWrapper2.cleanUp(false);
                    LayoutLooper.updateObject(lOControlWrapper2, this.fLayout);
                }
            }
        }
    }

    private static class MoveCompleted
    implements CompletionObserver {
        Vector fSelection;
        LayoutArea fLayout;

        MoveCompleted(Vector vector, LayoutArea layoutArea) {
            this.fSelection = vector;
            this.fLayout = layoutArea;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null) {
                int n2 = this.fSelection.size();
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = new Object[n2];
                for (int i = 0; i < n2; ++i) {
                    Object[] objectArray3 = new Object[]{objectArray[i * 2], objectArray[i * 2 + 1]};
                    GObjectWrapper gObjectWrapper = (GObjectWrapper)this.fSelection.elementAt(i);
                    gObjectWrapper.setProperties(objectArray3);
                    objectArray2[i] = gObjectWrapper.getBean();
                }
                ObjectRegistry.getLayoutRegistry().change(objectArray2);
            }
        }
    }

    private static class AddGObjectObserver
    implements CompletionObserver {
        LayoutArea fLayout;
        Vector fWrappers;
        LOWrapperOwner[] fParents;

        AddGObjectObserver(LOWrapperOwner[] lOWrapperOwnerArray, Vector vector, LayoutArea layoutArea) {
            this.fLayout = layoutArea;
            this.fWrappers = vector;
            this.fParents = lOWrapperOwnerArray;
        }

        public void completed(int n, Object object) {
            GObjectWrapper gObjectWrapper = null;
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = new Object[this.fWrappers.size()];
                for (int i = 0; i < this.fWrappers.size(); ++i) {
                    gObjectWrapper = (GObjectWrapper)this.fWrappers.elementAt(i);
                    gObjectWrapper.setHandle(objectArray[i * 6]);
                    gObjectWrapper.setBean(objectArray[i * 6 + 1]);
                    gObjectWrapper.setPeerBean(objectArray[i * 6 + 2]);
                    Object[] objectArray3 = new Object[]{objectArray[i * 6 + 3], objectArray[i * 6 + 4]};
                    gObjectWrapper.setProperties(objectArray3);
                    Object object2 = objectArray[i * 6 + 5];
                    if (object2 != null && object2 instanceof String[]) {
                        gObjectWrapper.setCallbackNames((String[])object2);
                    }
                    if (gObjectWrapper.needToMove()) {
                        gObjectWrapper.setNeedToMove(false);
                        gObjectWrapper.updatePosition();
                    }
                    Object object3 = gObjectWrapper.getParentObject();
                    ObjectOwner objectOwner = gObjectWrapper.getObjectOwner();
                    if (object3 != null && objectOwner != null) {
                        Object[] objectArray4 = new Object[]{gObjectWrapper.getBean()};
                        ObjectRegistry.getLayoutRegistry().register(objectArray4, object3, -1, objectOwner, gObjectWrapper.isEnclosure());
                    }
                    objectArray2[i] = objectArray[i * 6 + 1];
                }
                ObjectRegistry.getLayoutRegistry().setSelected(objectArray2, true);
            }
            if (this.fLayout != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AddGObjectObserver.this.fLayout.validate();
                        AddGObjectObserver.this.fLayout.repaint(5L);
                    }
                });
            }
        }
    }

    private static class ChangeParentObserver
    implements CompletionObserver {
        LayoutArea fLayout;
        Vector fWrappers;
        int[] fIndice;

        ChangeParentObserver(Vector vector, LayoutArea layoutArea, int[] nArray) {
            this.fLayout = layoutArea;
            this.fWrappers = vector;
            this.fIndice = nArray;
        }

        public void completed(int n, Object object) {
            GObjectWrapper gObjectWrapper = null;
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                int n2 = -1;
                for (int i = 0; i < this.fWrappers.size(); ++i) {
                    gObjectWrapper = (GObjectWrapper)this.fWrappers.elementAt(i);
                    if (this.fIndice != null) {
                        n2 = this.fIndice[i];
                    }
                    Object object2 = this.fLayout.getRootObject();
                    if (gObjectWrapper.getParent() != null) {
                        object2 = gObjectWrapper.getParent().getBean();
                    }
                    gObjectWrapper.cleanUp(false);
                    ObjectRegistry.getLayoutRegistry().move(new Object[]{gObjectWrapper.getBean()}, object2, n2);
                }
            }
        }
    }

    private static class DeleteGObjectObserver
    implements CompletionObserver {
        LayoutArea fLayout;
        Vector fWrappers;

        DeleteGObjectObserver(Vector vector, LayoutArea layoutArea) {
            this.fLayout = layoutArea;
            this.fWrappers = vector;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null) {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < this.fWrappers.size(); ++i) {
                    Object[] objectArray2 = new Object[]{objectArray[i * 2], objectArray[i * 2 + 1]};
                    ((GObjectWrapper)this.fWrappers.elementAt(i)).setProperties(objectArray2);
                }
            }
        }
    }
}

