/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.mathworks.beans.ServiceClient;
import com.mathworks.beans.ServiceRegistry;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mlwidgets.inspector.PropertyTarget;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.services.ObjectOwner;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import com.mathworks.toolbox.matlab.guide.HGControl;
import com.mathworks.toolbox.matlab.guide.LayoutClipboard;
import com.mathworks.toolbox.matlab.guide.LayoutEditor;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.LayoutOptions;
import com.mathworks.toolbox.matlab.guide.LayoutStackingArea;
import com.mathworks.toolbox.matlab.guide.LayoutStatusBar;
import com.mathworks.toolbox.matlab.guide.MWTPanel;
import com.mathworks.toolbox.matlab.guide.RuntimeArea;
import com.mathworks.toolbox.matlab.guide.TagManager;
import com.mathworks.toolbox.matlab.guide.VectorSort;
import com.mathworks.toolbox.matlab.guide.dragdrop.AddDrag;
import com.mathworks.toolbox.matlab.guide.dragdrop.CornerDrag;
import com.mathworks.toolbox.matlab.guide.dragdrop.DragTracker;
import com.mathworks.toolbox.matlab.guide.dragdrop.MoveDrag;
import com.mathworks.toolbox.matlab.guide.dragdrop.ResizeDrag;
import com.mathworks.toolbox.matlab.guide.dragdrop.RulerGuideDrag;
import com.mathworks.toolbox.matlab.guide.dragdrop.SelectDrag;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.LayoutGrid;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.LayoutRuler;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.RulerGuide;
import com.mathworks.toolbox.matlab.guide.layout.AlignmentManager;
import com.mathworks.toolbox.matlab.guide.layout.LayoutEnum;
import com.mathworks.toolbox.matlab.guide.palette.GObjectProxy;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOWrapperOwner;
import com.mathworks.toolbox.matlab.guide.palette.LayoutHandleEnum;
import com.mathworks.toolbox.matlab.guide.palette.LayoutWrapperOwner;
import com.mathworks.toolbox.matlab.guide.palette.MObjectProxy;
import com.mathworks.toolbox.matlab.guide.palette.MObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.ToolPalette;
import com.mathworks.toolbox.matlab.guide.undoredo.LayoutUndoManager;
import com.mathworks.toolbox.matlab.guide.undoredo.UndoAdd;
import com.mathworks.toolbox.matlab.guide.undoredo.UndoDelete;
import com.mathworks.toolbox.matlab.guide.undoredo.UndoFigure;
import com.mathworks.toolbox.matlab.guide.undoredo.UndoMove;
import com.mathworks.toolbox.matlab.guide.undoredo.UndoProperty;
import com.mathworks.toolbox.matlab.guide.undoredo.UndoReorder;
import com.mathworks.toolbox.matlab.guide.utils.LayoutUtils;
import com.mathworks.toolbox.matlab.guide.utils.LayoutWorker;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.Beans;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.undo.UndoableEdit;

public class LayoutArea
extends MWTPanel
implements MouseListener,
MouseMotionListener,
LOWrapperOwner,
LayoutStackingArea {
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    private static final int BIG_MOVE_INCREMENT = 10;
    private static final int DELAY = 5;
    private static final int DRAG_DIM = 8;
    private static ArrowTimer sArrowTimer;
    public static final String LAYOUT_AREA_SERVICE = "com/mathworks/toolbox/matlab/guide/LayoutArea";
    static final int MIN_DIM = 8;
    private int fSelectionCount;
    private LayoutGrid fLayoutGrid;
    private ToolPalette fToolPalette;
    private LayoutRuler fHRuler;
    private LayoutRuler fVRuler;
    private RuntimeArea fRuntimeArea;
    private Object fHandle;
    private Object fRootObject;
    private DragTracker fDragTracker;
    private KeyTracker fKeyTracker;
    private ObjectOwner fObjectOwner;
    private LayoutUndoManager fUndoManager;
    private ServiceRegistry fServiceRegistry;
    private ObjectRegistryListener fChangeListener;
    private ItemListener fSelectionListener;
    private MJPopupMenu fObjectPopup;
    private MJPopupMenu fWindowPopup;
    private TagManager fTagManager;
    private AlignmentManager fAlignmentManager;
    private Point fLastClick;
    private Point fMouseStart = new Point();
    private int fArrowID;
    private int fPropertyFromInspector;
    private Object[] fProperties;
    private String[] fCallbacks;
    private LayoutOptions fOptions;
    private LayoutWrapperOwner fWrapperOwner;
    private LayoutStatusBar fLayoutStatusBar;
    private LayoutEditor fLayoutEditor;
    private String fFigureTag;
    public static final int FORWARD = 0;
    public static final int BACKWARD = 1;
    private Point fArrowKeyMoveDelta = new Point(0, 0);

    LayoutArea(LayoutEditor layoutEditor, int n, int n2, Container container) {
        this.setLayout(null);
        this.setSize(n, n2);
        this.setName("Layout Area");
        this.fLayoutEditor = layoutEditor;
        this.fRuntimeArea = (RuntimeArea)container;
        this.fObjectOwner = new LayoutOwner();
        this.fChangeListener = new ObjectChanged();
        this.fSelectionListener = new SelectionChanged();
        this.fTagManager = new TagManager(this);
        this.fAlignmentManager = new AlignmentManager(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(new LayoutKey());
        this.setBackground(new Color(192, 192, 192));
        this.fServiceRegistry = new ServiceRegistry();
        this.fServiceRegistry.registerService(LAYOUT_AREA_SERVICE, (Object)this);
        this.fPropertyFromInspector = 0;
        this.fProperties = null;
        this.fCallbacks = null;
        this.fOptions = new LayoutOptions(null, null, this);
        this.fWrapperOwner = new LayoutWrapperOwner(true);
    }

    public final Object getRootObject() {
        if (this.fRootObject != null) {
            return this.fRootObject;
        }
        return this.fRuntimeArea;
    }

    final Object getObjectOwner() {
        return this.fObjectOwner;
    }

    public final RuntimeArea getRuntimeArea() {
        return this.fRuntimeArea;
    }

    public final LayoutEditor getLayoutEditor() {
        return this.fLayoutEditor;
    }

    final void setRootObject(Object object) {
        this.fRootObject = object;
        this.figureChanged();
    }

    final void setFigure(Object object) {
        this.fHandle = object;
    }

    public final Object getFigure() {
        return this.fHandle;
    }

    public void setLayoutOptions(Object[] objectArray, Object[] objectArray2) {
        this.fOptions.setOptions(objectArray, objectArray2);
    }

    public LayoutOptions getLayoutOptions() {
        return this.fOptions;
    }

    public void setCallbackNames(String[] stringArray) {
        this.fCallbacks = stringArray;
    }

    public String[] getCallbackNames() {
        return this.fCallbacks;
    }

    public void setPropertiesWithAffectOnOptions(Object[] objectArray) {
        if (this.fProperties != null && this.fOptions != null && this.fOptions.isUseSystemColor()) {
            Object[] objectArray2 = (Object[])objectArray[0];
            int n = -1;
            for (int i = 0; i < objectArray2.length; ++i) {
                if (!((String)objectArray2[i]).equalsIgnoreCase("Color")) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                double[] dArray;
                double[] dArray2;
                Object[] objectArray3 = (Object[])objectArray[1];
                Object[] objectArray4 = (Object[])this.fProperties[1];
                if (objectArray3[n] instanceof double[] && (dArray2 = (double[])objectArray3[n]).length == (dArray = (double[])objectArray4[n]).length) {
                    boolean bl = false;
                    for (int i = 0; i < dArray2.length; ++i) {
                        if (dArray2[i] == dArray[i]) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        LayoutLooper.setOption(this, LayoutOptions.sUseSystemColor, new Boolean(false));
                    }
                }
            }
        }
        this.setProperties(objectArray);
    }

    public void setProperties(Object[] objectArray) {
        this.fProperties = objectArray;
    }

    public Object[] getProperties() {
        return this.fProperties;
    }

    public void setPalette(ToolPalette toolPalette) {
        this.fToolPalette = toolPalette;
    }

    public ToolPalette getPalette() {
        return this.fToolPalette;
    }

    public void setHRuler(LayoutRuler layoutRuler) {
        this.fHRuler = layoutRuler;
    }

    public LayoutRuler getHRuler() {
        return this.fHRuler;
    }

    public void setVRuler(LayoutRuler layoutRuler) {
        this.fVRuler = layoutRuler;
    }

    public LayoutRuler getVRuler() {
        return this.fVRuler;
    }

    final void setObjectPopup(MJPopupMenu mJPopupMenu) {
        this.fObjectPopup = mJPopupMenu;
        this.fObjectPopup.setInvoker((Component)this);
    }

    final void setWindowPopup(MJPopupMenu mJPopupMenu) {
        this.fWindowPopup = mJPopupMenu;
        this.fWindowPopup.setInvoker((Component)this);
    }

    public final void setGrid(LayoutGrid layoutGrid) {
        this.fLayoutGrid = layoutGrid;
    }

    public final LayoutGrid getGrid() {
        return this.fLayoutGrid;
    }

    final void updatePasteCmd() {
        this.fLayoutEditor.updatePaste();
    }

    private Vector sortObjectIndices(int n) {
        Vector<LOControlWrapper> vector = this.getSelectedControls();
        VectorSort vectorSort = n == 2 ? new VerticalSort() : new HorizontalSort();
        vectorSort.sort(vector);
        return vector;
    }

    private void distributeMiddleObjects(int n, int n2) {
        Dimension dimension = this.getSize();
        int n3 = this.getSelectedObjectCount();
        if (n3 > 1) {
            Vector vector = this.sortObjectIndices(n);
            switch (n) {
                case 2: {
                    int n4;
                    LOControlWrapper lOControlWrapper;
                    int n5 = vector.size();
                    if (n2 == -1) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n5 - 1);
                        int n6 = lOControlWrapper.getTop();
                        int n7 = (lOControlWrapper.getBottom() - lOControlWrapper.getTop()) / 2;
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                        int n8 = lOControlWrapper.getBottom();
                        int n9 = n6 - n8 + (n7 += (lOControlWrapper.getBottom() - lOControlWrapper.getTop()) / 2);
                        n4 = n9 / (n5 - 1);
                        n5 = vector.size() - 1;
                    } else {
                        n4 = n2;
                        n5 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    int n10 = (lOControlWrapper.getBottom() - lOControlWrapper.getTop()) / 2;
                    int n11 = lOControlWrapper.getTop() + n4 + n10;
                    for (int i = 1; i < n5; ++i) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
                        n10 = (lOControlWrapper.getBottom() - lOControlWrapper.getTop()) / 2;
                        int n12 = lOControlWrapper.getBottom() - n10;
                        int n13 = n12 - n11;
                        lOControlWrapper.offsetRect(0, -n13);
                        if (lOControlWrapper.getBottom() > dimension.height) {
                            lOControlWrapper.offsetRect(0, dimension.height - lOControlWrapper.getBottom());
                        }
                        n11 = lOControlWrapper.getTop() + n4 + n10;
                    }
                    break;
                }
                case 1: {
                    int n14;
                    LOControlWrapper lOControlWrapper;
                    int n15 = vector.size();
                    if (n2 == -1) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n15 - 1);
                        int n16 = lOControlWrapper.getLeft();
                        int n17 = (lOControlWrapper.getRight() - lOControlWrapper.getLeft()) / 2;
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                        int n18 = lOControlWrapper.getRight();
                        int n19 = n16 - n18 + (n17 += (lOControlWrapper.getRight() - lOControlWrapper.getLeft()) / 2);
                        n14 = n19 / (n15 - 1);
                        n15 = vector.size() - 1;
                    } else {
                        n14 = n2;
                        n15 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    int n20 = (lOControlWrapper.getRight() - lOControlWrapper.getLeft()) / 2;
                    int n21 = lOControlWrapper.getLeft() + n14 + n20;
                    for (int i = 1; i < n15; ++i) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
                        n20 = (lOControlWrapper.getRight() - lOControlWrapper.getLeft()) / 2;
                        int n22 = lOControlWrapper.getRight() - n20;
                        int n23 = n22 - n21;
                        lOControlWrapper.offsetRect(-n23, 0);
                        if (lOControlWrapper.getRight() > dimension.width) {
                            lOControlWrapper.offsetRect(dimension.width - lOControlWrapper.getRight(), 0);
                        }
                        n21 = lOControlWrapper.getLeft() + n14 + n20;
                    }
                    break;
                }
            }
        }
        this.updateSelection();
    }

    private void distributeBottomRightObjects(int n, int n2) {
        Dimension dimension = this.getSize();
        int n3 = this.getSelectedObjectCount();
        if (n3 > 1) {
            Vector vector = this.sortObjectIndices(n);
            switch (n) {
                case 2: {
                    int n4;
                    int n5 = vector.size();
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n5 - 1);
                    if (n2 == -1) {
                        int n6 = lOControlWrapper.getBottom();
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                        int n7 = lOControlWrapper.getBottom();
                        int n8 = n6 - n7;
                        n4 = n8 / (n5 - 1);
                    } else {
                        n4 = n2;
                        n5 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    int n9 = lOControlWrapper.getBottom() + n4;
                    for (int i = 1; i < n5; ++i) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
                        int n10 = lOControlWrapper.getBottom();
                        int n11 = n10 - n9;
                        lOControlWrapper.offsetRect(0, -n11);
                        if (lOControlWrapper.getBottom() > dimension.height) {
                            lOControlWrapper.offsetRect(0, dimension.height - lOControlWrapper.getBottom());
                        }
                        n9 = lOControlWrapper.getBottom() + n4;
                    }
                    break;
                }
                case 1: {
                    int n12;
                    int n13 = vector.size();
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n13 - 1);
                    if (n2 == -1) {
                        int n14 = lOControlWrapper.getRight();
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                        int n15 = lOControlWrapper.getRight();
                        int n16 = n14 - n15;
                        n12 = n16 / (n13 - 1);
                        n13 = vector.size() - 1;
                    } else {
                        n12 = n2;
                        n13 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    int n17 = lOControlWrapper.getRight() + n12;
                    for (int i = 1; i < n13; ++i) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
                        int n18 = lOControlWrapper.getRight();
                        int n19 = n18 - n17;
                        lOControlWrapper.offsetRect(-n19, 0);
                        if (lOControlWrapper.getRight() > dimension.width) {
                            lOControlWrapper.offsetRect(dimension.width - lOControlWrapper.getRight(), 0);
                        }
                        n17 = lOControlWrapper.getRight() + n12;
                    }
                    break;
                }
            }
        }
        this.updateSelection();
    }

    private void distributeTopLeftObjects(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = this.getSize();
        int n5 = this.getSelectedObjectCount();
        if (n5 > 1) {
            Vector vector = this.sortObjectIndices(n);
            switch (n) {
                case 2: {
                    int n6 = vector.size();
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n6 - 1);
                    int n7 = lOControlWrapper.getTop();
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    if (n2 == -1) {
                        int n8 = lOControlWrapper.getTop();
                        int n9 = n7 - n8;
                        n3 = n9 / (n6 - 1);
                        n6 = vector.size() - 1;
                    } else {
                        n3 = n2;
                        n6 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    n4 = lOControlWrapper.getTop() + n3;
                    for (int i = 1; i < n6; ++i) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
                        int n10 = lOControlWrapper.getTop();
                        int n11 = n10 - n4;
                        lOControlWrapper.offsetRect(0, -n11);
                        if (lOControlWrapper.getBottom() > dimension.height) {
                            lOControlWrapper.offsetRect(0, dimension.height - lOControlWrapper.getBottom());
                        }
                        n4 = lOControlWrapper.getTop() + n3;
                    }
                    break;
                }
                case 1: {
                    int n12 = vector.size();
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(n12 - 1);
                    int n13 = lOControlWrapper.getLeft();
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    if (n2 == -1) {
                        int n14 = lOControlWrapper.getLeft();
                        int n15 = n13 - n14;
                        n3 = n15 / (n12 - 1);
                        n12 = vector.size() - 1;
                    } else {
                        n3 = n2;
                        n12 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    n4 = lOControlWrapper.getLeft() + n3;
                    for (int i = 1; i < n12; ++i) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
                        int n16 = lOControlWrapper.getLeft();
                        int n17 = n16 - n4;
                        lOControlWrapper.offsetRect(-n17, 0);
                        if (lOControlWrapper.getRight() > dimension.width) {
                            lOControlWrapper.offsetRect(dimension.width - lOControlWrapper.getRight(), 0);
                        }
                        n4 = lOControlWrapper.getLeft() + n3;
                    }
                    break;
                }
            }
        }
        this.updateSelection();
    }

    private void distributeBetweenObjects(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Dimension dimension = this.getSize();
        int n7 = this.getSelectedObjectCount();
        if (n7 > 1) {
            Vector vector = this.sortObjectIndices(n);
            switch (n) {
                case 2: {
                    LOControlWrapper lOControlWrapper;
                    int n8;
                    int n9 = vector.size();
                    for (n8 = 0; n8 < n9; ++n8) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n8);
                        n3 += lOControlWrapper.getBottom() - lOControlWrapper.getTop();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(n9 - 1);
                    int n10 = lOControlWrapper.getBottom();
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    int n11 = lOControlWrapper.getTop();
                    int n12 = n10 - n11;
                    if (n2 == -1) {
                        n4 = n12 - n3;
                        n5 = n4 / (n9 - 1);
                        n9 = vector.size() - 1;
                    } else {
                        n5 = n2;
                        n9 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    n6 = lOControlWrapper.getBottom() + n5;
                    n9 = vector.size();
                    for (n8 = 1; n8 < n9; ++n8) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n8);
                        int n13 = lOControlWrapper.getTop();
                        int n14 = n13 - n6;
                        lOControlWrapper.offsetRect(0, -n14);
                        if (lOControlWrapper.getBottom() > dimension.height) {
                            lOControlWrapper.offsetRect(0, dimension.height - lOControlWrapper.getBottom());
                        }
                        n6 = lOControlWrapper.getBottom() + n5;
                    }
                    break;
                }
                case 1: {
                    LOControlWrapper lOControlWrapper;
                    int n15;
                    int n16 = vector.size();
                    for (n15 = 0; n15 < n16; ++n15) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n15);
                        n3 += lOControlWrapper.getRight() - lOControlWrapper.getLeft();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(n16 - 1);
                    int n17 = lOControlWrapper.getRight();
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    int n18 = lOControlWrapper.getLeft();
                    int n19 = n17 - n18;
                    if (n2 == -1) {
                        n4 = n19 - n3;
                        n5 = n4 / (n16 - 1);
                        n16 = vector.size() - 1;
                    } else {
                        n5 = n2;
                        n16 = vector.size();
                    }
                    lOControlWrapper = (LOControlWrapper)vector.elementAt(0);
                    n6 = lOControlWrapper.getRight() + n5;
                    for (n15 = 1; n15 < n16; ++n15) {
                        lOControlWrapper = (LOControlWrapper)vector.elementAt(n15);
                        int n20 = lOControlWrapper.getLeft();
                        int n21 = n20 - n6;
                        lOControlWrapper.offsetRect(-n21, 0);
                        if (lOControlWrapper.getRight() > dimension.width) {
                            lOControlWrapper.offsetRect(dimension.width - lOControlWrapper.getRight(), 0);
                        }
                        n6 = lOControlWrapper.getRight() + n5;
                    }
                    break;
                }
            }
        }
        this.updateSelection();
    }

    public AlignmentManager getAlignmentManager() {
        return this.fAlignmentManager;
    }

    public void doAlignDist(int n, int n2, int n3, int n4) {
        if (this.getSelectedObjectCount() <= 1) {
            return;
        }
        Vector<LOControlWrapper> vector = this.getSelectedControls();
        UndoMove undoMove = new UndoMove(this, vector);
        switch (n) {
            case 4: {
                this.getAlignmentManager().alignControls(LayoutEnum.ALIGN_TOP, false);
                break;
            }
            case 2: {
                this.getAlignmentManager().alignControls(LayoutEnum.ALIGN_CENTER_VERT, false);
                break;
            }
            case 5: {
                this.getAlignmentManager().alignControls(LayoutEnum.ALIGN_BOTTOM, false);
                break;
            }
            case 7: {
                this.distributeBetweenObjects(2, n2);
                break;
            }
            case 11: {
                this.distributeTopLeftObjects(2, n2);
                break;
            }
            case 9: {
                this.distributeMiddleObjects(2, n2);
                break;
            }
            case 12: {
                this.distributeBottomRightObjects(2, n2);
                break;
            }
        }
        switch (n3) {
            case 1: {
                this.getAlignmentManager().alignControls(LayoutEnum.ALIGN_LEFT, false);
                break;
            }
            case 2: {
                this.getAlignmentManager().alignControls(LayoutEnum.ALIGN_CENTER_HORZ, false);
                break;
            }
            case 3: {
                this.getAlignmentManager().alignControls(LayoutEnum.ALIGN_RIGHT, false);
                break;
            }
            case 7: {
                this.distributeBetweenObjects(1, n4);
                break;
            }
            case 8: {
                this.distributeTopLeftObjects(1, n4);
                break;
            }
            case 9: {
                this.distributeMiddleObjects(1, n4);
                break;
            }
            case 10: {
                this.distributeBottomRightObjects(1, n4);
                break;
            }
        }
        if (undoMove.moveComplete()) {
            if (this.fHandle != null) {
                LayoutLooper.requestMove(vector, null);
            } else {
                this.fireObjectChangedEvent(vector);
            }
            this.fireContentChangedEvent();
            this.fireUndoEvent(undoMove);
            this.repaint(5L);
        }
        this.updateSelection();
    }

    void doCut() {
        this.doCopy();
        this.doClear();
    }

    void doCopy() {
        Vector<LOControlWrapper> vector = this.getSelectedControls();
        if (vector.size() == 0) {
            return;
        }
        Object[] objectArray = vector.toArray();
        LayoutClipboard.getClipboard().copy(this, objectArray);
    }

    void doPaste() {
        LayoutClipboard.getClipboard().paste(this);
    }

    public void doDuplicate(LOControlWrapper lOControlWrapper, Point point) {
        Vector<LOControlWrapper> vector = this.getSelectedControls();
        if (vector.size() == 0) {
            return;
        }
        this.selectAll(false);
        this.updateSelection();
        Object object = lOControlWrapper == null ? this.fHandle : lOControlWrapper.getBean();
        LayoutLooper.duplicate(object, vector, point, new DuplicateObserver());
    }

    void duplicateComplete(Object object) {
        if (object != null && object instanceof Object[]) {
            this.selectAll(false);
            this.updateSelection();
            Object[] objectArray = (Object[])object;
            int n = 0;
            Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>();
            if (objectArray.length == 6) {
                Object[] objectArray2 = (Object[])objectArray[0];
                Object[] objectArray3 = (Object[])objectArray[1];
                Object[] objectArray4 = (Object[])objectArray[2];
                Object[] objectArray5 = (Object[])objectArray[3];
                Object[] objectArray6 = (Object[])objectArray[4];
                boolean[] blArray = (boolean[])objectArray[5];
                n = objectArray2 == null ? 0 : objectArray2.length;
                for (int i = 0; i < n; ++i) {
                    LOControlWrapper lOControlWrapper = this.addMLObject((MObjectProxy)objectArray4[i], objectArray2[i], objectArray3[i], objectArray5[i], objectArray6[i], -1);
                    if (lOControlWrapper.isGObject()) {
                        ((GObjectWrapper)lOControlWrapper).setRootObject(this.fRootObject);
                        ((GObjectWrapper)lOControlWrapper).setObjectOwner(this.fObjectOwner);
                        ((GObjectWrapper)lOControlWrapper).setLayoutArea(this);
                    }
                    boolean bl = true;
                    for (LOControlWrapper lOControlWrapper2 = lOControlWrapper.getParent(); lOControlWrapper2 != null; lOControlWrapper2 = lOControlWrapper2.getParent()) {
                        if (!lOControlWrapper2.isSelected()) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        lOControlWrapper.setSelected(true);
                    }
                    if (!blArray[i]) continue;
                    vector.addElement(lOControlWrapper);
                }
            }
            this.updateSelection();
            if (n > 0) {
                this.fireUndoEvent(new UndoAdd(this, vector));
            }
            this.repaint(5L);
        }
    }

    public static void forceLayout(Container container) {
        LayoutArea.recursiveLayout(container);
    }

    private static void recursiveLayout(Container container) {
        container.doLayout();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component == null || !(component instanceof Container)) continue;
            Container container2 = (Container)component;
            LayoutArea.recursiveLayout(container2);
        }
    }

    @Override
    public void addToLayer(LOControlWrapper lOControlWrapper, int n) {
        this.fRuntimeArea.addToLayer(lOControlWrapper, n);
    }

    @Override
    public void removeFromLayer(LOControlWrapper lOControlWrapper) {
        this.fRuntimeArea.removeFromLayer(lOControlWrapper);
    }

    public void addObject(int n, Object object, Rectangle rectangle, LOWrapperOwner lOWrapperOwner) {
        if (object instanceof MObjectProxy) {
            if (!((MObjectProxy)object).isProxyCreated()) {
                LayoutLooper.prepareProxy(this, (MObjectProxy)object, rectangle, lOWrapperOwner);
            } else {
                n = ((MObjectProxy)object).getType();
                this.addLayoutObject(n, object, rectangle, lOWrapperOwner);
            }
        } else {
            this.addLayoutObject(n, object, rectangle, lOWrapperOwner);
        }
    }

    private void addLayoutObject(int n, Object object, Rectangle rectangle, LOWrapperOwner lOWrapperOwner) {
        LOControlWrapper lOControlWrapper = LOControlWrapper.buildWrapper(n, object);
        if (lOControlWrapper == null) {
            return;
        }
        if (lOControlWrapper.isGObject()) {
            GObjectWrapper gObjectWrapper = (GObjectWrapper)lOControlWrapper;
            gObjectWrapper.setRootObject(this.fRootObject);
            gObjectWrapper.setObjectOwner(this.fObjectOwner);
            gObjectWrapper.setLayoutArea(this);
        }
        int n2 = -1;
        Point point = new Point(rectangle.x, rectangle.y);
        if (lOWrapperOwner == null) {
            n2 = -2;
            lOWrapperOwner = this;
        } else if (lOWrapperOwner != this) {
            ((LOControlWrapper)lOWrapperOwner).translateFromBaseCoordinates(point);
            rectangle.setLocation(point);
        }
        Component component = lOControlWrapper.getControl();
        Dimension dimension = component.getPreferredSize();
        if (rectangle.width <= 2) {
            rectangle.width = dimension.width;
        }
        if (rectangle.height <= 2) {
            rectangle.height = dimension.height;
        }
        switch (n) {
            case 11: 
            case 12: 
            case 18: 
            case 21: 
            case 22: {
                rectangle.height = component.getPreferredSize().height;
                break;
            }
            case 14: {
                if (rectangle.width > rectangle.height) {
                    rectangle.width = Math.max(rectangle.width, 50);
                    rectangle.height = 16;
                    break;
                }
                rectangle.width = 16;
                rectangle.height = Math.max(rectangle.height, 50);
                break;
            }
        }
        Dimension dimension2 = component.getMinimumSize();
        this.ensureMinimumSize(dimension2);
        if (rectangle.width < dimension2.width) {
            rectangle.width = dimension2.width;
        }
        if (rectangle.height < dimension2.height) {
            rectangle.height = dimension2.height;
        }
        Dimension dimension3 = component.getMaximumSize();
        if (rectangle.width > dimension3.width) {
            rectangle.width = dimension3.width;
        }
        if (rectangle.height > dimension3.height) {
            rectangle.height = dimension3.height;
        }
        component.setBounds(rectangle);
        this.selectObject(lOControlWrapper, true);
        lOWrapperOwner.addWrapper(lOControlWrapper, n2, true);
        if (lOControlWrapper.getNeedsLayout()) {
            LayoutArea.recursiveLayout((Container)component);
        }
        if (!lOControlWrapper.isGObject()) {
            this.fTagManager.setNewUniqueName(lOControlWrapper.getBean());
            this.register(lOControlWrapper);
        }
        if (lOControlWrapper.isBean()) {
            this.addServices(lOControlWrapper);
        }
        if (!lOControlWrapper.isGObject()) {
            this.updateSelection();
        }
        this.fireContentChangedEvent();
        Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>(1);
        vector.addElement(lOControlWrapper);
        this.fireUndoEvent(new UndoAdd(this, vector));
        Point point2 = lOControlWrapper.getBaseLocation();
        Dimension dimension4 = component.getSize();
        this.repaint(5L, point2.x - 2, point2.y - 2, dimension4.width + 4, dimension4.height + 4);
        this.requestFocus();
    }

    public void ensureMinimumSize(Dimension dimension) {
        if (dimension.width < 8) {
            dimension.width = 8;
        }
        if (dimension.height < 8) {
            dimension.height = 8;
        }
    }

    LOControlWrapper addMLObject(MObjectProxy mObjectProxy, Object object, Object object2, Object object3, Object object4, int n) {
        Object[] objectArray;
        GObjectWrapper gObjectWrapper = new GObjectWrapper(mObjectProxy, object, object2, object3);
        gObjectWrapper.setRootObject(this.fRootObject);
        gObjectWrapper.setObjectOwner(this.fObjectOwner);
        gObjectWrapper.setLayoutArea(this);
        Object object5 = this;
        Object object6 = this.fRootObject;
        if (object4 != null && object4 != this.fRootObject && (objectArray = this.findWrapper(object4)) != null) {
            object5 = objectArray;
            object6 = objectArray.getBean();
        }
        object5.addWrapper(gObjectWrapper, n, true);
        objectArray = new Object[]{object2};
        boolean bl = gObjectWrapper.isEnclosure();
        ObjectRegistry.getLayoutRegistry().register(objectArray, object6, -1, this.fObjectOwner, bl);
        return gObjectWrapper;
    }

    void cleanUp() {
        this.removeServices();
        this.removeAll();
        Enumeration enumeration = this.baseWrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            lOControlWrapper.cleanUp(false);
        }
    }

    public void register(LOControlWrapper lOControlWrapper) {
        if (lOControlWrapper.getBean() != null) {
            this.registerNow(lOControlWrapper);
        }
    }

    private void registerNow(LOControlWrapper lOControlWrapper) {
        Vector vector;
        Object[] objectArray = new Object[]{lOControlWrapper.getBean()};
        Object object = this.getRootObject();
        int n = lOControlWrapper.getControlType();
        if (lOControlWrapper.getParent() != null) {
            object = lOControlWrapper.getControl().getParent();
        }
        boolean bl = lOControlWrapper.isEnclosure();
        ObjectRegistry.getLayoutRegistry().register(objectArray, object, -1, this.fObjectOwner, bl);
        if (bl && (vector = lOControlWrapper.getSublayer()) != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.register((LOControlWrapper)enumeration.nextElement());
            }
        }
    }

    void registerAll() {
        Enumeration enumeration = this.fWrapperOwner.baseWrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            this.register(lOControlWrapper);
        }
        ObjectRegistry.getLayoutRegistry().addObjectRegistryListener(this.fChangeListener);
        ObjectRegistry.getLayoutRegistry().addItemListener(this.fSelectionListener);
    }

    void unregisterAll() {
        ObjectRegistry.getLayoutRegistry().removeItemListener(this.fSelectionListener);
        ObjectRegistry.getLayoutRegistry().removeObjectRegistryListener(this.fChangeListener);
        if (this.hasSelection()) {
            ObjectRegistry.getLayoutRegistry().setSelected(null, false, true);
        }
    }

    void addService(String string, Object object) {
        this.fServiceRegistry.registerService(string, object);
    }

    void removeServices() {
        Enumeration enumeration = this.allWrappers();
        while (enumeration.hasMoreElements()) {
            Object object;
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isBean() || !Beans.isInstanceOf(object = lOControlWrapper.getBean(), ServiceClient.class)) continue;
            ServiceClient serviceClient = (ServiceClient)Beans.getInstanceOf(object, ServiceClient.class);
            serviceClient.servicesUnavailable(this.fServiceRegistry);
        }
    }

    void addServices() {
        Enumeration enumeration = this.allWrappers();
        while (enumeration.hasMoreElements()) {
            Object object;
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isBean() || !Beans.isInstanceOf(object = lOControlWrapper.getBean(), ServiceClient.class)) continue;
            ServiceClient serviceClient = (ServiceClient)Beans.getInstanceOf(object, ServiceClient.class);
            serviceClient.servicesAvailable(this.fServiceRegistry);
        }
    }

    public void removeServices(LOControlWrapper lOControlWrapper) {
        Enumeration enumeration;
        if (lOControlWrapper.isBean()) {
            Object object = lOControlWrapper.getBean();
            if (Beans.isInstanceOf(object, ServiceClient.class)) {
                ServiceClient serviceClient = (ServiceClient)Beans.getInstanceOf(object, ServiceClient.class);
                serviceClient.servicesUnavailable(this.fServiceRegistry);
            }
        } else if (lOControlWrapper.isEnclosure() && (enumeration = lOControlWrapper.wrappers()) != null) {
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
                this.removeServices(lOControlWrapper2);
            }
        }
    }

    public void addServices(LOControlWrapper lOControlWrapper) {
        Enumeration enumeration;
        if (lOControlWrapper.isBean()) {
            Object object = lOControlWrapper.getBean();
            if (Beans.isInstanceOf(object, ServiceClient.class)) {
                ServiceClient serviceClient = (ServiceClient)Beans.getInstanceOf(object, ServiceClient.class);
                serviceClient.servicesAvailable(this.fServiceRegistry);
            }
        } else if (lOControlWrapper.isEnclosure() && (enumeration = lOControlWrapper.wrappers()) != null) {
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper2 = (LOControlWrapper)enumeration.nextElement();
                this.addServices(lOControlWrapper2);
            }
        }
    }

    public void unregister(LOControlWrapper lOControlWrapper) {
        Object[] objectArray = new Object[]{lOControlWrapper.getBean()};
        ObjectRegistry.getLayoutRegistry().unregister(objectArray);
    }

    public void move(LOControlWrapper lOControlWrapper, int n) {
        Object[] objectArray = new Object[]{lOControlWrapper.getBean()};
        Object object = this.getRootObject();
        LOControlWrapper lOControlWrapper2 = lOControlWrapper.getParent();
        if (lOControlWrapper2 != null) {
            object = lOControlWrapper2.isGObject() ? lOControlWrapper2.getBean() : lOControlWrapper.getControl().getParent();
        }
        ObjectRegistry.getLayoutRegistry().move(objectArray, object, n);
    }

    public void updateSelection() {
        Object[] objectArray = this.getSelectedObjects();
        if (objectArray == null) {
            this.fSelectionCount = 0;
            objectArray = new Object[]{this.getRootObject()};
        } else {
            this.fSelectionCount = objectArray.length;
        }
        this.fireSelectionChangedEvent(this.fSelectionCount);
        ObjectRegistry.getLayoutRegistry().setSelected(objectArray, true);
    }

    private Object[] getSelectedObjects() {
        int n = this.getSelectedObjectCount();
        if (n != 0) {
            Object[] objectArray = new Object[n];
            Enumeration enumeration = this.wrappers();
            int n2 = 0;
            while (enumeration.hasMoreElements() && n2 < n) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                if (!lOControlWrapper.isSelected()) continue;
                objectArray[n2++] = lOControlWrapper.getBean();
            }
            return objectArray;
        }
        return null;
    }

    public void editCallback(String string) {
        Vector<LOControlWrapper> vector = this.getSelectedControls();
        if (vector == null || vector.size() == 0) {
            Object[] objectArray = new Object[]{this.fHandle};
            LayoutLooper.editCallback(this.fHandle, objectArray, string);
        } else {
            Object[] objectArray = new Object[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                objectArray[i] = ((MObjectWrapper)vector.elementAt(i)).getHandle();
            }
            LayoutLooper.editCallback(this.fHandle, objectArray, string);
        }
    }

    private Vector getSelectedInLayer(Vector vector) {
        Vector<LOControlWrapper> vector2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isSelected()) continue;
            if (vector2 == null) {
                vector2 = new Vector<LOControlWrapper>(vector.size());
            }
            vector2.addElement(lOControlWrapper);
        }
        return vector2;
    }

    private boolean canReorder(Vector vector, int n) {
        block6: {
            int n2;
            block5: {
                n2 = vector.size();
                if (n2 < 2) {
                    return false;
                }
                if (n != 0) break block5;
                boolean bl = false;
                for (int i = n2 - 1; i >= 0; --i) {
                    LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
                    if (bl) {
                        if (!lOControlWrapper.isSelected()) continue;
                        return true;
                    }
                    if (lOControlWrapper.isSelected()) continue;
                    bl = true;
                }
                break block6;
            }
            if (n != 1) break block6;
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
                if (bl) {
                    if (!lOControlWrapper.isSelected()) continue;
                    return true;
                }
                if (lOControlWrapper.isSelected()) continue;
                bl = true;
            }
        }
        return false;
    }

    private void moveToBack(Vector vector) {
        Vector vector2 = this.getSelectedInLayer(vector);
        int n = vector2.size();
        for (int i = n - 1; i >= 0; --i) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector2.elementAt(i);
            vector.removeElement(lOControlWrapper);
            vector.insertElementAt(lOControlWrapper, 0);
            Component component = lOControlWrapper.getControl();
            Container container = component.getParent();
            if (container != null) {
                container.remove(component);
                container.add(component);
            }
            this.move(lOControlWrapper, 0);
            if (!lOControlWrapper.isGObject()) continue;
            LayoutLooper.moveToBack((GObjectWrapper)lOControlWrapper, this);
        }
    }

    public void moveToBack() {
        Enumeration enumeration = this.fWrapperOwner.layers();
        UndoReorder undoReorder = new UndoReorder(this, 1);
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            if (!this.canReorder(vector, 1)) continue;
            undoReorder.addLayer(vector);
            this.moveToBack(vector);
        }
        if (undoReorder.reorderComplete()) {
            this.fireContentChangedEvent();
            this.fireUndoEvent(undoReorder);
            this.repaint(5L);
        }
    }

    private void moveBackward(Vector vector) {
        int n = vector.size();
        for (int i = 1; i < n; ++i) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)vector.elementAt(i - 1);
            if (!lOControlWrapper.isSelected() || lOControlWrapper2.isSelected()) continue;
            vector.removeElementAt(i);
            vector.insertElementAt(lOControlWrapper, i - 1);
            Component component = lOControlWrapper.getControl();
            Container container = component.getParent();
            if (container != null && container.getComponentCount() == n) {
                int n2 = n - i - 1;
                container.remove(n2);
                container.add(component, n2 + 1);
            }
            if (lOControlWrapper.isGObject()) {
                LOControlWrapper lOControlWrapper3 = lOControlWrapper2.getParent();
                Vector vector2 = null;
                vector2 = lOControlWrapper3 == null ? ObjectRegistry.getLayoutRegistry().getChildren(this.getRootObject()) : ObjectRegistry.getLayoutRegistry().getChildren(lOControlWrapper3.getBean());
                this.move(lOControlWrapper, vector2.indexOf(lOControlWrapper2.getBean()));
                LayoutLooper.moveBackward((GObjectWrapper)lOControlWrapper, this);
                continue;
            }
            this.move(lOControlWrapper, i - 1);
        }
    }

    public void moveBackward() {
        Enumeration enumeration = this.fWrapperOwner.layers();
        UndoReorder undoReorder = new UndoReorder(this, 1);
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            if (!this.canReorder(vector, 1)) continue;
            undoReorder.addLayer(vector);
            this.moveBackward(vector);
        }
        if (undoReorder.reorderComplete()) {
            this.fireContentChangedEvent();
            this.fireUndoEvent(undoReorder);
            this.repaint(5L);
        }
    }

    private void moveToFront(Vector vector) {
        Vector vector2 = this.getSelectedInLayer(vector);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            vector.removeElement(lOControlWrapper);
            vector.addElement(lOControlWrapper);
            Component component = lOControlWrapper.getControl();
            Container container = component.getParent();
            if (container != null) {
                container.remove(component);
                container.add(component, 0);
            }
            this.move(lOControlWrapper, -1);
            if (!lOControlWrapper.isGObject()) continue;
            LayoutLooper.moveToFront((GObjectWrapper)lOControlWrapper, this);
        }
    }

    public void moveToFront() {
        Enumeration enumeration = this.fWrapperOwner.layers();
        UndoReorder undoReorder = new UndoReorder(this, 0);
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            if (!this.canReorder(vector, 0)) continue;
            undoReorder.addLayer(vector);
            this.moveToFront(vector);
        }
        if (undoReorder.reorderComplete()) {
            this.fireContentChangedEvent();
            this.fireUndoEvent(undoReorder);
            this.repaint(5L);
        }
    }

    private void moveForward(Vector vector) {
        int n = vector.size();
        for (int i = n - 2; i >= 0; --i) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
            LOControlWrapper lOControlWrapper2 = (LOControlWrapper)vector.elementAt(i + 1);
            if (!lOControlWrapper.isSelected() || lOControlWrapper2.isSelected()) continue;
            vector.removeElementAt(i);
            vector.insertElementAt(lOControlWrapper, i + 1);
            Component component = lOControlWrapper.getControl();
            Container container = component.getParent();
            if (container != null && container.getComponentCount() == n) {
                int n2 = n - i - 1;
                container.remove(n2);
                container.add(component, n2 - 1);
            }
            if (lOControlWrapper.isGObject()) {
                LOControlWrapper lOControlWrapper3 = lOControlWrapper2.getParent();
                Vector vector2 = null;
                vector2 = lOControlWrapper3 == null ? ObjectRegistry.getLayoutRegistry().getChildren(this.getRootObject()) : ObjectRegistry.getLayoutRegistry().getChildren(lOControlWrapper3.getBean());
                this.move(lOControlWrapper, vector2.indexOf(lOControlWrapper2.getBean()));
                LayoutLooper.moveForward((GObjectWrapper)lOControlWrapper, this);
                continue;
            }
            this.move(lOControlWrapper, i + 1);
        }
    }

    public void moveForward() {
        Enumeration enumeration = this.fWrapperOwner.layers();
        UndoReorder undoReorder = new UndoReorder(this, 0);
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            if (!this.canReorder(vector, 0)) continue;
            undoReorder.addLayer(vector);
            this.moveForward(vector);
        }
        if (undoReorder.reorderComplete()) {
            this.fireContentChangedEvent();
            this.fireUndoEvent(undoReorder);
            this.repaint(5L);
        }
    }

    void doClear() {
        Vector<LOControlWrapper> vector = this.getSelectedControls();
        if (vector.isEmpty()) {
            return;
        }
        UndoDelete undoDelete = new UndoDelete(this, vector);
        Enumeration<LOControlWrapper> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = enumeration.nextElement();
            this.removeServices(lOControlWrapper);
            this.unregister(lOControlWrapper);
            LOControlWrapper lOControlWrapper2 = lOControlWrapper.getParent();
            if (lOControlWrapper2 != null) {
                lOControlWrapper2.removeWrapper(lOControlWrapper, true);
            } else {
                this.removeWrapper(lOControlWrapper, true);
            }
            this.selectObject(lOControlWrapper, true);
        }
        this.updateSelection();
        this.fireContentChangedEvent();
        this.fireUndoEvent(undoDelete);
        this.repaint(5L);
    }

    public boolean selectAll(boolean bl) {
        Enumeration enumeration = this.wrappers();
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (lOControlWrapper.isSelected() == bl) continue;
            this.selectObject(lOControlWrapper, bl);
            bl2 = true;
        }
        return bl2;
    }

    void selectAllObjects(boolean bl) {
        this.selectAllObjectInRectangle(null, true, false);
    }

    private LOControlWrapper findHandleInLayer(Vector vector, Point point) {
        for (int i = vector.size() - 1; i >= 0; --i) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
            if (lOControlWrapper.isSelected() && lOControlWrapper.ptOverResizehandle(point)) {
                return lOControlWrapper;
            }
            Vector[] vectorArray = lOControlWrapper.getLayers();
            if (vectorArray == null) continue;
            for (Vector vector2 : vectorArray) {
                LOControlWrapper lOControlWrapper2 = this.findHandleInLayer(vector2, point);
                if (lOControlWrapper2 == null) continue;
                return lOControlWrapper2;
            }
        }
        return null;
    }

    private LOControlWrapper findHandle(Point point) {
        for (int i = LayoutWrapperOwner.getNumberOfLayers() - 1; i >= 0; --i) {
            LOControlWrapper lOControlWrapper = this.findHandleInLayer(this.fWrapperOwner.getLayer(i), point);
            if (lOControlWrapper == null) continue;
            return lOControlWrapper;
        }
        return null;
    }

    LOControlWrapper findControl(Point point) {
        return this.fWrapperOwner.findControl(point);
    }

    private RulerGuide findGuide(Point point) {
        return this.fLayoutGrid.findGuide(point);
    }

    public LOControlWrapper findContainer(Point point) {
        return this.fWrapperOwner.findContainer(point);
    }

    private boolean inCorner(Point point) {
        Dimension dimension = this.getSize();
        return point.x > dimension.width - 8 && point.x <= dimension.width && point.y > dimension.height - 8 && point.y <= dimension.height;
    }

    public Object getComponentByName(String string) {
        Enumeration enumeration = this.allWrappers();
        while (enumeration.hasMoreElements()) {
            Component component;
            String string2;
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!(lOControlWrapper.getBean() instanceof Component) || (string2 = (component = (Component)lOControlWrapper.getBean()).getName()) == null || !string2.equals(string)) continue;
            return component;
        }
        return null;
    }

    public String[] getComponentNames() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>(10);
        Enumeration enumeration = this.allWrappers();
        while (enumeration.hasMoreElements()) {
            Component component;
            String string;
            objectArray = (Object[])enumeration.nextElement();
            if (!(objectArray.getBean() instanceof Component) || (string = (component = (Component)objectArray.getBean()).getName()) == null || string.equals("")) continue;
            vector.addElement(string);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    boolean hasSelection() {
        return this.fSelectionCount != 0;
    }

    public int getSelectedObjectCount() {
        int n = 0;
        Enumeration enumeration = this.wrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isSelected()) continue;
            ++n;
        }
        return n;
    }

    public void selectAllObjectInRectangle(Rectangle rectangle, boolean bl, boolean bl2) {
        int n;
        Vector<LOControlWrapper> vector = this.getSelectedControls();
        this.selectAll(false);
        LOControlWrapper lOControlWrapper = null;
        LOControlWrapper lOControlWrapper2 = null;
        LOControlWrapper lOControlWrapper3 = null;
        boolean bl3 = false;
        Enumeration enumeration = null;
        enumeration = bl ? this.wrappers() : this.fWrapperOwner.wrappersReversed();
        while (enumeration.hasMoreElements()) {
            lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (bl3 && lOControlWrapper.getParent() != lOControlWrapper3 || rectangle != null && !lOControlWrapper.objInRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height) || bl2 && vector.indexOf(lOControlWrapper) >= 0) continue;
            n = 1;
            for (lOControlWrapper2 = lOControlWrapper.getParent(); lOControlWrapper2 != null; lOControlWrapper2 = lOControlWrapper2.getParent()) {
                if (!lOControlWrapper2.isSelected()) continue;
                n = 0;
                break;
            }
            if (n == 0) continue;
            lOControlWrapper.setSelected(true);
            if (bl3) continue;
            bl3 = true;
            lOControlWrapper3 = lOControlWrapper.getParent();
        }
        if (bl2) {
            for (n = 0; n < vector.size(); ++n) {
                lOControlWrapper = vector.elementAt(n);
                if (bl3 && lOControlWrapper.getParent() != lOControlWrapper3 || rectangle != null && lOControlWrapper.objInRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) continue;
                lOControlWrapper.setSelected(true);
            }
        }
        this.updateSelection();
        this.repaint(5L);
    }

    public Point pinRectToBounds(int n, int n2, int n3, int n4) {
        int n5;
        Point point = new Point(n, n2);
        int n6 = this.getSize().width;
        if (point.x + n3 > n6) {
            point.x = n6 - n3;
        }
        if (point.y + n4 > (n5 = this.getSize().height)) {
            point.y = n5 - n4;
        }
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        return point;
    }

    private void paintControlList(Graphics graphics) {
        Enumeration enumeration = this.fWrapperOwner.baseWrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            lOControlWrapper.getControl().setBackground(this.getBackground());
            lOControlWrapper.paint(graphics);
        }
    }

    private void drawSelectionHandlesInLayer(Graphics graphics, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isSelected()) continue;
            lOControlWrapper.drawHandles(graphics);
        }
    }

    private void drawSelectionHandles(Graphics graphics) {
        Enumeration enumeration = this.fWrapperOwner.layers();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            this.drawSelectionHandlesInLayer(graphics, vector);
        }
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.isShowing()) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawLayoutArea(graphics);
        this.paintControlList(graphics);
        this.drawSelectionHandles(graphics);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void print(Graphics graphics) {
        this.paintControlList(graphics);
    }

    public static Color getCorrectedColor(Color color, Color color2) {
        Color color3 = null;
        if (color != null && color2 != null) {
            boolean bl;
            color3 = color2;
            float f = 0.114f * (float)color.getBlue() + 0.587f * (float)color.getGreen() + 0.299f * (float)color.getRed();
            float f2 = 0.114f * (float)color2.getBlue() + 0.587f * (float)color2.getGreen() + 0.299f * (float)color2.getRed();
            boolean bl2 = bl = Math.abs(f2 - f) < 40.0f;
            if (bl) {
                color3 = new Color(255 - color2.getRed() / 2, 255 - color2.getGreen() / 2, 255 - color2.getBlue() / 2);
            }
        }
        return color3;
    }

    public void drawNow() {
        Container container = this.getParent();
        Graphics graphics = container.getGraphics();
        container.paint(graphics);
        graphics.dispose();
        graphics = null;
    }

    public void resizeScroller() {
        this.getParent().getParent().validate();
    }

    private void drawLayoutArea(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Color color = this.getBackground();
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.fLayoutGrid.paintGrid(graphics);
        Dimension dimension = this.getSize();
        if (rectangle.x + rectangle.width > dimension.width - 8 && rectangle.y + rectangle.height > dimension.height - 8) {
            graphics.setColor(Color.black);
            graphics.fillRect(dimension.width - 8, dimension.height - 8, 8, 8);
            graphics.setColor(Color.white);
            graphics.drawRect(dimension.width - 8, dimension.height - 8, 8, 8);
        }
        graphics.setColor(color2);
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    private void doSetCursor(MouseEvent mouseEvent) {
        int n = this.fToolPalette.getSelectedButtonIndex();
        if (PlatformInfo.isMacintosh() && mouseEvent.isControlDown()) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (mouseEvent.isShiftDown() || LayoutUtils.isCommandDown(mouseEvent)) {
            n = 0;
        }
        if (n == 0) {
            LOControlWrapper lOControlWrapper = this.findHandle(mouseEvent.getPoint());
            if (lOControlWrapper != null) {
                LayoutHandleEnum layoutHandleEnum = lOControlWrapper.findResizeHandle(mouseEvent.getPoint());
                switch (layoutHandleEnum) {
                    case BR_HANDLE: {
                        this.setCursor(Cursor.getPredefinedCursor(5));
                        break;
                    }
                    case TR_HANDLE: {
                        this.setCursor(Cursor.getPredefinedCursor(7));
                        break;
                    }
                    case TL_HANDLE: {
                        this.setCursor(Cursor.getPredefinedCursor(6));
                        break;
                    }
                    case BL_HANDLE: {
                        this.setCursor(Cursor.getPredefinedCursor(4));
                        break;
                    }
                    case MT_HANDLE: {
                        this.setCursor(Cursor.getPredefinedCursor(8));
                        break;
                    }
                    case MB_HANDLE: {
                        this.setCursor(Cursor.getPredefinedCursor(9));
                        break;
                    }
                    case ML_HANDLE: {
                        this.setCursor(Cursor.getPredefinedCursor(10));
                        break;
                    }
                    case MR_HANDLE: {
                        this.setCursor(Cursor.getPredefinedCursor(11));
                    }
                }
            } else if (this.findGuide(mouseEvent.getPoint()) != null) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            } else if (this.findControl(mouseEvent.getPoint()) != null) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            } else if (this.inCorner(mouseEvent.getPoint())) {
                this.setCursor(Cursor.getPredefinedCursor(5));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    private static boolean pointsAreClose(Point point, Point point2) {
        return Math.abs(point.x - point2.x) <= 3 && Math.abs(point.y - point2.y) <= 3;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.fLastClick != null && LayoutArea.pointsAreClose(this.fLastClick, mouseEvent.getPoint())) {
            LayoutEditor.showInspector();
        } else {
            this.fLastClick = mouseEvent.getPoint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.fLastClick = null;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.fHRuler.doMouseTrackXOROff();
        this.fVRuler.doMouseTrackXOROff();
        this.fLastClick = null;
    }

    private void doPopup(MouseEvent mouseEvent) {
        if (!this.hasSelection()) {
            this.fWindowPopup.show((Component)this, mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.fObjectPopup.show((Component)this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private boolean supportCallback() {
        boolean bl = true;
        int n = this.getSelectedObjectCount();
        int n2 = 0;
        if (n != 0) {
            Enumeration enumeration = this.wrappers();
            while (enumeration.hasMoreElements() && n2 < n) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                if (!lOControlWrapper.isSelected() || !lOControlWrapper.isGObject()) continue;
                GObjectWrapper gObjectWrapper = (GObjectWrapper)lOControlWrapper;
                int n3 = ((GObjectProxy)gObjectWrapper.getControl()).getStyle();
                if (!GObjectProxy.hasCallback(n3)) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    private static boolean isMouseDownPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.isPopupTrigger();
    }

    private boolean isMouseUpPopupTrigger(MouseEvent mouseEvent) {
        return PlatformInfo.getPlatform() == 1 && LayoutArea.pointsAreClose(mouseEvent.getPoint(), this.fMouseStart) && mouseEvent.isPopupTrigger();
    }

    private boolean isDuplicateTrigger(MouseEvent mouseEvent) {
        if (PlatformInfo.isWindows()) {
            return mouseEvent.isMetaDown();
        }
        return mouseEvent.isAltDown();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fMouseStart = mouseEvent.getPoint();
        LayoutClipboard.getClipboard().updatePasteLocation(this.fMouseStart);
        if (LayoutArea.isMouseDownPopupTrigger(mouseEvent)) {
            LOControlWrapper lOControlWrapper = this.findControl(mouseEvent.getPoint());
            boolean bl = false;
            if (!(lOControlWrapper != null && lOControlWrapper.isSelected() || this.fSelectionCount == 0)) {
                bl = this.selectAll(false);
            }
            if (lOControlWrapper != null && !lOControlWrapper.isSelected()) {
                bl = true;
                this.selectObject(lOControlWrapper, true);
            }
            if (bl) {
                this.updateSelection();
                this.drawNow();
            }
            this.doPopup(mouseEvent);
            return;
        }
        int n = this.fToolPalette.getSelectedButtonIndex();
        if (mouseEvent.isShiftDown() || LayoutUtils.isCommandDown(mouseEvent)) {
            n = 0;
        }
        if (n == 0) {
            LOControlWrapper lOControlWrapper = this.findHandle(mouseEvent.getPoint());
            if (lOControlWrapper != null) {
                this.fDragTracker = new ResizeDrag(this, lOControlWrapper);
                this.fDragTracker.mousePressed(mouseEvent);
            } else {
                RulerGuide rulerGuide = this.findGuide(mouseEvent.getPoint());
                if (rulerGuide != null) {
                    this.fDragTracker = new RulerGuideDrag(this, rulerGuide);
                    this.fDragTracker.mousePressed(mouseEvent);
                } else {
                    lOControlWrapper = this.findControl(mouseEvent.getPoint());
                    if (lOControlWrapper != null) {
                        if ((mouseEvent.isShiftDown() || LayoutUtils.isCommandDown(mouseEvent)) && lOControlWrapper.isSelected()) {
                            this.selectObject(lOControlWrapper, false);
                            this.updateSelection();
                            this.repaint(5L);
                        } else {
                            this.fDragTracker = new MoveDrag(this, lOControlWrapper, this.isDuplicateTrigger(mouseEvent));
                            this.fDragTracker.mousePressed(mouseEvent);
                        }
                    } else if (this.inCorner(mouseEvent.getPoint())) {
                        this.fDragTracker = this.fHandle != null ? new CornerDrag(this, this.fHandle, this.fRootObject) : new CornerDrag(this, this.fRuntimeArea);
                        this.fDragTracker.mousePressed(mouseEvent);
                    } else {
                        this.fDragTracker = new SelectDrag(this);
                        this.fDragTracker.mousePressed(mouseEvent);
                    }
                }
            }
        } else {
            AddDrag addDrag = this.getAddDragTracker();
            if (addDrag != null) {
                ((DragTracker)addDrag).mousePressed(mouseEvent);
            } else if (this.fDragTracker != null) {
                this.fDragTracker.mousePressed(mouseEvent);
            }
        }
    }

    public Vector<LOControlWrapper> getSelectedControls() {
        Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>();
        Enumeration enumeration = this.wrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            if (!lOControlWrapper.isSelected() || lOControlWrapper.getParent() != null && lOControlWrapper.getParent().isSelected()) continue;
            vector.add(lOControlWrapper);
        }
        block1: for (LOControlWrapper lOControlWrapper : vector) {
            for (LOControlWrapper lOControlWrapper2 = lOControlWrapper.getParent(); lOControlWrapper2 != null; lOControlWrapper2 = lOControlWrapper2.getParent()) {
                if (!vector.contains(lOControlWrapper2)) continue;
                vector.remove(lOControlWrapper);
                continue block1;
            }
        }
        return vector;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        if (this.fDragTracker != null) {
            this.fDragTracker.mouseReleased(mouseEvent);
            this.fDragTracker = null;
        }
        if (this.fToolPalette != null && (n = this.fToolPalette.getSelectedButtonIndex()) != 0) {
            this.fToolPalette.resetToSelectTool();
        }
        if (this.isMouseUpPopupTrigger(mouseEvent)) {
            this.fLastClick = null;
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fLayoutStatusBar != null) {
            this.fLayoutStatusBar.setCurrentPoint(mouseEvent.getPoint());
        }
        if (this.fDragTracker != null) {
            this.fDragTracker.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.fHRuler.doMouseTrackMouseMoved(mouseEvent.getPoint());
        this.fVRuler.doMouseTrackMouseMoved(mouseEvent.getPoint());
        this.doSetCursor(mouseEvent);
        AddDrag addDrag = this.getAddDragTracker();
        if (addDrag != null) {
            addDrag.mouseMoved(mouseEvent);
        }
        if (this.fLayoutStatusBar != null) {
            this.fLayoutStatusBar.setCurrentPoint(mouseEvent.getPoint());
        }
    }

    private AddDrag getAddDragTracker() {
        AddDrag addDrag = null;
        int n = this.fToolPalette.getSelectedButtonIndex();
        if (n != 0) {
            if (this.fDragTracker == null || !(this.fDragTracker instanceof AddDrag)) {
                this.fDragTracker = new AddDrag(this, n);
            } else if (((AddDrag)this.fDragTracker).getToolID() != n) {
                this.fDragTracker = new AddDrag(this, n);
            }
            addDrag = (AddDrag)this.fDragTracker;
        } else {
            this.fDragTracker = null;
        }
        return addDrag;
    }

    public DragTracker getDragTracker() {
        return this.fDragTracker;
    }

    private void doKeyDown(KeyEvent keyEvent) {
        Point point = new Point(0, 0);
        int n = keyEvent.getKeyCode();
        if (keyEvent.isActionKey()) {
            if (LayoutUtils.isCommandDown(keyEvent)) {
                switch (n) {
                    case 38: {
                        point.y = -10;
                        break;
                    }
                    case 40: {
                        point.y = 10;
                        break;
                    }
                    case 37: {
                        point.x = -10;
                        break;
                    }
                    case 39: {
                        point.x = 10;
                        break;
                    }
                }
            } else {
                switch (n) {
                    case 38: {
                        point.y = -1;
                        break;
                    }
                    case 40: {
                        point.y = 1;
                        break;
                    }
                    case 37: {
                        point.x = -1;
                        break;
                    }
                    case 39: {
                        point.x = 1;
                        break;
                    }
                }
            }
            if (point.x != 0 || point.y != 0) {
                this.arrowKeyObjectMove(point);
                if (this.fLayoutStatusBar != null) {
                    this.fLayoutStatusBar.updateSelectionCoord();
                }
            }
        } else {
            switch (n) {
                case 8: 
                case 127: {
                    this.doClear();
                    break;
                }
            }
        }
    }

    private void arrowKeyObjectMove(Point point) {
        Vector<LOControlWrapper> vector = this.getSelectedControls();
        if (vector.isEmpty()) {
            return;
        }
        Rectangle rectangle = this.getLayerBounds(vector);
        Rectangle rectangle2 = new Rectangle(rectangle);
        Dimension dimension = this.getSize();
        rectangle2.translate(point.x, point.y);
        if (rectangle2.x < 0) {
            point.translate(-rectangle2.x, 0);
        }
        if (rectangle2.y < 0) {
            point.translate(0, -rectangle2.y);
        }
        if (rectangle2.x + rectangle2.width > dimension.width) {
            point.translate(dimension.width - (rectangle2.x + rectangle2.width), 0);
        }
        if (rectangle2.y + rectangle2.height > dimension.height) {
            point.translate(0, dimension.height - (rectangle2.y + rectangle2.height));
        }
        boolean bl = this.fLayoutGrid.getSnapToGrid();
        this.fLayoutGrid.setSnapToGrid(false);
        UndoMove undoMove = new UndoMove(this, vector);
        if (point.x != 0 || point.y != 0) {
            Enumeration<LOControlWrapper> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper = enumeration.nextElement();
                lOControlWrapper.offsetRect(point.x, point.y);
            }
        }
        undoMove.moveComplete();
        if (this.fHandle != null) {
            ++this.fArrowID;
            if (this.fKeyTracker == null) {
                this.fKeyTracker = new KeyTracker(vector);
            }
            this.repaint(5L);
        } else {
            this.fireObjectChangedEvent(vector);
        }
        this.fireContentChangedEvent();
        this.fireUndoEvent(undoMove);
        this.fLayoutGrid.setSnapToGrid(bl);
        this.fArrowKeyMoveDelta.translate(point.x, point.y);
    }

    private Rectangle getLayerBounds(Vector vector) {
        LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.firstElement();
        Point point = lOControlWrapper.getBaseLocation();
        Dimension dimension = lOControlWrapper.getControl().getSize();
        Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            point = lOControlWrapper.getBaseLocation();
            dimension = lOControlWrapper.getControl().getSize();
            rectangle.add(point);
            rectangle.add(point.x + dimension.width, point.y + dimension.height);
        }
        return rectangle;
    }

    private void doKeyUp(KeyEvent keyEvent) {
        if (this.fHandle == null) {
            return;
        }
        if (keyEvent.isActionKey()) {
            switch (keyEvent.getKeyCode()) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    if (this.fKeyTracker == null) break;
                    if (PlatformInfo.isXWindows()) {
                        if (sArrowTimer == null) {
                            sArrowTimer = new ArrowTimer();
                        }
                        sArrowTimer.setTarget(this, this.fArrowID);
                        break;
                    }
                    this.doKeyUpUponMatchingArrowKey(this.fArrowID);
                    break;
                }
            }
        }
    }

    private void doKeyUpUponMatchingArrowKey(int n) {
        if (this.fKeyTracker != null && n == this.fArrowID) {
            this.fKeyTracker.setDisplacement(this.fArrowKeyMoveDelta);
            this.fArrowKeyMoveDelta = new Point(0, 0);
            this.fArrowID = 0;
            this.fKeyTracker.run();
            this.fKeyTracker = null;
        }
    }

    private void fireSelectionChangedEvent(int n) {
        this.fLayoutEditor.selectionChanged();
    }

    public void fireContentChangedEvent() {
        this.fLayoutEditor.contentChanged(null);
    }

    public void fireObjectChangedEvent(LOControlWrapper lOControlWrapper) {
        Object[] objectArray = new Object[]{lOControlWrapper.getBean()};
        ObjectRegistry.getLayoutRegistry().change(objectArray);
    }

    public void fireObjectChangedEvent(Vector vector) {
        int n = vector.size();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
            objectArray[i] = lOControlWrapper.getBean();
        }
        ObjectRegistry.getLayoutRegistry().change(objectArray);
    }

    void fireOptionsChange() {
        Object[] objectArray = new Object[]{this.fRootObject};
        ObjectRegistry.getLayoutRegistry().change(objectArray, (Object)this.fOptions);
    }

    void setUndoManager(LayoutUndoManager layoutUndoManager) {
        this.fUndoManager = layoutUndoManager;
    }

    LayoutUndoManager getUndoManager() {
        return this.fUndoManager;
    }

    public void fireUndoEvent(UndoableEdit undoableEdit) {
        LayoutUndoManager layoutUndoManager = this.fUndoManager;
        if (layoutUndoManager != null) {
            layoutUndoManager.addEdit(undoableEdit);
        }
    }

    Enumeration allWrappers() {
        Vector vector = new Vector(10);
        for (int i = 0; i < LayoutWrapperOwner.getNumberOfLayers(); ++i) {
            this.addAllSublayers(vector, this.fWrapperOwner.getLayer(i));
        }
        return new WrapperEnumerator(vector.elements());
    }

    private void addAllSublayers(Vector vector, Vector vector2) {
        vector.addElement(vector2);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            Vector vector3 = lOControlWrapper.getSublayer();
            if (vector3 == null) continue;
            this.addAllSublayers(vector, vector3);
        }
    }

    @Override
    public void addWrapper(LOControlWrapper lOControlWrapper, int n, boolean bl) {
        this.fWrapperOwner.addWrapper(lOControlWrapper, n, bl);
        if (lOControlWrapper.getParent() == null) {
            lOControlWrapper.addToLayout(this, 0, bl);
        }
    }

    @Override
    public void removeWrapper(LOControlWrapper lOControlWrapper, boolean bl) {
        lOControlWrapper.removeFromLayout(this, bl);
        this.fWrapperOwner.removeWrapper(lOControlWrapper, bl);
    }

    @Override
    public int getIndexOfWrapper(LOControlWrapper lOControlWrapper) {
        return this.fWrapperOwner.getIndexOfWrapper(lOControlWrapper);
    }

    @Override
    public LOControlWrapper findWrapper(Object object) {
        return this.fWrapperOwner.findWrapper(object);
    }

    public Enumeration baseLayers() {
        return this.fWrapperOwner.baseLayers();
    }

    Enumeration wrappers() {
        return this.fWrapperOwner.wrappers();
    }

    Enumeration baseWrappers() {
        return this.fWrapperOwner.baseWrappers();
    }

    private void selectObjects(Object[] objectArray, boolean bl) {
        boolean bl2 = false;
        for (int i = objectArray.length - 1; i >= 0; --i) {
            LOControlWrapper lOControlWrapper = this.findWrapper(objectArray[i]);
            if (lOControlWrapper == null || lOControlWrapper.isSelected() == bl) continue;
            this.selectObject(lOControlWrapper, bl);
            bl2 = true;
        }
        if (bl2) {
            if (bl) {
                this.updateSelection();
            }
            this.repaint(5L);
        } else {
            this.fSelectionCount = this.getSelectedObjectCount();
            this.fireSelectionChangedEvent(this.fSelectionCount);
        }
    }

    public void selectObject(LOControlWrapper lOControlWrapper, boolean bl) {
        if (lOControlWrapper.isSelected() != bl) {
            Vector<LOControlWrapper> vector = null;
            if (bl && (vector = this.getSelectedControls()).size() > 0) {
                this.selectAll(false);
            }
            lOControlWrapper.setSelected(bl);
            if (bl && vector != null) {
                LOControlWrapper lOControlWrapper2 = lOControlWrapper.getParent();
                LOControlWrapper lOControlWrapper3 = null;
                for (int i = 0; i < vector.size(); ++i) {
                    lOControlWrapper3 = vector.elementAt(i);
                    if (lOControlWrapper3.getParent() != lOControlWrapper2) continue;
                    lOControlWrapper3.setSelected(bl);
                }
            }
        }
    }

    void changeObjects(ObjectRegistryEvent objectRegistryEvent) {
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = objectRegistryEvent.getObjects();
        Object object = objectRegistryEvent.getChangeSource();
        for (int i = 0; i < objectArray.length; ++i) {
            Cloneable cloneable;
            Object[] objectArray2;
            ObjectOwner objectOwner;
            LOWrapperOwner lOWrapperOwner = null;
            lOWrapperOwner = objectArray[i] == this.getRootObject() ? this : this.findWrapper(objectArray[i]);
            if (this.fHandle != null && object instanceof PropertyTarget && lOWrapperOwner != null) {
                LayoutLooper.updateChildrenPosition(new LOWrapperOwner[]{lOWrapperOwner}, this);
            }
            if ((objectOwner = ObjectRegistry.getLayoutRegistry().getOwner(objectArray[i])) == this.fObjectOwner) {
                bl = true;
                boolean bl3 = bl2 = object == null || !object.equals("TableData");
                if (objectArray[i] instanceof Component) {
                    objectArray2 = (Component)objectArray[i];
                    cloneable = objectArray2.getSize();
                    Dimension dimension = objectArray2.getMinimumSize();
                    if (((Dimension)cloneable).width < dimension.width || ((Dimension)cloneable).height < dimension.height) {
                        ((Dimension)cloneable).width = Math.max(((Dimension)cloneable).width, dimension.width);
                        ((Dimension)cloneable).height = Math.max(((Dimension)cloneable).height, dimension.height);
                        objectArray2.setSize((Dimension)cloneable);
                        if (objectArray2 instanceof Container) {
                            LayoutArea.forceLayout((Container)objectArray2);
                        }
                    }
                }
                if (lOWrapperOwner != null && lOWrapperOwner instanceof LOControlWrapper) {
                    objectArray2 = (LOControlWrapper)lOWrapperOwner;
                    switch (objectArray2.getControlType()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            if (objectArray2.getParent() != null) {
                                LayoutLooper.updateObject(objectArray2.getParent(), this);
                            } else {
                                LayoutLooper.updateObject(objectArray2, this);
                            }
                            bl = false;
                            break;
                        }
                    }
                }
            } else if (objectOwner == null && objectArray[i] instanceof RuntimeArea && objectArray[i] == this.fRuntimeArea) {
                bl2 = true;
            } else if (this.fHandle != null && objectOwner == null && objectArray[i] == this.fRootObject) {
                if (!this.getRuntimeArea().isInRuntimeResize()) {
                    bl2 = true;
                }
                LayoutLooper.updateFigure(this);
            } else if (objectOwner instanceof LayoutEditor && ((LayoutEditor)objectOwner).getBean() == this.fRootObject) {
                bl2 = true;
            }
            if (this.fHandle == null) continue;
            if (object instanceof LayoutOptions) {
                if (this != ((LayoutOptions)object).getLayoutArea()) continue;
                this.fPropertyFromInspector = 0;
                objectArray2 = new Vector(1);
                objectArray2.addElement(this);
                LayoutLooper.getProperty(objectArray2, new FigureChangeObserver((Vector)objectArray2, object));
                continue;
            }
            if (object instanceof PropertyTarget) {
                if (lOWrapperOwner == null) continue;
                ++this.fPropertyFromInspector;
                if (this.fPropertyFromInspector != ((PropertyTarget)object).getObjects().length) continue;
                this.fPropertyFromInspector = 0;
                objectArray2 = ((PropertyTarget)object).getObjects();
                cloneable = new Vector();
                for (int j = 0; j < objectArray2.length; ++j) {
                    if (objectArray2[j] == this.fRootObject) {
                        ((Vector)cloneable).addElement(this);
                        continue;
                    }
                    lOWrapperOwner = this.findWrapper(objectArray2[j]);
                    if (lOWrapperOwner == null) continue;
                    ((Vector)cloneable).addElement(lOWrapperOwner);
                }
                if (((Vector)cloneable).size() <= 0) continue;
                if (((Vector)cloneable).size() == 1 && ((Vector)cloneable).elementAt(0).equals(this)) {
                    LayoutLooper.getProperty((Vector)cloneable, new FigureChangeObserver((Vector)cloneable, object));
                    continue;
                }
                LayoutLooper.getProperty((Vector)cloneable, new PropertyChangeObserver((Vector)cloneable));
                continue;
            }
            this.fPropertyFromInspector = 0;
        }
        if (bl2) {
            this.fireContentChangedEvent();
        }
        if (bl) {
            this.repaint(5L);
        }
    }

    private void figureChangeComplete(Vector vector, Object object, Object object2) {
        Object object3;
        Object[] objectArray = (Object[])object2;
        Vector<Object[]> vector2 = new Vector<Object[]>(vector.size());
        if (((LayoutArea)vector.elementAt(0)).getFigure() != null) {
            object3 = new Object[]{objectArray[0], objectArray[1]};
            vector2.addElement((Object[])object3);
        }
        object3 = new UndoFigure(this, vector2);
        if (((LayoutArea)vector.elementAt(0)).getFigure() != null) {
            Object[] objectArray2 = new Object[]{objectArray[0], objectArray[1]};
            if (object instanceof LayoutOptions) {
                ((LayoutArea)vector.elementAt(0)).setProperties(objectArray2);
            } else {
                ((LayoutArea)vector.elementAt(0)).setPropertiesWithAffectOnOptions(objectArray2);
            }
        }
        if (this.fUndoManager != null) {
            this.fUndoManager.addEdit((UndoableEdit)object3);
        }
        LayoutLooper.updateTagProperty(vector);
    }

    private void propertyChangeComplete(Vector vector, Object object) {
        Object object2;
        Object[] objectArray = (Object[])object;
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.elementAt(i);
            if (!lOControlWrapper.isGObject()) continue;
            object2 = new Object[]{objectArray[2 * i], objectArray[2 * i + 1]};
            vector2.addElement(object2);
        }
        UndoProperty undoProperty = new UndoProperty(this, vector, vector2);
        for (int i = 0; i < vector.size(); ++i) {
            object2 = (LOControlWrapper)vector.elementAt(i);
            if (!((LOControlWrapper)object2).isGObject()) continue;
            Object[] objectArray2 = new Object[]{objectArray[2 * i], objectArray[2 * i + 1]};
            ((GObjectWrapper)object2).setProperties(objectArray2);
        }
        if (this.fUndoManager != null) {
            this.fUndoManager.addEdit(undoProperty);
        }
        LayoutLooper.updateTagProperty(vector);
    }

    public void setLayoutStatusBar(LayoutStatusBar layoutStatusBar) {
        this.fLayoutStatusBar = layoutStatusBar;
    }

    public LayoutStatusBar getLayoutStatusBar() {
        return this.fLayoutStatusBar;
    }

    public void figureChanged() {
        FigureChangeWorker figureChangeWorker = new FigureChangeWorker(this.getRootObject());
        figureChangeWorker.start();
    }

    public String getFigureTag() {
        return this.fFigureTag;
    }

    private class FigureChangeWorker
    extends MatlabWorker {
        private Object fFigureObject;

        FigureChangeWorker(Object object) {
            this.fFigureObject = object;
        }

        public Object runOnMatlabThread() throws Exception {
            UDDObject uDDObject;
            if (this.fFigureObject instanceof UDDObject && (uDDObject = (UDDObject)this.fFigureObject).isValid()) {
                return HGControl.getPropertyValueForCompatibility(uDDObject, "Tag");
            }
            return "";
        }

        public void runOnAWTEventDispatchThread(Object object) {
            LayoutArea.this.fFigureTag = (String)object;
            if (LayoutArea.this.fLayoutStatusBar != null) {
                LayoutArea.this.fLayoutStatusBar.updateSelectionCoord();
            }
        }
    }

    private class PropertyChangeObserver
    implements CompletionObserver {
        Vector fSelection;

        PropertyChangeObserver(Vector vector) {
            this.fSelection = vector;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null) {
                LayoutArea.this.propertyChangeComplete(this.fSelection, object);
            }
        }
    }

    private class FigureChangeObserver
    implements CompletionObserver {
        Vector fSelection;
        Object fSource;

        FigureChangeObserver(Vector vector, Object object) {
            this.fSelection = vector;
            this.fSource = object;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null) {
                LayoutArea.this.figureChangeComplete(this.fSelection, this.fSource, object);
            }
        }
    }

    private class ObjectChanged
    implements ObjectRegistryListener {
        private ObjectChanged() {
        }

        public void objectRegistered(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void objectUnregistered(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void objectChanged(ObjectRegistryEvent objectRegistryEvent) {
            LayoutArea.this.changeObjects(objectRegistryEvent);
        }

        public void objectMoved(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionStarted(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionEnded(ObjectRegistryEvent objectRegistryEvent) {
        }
    }

    private class SelectionChanged
    implements ItemListener {
        private SelectionChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object[] objectArray = (Object[])itemEvent.getItem();
            boolean bl = itemEvent.getStateChange() == 1;
            LayoutArea.this.selectObjects(objectArray, bl);
            if (LayoutArea.this.fLayoutStatusBar != null) {
                LayoutArea.this.fLayoutStatusBar.updateSelectionCoord();
            }
        }
    }

    private class LayoutOwner
    implements ObjectOwner {
        private LayoutOwner() {
        }

        public void add(Object[] objectArray, Object object, int n) {
        }

        public void remove(Object[] objectArray) {
        }

        public void move(Object[] objectArray, Object object, int n) {
        }

        public void copy(Object[] objectArray) {
        }

        public void paste(Object object, int n) {
        }

        public void refresh(Object[] objectArray) {
        }

        public void setSelected(Object[] objectArray, boolean bl, boolean bl2) {
        }

        public void setSelected(Object[] objectArray, boolean bl) {
        }
    }

    private class WrapperEnumerator
    implements Enumeration {
        Enumeration fLayers;
        Enumeration fWrappers;

        WrapperEnumerator(Enumeration enumeration) {
            this.fLayers = enumeration;
            this.fWrappers = ((Vector)this.fLayers.nextElement()).elements();
            this.advance();
        }

        private void advance() {
            while (!this.fWrappers.hasMoreElements() && this.fLayers.hasMoreElements()) {
                this.fWrappers = ((Vector)this.fLayers.nextElement()).elements();
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.fWrappers.hasMoreElements();
        }

        public Object nextElement() {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)this.fWrappers.nextElement();
            this.advance();
            return lOControlWrapper;
        }
    }

    private static class ArrowTimer
    extends Timer
    implements ActionListener {
        private LayoutArea fTarget;
        private int fArrowID;

        ArrowTimer() {
            super(100, null, 2, "layout arrow key");
            this.addActionListener(this);
        }

        void setTarget(LayoutArea layoutArea, int n) {
            this.fTarget = layoutArea;
            this.fArrowID = n;
            this.start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.fTarget.doKeyUpUponMatchingArrowKey(this.fArrowID);
        }
    }

    private class KeyTracker
    implements Runnable {
        private Vector fSelection;
        private Point fDisplacement;

        KeyTracker(Vector vector) {
            this.fSelection = vector;
            this.fDisplacement = new Point(0, 0);
        }

        void setDisplacement(Point point) {
            this.fDisplacement = point;
        }

        @Override
        public void run() {
            LayoutLooper.requestMove(this.fSelection, null, this.fDisplacement);
        }
    }

    private class LayoutKey
    extends KeyAdapter {
        private LayoutKey() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            LayoutArea.this.doKeyDown(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            LayoutArea.this.doKeyUp(keyEvent);
        }
    }

    private class DuplicateObserver
    implements CompletionObserver {
        private DuplicateObserver() {
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                LayoutArea.this.duplicateComplete(object);
            }
        }
    }

    private static class HorizontalSort
    extends VectorSort {
        private HorizontalSort() {
        }

        @Override
        protected int compare(Object object, Object object2) {
            return ((LOControlWrapper)object).getLeft() - ((LOControlWrapper)object2).getLeft();
        }
    }

    private static class VerticalSort
    extends VectorSort {
        private VerticalSort() {
        }

        @Override
        protected int compare(Object object, Object object2) {
            return ((LOControlWrapper)object).getTop() - ((LOControlWrapper)object2).getTop();
        }
    }
}

