/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskManager {
    protected static final Logger logger = Logger.getLogger("com.sun.jini.thread.TaskManager");
    protected final ArrayList tasks = new ArrayList();
    protected int firstPending = 0;
    protected final List roTasks = Collections.unmodifiableList(this.tasks);
    protected final List threads = new ArrayList();
    protected final int maxThreads;
    protected final long timeout;
    protected final float loadFactor;
    protected boolean terminated = false;

    public TaskManager() {
        this(10, 15000L, 3.0f);
    }

    public TaskManager(int n, long l, float f) {
        this.maxThreads = n;
        this.timeout = l;
        this.loadFactor = f;
    }

    public synchronized void addIfNew(Task task) {
        if (!this.tasks.contains(task)) {
            this.add(task);
        }
    }

    public synchronized void add(Task task) {
        this.tasks.add(task);
        if (this.threads.size() < this.maxThreads && this.needThread()) {
            TaskThread taskThread = new TaskThread();
            this.threads.add(taskThread);
            taskThread.start();
        } else if (this.threads.size() > this.firstPending && !this.runAfter(task, this.tasks.size() - 1)) {
            this.notify();
        }
    }

    public synchronized void addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add((Task)iterator.next());
        }
    }

    protected boolean needThread() {
        int n = (int)(this.loadFactor * (float)this.threads.size());
        int n2 = this.tasks.size();
        if (n2 < n) {
            return false;
        }
        if (this.runAfter((Task)this.tasks.get(--n2), n2)) {
            return false;
        }
        int n3 = this.firstPending + 1;
        if (n3 > n) {
            return true;
        }
        for (int i = this.firstPending; i < n2; ++i) {
            if (this.runAfter((Task)this.tasks.get(i), i) || ++n3 <= n) continue;
            return true;
        }
        return false;
    }

    private boolean runAfter(Task task, int n) {
        try {
            return task.runAfter(this.roTasks, n);
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "Task.runAfter exception", throwable);
            return false;
        }
    }

    public synchronized boolean removeIfPending(Task task) {
        return this.removeTask(task, this.firstPending);
    }

    public synchronized boolean remove(Task task) {
        return this.removeTask(task, 0);
    }

    private boolean removeTask(Task task, int n) {
        int n2 = this.tasks.size();
        while (--n2 >= n) {
            if (this.tasks.get(n2) != task) continue;
            this.tasks.remove(n2);
            if (n2 < this.firstPending) {
                --this.firstPending;
                int n3 = this.threads.size();
                while (--n3 >= 0) {
                    TaskThread taskThread = (TaskThread)this.threads.get(n3);
                    if (taskThread.task != task) continue;
                    taskThread.interrupt();
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public synchronized void terminate() {
        this.terminated = true;
        int n = this.threads.size();
        while (--n >= 0) {
            ((Thread)this.threads.get(n)).interrupt();
        }
    }

    public synchronized ArrayList getPending() {
        ArrayList arrayList = (ArrayList)this.tasks.clone();
        int n = this.firstPending;
        while (--n >= 0) {
            arrayList.remove(0);
        }
        return arrayList;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    private class TaskThread
    extends Thread {
        public Task task;

        public TaskThread() {
            super("task");
            this.task = null;
            this.setDaemon(true);
        }

        private boolean takeTask() {
            int n = TaskManager.this.tasks.size();
            for (int i = TaskManager.this.firstPending; i < n; ++i) {
                Task task = (Task)TaskManager.this.tasks.get(i);
                if (TaskManager.this.runAfter(task, i)) continue;
                if (i > TaskManager.this.firstPending) {
                    TaskManager.this.tasks.remove(i);
                    TaskManager.this.tasks.add(TaskManager.this.firstPending, task);
                }
                ++TaskManager.this.firstPending;
                this.task = task;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                TaskManager taskManager = TaskManager.this;
                synchronized (taskManager) {
                    if (TaskManager.this.terminated) {
                        return;
                    }
                    if (this.task != null) {
                        int n = TaskManager.this.firstPending;
                        while (--n >= 0) {
                            if (TaskManager.this.tasks.get(n) != this.task) continue;
                            TaskManager.this.tasks.remove(n);
                            --TaskManager.this.firstPending;
                            break;
                        }
                        this.task = null;
                        TaskThread.interrupted();
                    }
                    if (!this.takeTask()) {
                        try {
                            TaskManager.this.wait(TaskManager.this.timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TaskManager.this.terminated || !this.takeTask()) {
                            TaskManager.this.threads.remove(this);
                            return;
                        }
                    }
                }
                try {
                    this.task.run();
                    continue;
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "Task.run exception", throwable);
                    continue;
                }
                break;
            }
        }
    }

    public static interface Task
    extends Runnable {
        public boolean runAfter(List var1, int var2);
    }
}

