/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.threads.executionwrappers;

import com.mathworks.toolbox.shared.computils.threads.ExecutionWrapperFactory;
import com.mathworks.toolbox.shared.computils.threads.ThreadUtils;
import com.mathworks.toolbox.shared.computils.threads.WrappingExecutorService;
import java.util.concurrent.Callable;

public class VerboseExecutionWrapperFactory
implements ExecutionWrapperFactory {
    @Override
    public Runnable wrap(final Runnable runnable, final Thread thread) {
        final String string = ThreadUtils.generateStackTrace(thread);
        return new Runnable(){

            @Override
            public void run() {
                long l = System.nanoTime();
                System.out.println("Starting " + runnable + " : " + VerboseExecutionWrapperFactory.generateThreadTransitionString(thread, Thread.currentThread(), string));
                runnable.run();
                String string2 = VerboseExecutionWrapperFactory.getFormattedElapsedTimeSince(l);
                System.out.println("Finishing " + runnable + " : elapsed time " + string2 + " ns");
            }
        };
    }

    @Override
    public <T> Callable<T> wrap(final Callable<T> callable, final Thread thread) {
        final String string = ThreadUtils.generateStackTrace(thread);
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                long l = System.nanoTime();
                System.out.println("Starting " + callable + ": " + VerboseExecutionWrapperFactory.generateThreadTransitionString(thread, Thread.currentThread(), string));
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    String string2 = VerboseExecutionWrapperFactory.getFormattedElapsedTimeSince(l);
                    System.out.println("Finishing " + callable + " : elapsed time " + string2 + " ns");
                }
            }
        };
    }

    private static String getFormattedElapsedTimeSince(long l) {
        return String.format("%, d", System.nanoTime() - l);
    }

    public static void install(WrappingExecutorService wrappingExecutorService) {
        wrappingExecutorService.set(new VerboseExecutionWrapperFactory());
    }

    private static String generateThreadTransitionString(Thread thread, Thread thread2, String string) {
        return String.format("<a href=\"matlab:fprintf('\\n%s')\">%s</a> -> %s", string, thread, thread2);
    }
}

