/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.threads.executionwrappers;

import com.mathworks.toolbox.shared.computils.exceptions.ExecutionFailureHandler;
import com.mathworks.toolbox.shared.computils.threads.ExecutionWrapperFactory;
import com.mathworks.toolbox.shared.computils.threads.ThreadUtils;
import java.util.concurrent.Callable;

public class ExceptionHandlingWrapperFactory
implements ExecutionWrapperFactory {
    private final ExecutionFailureHandler fExecutionFailureHandler;

    public ExceptionHandlingWrapperFactory(ExecutionFailureHandler executionFailureHandler) {
        this.fExecutionFailureHandler = executionFailureHandler;
    }

    @Override
    public Runnable wrap(final Runnable runnable, Thread thread) {
        final String string = ThreadUtils.generateStackTrace(thread);
        return new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception exception) {
                    ExceptionHandlingWrapperFactory.this.fExecutionFailureHandler.handle(exception, string);
                }
            }
        };
    }

    @Override
    public <T> Callable<T> wrap(final Callable<T> callable, Thread thread) {
        final String string = ThreadUtils.generateStackTrace(thread);
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object t = null;
                try {
                    t = callable.call();
                }
                catch (Exception exception) {
                    ExceptionHandlingWrapperFactory.this.fExecutionFailureHandler.handle(exception, string);
                }
                return t;
            }
        };
    }
}

