/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class FlippedIcon
implements Icon {
    private final Icon fDelegateIcon;
    private final Direction fDirection;

    public FlippedIcon(Icon icon, Direction direction) {
        this.fDelegateIcon = icon;
        this.fDirection = direction;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate((double)n + (double)this.fDelegateIcon.getIconWidth() / 2.0, (double)n2 + (double)this.fDelegateIcon.getIconHeight() / 2.0);
        graphics2D.scale(this.fDirection.getXScale(), this.fDirection.getYScale());
        graphics2D.translate(-((double)n + (double)this.fDelegateIcon.getIconWidth() / 2.0), -((double)n2 + (double)this.fDelegateIcon.getIconHeight() / 2.0));
        this.fDelegateIcon.paintIcon(component, graphics2D, n, n2);
    }

    @Override
    public int getIconWidth() {
        return this.fDelegateIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.fDelegateIcon.getIconHeight();
    }

    public static enum Direction {
        HORIZONTAL(-1.0, 1.0),
        VERTICAL(1.0, -1.0);

        private final double fXScale;
        private final double fYScale;

        private Direction(double d, double d2) {
            this.fXScale = d;
            this.fYScale = d2;
        }

        private double getXScale() {
            return this.fXScale;
        }

        private double getYScale() {
            return this.fYScale;
        }
    }
}

