/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction;

import com.mathworks.toolbox.shared.computils.file.ComparisonsTempFolder;
import com.mathworks.toolbox.shared.computils.file.FileDeleter;
import com.mathworks.toolbox.shared.computils.file.FileUtil;
import com.mathworks.toolbox.shared.computils.file.diffreader.DiffAwareInputStream;
import com.mathworks.toolbox.shared.computils.file.diffreader.LeftDiffAwareInputStream;
import com.mathworks.toolbox.shared.computils.file.diffreader.RightDiffAwareInputStream;
import com.mathworks.toolbox.shared.computils.file.diffreader.fileextraction.ConflictExtractionParameters;
import com.mathworks.toolbox.shared.computils.file.resources.CancelledException;
import com.mathworks.toolbox.shared.computils.file.resources.FileException;
import com.mathworks.toolbox.shared.computils.tasks.CancellationStatus;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class ConflictMarkerExtractor {
    private final ConflictExtractionParameters fConflictExtractionParameters;
    private final CancellationStatus fCancellationStatus;
    private static volatile DiffAwareInputStreamFactory sMineInputStreamFactory;
    private static volatile DiffAwareInputStreamFactory sTheirsInputStreamFactory;

    public ConflictMarkerExtractor(ConflictExtractionParameters conflictExtractionParameters, CancellationStatus cancellationStatus) {
        this.fConflictExtractionParameters = conflictExtractionParameters;
        this.fCancellationStatus = cancellationStatus;
    }

    public void extract() throws IOException {
        CleanUp cleanUp;
        File file;
        File file2;
        this.assertTargetsAreSensible();
        File file3 = this.fConflictExtractionParameters.getMineFile();
        File file4 = this.fConflictExtractionParameters.getTheirsFile();
        if (this.doesTargetSetIncludeSource()) {
            ComparisonsTempFolder comparisonsTempFolder = new ComparisonsTempFolder();
            file2 = new File(comparisonsTempFolder, file3.getName());
            file = new File(comparisonsTempFolder, file4.getName());
            cleanUp = new CleanUpTempFolder(comparisonsTempFolder);
        } else {
            file2 = file3;
            file = file4;
            cleanUp = new NoCleanUpNecessary();
        }
        this.extractTo(file2, sMineInputStreamFactory);
        this.extractTo(file, sTheirsInputStreamFactory);
        ConflictMarkerExtractor.move(file2, file3);
        ConflictMarkerExtractor.move(file, file4);
        cleanUp.perform();
    }

    private static void move(File file, File file2) throws IOException {
        if (FileUtil.areFilesTheSame(file, file2)) {
            return;
        }
        if (file2.exists()) {
            FileDeleter.deleteFile(file2);
        }
        FileUtils.moveFile((File)file, (File)file2);
    }

    private boolean doesTargetSetIncludeSource() {
        return this.isTargetSource(this.fConflictExtractionParameters.getMineFile()) || this.isTargetSource(this.fConflictExtractionParameters.getTheirsFile());
    }

    private boolean isTargetSource(File file) {
        File file2 = this.fConflictExtractionParameters.getConflictedFile();
        try {
            return FileUtil.areFilesTheSame(file, file2);
        }
        catch (IOException iOException) {
            return file.equals(this.fConflictExtractionParameters.getConflictedFile());
        }
    }

    private void assertTargetsAreSensible() throws FileException {
        File file;
        File file2 = this.fConflictExtractionParameters.getMineFile();
        if (file2.equals(file = this.fConflictExtractionParameters.getTheirsFile())) {
            throw new FileException("exception.conflictExtractor.mineFileEqualsTheirsFile", file2.getAbsolutePath(), file.getAbsolutePath());
        }
    }

    public static void setMineInputStreamFactory(DiffAwareInputStreamFactory diffAwareInputStreamFactory) {
        sMineInputStreamFactory = diffAwareInputStreamFactory;
    }

    public static void setsTheirsInputStreamFactory(DiffAwareInputStreamFactory diffAwareInputStreamFactory) {
        sTheirsInputStreamFactory = diffAwareInputStreamFactory;
    }

    public static void resetInputStreamFactories() {
        sMineInputStreamFactory = new DefaultMineInputStreamFactory();
        sTheirsInputStreamFactory = new DefaultTheirsInputStreamFactory();
    }

    protected void extractTo(File file, DiffAwareInputStreamFactory diffAwareInputStreamFactory) throws IOException {
        try (FileInputStream fileInputStream = this.openConflictedFile();
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
             DiffAwareInputStream diffAwareInputStream = diffAwareInputStreamFactory.generateFor(bufferedInputStream);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            while (true) {
                this.checkCancellationStatus();
                int n = ((InputStream)diffAwareInputStream).read();
                if (n == -1) {
                    break;
                }
                bufferedOutputStream.write(n);
            }
        }
        catch (IOException iOException) {
            throw new FileException("exception.conflictExtractor.extractionFailure", (Throwable)iOException, iOException.getMessage());
        }
    }

    private void checkCancellationStatus() throws IOException {
        if (this.fCancellationStatus.isCancelled()) {
            throw new CancelledException();
        }
    }

    private FileInputStream openConflictedFile() throws IOException {
        File file = this.fConflictExtractionParameters.getConflictedFile();
        if (!file.exists()) {
            throw new FileException("exception.conflictExtractor.noConflictedFile", file.getAbsolutePath());
        }
        return new FileInputStream(file);
    }

    static {
        ConflictMarkerExtractor.resetInputStreamFactories();
    }

    private static class DefaultTheirsInputStreamFactory
    implements DiffAwareInputStreamFactory {
        private DefaultTheirsInputStreamFactory() {
        }

        @Override
        public DiffAwareInputStream generateFor(InputStream inputStream) {
            return new RightDiffAwareInputStream(inputStream);
        }
    }

    private static class DefaultMineInputStreamFactory
    implements DiffAwareInputStreamFactory {
        private DefaultMineInputStreamFactory() {
        }

        @Override
        public DiffAwareInputStream generateFor(InputStream inputStream) {
            return new LeftDiffAwareInputStream(inputStream);
        }
    }

    public static interface DiffAwareInputStreamFactory {
        public DiffAwareInputStream generateFor(InputStream var1);
    }

    private static class CleanUpTempFolder
    implements CleanUp {
        private final ComparisonsTempFolder iTempFolder;

        private CleanUpTempFolder(ComparisonsTempFolder comparisonsTempFolder) {
            this.iTempFolder = comparisonsTempFolder;
        }

        @Override
        public void perform() throws IOException {
            this.iTempFolder.cleanUp();
        }
    }

    private static class NoCleanUpNecessary
    implements CleanUp {
        private NoCleanUpNecessary() {
        }

        @Override
        public void perform() throws IOException {
        }
    }

    private static interface CleanUp {
        public void perform() throws IOException;
    }
}

