/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file.diffreader;

import com.mathworks.toolbox.shared.computils.file.diffreader.DiffReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class DiffAwareInputStream
extends InputStream {
    private final InputStream fDelegateStream;
    private DiffReader fDiffReader = new DiffReader();
    private List<Integer> fBuffer = new ArrayList<Integer>();
    private int fBufferPointer = 0;

    public DiffAwareInputStream(InputStream inputStream) {
        this.fDelegateStream = inputStream;
    }

    @Override
    public void close() throws IOException {
        this.fDelegateStream.close();
    }

    @Override
    public int read() throws IOException {
        int n = this.readFromBuffer();
        if (n > -1) {
            return n;
        }
        this.populateBuffer();
        return this.readFromBuffer();
    }

    private void populateBuffer() throws IOException {
        List<Integer> list = this.readDataThroughDiffReader();
        this.fBuffer = new ArrayList<Integer>(list);
        this.fBufferPointer = 0;
    }

    private List<Integer> readDataThroughDiffReader() throws IOException {
        int n;
        boolean bl;
        while (!(bl = this.fDiffReader.add(n = this.fDelegateStream.read()))) {
        }
        List<Integer> list = this.getData(this.fDiffReader);
        this.fDiffReader = new DiffReader();
        return list;
    }

    private int readFromBuffer() {
        if (this.fBufferPointer < this.fBuffer.size()) {
            return this.fBuffer.get(this.fBufferPointer++);
        }
        return -1;
    }

    protected abstract List<Integer> getData(DiffReader var1);
}

