/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file;

import com.mathworks.toolbox.shared.computils.ChangeDetector;
import com.mathworks.toolbox.shared.computils.file.ChecksumGenerator;
import com.mathworks.toolbox.shared.computils.file.FileLists;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class FileChangeDetector
implements ChangeDetector<File, IOException> {
    private final File fRoot;
    private final AtomicReference<Map<File, Long>> fSnapshot;

    public FileChangeDetector(File file) {
        this.fRoot = file;
        this.fSnapshot = new AtomicReference(new HashMap());
    }

    @Override
    public void snapshot() throws IOException {
        this.fSnapshot.set(this.generateCheckSums());
    }

    @Override
    public Map<File, ChangeDetector.ChangeType> getChanges() throws IOException {
        Map<File, Long> map = this.fSnapshot.get();
        Map<File, Long> map2 = this.generateCheckSums();
        HashMap<File, ChangeDetector.ChangeType> hashMap = new HashMap<File, ChangeDetector.ChangeType>();
        for (Map.Entry<File, Long> object : map.entrySet()) {
            File file = object.getKey();
            if (map2.containsKey(file)) {
                if (map2.get(file).equals(object.getValue())) continue;
                hashMap.put(file, ChangeDetector.ChangeType.CHANGED);
                continue;
            }
            hashMap.put(file, ChangeDetector.ChangeType.DELETED);
        }
        for (File file : map2.keySet()) {
            if (map.containsKey(file)) continue;
            hashMap.put(file, ChangeDetector.ChangeType.ADDED);
        }
        return hashMap;
    }

    private Map<File, Long> generateCheckSums() throws IOException {
        Collection<File> collection = FileLists.listAllChildren(this.fRoot);
        return ChecksumGenerator.getCRC32CheckSums(collection);
    }
}

