/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.pctutil.concurrent;

import java.util.LinkedList;
import java.util.Queue;

public final class WaitForTurnQueue<T> {
    private final Queue<T> fQueue = new LinkedList<T>();
    private T fExecutingTurn;

    public TurnCloser getTurn(final T t) throws TurnAbandonedException {
        boolean bl = this.waitForMyTurn(t);
        if (!bl) {
            throw new TurnAbandonedException();
        }
        return new TurnCloser(){

            @Override
            public void close() {
                WaitForTurnQueue.this.turnCompleted(t);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForMyTurn(T t) {
        Queue<T> queue = this.fQueue;
        synchronized (queue) {
            while (this.fQueue.peek() != t) {
                if (!this.fQueue.contains(t)) {
                    return false;
                }
                try {
                    this.fQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.fExecutingTurn = t;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnCompleted(T t) {
        Queue<T> queue = this.fQueue;
        synchronized (queue) {
            assert (this.fQueue.peek() == t) : "turnCompleted called when not correct turn";
            assert (this.fExecutingTurn == t) : "turnCompleted called when not correct turn";
            this.fQueue.poll();
            this.fExecutingTurn = null;
            this.fQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnAbandoned(T t) {
        Queue<T> queue = this.fQueue;
        synchronized (queue) {
            if (this.fExecutingTurn != t) {
                this.fQueue.remove(t);
                this.fQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserveTurn(T t) {
        Queue<T> queue = this.fQueue;
        synchronized (queue) {
            assert (!this.fQueue.contains(t)) : "Turn already reserved";
            this.fQueue.add(t);
        }
    }

    public static final class TurnAbandonedException
    extends Exception {
    }

    public static interface TurnCloser
    extends AutoCloseable {
        @Override
        public void close();
    }
}

