/*
 * Decompiled with CFR 0.152.
 */
package ice.storm.print;

import ice.debug.Debug;
import ice.storm.print.PageDecoration;
import ice.util.unit.Unit;
import java.awt.Dimension;
import java.awt.Font;
import java.io.Serializable;
import java.util.Vector;

public class StormPageFormat
implements Cloneable,
Serializable {
    public static final int NA_LETTER = 0;
    public static final int TABLOID = 1;
    public static final int EXECUTIVE = 2;
    public static final int NA_LEGAL = 3;
    public static final int LEDGER = 4;
    public static final int ISO_4A = 5;
    public static final int ISO_2A = 6;
    public static final int ISO_A0 = 7;
    public static final int ISO_A1 = 8;
    public static final int ISO_A2 = 9;
    public static final int ISO_A3 = 10;
    public static final int ISO_A4 = 11;
    public static final int ISO_A5 = 12;
    public static final int ISO_A6 = 13;
    public static final int ISO_A7 = 14;
    public static final int ISO_A8 = 15;
    public static final int ISO_A9 = 16;
    public static final int ISO_A10 = 17;
    public static final int ISO_4B = 18;
    public static final int ISO_2B = 19;
    public static final int ISO_B0 = 20;
    public static final int ISO_B1 = 21;
    public static final int ISO_B2 = 22;
    public static final int ISO_B3 = 23;
    public static final int ISO_B4 = 24;
    public static final int ISO_B5 = 25;
    public static final int ISO_B6 = 26;
    public static final int ISO_B7 = 27;
    public static final int ISO_B8 = 28;
    public static final int ISO_B9 = 29;
    public static final int ISO_B10 = 30;
    public static final int ISO_C0 = 31;
    public static final int ISO_C1 = 32;
    public static final int ISO_C2 = 33;
    public static final int ISO_C3 = 34;
    public static final int ISO_C4 = 35;
    public static final int ISO_C5 = 36;
    public static final int ISO_C6 = 37;
    public static final int ISO_C7 = 38;
    public static final int ISO_C8 = 39;
    public static final int ISO_C9 = 40;
    public static final int ISO_C10 = 41;
    public static final int[][] PAPER_SIZES = new int[][]{{612, 792}, {792, 1224}, {556, 756}, {612, 1008}, {792, 1224}, {1682, 2378}, {1189, 1682}, {841, 1189}, {594, 841}, {420, 594}, {297, 420}, {210, 297}, {148, 210}, {105, 148}, {74, 105}, {52, 74}, {37, 52}, {26, 37}, {2000, 2828}, {1414, 2000}, {1000, 1414}, {707, 1000}, {500, 707}, {353, 500}, {250, 353}, {176, 250}, {125, 176}, {88, 125}, {62, 88}, {44, 62}, {31, 44}, {917, 1297}, {648, 2601}, {458, 648}, {324, 458}, {229, 324}, {162, 229}, {114, 162}, {81, 114}, {57, 81}, {40, 57}, {28, 40}};
    public static final String[][] PAPER_NAMES = new String[][]{{"LETTER", "NA_LETTER"}, {"TABLOID"}, {"EXECUTIVE"}, {"LEGAL"}, {"LEDGER"}, {"IS0_4A0", "IS0_4A", "4A", "JIS_4A0"}, {"IS0_2A0", "IS0_2A", "2A", "JIS_2A0"}, {"A0", "IS0_A0", "JIS_A0"}, {"A1", "IS0_A1", "JIS_A1"}, {"A2", "IS0_A2", "JIS_A2"}, {"A3", "IS0_A3", "JIS_A3"}, {"A4", "IS0_A4", "JIS_A4"}, {"A5", "IS0_A5", "JIS_A5"}, {"A6", "IS0_A6", "JIS_A6"}, {"A7", "IS0_A7", "JIS_A7"}, {"A8", "IS0_A8", "JIS_A8"}, {"A9", "IS0_A9", "JIS_A9"}, {"A10", "IS0_A10", "JIS_A10"}, {"4B", "IS0_4B"}, {"2B", "IS0_2B"}, {"B0", "IS0_B0"}, {"B1", "IS0_B1"}, {"B2", "IS0_B2"}, {"B3", "IS0_B3"}, {"B4", "IS0_B4"}, {"B5", "IS0_B5"}, {"B6", "IS0_B6"}, {"B7", "IS0_B7"}, {"B8", "IS0_B8"}, {"B9", "IS0_B9"}, {"B10", "IS0_B10"}, {"C0", "IS0_C0"}, {"C1", "IS0_C1"}, {"C2", "IS0_C2"}, {"C3", "IS0_C3"}, {"C4", "IS0_C4"}, {"C5", "IS0_C5"}, {"C6", "IS0_C6"}, {"C7", "IS0_C7"}, {"C8", "IS0_C8"}, {"C9", "IS0_C9"}, {"C10", "IS0_C10"}};
    public static final String[] PAPER_DISPLAY_NAMES = new String[]{"Letter (8 1/2 x 11 in)", "Tabloid (11 x 17 in)", "Executive (7 1/4 x  10 1/2 in)", "Legal (8 1/2 x 14 in)", "Ledger (11 x 17 in)", "4A (1682 x 2378 mm)", "2A (1189 x 1682 mm)", "A0 (841 x 1189 mm)", "A1 (594 x 841 mm)", "A2 (420 x 594 mm)", "A3 (297 x 420 mm)", "A4 (210 x 297 mm)", "A5 (148 x 210 mm)", "A6 (105 x 148 mm)", "A7 (74 x 105 mm)", "A8 (52 x 74 mm)", "A9 (37 x 52 mm)", "A10 (26 x 37 mm)", "4B (2000 x 2828 mm)", "2B (1414 x 2000 mm)", "B0 (1000 x 1414 mm)", "B1 (707 x 1000 mm)", "B2 (500 x 707 mm)", "B3 (353 x 500 mm)", "B4 (250 x 353 mm)", "B5 (176 x 250 mm)", "B6 (125 x 176 mm)", "B7 (88 x 125 mm)", "B8 (62 x 88 mm)", "B9 (44 x 62 mm)", "B10 (31 x 44 mm)", "C0 (917 x 1297 mm)", "C1 (648 x 917 mm)", "C2 (458 x 648 mm)", "C3 (324 x 458 mm)", "C4 (229 x 324 mm)", "C5 (162 x 229 mm)", "C6 (114 x 162 mm)", "C7 (81 x 114 mm)", "C8 (57 x 81 mm)", "C9 (40 x 57 mm)", "C10 (28 x 40 mm)"};
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    public static final int PRINT_ALL_FRAMES = 1;
    public static final int PRINT_ACTIVE_FRAMES = 2;
    public static final int PRINT_FRAMES_PAGE = 3;
    public static final int UNIT_POINTS = 0;
    public static final int UNIT_MILLIMETERS = 1;
    public static final int UNIT_INCHES = 2;
    private int dialogUnit = 0;
    private double pageWidth = 612.0;
    private double pageHeight = 792.0;
    private int orientation = 1;
    private double topMargin = 36.0;
    private double leftMargin = 36.0;
    private double rightMargin = 36.0;
    private double bottomMargin = 36.0;
    private double imageableWidth = 540.0;
    private double imageableHeight = 720.0;
    private double pageGutterWidth = 0.0;
    private int framePrintFormat = 3;
    private boolean isBackgroundVisible = true;
    private Font headerFooterFont = new Font("Arial", 0, 10);
    private double scale = 1.0;
    private boolean isTextWrappingEnabled = true;
    private boolean isHtmlSmartPaging = true;
    private boolean isScaleToFitEnabled = false;
    protected Vector pageDecorations = new Vector(6);
    private int selectedViewportIndex = 0;
    private boolean isDirrty = true;

    public void setMargin(Unit unit, int n) throws IllegalArgumentException {
        if (unit.getPoints() < 0.0) {
            unit.setPoints(0.0);
        }
        if (n == 2) {
            if (unit.getPoints() >= this.pageWidth - this.rightMargin) {
                unit.setPoints(this.pageWidth - this.rightMargin - 1.0);
            }
            this.leftMargin = unit.getPoints();
            this.recalculateImageableArea();
        } else if (n == 4) {
            if (unit.getPoints() >= this.pageWidth - this.leftMargin) {
                unit.setPoints(this.pageWidth - this.leftMargin - 1.0);
            }
            this.rightMargin = unit.getPoints();
            this.recalculateImageableArea();
        } else if (n == 1) {
            if (unit.getPoints() >= this.pageHeight - this.bottomMargin) {
                unit.setPoints(this.pageHeight - this.bottomMargin - 1.0);
            }
            this.topMargin = unit.getPoints();
            this.recalculateImageableArea();
        } else if (n == 3) {
            if (unit.getPoints() >= this.pageHeight - this.topMargin) {
                unit.setPoints(this.pageHeight - this.topMargin - 1.0);
            }
            this.bottomMargin = unit.getPoints();
            this.recalculateImageableArea();
        } else {
            throw new IllegalArgumentException("Unrecognized location");
        }
    }

    public void setOrientation(int n) throws IllegalArgumentException {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Unknown orientation");
        }
        if (n == 1 && this.orientation != 1) {
            this.orientation = 1;
            this.setPageSize(this.pageHeight, this.pageWidth);
            this.isDirrty = true;
        } else if (n == 0 && this.orientation != 0) {
            this.orientation = 0;
            this.setPageSize(this.pageHeight, this.pageWidth);
            this.isDirrty = true;
        }
    }

    public void setOrientation(Dimension dimension) {
        int n = StormPageFormat.findPageOrientation(dimension);
        if (n == 0) {
            this.setOrientation(0);
        } else if (n == 1) {
            this.setOrientation(1);
        }
    }

    public void setPageSize(Unit unit, Unit unit2) throws IllegalArgumentException {
        if (unit.getPoints() < 0.0 || unit2.getPoints() < 0.0) {
            throw new IllegalArgumentException("Page dimesions must have width and height values greater than zero.");
        }
        if (this.pageWidth != unit.getPoints() || this.pageHeight != unit2.getPoints()) {
            this.pageWidth = unit.getPoints();
            this.pageHeight = unit2.getPoints();
            this.recalculateImageableArea();
        }
    }

    public void setPageSize(int n) throws IllegalArgumentException {
        if (n < 0 || n >= PAPER_SIZES.length) {
            throw new IllegalArgumentException("Unknown paper size.");
        }
        this.setPageSize(PAPER_SIZES[n][0], PAPER_SIZES[n][1]);
    }

    private void setPageSize(double d, double d2) {
        if (this.pageWidth != d || this.pageHeight != d2) {
            this.pageWidth = d;
            this.pageHeight = d2;
            this.recalculateImageableArea();
        }
    }

    public void setPageGutterWidth(Unit unit) {
        if (unit.getPoints() < 0.0) {
            unit.setPoints(0.0);
        } else if (unit.getPoints() > this.imageableWidth) {
            unit.setPoints(this.imageableWidth - 1.0);
        }
        if (this.pageGutterWidth != unit.getPoints()) {
            this.pageGutterWidth = unit.getPoints();
            this.recalculateImageableArea();
        }
    }

    public void setBackgroundVisible(boolean bl) {
        if (this.isBackgroundVisible != bl) {
            this.isBackgroundVisible = bl;
            this.isDirrty = true;
        }
    }

    public void setTextWrapping(boolean bl) {
        this.isTextWrappingEnabled = bl;
        this.isDirrty = true;
    }

    public void setHtmlSmartPaging(boolean bl) {
        this.isHtmlSmartPaging = bl;
        this.isDirrty = true;
    }

    public void setPageSetupDialogUnit(int n) {
        if (n == 2 || n == 1 || n == 0) {
            this.dialogUnit = n;
        }
    }

    public void setFramePrintFormat(int n) {
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Unrecognized format");
        }
        this.framePrintFormat = n;
        this.selectedViewportIndex = 0;
    }

    public void setSelectedViewportIndex(int n) {
        this.selectedViewportIndex = n;
    }

    public void setHeaderFooterFont(Font font) {
        if (font == null) {
            throw new NullPointerException();
        }
        this.headerFooterFont = font;
    }

    public void setScale(double d) {
        if (this.scale != d) {
            if (d < 0.01) {
                d = 0.01;
            } else if (d > 9.0) {
                d = 9.0;
            } else {
                this.scale = d;
            }
            this.isDirrty = true;
        }
    }

    public double getScale() {
        return this.scale;
    }

    public int getSelectedViewportIndex() {
        return this.selectedViewportIndex;
    }

    public double getMargin(int n) {
        if (n == 1) {
            return this.topMargin;
        }
        if (n == 3) {
            return this.bottomMargin;
        }
        if (n == 2) {
            return this.leftMargin;
        }
        if (n == 4) {
            return this.rightMargin;
        }
        throw new IllegalArgumentException("Unrecognized location");
    }

    public double getPageGutter() {
        return this.pageGutterWidth;
    }

    public final int getPageSetupDialogUnit() {
        return this.dialogUnit;
    }

    public String getPaperDisplayNames(int n) {
        if (n >= 0 && n < PAPER_DISPLAY_NAMES.length) {
            return PAPER_DISPLAY_NAMES[n];
        }
        return "Paper not found";
    }

    public Dimension getPaperSize(int n) {
        if (n >= 0 && n < PAPER_SIZES.length) {
            return new Dimension(PAPER_SIZES[n][0], PAPER_SIZES[n][1]);
        }
        return null;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public double getPageWidth() {
        return this.pageWidth;
    }

    public double getPageHeight() {
        return this.pageHeight;
    }

    public double getImageableWidth() {
        return this.imageableWidth;
    }

    public double getImageableHeight() {
        return this.imageableHeight;
    }

    public int getFramePrintFormat() {
        return this.framePrintFormat;
    }

    public Font getHeaderFooterFont() {
        return this.headerFooterFont;
    }

    public boolean isBackgroundVisible() {
        return this.isBackgroundVisible;
    }

    public boolean isTextWrappingEnabled() {
        return this.isTextWrappingEnabled;
    }

    public boolean isScaleToFitEnabled() {
        return this.isScaleToFitEnabled;
    }

    public boolean isHtmlSmartPagingEnabled() {
        return this.isHtmlSmartPaging;
    }

    public Object clone() {
        StormPageFormat stormPageFormat;
        try {
            stormPageFormat = (StormPageFormat)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Debug.ex((Throwable)cloneNotSupportedException);
            stormPageFormat = null;
        }
        return stormPageFormat;
    }

    public boolean hasImageableAreaChanged() {
        return this.isDirrty;
    }

    public void setImageableAreaChangedFlag(boolean bl) {
        this.isDirrty = bl;
    }

    public static final int findPageOrientation(Dimension dimension) {
        int n = -1;
        for (int i = 0; i < PAPER_SIZES.length; ++i) {
            if (dimension.width == PAPER_SIZES[i][0] && dimension.height == PAPER_SIZES[i][1]) {
                n = 1;
                continue;
            }
            if (dimension.width != PAPER_SIZES[i][1] || dimension.height != PAPER_SIZES[i][0]) continue;
            n = 0;
        }
        return n;
    }

    public static final int findPageSize(Dimension dimension) {
        int n = -1;
        for (int i = 0; i < PAPER_SIZES.length; ++i) {
            if ((dimension.width != PAPER_SIZES[i][0] || dimension.height != PAPER_SIZES[i][1]) && (dimension.width != PAPER_SIZES[i][1] || dimension.height != PAPER_SIZES[i][0])) continue;
            n = i;
            break;
        }
        return n;
    }

    public void addDecoration(PageDecoration pageDecoration) {
        this.pageDecorations.addElement(pageDecoration);
    }

    public Vector getDecoration() {
        return this.pageDecorations;
    }

    public void removeAllDecorations() {
        this.pageDecorations = new Vector(6);
    }

    public void setScaleToFitEnabled(boolean bl) {
        this.isScaleToFitEnabled = bl;
    }

    private void recalculateImageableArea() {
        double d = this.pageWidth - this.leftMargin - this.rightMargin - this.pageGutterWidth;
        double d2 = this.pageHeight - this.topMargin - this.bottomMargin;
        if (this.imageableWidth != d || this.imageableHeight != d2) {
            this.imageableWidth = d;
            this.imageableHeight = d2;
            this.isDirrty = true;
        }
    }
}

