/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.notsupported;

import ice.debug.Debug;
import ice.pilots.notsupported.LWComponent;
import ice.pilots.notsupported.MyComponent;
import ice.storm.ContentLoader;
import ice.storm.Hint;
import ice.storm.LPilot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;

public class ThePilot
extends LPilot {
    private MyComponent comp = null;
    private String contentType;
    private int width = 32;
    private int height = 32;
    private ContentLoader contentLoader;
    protected static final String noPilotMessage = "No pilot configured for";
    protected static final Color BACKGROUND_COLOR = new Color(230, 230, 230);
    protected static final Color BORDER_COLOR = Color.lightGray;
    protected static final Color MESSAGE_COLOR = Color.darkGray;
    protected static final Font MESSAGE_FONT = new Font("SanSerif", 0, 10);
    protected static FontMetrics fontMetrics;
    protected static int textHeight;
    private static Image defaultImage;
    private static final String DEFAULT_IMAGE_LOC = "res/pilot-error.gif";
    private static int defaultImageWidth;
    private static int defaultImageHeight;
    private static Image smallImage;
    private static final String SMALL_IMAGE_LOC = "res/pilot-error-small.gif";
    private static int smallImageWidth;
    private static int smallImageHeight;
    private static final Component OBSERVER;

    public void clear(String string) {
        this.contentType = string;
    }

    public void parse(ContentLoader contentLoader) throws IOException {
        this.contentLoader = contentLoader;
        this.contentType = this.contentLoader.getContentType();
        this.firePropertyChange("location", null, contentLoader.getLocation());
        this.firePropertyChange("title", null, contentLoader.getLocation());
        Hint hint = new Hint(this, contentLoader);
        hint.setCustomDescription("No pilot configured for \"" + this.contentType + "\"");
        this.firePropertyChange("hint", null, hint);
        this.refreshViewport();
    }

    private static void init() {
        block2: {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            fontMetrics = toolkit.getFontMetrics(MESSAGE_FONT);
            textHeight = fontMetrics.getHeight();
            Class clazz = ThePilot.class;
            URL uRL = clazz.getResource(DEFAULT_IMAGE_LOC);
            defaultImage = toolkit.getImage(uRL);
            uRL = clazz.getResource(SMALL_IMAGE_LOC);
            smallImage = toolkit.getImage(uRL);
            try {
                MediaTracker mediaTracker = new MediaTracker(OBSERVER);
                mediaTracker.addImage(defaultImage, 0);
                mediaTracker.addImage(smallImage, 1);
                mediaTracker.waitForAll();
                defaultImageWidth = defaultImage.getWidth(OBSERVER);
                defaultImageHeight = defaultImage.getHeight(OBSERVER);
                smallImageWidth = smallImage.getWidth(OBSERVER);
                smallImageHeight = smallImage.getHeight(OBSERVER);
            }
            catch (InterruptedException interruptedException) {
                if (!Debug.ex) break block2;
                Debug.ex((Throwable)interruptedException);
            }
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(BACKGROUND_COLOR);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setFont(MESSAGE_FONT);
        graphics.setColor(BORDER_COLOR);
        graphics.fillRect(0, 0, this.width, 2);
        graphics.fillRect(this.width - 2, 0, 2, this.height);
        graphics.fillRect(0, this.height - 2, this.width, 2);
        graphics.fillRect(0, 0, 2, this.height);
        graphics.setColor(MESSAGE_COLOR);
        if (!this.tryDefaultImage(graphics) && !this.trySmallImage(graphics)) {
            graphics.drawString("?", 3, textHeight);
        }
    }

    private boolean trySmallImage(Graphics graphics) {
        if (smallImage == null) {
            return false;
        }
        int n = (this.width - smallImageWidth) / 2;
        int n2 = (this.height - smallImageHeight) / 2;
        graphics.drawImage(smallImage, n, n2, OBSERVER);
        return true;
    }

    private boolean tryDefaultImage(Graphics graphics) {
        if (defaultImage == null) {
            return false;
        }
        int n = textHeight + defaultImageHeight;
        if (n >= this.height) {
            return false;
        }
        String string = this.getSafeContentType();
        int n2 = fontMetrics.stringWidth(noPilotMessage);
        int n3 = fontMetrics.stringWidth(string);
        if (n2 >= this.width || n3 >= this.width) {
            return false;
        }
        int n4 = (this.width - defaultImageWidth) / 2;
        int n5 = (this.height - n) / 2;
        graphics.drawImage(defaultImage, n4, n5, OBSERVER);
        n4 = (this.width - n2) / 2;
        n5 = n5 + defaultImageHeight + textHeight;
        graphics.drawString(noPilotMessage, n4, n5);
        n4 = (this.width - n3) / 2;
        graphics.drawString(string, n4, n5 += textHeight);
        return true;
    }

    private String getSafeContentType() {
        if (this.contentType == null) {
            return "";
        }
        int n = this.contentType.indexOf(";");
        if (n < 0) {
            return this.contentType;
        }
        return this.contentType.substring(0, n);
    }

    public Component createComponent() {
        if (this.comp != null) {
            return this.comp;
        }
        this.comp = new MyComponent(this);
        return this.comp;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    static {
        textHeight = 12;
        defaultImageWidth = 0;
        defaultImageHeight = 0;
        smallImageWidth = 0;
        smallImageHeight = 0;
        OBSERVER = new LWComponent();
        ThePilot.init();
    }
}

