/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.image.swing;

import ice.debug.Debug;
import ice.pilots.image.ImageComponent;
import ice.pilots.image.ThePilot;
import ice.pilots.image.swing.TheImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.EventListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class TheContainer
extends JPanel
implements ImageComponent,
AdjustmentListener,
MouseListener,
KeyListener {
    private ThePilot pilot;
    private JScrollBar vbar;
    private JScrollBar hbar;
    private TheImpl impl;

    public void init(ThePilot thePilot) {
        this.pilot = thePilot;
        this.impl = new TheImpl(thePilot);
        this.impl.addMouseListener(this);
        this.impl.addKeyListener(this);
        this.setLayout(new BorderLayout());
        this.hbar = new JScrollBar(0);
        this.vbar = new JScrollBar(1);
        this.hbar.addAdjustmentListener(this);
        this.vbar.addAdjustmentListener(this);
        this.initMouseWheelSupport();
        this.add((Component)this.impl, "Center");
        this.add((Component)this.hbar, "South");
        this.add((Component)this.vbar, "East");
    }

    private void initMouseWheelSupport() {
        block7: {
            try {
                Class<?> clazz = Class.forName("java.awt.event.MouseWheelEvent");
                try {
                    String string = "ice.util.swing.jdk14.SwingMouseWheelListener";
                    Constructor<?> constructor = Class.forName(string).getConstructors()[0];
                    Object[] objectArray = new Object[]{this.vbar, this.hbar};
                    EventListener eventListener = null;
                    eventListener = (EventListener)constructor.newInstance(objectArray);
                    this.addMouseWheelListenerReflectively(eventListener, this.impl);
                    this.addMouseWheelListenerReflectively(eventListener, this.vbar);
                    this.addMouseWheelListenerReflectively(eventListener, this.hbar);
                    if (Debug.trace) {
                        Debug.trace((String)"MouseWheel support found and configured.");
                    }
                }
                catch (Throwable throwable) {
                    if (Debug.trace) {
                        Debug.trace((String)"MouseWheel support found, but error occurred during configuration.");
                    }
                    if (Debug.ex) {
                        Debug.ex((Throwable)throwable);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!Debug.trace) break block7;
                Debug.trace((String)"MouseWheel support not found.");
            }
        }
    }

    private void addMouseWheelListenerReflectively(Object object, Object object2) throws Throwable {
        Class<?> clazz = object2.getClass();
        Class[] classArray = new Class[]{Class.forName("java.awt.event.MouseWheelListener")};
        Method method = clazz.getMethod("addMouseWheelListener", classArray);
        method.invoke(object2, object);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.updateView();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.impl.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = 0;
        int n2 = 0;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                n2 = -this.vbar.getUnitIncrement();
                break;
            }
            case 40: {
                n2 = this.vbar.getUnitIncrement();
                break;
            }
            case 37: {
                n = -this.hbar.getUnitIncrement();
                break;
            }
            case 39: {
                n = this.hbar.getUnitIncrement();
            }
        }
        if (n != 0) {
            this.hbar.setValue(this.hbar.getValue() + n);
        }
        if (n2 != 0) {
            this.vbar.setValue(this.vbar.getValue() + n2);
        }
        if (n != 0 || n2 != 0) {
            this.updateView();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void doLayout() {
        super.doLayout();
        this.updateScrollbars();
    }

    private void updateScrollbars() {
        Dimension dimension = this.impl.getSize();
        this.hbar.setValues(this.hbar.getValue(), dimension.width, 0, this.pilot.getWidth());
        this.vbar.setValues(this.vbar.getValue(), dimension.height, 0, this.pilot.getHeight());
        this.hbar.setUnitIncrement(20);
        this.vbar.setUnitIncrement(20);
        this.hbar.setBlockIncrement(dimension.width);
        this.vbar.setBlockIncrement(dimension.height);
        this.updateView();
    }

    private void updateView() {
        this.impl.sx = -this.hbar.getValue();
        this.impl.sy = -this.vbar.getValue();
        this.impl.repaint();
    }

    public void updateYourself() {
        this.updateScrollbars();
    }
}

