/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import ice.util.Defs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class FocusManager {
    public static final int UP = 38;
    public static final int DOWN = 40;
    public static final int LEFT = 37;
    public static final int RIGHT = 39;
    public static final int NEXT = 9;
    public static final int PREVIOUS = 411;
    protected int theFocusedElement = -1;
    protected Vector domnodes = new Vector();
    protected Vector cssboxes = new Vector();
    protected Hashtable accesskeys = new Hashtable();
    private int tabIndexStart = 0;
    private int tabIndexEnd = 0;
    protected DDocument doc;
    protected CSSLayout layout;
    protected ThePilot pilot;
    protected DocPane docPane;
    private boolean frameHasFocus = false;
    protected Point documentScrollPosition = new Point();
    protected Dimension viewDimension = new Dimension();
    private Rectangle tmpRect = new Rectangle();
    private Object keyboardFocusMgr;
    private static final String KBFM_CLASS_NAME = "java.awt.KeyboardFocusManager";

    public FocusManager(DDocument dDocument, CSSLayout cSSLayout, ThePilot thePilot) {
        this.doc = dDocument;
        this.layout = cSSLayout;
        this.pilot = thePilot;
        this.docPane = cSSLayout.docPane;
    }

    void clearElements() {
        this.domnodes.removeAllElements();
        this.cssboxes.removeAllElements();
        this.theFocusedElement = -1;
        this.tabIndexStart = 0;
        this.tabIndexEnd = 0;
    }

    public final void setFrameFocused(boolean bl) {
        this.frameHasFocus = bl;
        if (Defs.sysPropertyBoolean((String)"ice.pilots.html4.documentFocusOutline")) {
            this.layout.validateLayout();
        }
    }

    public final boolean isFrameFocused() {
        return this.frameHasFocus && this.theFocusedElement == -1;
    }

    void layoutComplete() {
        this.viewDimension.width = this.pilot.getView().getDocPane().getPaneWidth();
        this.viewDimension.height = this.pilot.getView().getDocPane().getPaneWidth();
        this.docPane = this.layout.docPane;
    }

    protected boolean isOnScreen(Rectangle rectangle) {
        if (rectangle == null) {
            return false;
        }
        this.documentScrollPosition.x = this.docPane.getScrollX();
        this.documentScrollPosition.y = this.docPane.getScrollY();
        if (rectangle.y > this.viewDimension.height + this.documentScrollPosition.y) {
            return false;
        }
        if (rectangle.x > this.viewDimension.width + this.documentScrollPosition.x) {
            return false;
        }
        if (rectangle.y + rectangle.height < this.documentScrollPosition.y) {
            return false;
        }
        return rectangle.x + rectangle.width >= this.documentScrollPosition.x;
    }

    protected int focusDefaultBox() {
        for (int i = 0; i < this.cssboxes.size(); ++i) {
            CSSBox cSSBox = (CSSBox)this.cssboxes.elementAt(i);
            this.tmpRect.y = 0;
            this.tmpRect.x = 0;
            this.tmpRect.height = 0;
            this.tmpRect.width = 0;
            cSSBox.findBoundingBox(this.tmpRect);
            if (!this.isOnScreen(this.tmpRect)) continue;
            return i;
        }
        return -1;
    }

    protected boolean localDFM(int n) {
        return false;
    }

    protected boolean globalDFM(int n) {
        return false;
    }

    protected void registerAccesskey(String string, Object object) {
        if (string.length() == 0) {
            return;
        }
        long l = string.charAt(0);
        this.accesskeys.put(new Long(l), object);
    }

    protected Object lookupAccesskey(Object object) {
        return this.accesskeys.get(object);
    }

    protected void setFocusedBox(DNode dNode) {
        if (dNode == null) {
            this.setFocusedBox(-1);
        } else {
            this.setFocusedBox(this.domnodes.indexOf(dNode));
        }
    }

    protected void setFocusedBox(int n) {
        Point point;
        CSSBox cSSBox;
        DNode dNode;
        if (this.theFocusedElement == n) {
            return;
        }
        DOMUIEvent dOMUIEvent = null;
        DOMUIEvent dOMUIEvent2 = null;
        if (this.theFocusedElement != -1) {
            dNode = (DNode)this.domnodes.elementAt(this.theFocusedElement);
            cSSBox = (CSSBox)this.cssboxes.elementAt(this.theFocusedElement);
            dOMUIEvent = (DOMUIEvent)this.doc.createDOMEvent(22);
            dOMUIEvent.target = dNode;
            point = new Point();
            cSSBox.findAbsolutePosition(point);
            dOMUIEvent.setPosX(point.x);
            dOMUIEvent.setPosY(point.y);
        } else {
            this.setFrameFocused(true);
        }
        this.theFocusedElement = n;
        if (this.theFocusedElement == -1) {
            this.setFrameFocused(true);
        } else {
            dNode = (DNode)this.domnodes.elementAt(this.theFocusedElement);
            cSSBox = (CSSBox)this.cssboxes.elementAt(n);
            dOMUIEvent2 = (DOMUIEvent)this.doc.createDOMEvent(21);
            dOMUIEvent2.target = dNode;
            point = new Point();
            cSSBox.findAbsolutePosition(point);
            dOMUIEvent2.setPosX(point.x);
            dOMUIEvent2.setPosY(point.y);
            if (dOMUIEvent != null) {
                dOMUIEvent2.relatedNode = dOMUIEvent.target;
                dOMUIEvent.relatedNode = dOMUIEvent2.target;
            }
        }
        if (dOMUIEvent != null) {
            this.postFocusEvent(dOMUIEvent);
        }
        if (dOMUIEvent2 != null) {
            this.postFocusEvent(dOMUIEvent2);
        }
    }

    private void postFocusEvent(final DOMUIEvent dOMUIEvent) {
        dOMUIEvent.setAction(new EventListener(){

            public void handleEvent(Event event) {
                DNode dNode = dOMUIEvent.target;
                if (dOMUIEvent.typeId == 21) {
                    FocusManager.this.layout.docPane.onNodeFocusEvent(dOMUIEvent, dNode);
                } else if (dOMUIEvent.typeId == 22) {
                    FocusManager.this.layout.docPane.onNodeBlurEvent(dOMUIEvent, dNode);
                }
            }
        });
        this.doc.processEventLater(dOMUIEvent, 0L);
    }

    private int findTabIndex(DElement dElement) throws NumberFormatException {
        String string = dElement.getAttribute("tabindex");
        if (string != null) {
            Integer n = Integer.valueOf(string.trim());
            return n;
        }
        throw new NumberFormatException("Not specified");
    }

    void registerNewElement(CSSBox cSSBox, DElement dElement) {
        int n = 0;
        try {
            n = this.findTabIndex(dElement);
            if (0 == n) {
                this.domnodes.insertElementAt(dElement, this.tabIndexStart);
                this.cssboxes.insertElementAt(cSSBox, this.tabIndexStart);
                ++this.tabIndexStart;
                ++this.tabIndexEnd;
            } else {
                int n2;
                for (n2 = this.tabIndexStart; n2 < this.tabIndexEnd; ++n2) {
                    DElement dElement2 = (DElement)this.domnodes.elementAt(n2);
                    try {
                        int n3 = this.findTabIndex(dElement2);
                        if (n3 <= n) continue;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!Debug.trace) continue;
                        Debug.trace((String)"tabIndex problem");
                    }
                }
                this.domnodes.insertElementAt(dElement, n2);
                this.cssboxes.insertElementAt(cSSBox, n2);
                ++this.tabIndexEnd;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.domnodes.addElement(dElement);
            this.cssboxes.addElement(cSSBox);
        }
        String string = dElement.getAttribute(4);
        if (string != null) {
            this.registerAccesskey(string, dElement);
        }
    }

    boolean processAccessKey(long l) {
        Long l2 = new Long(l);
        DNode dNode = (DNode)this.lookupAccesskey(l2);
        if (dNode == null) {
            return false;
        }
        this.setFocusedBox(dNode);
        return true;
    }

    protected boolean isDisabled(int n) {
        DElement dElement;
        if (n < 0 || n >= this.domnodes.size()) {
            return true;
        }
        DNode dNode = (DNode)this.domnodes.elementAt(n);
        return dNode instanceof DElement && (dElement = (DElement)dNode).getAttribute("disabled") != null;
    }

    protected int nextFocus() {
        if (this.domnodes.size() == 0) {
            return -1;
        }
        if (this.theFocusedElement < this.tabIndexStart) {
            return this.tabIndexStart;
        }
        if (this.domnodes.elementAt(this.theFocusedElement) == this.domnodes.lastElement()) {
            this.focusDocPane();
            return -1;
        }
        int n = this.theFocusedElement + 1;
        boolean bl = true;
        while (bl) {
            if (n == this.domnodes.size()) {
                this.focusDocPane();
                return -1;
            }
            if (this.isDisabled(n)) {
                ++n;
                continue;
            }
            bl = false;
        }
        DElement dElement = (DElement)this.domnodes.elementAt(this.theFocusedElement);
        DElement dElement2 = (DElement)this.domnodes.elementAt(n);
        if (dElement.isFormControl() && !dElement2.isFormControl()) {
            this.focusDocPane();
        }
        return n;
    }

    protected int previousFocus() {
        if (this.domnodes.size() == 0) {
            return -1;
        }
        if (this.theFocusedElement == -1) {
            return this.domnodes.indexOf(this.domnodes.lastElement());
        }
        int n = this.theFocusedElement - 1;
        boolean bl = true;
        while (bl) {
            if (n < this.tabIndexStart) {
                this.focusDocPane();
                return -1;
            }
            if (this.isDisabled(n)) {
                --n;
                continue;
            }
            bl = false;
        }
        DElement dElement = (DElement)this.domnodes.elementAt(this.theFocusedElement);
        DElement dElement2 = (DElement)this.domnodes.elementAt(n);
        if (dElement.isFormControl() && !dElement2.isFormControl()) {
            this.focusDocPane();
        }
        return n;
    }

    private void focusDocPane() {
        this.docPane.reqFocus();
    }

    public DNode getFocusedElement() {
        if (this.theFocusedElement == -1) {
            return null;
        }
        return (DNode)this.domnodes.elementAt(this.theFocusedElement);
    }

    public boolean requestFocus() {
        if (this.theFocusedElement == -1) {
            return false;
        }
        DNode dNode = (DNode)this.domnodes.elementAt(this.theFocusedElement);
        ObjectPainter objectPainter = this.pilot.getView().getNodePainter(dNode);
        if (objectPainter instanceof Component) {
            ((Component)((Object)objectPainter)).requestFocus();
            return true;
        }
        return false;
    }

    protected void previousExternalFocus() {
        this.invokeReflectively("focusPreviousComponent");
    }

    protected void nextExternalFocus() {
        this.invokeReflectively("focusNextComponent");
    }

    private void invokeReflectively(String string) {
        block5: {
            if (this.keyboardFocusMgr == null) {
                this.initKeyboardFocusManager();
                if (this.keyboardFocusMgr == null) {
                    return;
                }
            }
            try {
                Method method = Defs.getMethod((String)KBFM_CLASS_NAME, (String)string, null);
                method.invoke(this.keyboardFocusMgr, Defs.EMPTY_OBJECT_ARRAY);
            }
            catch (Exception exception) {
                if (Debug.ex) {
                    Debug.ex((Throwable)exception);
                }
                if (!Debug.trace) break block5;
                Debug.trace((String)exception.getMessage());
            }
        }
    }

    private void initKeyboardFocusManager() {
        block3: {
            try {
                Method method = Defs.getMethod((String)KBFM_CLASS_NAME, (String)"getCurrentKeyboardFocusManager", null);
                this.keyboardFocusMgr = method.invoke(null, null);
            }
            catch (Exception exception) {
                this.keyboardFocusMgr = null;
                if (Debug.ex) {
                    Debug.ex((Throwable)exception);
                }
                if (!Debug.trace) break block3;
                Debug.trace((String)exception.getMessage());
            }
        }
    }
}

