/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DTextNode;
import ice.storm.DynEnv;
import ice.util.alg.Bidi;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLOptionElement;

public class DOptionElement
extends DElement
implements HTMLOptionElement {
    static final int SELECTION_AS_DEFAULT = 0;
    static final int SELECTION_ON = 1;
    static final int SELECTION_OFF = 2;
    int selection_state = 0;
    private static final int Field_defaultSelected = 1;
    private static final int Field_disabled = 2;
    private static final int Field_form = 3;
    private static final int Field_index = 4;
    private static final int Field_label = 5;
    private static final int Field_selected = 6;
    private static final int Field_text = 7;
    private static final int Field_value = 8;

    protected DOptionElement(DDocument dDocument, int n) {
        super(dDocument, n);
    }

    protected void onDAttrValueChange(DAttr dAttr) {
        DSelectElement.SelectPainter selectPainter;
        if (this.parent instanceof DSelectElement && (selectPainter = ((DSelectElement)this.parent).getSelectPainter()) != null) {
            selectPainter.onOptionAttrChange(this, dAttr);
        }
        super.onDAttrValueChange(dAttr);
    }

    public final HTMLFormElement getForm() {
        return this.getDForm();
    }

    protected DFormElement getDForm() {
        return DFormElement.parentForm(this);
    }

    void setAttributes(int[] nArray, String[] stringArray, int n) {
        super.setAttributes(nArray, stringArray, n);
        this.selection_state = 0;
    }

    public boolean getDefaultSelected() {
        return this.getAttribute(98) != null;
    }

    public void setDefaultSelected(boolean bl) {
        this.setAttribute(98, bl ? "selected" : null);
    }

    public String getText() {
        Node node = this.getFirstChild();
        if (node instanceof DTextNode) {
            DTextNode dTextNode = (DTextNode)node;
            if (dTextNode.doc.charsetId != 0) {
                Bidi bidi = Bidi.createBidi((int)dTextNode.doc.charsetId, (char[])dTextNode.text, (int)0, (int)dTextNode.text.length);
                return bidi.getString();
            }
            return dTextNode.getData();
        }
        return null;
    }

    public final String getTextOrEmptyString() {
        String string = this.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private String script_getText() {
        String string = this.getText();
        string = string != null ? string.trim() : "";
        return string;
    }

    void setText(String string) {
        DNode dNode = this.getFirstDChild();
        if (dNode instanceof DTextNode) {
            DTextNode dTextNode = (DTextNode)dNode;
            dTextNode.setData(string);
        } else {
            this.insertDChildBefore(this.doc.createDTextNode(string), dNode);
        }
    }

    public int getIndex() {
        return -1;
    }

    public void setIndex(int n) {
    }

    public boolean getDisabled() {
        return false;
    }

    public void setDisabled(boolean bl) {
    }

    public String getLabel() {
        return this.getAttribute(52);
    }

    public void setLabel(String string) {
        this.setAttribute(52, string);
    }

    String getValueOrText() {
        String string = this.getValue();
        if (string == null) {
            string = this.getText();
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    public boolean getSelected() {
        boolean bl = this.selection_state == 1 ? true : (this.selection_state == 2 ? false : this.getDefaultSelected());
        return bl;
    }

    public String getValue() {
        return this.getAttribute(114);
    }

    private String script_getValue() {
        String string = this.getValue();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setValue(String string) {
        this.setAttribute(114, string);
    }

    public void setSelected(boolean bl) {
        DNode dNode;
        boolean bl2 = this.getSelected();
        if (bl2 != bl && (dNode = this.parent) instanceof DSelectElement) {
            DSelectElement dSelectElement = (DSelectElement)dNode;
            dSelectElement.setOptionSelection(this, bl);
        }
    }

    void do_setSelected(boolean bl) {
        this.selection_state = bl ? 1 : 2;
    }

    final void setSelectionAsDefault() {
        this.selection_state = 0;
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DOptionElement.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        if (n > 0) {
            return this.getDynamicValue(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DOptionElement.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.setDynamicValue(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    private Object getDynamicValue(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return dynEnv.wrapBoolean(this.getDefaultSelected());
            }
            case 2: {
                return dynEnv.wrapBoolean(this.getDisabled());
            }
            case 3: {
                return this.getDForm();
            }
            case 4: {
                return dynEnv.wrapInt(this.getIndex());
            }
            case 5: {
                return this.getLabel();
            }
            case 6: {
                return dynEnv.wrapBoolean(this.getSelected());
            }
            case 7: {
                return this.script_getText();
            }
            case 8: {
                return this.script_getValue();
            }
        }
        return null;
    }

    private int setDynamicValue(int n, Object object, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                this.setDefaultSelected(dynEnv.toBoolean(object));
                return 1;
            }
            case 2: {
                this.setDisabled(dynEnv.toBoolean(object));
                return 1;
            }
            case 3: {
                break;
            }
            case 4: {
                this.setIndex(dynEnv.toInt(object));
                return 1;
            }
            case 5: {
                this.setLabel(dynEnv.toStr(object));
                return 1;
            }
            case 6: {
                this.setSelected(dynEnv.toBoolean(object));
                return 1;
            }
            case 7: {
                this.setText(dynEnv.toStr(object));
                return 1;
            }
            case 8: {
                this.setValue(dynEnv.toStr(object));
                return 1;
            }
        }
        return 2;
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                char c = string.charAt(0);
                if (c == 'f') {
                    string2 = "form";
                    n = 3;
                    break;
                }
                if (c != 't') break;
                string2 = "text";
                n = 7;
                break;
            }
            case 5: {
                char c = string.charAt(0);
                if (c == 'i') {
                    string2 = "index";
                    n = 4;
                    break;
                }
                if (c == 'l') {
                    string2 = "label";
                    n = 5;
                    break;
                }
                if (c != 'v') break;
                string2 = "value";
                n = 8;
                break;
            }
            case 8: {
                char c = string.charAt(0);
                if (c == 'd') {
                    string2 = "disabled";
                    n = 2;
                    break;
                }
                if (c != 's') break;
                string2 = "selected";
                n = 6;
                break;
            }
            case 15: {
                string2 = "defaultSelected";
                n = 1;
                break;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

