/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.system;

import com.sun.jini.system.CommandLine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;

public class MultiCommandLine
extends CommandLine {
    private String[] args;
    private BitSet used;
    private boolean allUsed;
    private boolean usedUp;
    private ArrayList options;
    private String prog;
    private int str;
    private String opt;

    public MultiCommandLine(String[] stringArray) {
        this(null, stringArray);
    }

    public MultiCommandLine(String string, String[] stringArray) {
        this.prog = string;
        this.args = stringArray;
        this.used = new BitSet(stringArray.length);
        this.options = new ArrayList();
    }

    public synchronized boolean getBoolean(String string) {
        this.addOpt(string, null);
        boolean bl = false;
        while (this.findOpt(string)) {
            bl = true;
        }
        return bl;
    }

    private String getArgument(String string) throws CommandLine.BadInvocationException {
        if (this.findOpt(string)) {
            return this.optArg();
        }
        return null;
    }

    public synchronized String getString(String string, String string2) throws CommandLine.BadInvocationException {
        this.addOpt(string, "str");
        return MultiCommandLine.parseString(this.getArgument(string), string2);
    }

    public synchronized int getInt(String string, int n) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(string, "int");
        return MultiCommandLine.parseInt(this.getArgument(string), n);
    }

    public synchronized long getLong(String string, long l) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(string, "long");
        return MultiCommandLine.parseLong(this.getArgument(string), l);
    }

    public synchronized double getDouble(String string, double d) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(string, "val");
        return MultiCommandLine.parseDouble(this.getArgument(string), d);
    }

    public synchronized Writer getWriter(String string, Writer writer) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(string, "file");
        return MultiCommandLine.parseWriter(this.getArgument(string), writer);
    }

    public synchronized Writer getWriter(String string, String string2) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(string, "file");
        return MultiCommandLine.parseWriter(this.getArgument(string), string2);
    }

    public synchronized Reader getReader(String string, Reader reader) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(string, "file");
        return MultiCommandLine.parseReader(this.getArgument(string), reader);
    }

    public synchronized Reader getReader(String string, String string2) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(string, "file");
        return MultiCommandLine.parseReader(this.getArgument(string), string2);
    }

    public synchronized OutputStream getOutputStream(String string, OutputStream outputStream) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(string, "file");
        return MultiCommandLine.parseOutputStream(this.getArgument(string), outputStream);
    }

    public synchronized OutputStream getOutputStream(String string, String string2) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(string, "file");
        return MultiCommandLine.parseOutputStream(this.getArgument(string), string2);
    }

    public synchronized InputStream getInputStream(String string, InputStream inputStream) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(string, "file");
        return MultiCommandLine.parseInputStream(this.getArgument(string), inputStream);
    }

    public synchronized InputStream getInputStream(String string, String string2) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(string, "file");
        return MultiCommandLine.parseInputStream(this.getArgument(string), string2);
    }

    public synchronized RandomAccessFile getRandomAccessFile(String string, RandomAccessFile randomAccessFile, String string2) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(string, "file");
        return MultiCommandLine.parseRandomAccessFile(this.getArgument(string), randomAccessFile, string2);
    }

    public synchronized RandomAccessFile getRandomAccessFile(String string, String string2, String string3) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(string, "file");
        return MultiCommandLine.parseRandomAccessFile(this.getArgument(string), string2, string3);
    }

    private boolean findOpt(String string) {
        if (this.allUsed) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.used.get(i) || !this.args[i].startsWith("-")) continue;
            if (this.args[i].equals("--")) break;
            bl = true;
            if (this.args[i].length() - 1 != string.length() || !this.args[i].regionMatches(1, string, 0, string.length())) continue;
            this.str = i;
            this.opt = string;
            this.used.set(i);
            return true;
        }
        if (!bl) {
            this.allUsed = true;
        }
        return false;
    }

    private String optArg() throws CommandLine.BadInvocationException {
        if (this.str >= this.args.length) {
            throw new CommandLine.BadInvocationException(this.opt);
        }
        this.used.set(this.str + 1);
        return this.args[this.str + 1];
    }

    public String[] getOperands() throws CommandLine.BadInvocationException, CommandLine.HelpOnlyException {
        int n;
        if (this.getBoolean("?") || this.getBoolean("help")) {
            this.usage();
            throw new CommandLine.HelpOnlyException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.args.length; ++n) {
            if (this.used.get(n)) continue;
            if (!this.args[n].startsWith("-")) break;
            if (this.args[n].equals("--")) {
                ++n;
                break;
            }
            stringBuffer.append(' ').append(this.args[n]);
        }
        if (stringBuffer.length() != 0) {
            String string = stringBuffer.toString();
            throw new CommandLine.BadInvocationException("unknown option" + (string.indexOf(32) > 0 ? "s" : "") + ":" + string);
        }
        String[] stringArray = new String[this.args.length - n];
        System.arraycopy(this.args, n, stringArray, 0, stringArray.length);
        this.usedUp = true;
        return stringArray;
    }

    private void addOpt(String string, String string2) {
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            Opt opt = (Opt)iterator.next();
            if (!opt.opt.equals(string)) continue;
            opt.multi = true;
            return;
        }
        if (!MultiCommandLine.isHelp(string)) {
            this.options.add(new Opt(string, string2));
        }
    }

    private static boolean isHelp(String string) {
        return string.equals("?") || string.equals("help");
    }

    public void usage() {
        if (this.prog != null) {
            System.out.print(this.prog);
            System.out.print(' ');
        }
        System.out.print("[-?]");
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            Opt opt = (Opt)iterator.next();
            System.out.print(" [-");
            System.out.print(opt.opt);
            if (opt.argType != null) {
                System.out.print(' ');
                System.out.print(opt.argType);
            }
            System.out.print("]");
            if (!opt.multi) continue;
            System.out.print("...");
        }
        System.out.println(" ...");
    }

    private static class Opt {
        String opt;
        String argType;
        boolean multi;

        Opt(String string, String string2) {
            this.opt = string;
            this.argType = string2;
        }
    }
}

