/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.landlord;

import com.sun.jini.landlord.ConstrainableLandlordLease;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.landlord.LandlordProxyVerifier;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;

public class LeaseFactory {
    private final Landlord landlord;
    private final Uuid landlordUuid;

    public LeaseFactory(Landlord landlord, Uuid uuid) {
        if (landlord == null) {
            throw new NullPointerException("landlord must be non-null");
        }
        if (uuid == null) {
            throw new NullPointerException("landlordUuid must be non-null");
        }
        this.landlord = landlord;
        this.landlordUuid = uuid;
    }

    public LandlordLease newLease(Uuid uuid, long l) {
        if (this.landlord instanceof RemoteMethodControl) {
            return new ConstrainableLandlordLease(uuid, this.landlord, this.landlordUuid, l, null);
        }
        return new LandlordLease(uuid, this.landlord, this.landlordUuid, l);
    }

    public TrustVerifier getVerifier() {
        return new LandlordProxyVerifier(this.landlord, this.landlordUuid);
    }
}

