/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.landlord;

import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import net.jini.core.lease.LeaseDeniedException;

public class FixedLeasePeriodPolicy
implements LeasePeriodPolicy {
    private final long maximum;
    private final long defaultLength;

    public FixedLeasePeriodPolicy(long l, long l2) {
        if (l <= 0L) {
            throw new IllegalArgumentException("FixedLeasePeriodPolicy:maximum lease time must be larger than 0, passed:" + l);
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("FixedLeasePeriodPolicy:default lease time must be larger than 0, passed:" + l2);
        }
        this.maximum = l;
        this.defaultLength = l2;
    }

    protected long calculateDuration(LeasedResource leasedResource, long l) {
        if (l == Long.MAX_VALUE) {
            l = Long.MAX_VALUE;
        } else if (l == -1L) {
            l = this.defaultLength;
        } else if (l < 0L) {
            throw new IllegalArgumentException("Negative lease duration requested");
        }
        return Math.min(l, this.maximum);
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    private long calcExpiration(long l, long l2) {
        long l3 = l2 + l;
        if (l3 < 0L) {
            return Long.MAX_VALUE;
        }
        return l3;
    }

    public LeasePeriodPolicy.Result grant(LeasedResource leasedResource, long l) throws LeaseDeniedException {
        long l2 = this.currentTime();
        long l3 = this.calcExpiration(this.calculateDuration(leasedResource, l), l2);
        long l4 = l3 - l2;
        return new LeasePeriodPolicy.Result(l3, l4);
    }

    public LeasePeriodPolicy.Result renew(LeasedResource leasedResource, long l) throws LeaseDeniedException {
        long l2 = this.currentTime();
        long l3 = this.calcExpiration(this.calculateDuration(leasedResource, l), l2);
        long l4 = leasedResource.getExpiration();
        if (l4 > l3) {
            long l5;
            l3 = l == -1L ? l4 : ((l5 = this.calcExpiration(l, l2)) > l4 ? l4 : l5);
        }
        return new LeasePeriodPolicy.Result(l3, l3 - l2);
    }
}

