/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mjs.impl;

import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.http.EntityEnclosingRequest;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.mjs.CloudMJSDataAccess;
import com.mathworks.webservices.mjs.core.GDSServiceResponse;
import com.mathworks.webservices.mjs.core.raw.RawByteResponse;
import com.mathworks.webservices.mjs.exception.ArgumentException;
import com.mathworks.webservices.mjs.exception.ContentIsEmptyException;
import com.mathworks.webservices.mjs.exception.ContentListEmptyException;
import com.mathworks.webservices.mjs.exception.IllegalPartialContentLengthException;
import com.mathworks.webservices.mjs.exception.IllegalStartLocationException;
import com.mathworks.webservices.mjs.exception.OutputStreamNotSpecifiedException;
import com.mathworks.webservices.mjs.exception.QuotaExceededException;
import com.mathworks.webservices.mjs.exception.ServiceException;
import com.mathworks.webservices.mjs.exception.SessionException;
import com.mathworks.webservices.mjs.exception.UuidNotSpecifiedException;
import com.mathworks.webservices.mjs.impl.BaseServiceImpl;
import com.mathworks.webservices.mjs.impl.CloudMJSClientImpl;
import com.mathworks.webservices.mjs.model.ErrorReturn;
import com.mathworks.webservices.mjs.model.ProgressReporter;
import com.mathworks.webservices.mjs.model.data.CloudDataMetadata;
import com.mathworks.webservices.mjs.model.data.CloudDataMetadataList;
import com.mathworks.webservices.mjs.model.data.DataCreateProgressReport;
import com.mathworks.webservices.mjs.model.data.DataReadProgressReport;
import com.mathworks.webservices.mjs.model.data.DataUpdateProgressReport;
import com.mathworks.webservices.mjs.model.request.CloudDataCloneRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataCreateRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataFullReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataFullUpdateRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataMetadataReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataRangeReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataRangeUpdateRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataRemoveRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataTruncateRequest;
import com.mathworks.webservices.mjs.model.response.CloudDataCloneResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataCreateResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataFullReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataFullUpdateResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataMetadataReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataRangeReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataRangeUpdateResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataRemoveResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataTruncateResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXB;
import org.apache.commons.io.IOUtils;

public class CloudMJSDataAccessImpl
extends BaseServiceImpl
implements CloudMJSDataAccess {
    public CloudMJSDataAccessImpl(CloudMJSClientImpl cloudMJSClient) {
        super(cloudMJSClient);
    }

    @Override
    public CloudDataCreateResponse create(CloudDataCreateRequest cloudDataCreateRequest) {
        this.basicValidation(cloudDataCreateRequest);
        if (null == cloudDataCreateRequest.getCloudDataMetadata()) {
            throw new ContentListEmptyException("MetadataContent cannot be null");
        }
        ProgressReporter<DataCreateProgressReport> progressReporter = cloudDataCreateRequest.getProgressReporter();
        int maxVectorizedSize = this.getCloudMJSClient().getConfigAccess().getServerConfiguration().getMaximumNumberOfVectorizedRecords();
        List<CloudDataMetadata> fullMetadataList = Arrays.asList(cloudDataCreateRequest.getCloudDataMetadata());
        List<List<CloudDataMetadata>> subLists = this.subLists(fullMetadataList, maxVectorizedSize);
        ArrayList<CloudDataMetadata> createdDataMetadata = new ArrayList<CloudDataMetadata>(fullMetadataList.size());
        ArrayList<ErrorReturn> errors = new ArrayList<ErrorReturn>();
        DataCreateProgressReport status = new DataCreateProgressReport(0L, fullMetadataList.size());
        for (List<CloudDataMetadata> metadataList : subLists) {
            CloudDataMetadataList cloudDataMetadataList = new CloudDataMetadataList();
            cloudDataMetadataList.setMetadataList(metadataList);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JAXB.marshal((Object)cloudDataMetadataList, (OutputStream)outputStream);
            EntityEnclosingRequest request = this.createEntityEnclosingRequest(outputStream, "application/xml", "/v1/data", null, cloudDataCreateRequest);
            try {
                CloudDataCreateResponse response = (CloudDataCreateResponse)this.getCloudMJSClient().executeRequestNew((HttpRequest)request).getResponsePayload();
                createdDataMetadata.addAll(response.getCreatedDataMetadata());
                errors.addAll(response.getErrors());
            }
            catch (MathWorksServiceException ex) {
                throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
            }
            catch (MathWorksClientException ex) {
                throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
            }
            status = new DataCreateProgressReport(status.getUnitsCompleted() + (long)metadataList.size(), fullMetadataList.size());
            this.reportStatus(progressReporter, status, "dataCreate");
        }
        CloudDataCreateResponse response = new CloudDataCreateResponse();
        response.setCreatedDataMetadata(createdDataMetadata);
        response.setErrors(errors);
        return response;
    }

    @Override
    public CloudDataFullReadResponse fullRead(CloudDataFullReadRequest cloudDataFullReadRequest) {
        this.basicValidation(cloudDataFullReadRequest);
        String uuid = cloudDataFullReadRequest.getUuid();
        if (this.isEmpty(uuid)) {
            throw new UuidNotSpecifiedException();
        }
        if (cloudDataFullReadRequest.getOutputStream() == null) {
            throw new OutputStreamNotSpecifiedException();
        }
        ProgressReporter<DataReadProgressReport> progressReporter = cloudDataFullReadRequest.getProgressReporter();
        Long maximumDataChunkLength = this.getCloudMJSClient().getConfigAccess().getServerConfiguration().getMaximumSizeOfData();
        CloudDataRangeReadResponse rangeReadResponse = this.rangeRead(new CloudDataRangeReadRequest().withUuid(uuid).withStartLocation(0L).withLength(maximumDataChunkLength));
        OutputStream accumulatedContent = cloudDataFullReadRequest.getOutputStream();
        this.copyRangeReadResponse(rangeReadResponse, accumulatedContent);
        this.reportRangeReadStatus(rangeReadResponse, progressReporter);
        for (long startLocation = rangeReadResponse.getContentLength().longValue(); startLocation < rangeReadResponse.getTotalDataSize(); startLocation += rangeReadResponse.getContentLength().longValue()) {
            rangeReadResponse = this.rangeRead(new CloudDataRangeReadRequest().withUuid(uuid).withStartLocation(startLocation).withLength(maximumDataChunkLength));
            this.copyRangeReadResponse(rangeReadResponse, accumulatedContent);
            this.reportRangeReadStatus(rangeReadResponse, progressReporter);
        }
        CloudDataFullReadResponse response = new CloudDataFullReadResponse();
        response.setContentLength(rangeReadResponse.getTotalDataSize());
        return response;
    }

    private CloudDataRangeReadResponse rangeRead(CloudDataRangeReadRequest cloudDataRangeReadRequest) throws SessionException, ArgumentException, ServiceException {
        GDSServiceResponse serviceResponse;
        this.basicValidation(cloudDataRangeReadRequest);
        if (this.isEmpty(cloudDataRangeReadRequest.getUuid())) {
            throw new UuidNotSpecifiedException();
        }
        if (cloudDataRangeReadRequest.getStartLocation() == null) {
            throw new IllegalStartLocationException();
        }
        if (cloudDataRangeReadRequest.getLength() == null) {
            throw new IllegalPartialContentLengthException();
        }
        HttpRequest req = this.createHttpRequestWithQueueContext(HttpMethodName.GET, "/v1/data", cloudDataRangeReadRequest.getUuid(), cloudDataRangeReadRequest);
        req.addParameter("startLocation", cloudDataRangeReadRequest.getStartLocation().toString());
        req.addParameter("length", cloudDataRangeReadRequest.getLength().toString());
        try {
            serviceResponse = this.getCloudMJSClient().executeRequestNew(req);
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        RawByteResponse rawByteResponse = (RawByteResponse)serviceResponse.getResponsePayload();
        CloudDataRangeReadResponse cloudDataRangeReadResponse = new CloudDataRangeReadResponse();
        cloudDataRangeReadResponse.setContent(new ByteArrayInputStream(rawByteResponse.getResponseBody()));
        cloudDataRangeReadResponse.setContentLength(rawByteResponse.getContentLength());
        cloudDataRangeReadResponse.setStartLocation(Long.valueOf(serviceResponse.getHeaders().get("startLocation")));
        cloudDataRangeReadResponse.setTotalDataSize(Long.valueOf(serviceResponse.getHeaders().get("totalDataSize")));
        return cloudDataRangeReadResponse;
    }

    private void reportRangeReadStatus(CloudDataRangeReadResponse rangeReadResponse, ProgressReporter<DataReadProgressReport> progressReporter) {
        DataReadProgressReport status = new DataReadProgressReport(rangeReadResponse.getStartLocation() + rangeReadResponse.getContentLength(), rangeReadResponse.getTotalDataSize());
        this.reportStatus(progressReporter, status, "dataFullRead");
    }

    private void copyRangeReadResponse(CloudDataRangeReadResponse rangeReadResponse, OutputStream accumulatedContent) {
        try {
            IOUtils.copy((InputStream)rangeReadResponse.getContent(), (OutputStream)accumulatedContent);
        }
        catch (IOException e) {
            throw new ServiceException("Issue reading content", e);
        }
    }

    @Override
    public CloudDataFullUpdateResponse fullUpdate(CloudDataFullUpdateRequest cloudDataFullUpdateRequest) {
        this.basicValidation(cloudDataFullUpdateRequest);
        String uuid = cloudDataFullUpdateRequest.getUuid();
        if (this.isEmpty(uuid)) {
            throw new UuidNotSpecifiedException();
        }
        InputStream inputStream = cloudDataFullUpdateRequest.getContent();
        if (inputStream == null) {
            throw new ContentIsEmptyException();
        }
        if (cloudDataFullUpdateRequest.getContentLength() == null || cloudDataFullUpdateRequest.getContentLength() < 0L) {
            throw new IllegalPartialContentLengthException();
        }
        ProgressReporter<DataUpdateProgressReport> progressReporter = cloudDataFullUpdateRequest.getProgressReporter();
        long startLocation = 0L;
        long maximumSizeOfData = this.getCloudMJSClient().getConfigAccess().getServerConfiguration().getMaximumSizeOfData();
        boolean append = cloudDataFullUpdateRequest.getAppend() != null && cloudDataFullUpdateRequest.getAppend() != false;
        long totalDataSize = 0L;
        while (startLocation < cloudDataFullUpdateRequest.getContentLength()) {
            long remainingBytes = cloudDataFullUpdateRequest.getContentLength() - startLocation;
            long contentLength = Math.min(maximumSizeOfData, remainingBytes);
            byte[] content = new byte[(int)contentLength];
            try {
                int bytesRead = IOUtils.read((InputStream)inputStream, (byte[])content, (int)0, (int)content.length);
                if (bytesRead != content.length) {
                    content = Arrays.copyOf(content, bytesRead);
                }
            }
            catch (IOException e) {
                throw new ServiceException("Issue updating content", e);
            }
            CloudDataRangeUpdateRequest rangeUpdateRequest = new CloudDataRangeUpdateRequest().withUuid(uuid).withContent(new ByteArrayInputStream(content)).withContentLength(Long.valueOf(content.length)).withStartLocation(append ? null : Long.valueOf(startLocation));
            this.rangeUpdate(rangeUpdateRequest);
            totalDataSize += (long)content.length;
            this.reportStatus(progressReporter, new DataUpdateProgressReport(startLocation += contentLength, cloudDataFullUpdateRequest.getContentLength()), "dataFullUpdate");
        }
        if (!append) {
            this.truncate(new CloudDataTruncateRequest().withUuid(uuid).withContentLength(totalDataSize));
        }
        return new CloudDataFullUpdateResponse();
    }

    private CloudDataTruncateResponse truncate(CloudDataTruncateRequest cloudDataTruncateRequest) {
        this.basicValidation(cloudDataTruncateRequest);
        if (this.isEmpty(cloudDataTruncateRequest.getUuid())) {
            throw new UuidNotSpecifiedException();
        }
        if (cloudDataTruncateRequest.getContentLength() == null) {
            throw new IllegalPartialContentLengthException();
        }
        HttpRequest req = this.createHttpRequestWithQueueContext(HttpMethodName.DELETE, "/v1/data", cloudDataTruncateRequest.getUuid(), cloudDataTruncateRequest);
        req.addParameter("length", cloudDataTruncateRequest.getContentLength().toString());
        try {
            return (CloudDataTruncateResponse)this.getCloudMJSClient().executeRequestNew(req).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    private CloudDataRangeUpdateResponse rangeUpdate(CloudDataRangeUpdateRequest cloudDataRangeUpdateRequest) throws SessionException, ArgumentException, QuotaExceededException, ServiceException {
        this.basicValidation(cloudDataRangeUpdateRequest);
        if (this.isEmpty(cloudDataRangeUpdateRequest.getUuid())) {
            throw new UuidNotSpecifiedException();
        }
        if (cloudDataRangeUpdateRequest.getContent() == null) {
            throw new ContentIsEmptyException();
        }
        if (cloudDataRangeUpdateRequest.getContentLength() == null) {
            throw new IllegalPartialContentLengthException();
        }
        EntityEnclosingRequest request = this.createEntityEnclosingRequest(cloudDataRangeUpdateRequest.getContent(), "application/octet-stream", cloudDataRangeUpdateRequest.getContentLength(), "/v1/data", cloudDataRangeUpdateRequest.getUuid(), cloudDataRangeUpdateRequest);
        if (cloudDataRangeUpdateRequest.getStartLocation() != null) {
            request.addParameter("startLocation", cloudDataRangeUpdateRequest.getStartLocation().toString());
        }
        request.addParameter("length", cloudDataRangeUpdateRequest.getContentLength().toString());
        try {
            return (CloudDataRangeUpdateResponse)this.getCloudMJSClient().executeRequestNew((HttpRequest)request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudDataRemoveResponse remove(CloudDataRemoveRequest cloudDataRemoveRequest) {
        this.basicValidation(cloudDataRemoveRequest);
        HttpRequest request = this.createHttpRequestWithQueueContext(HttpMethodName.DELETE, "/v1/data", null, cloudDataRemoveRequest);
        this.addRequestMetadataCriteria(request, cloudDataRemoveRequest.getCloudDataMetadata());
        if (cloudDataRemoveRequest.getAllowRemoveAll() != null) {
            request.addParameter("allowRemoveAll", cloudDataRemoveRequest.getAllowRemoveAll().toString());
        }
        try {
            return (CloudDataRemoveResponse)this.getCloudMJSClient().executeRequestNew(request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudDataMetadataReadResponse metadataRead(CloudDataMetadataReadRequest cloudDataMetadataReadRequest) {
        this.basicValidation(cloudDataMetadataReadRequest);
        HttpRequest request = this.createHttpRequestWithQueueContext(HttpMethodName.GET, "/v1/data", null, cloudDataMetadataReadRequest);
        this.addRequestMetadataCriteria(request, cloudDataMetadataReadRequest.getCloudDataMetadata());
        try {
            return (CloudDataMetadataReadResponse)this.getCloudMJSClient().executeRequestNew(request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudDataCloneResponse clone(CloudDataCloneRequest cloudDataCloneRequest) {
        this.basicValidation(cloudDataCloneRequest);
        if (this.isEmpty(cloudDataCloneRequest.getOriginalDataUuid())) {
            throw new UuidNotSpecifiedException("Uuid of original data cannot be null or empty");
        }
        if (null == cloudDataCloneRequest.getCloneDataMetadata()) {
            throw new ContentListEmptyException("MetadataContent cannot be null");
        }
        int maxVectorizedSize = this.getCloudMJSClient().getConfigAccess().getServerConfiguration().getMaximumNumberOfVectorizedRecords();
        List<CloudDataMetadata> fullMetadataList = Arrays.asList(cloudDataCloneRequest.getCloneDataMetadata());
        List<List<CloudDataMetadata>> subLists = this.subLists(fullMetadataList, maxVectorizedSize);
        ArrayList<CloudDataMetadata> aggregatedDataMetadata = new ArrayList<CloudDataMetadata>(fullMetadataList.size());
        ArrayList<ErrorReturn> errors = new ArrayList<ErrorReturn>();
        for (List<CloudDataMetadata> subList : subLists) {
            CloudDataMetadataList cloudDataMetadataList = new CloudDataMetadataList();
            cloudDataMetadataList.setMetadataList(subList);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JAXB.marshal((Object)cloudDataMetadataList, (OutputStream)outputStream);
            EntityEnclosingRequest request = this.createEntityEnclosingRequest(outputStream, "application/xml", "/v1/data", null, cloudDataCloneRequest);
            request.addParameter("originalUuid", cloudDataCloneRequest.getOriginalDataUuid());
            try {
                CloudDataCloneResponse response = (CloudDataCloneResponse)this.getCloudMJSClient().executeRequestNew((HttpRequest)request).getResponsePayload();
                aggregatedDataMetadata.addAll(response.getClonedData());
                errors.addAll(response.getErrors());
            }
            catch (MathWorksServiceException ex) {
                throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
            }
            catch (MathWorksClientException ex) {
                throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
            }
        }
        CloudDataCloneResponse response = new CloudDataCloneResponse();
        response.setClonedData(aggregatedDataMetadata);
        response.setErrors(errors);
        return response;
    }

    private void addRequestMetadataCriteria(HttpRequest request, CloudDataMetadata[] criteriaList) {
        if (criteriaList == null) {
            return;
        }
        for (int index = 0; index < criteriaList.length; ++index) {
            CloudDataMetadata criteria = criteriaList[index];
            if (criteria == null) continue;
            this.addCriteriaParam(request, index, "uuid", criteria.getUuid());
            this.addCriteriaParam(request, index, "jobUuid", criteria.getJobUuid());
            this.addCriteriaParam(request, index, "taskUuid", criteria.getTaskUuid());
        }
    }
}

