/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.BrowserRequestManager;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.Url;
import com.mathworks.html.jxbrowser.chromium.CustomProtocolFormHandler;
import com.teamdev.jxbrowser.chromium.LoadHandler;
import com.teamdev.jxbrowser.chromium.LoadParams;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;

class RequestHandlerAdapter
extends LoadAdapter
implements LoadHandler {
    private final RequestHandler fRequestHandler;
    private final BrowserRequestManager fRequestManager = new BrowserRequestManager();
    private final CustomProtocolFormHandler fCustomProtocolFormHandler;

    RequestHandlerAdapter(RequestHandler requestHandler, CustomProtocolFormHandler customProtocolFormHandler) {
        this.fRequestHandler = requestHandler;
        this.fCustomProtocolFormHandler = customProtocolFormHandler;
    }

    public void setPendingRequest(Url url, BrowserRequest.Origin origin) {
        this.fRequestManager.setPendingRequest(url, origin);
    }

    public boolean onLoad(LoadParams loadParams) {
        Url url = Url.parseSilently(loadParams.getURL());
        if (url != null && !url.getProtocol().equalsIgnoreCase("javascript")) {
            if (loadParams.getType() == LoadParams.LoadType.FormSubmitted && this.handleCustomProtocolForm(url)) {
                return true;
            }
            BrowserRequest browserRequest = this.createBrowserEvent(url);
            return this.fRequestHandler.handleRequest(browserRequest);
        }
        return false;
    }

    private boolean handleCustomProtocolForm(Url url) {
        Url url2 = this.fCustomProtocolFormHandler.getCustomProtocolFormUrl(url);
        if (url2 != null) {
            BrowserRequest browserRequest = this.createBrowserEvent(url2);
            this.fRequestHandler.handleRequest(browserRequest);
            return true;
        }
        return false;
    }

    public void onFinishLoadingFrame(FinishLoadingEvent finishLoadingEvent) {
        if (finishLoadingEvent.isMainFrame()) {
            Url url = Url.parseSilently(finishLoadingEvent.getValidatedURL());
            this.fRequestManager.requestCompleted(url);
        }
    }

    private BrowserRequest createBrowserEvent(Url url) {
        return url == null ? null : this.fRequestManager.getRequestForUrl(url);
    }
}

