/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.BrowserListeners;
import com.mathworks.html.BrowserNavigator;
import com.mathworks.html.BrowserQueue;
import com.mathworks.html.HtmlActionGroups;
import com.mathworks.html.HtmlComponentIdentifier;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlFileWriter;
import com.mathworks.html.HtmlFindInPage;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.HtmlPanelContextMenuHandler;
import com.mathworks.html.HtmlPanelSupport;
import com.mathworks.html.PopupWindowListener;
import com.mathworks.html.Url;
import com.mathworks.html.jxbrowser.chromium.ChromiumContextMenuHandler;
import com.mathworks.html.jxbrowser.chromium.JavaScriptRunnable;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumComponent;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumFindInPage;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumIdentifier;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumNavigator;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumPopupHandler;
import com.mathworks.html.jxbrowser.chromium.LoadHtmlHandler;
import com.mathworks.html.jxbrowser.chromium.SystemBrowserPrinter;
import com.mathworks.html.jxbrowser.chromium.TitleAndPageChangeAdapter;
import com.mathworks.html.jxbrowser.chromium.ZoomActions;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.ContextMenuHandler;
import com.teamdev.jxbrowser.chromium.PopupHandler;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import com.teamdev.jxbrowser.chromium.events.TitleListener;
import java.io.File;
import javax.swing.JComponent;

class JxBrowserChromiumPanel
implements HtmlPanelSupport {
    private final Browser fBrowser;
    private final JComponent fComponent;
    private final HtmlActionGroups fChromeActionGroups;
    private final TitleAndPageChangeAdapter fTitleAndPageChangeAdapter;
    private final BrowserNavigator fNavigator;

    JxBrowserChromiumPanel(Browser browser, JxBrowserChromiumNavigator jxBrowserChromiumNavigator, BrowserListeners browserListeners) {
        this.fBrowser = browser;
        this.fComponent = new JxBrowserChromiumComponent(browser);
        this.fNavigator = jxBrowserChromiumNavigator;
        LoadHtmlHandler loadHtmlHandler = jxBrowserChromiumNavigator.getLoadHtmlHandler();
        this.fTitleAndPageChangeAdapter = new TitleAndPageChangeAdapter(browserListeners, loadHtmlHandler);
        this.fBrowser.addLoadListener((LoadListener)this.fTitleAndPageChangeAdapter);
        this.fBrowser.addTitleListener((TitleListener)this.fTitleAndPageChangeAdapter);
        this.fChromeActionGroups = JxBrowserChromiumPanel.createCustomActionGroups(this.fBrowser);
    }

    private static HtmlActionGroups createCustomActionGroups(Browser browser) {
        HtmlActionGroups htmlActionGroups = new HtmlActionGroups();
        ZoomActions zoomActions = new ZoomActions(browser);
        htmlActionGroups.addCustomActionGroup(zoomActions.getZoomActionGroup());
        return htmlActionGroups;
    }

    @Override
    public JComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public HtmlPanel.BrowserType getBrowserType() {
        return HtmlPanel.BrowserType.JXBROWSER;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public BrowserNavigator getNavigator() {
        return this.fNavigator;
    }

    @Override
    public String getTitle() {
        return this.fTitleAndPageChangeAdapter.getTitle();
    }

    @Override
    public void executeScript(String string, HtmlDataListener<String> htmlDataListener) {
        JavaScriptRunnable javaScriptRunnable = new JavaScriptRunnable(this.fBrowser, string, htmlDataListener);
        BrowserQueue.invokeLater(javaScriptRunnable);
    }

    @Override
    public void getSelectedText(HtmlDataListener<String> htmlDataListener) {
        this.executeScript("window.getSelection().toString()", htmlDataListener);
    }

    @Override
    public String getHtmlText() {
        return this.fBrowser.getHTML();
    }

    @Override
    public boolean isPrintingSupported() {
        return true;
    }

    @Override
    public void print(HtmlDataListener<Boolean> htmlDataListener) {
        SystemBrowserPrinter.print(this.getComponent(), this.fNavigator.getCurrentLocation(), htmlDataListener);
    }

    @Override
    public void saveAs(File file) {
        new HtmlFileWriter(file, this.getHtmlText(), this.getCurrentLocation(), true).saveFile();
    }

    @Override
    public void dispose() {
        this.fBrowser.dispose();
    }

    @Override
    public void setContextMenuHandler(HtmlPanelContextMenuHandler htmlPanelContextMenuHandler) {
        this.fBrowser.setContextMenuHandler((ContextMenuHandler)new ChromiumContextMenuHandler(htmlPanelContextMenuHandler));
    }

    @Override
    public HtmlFindInPage getFindInPage() {
        return new JxBrowserChromiumFindInPage(this);
    }

    @Override
    public void setPopupWindowListener(PopupWindowListener popupWindowListener) {
        this.fBrowser.setPopupHandler((PopupHandler)new JxBrowserChromiumPopupHandler(popupWindowListener));
    }

    @Override
    public HtmlActionGroups getBrowserSuppliedActions() {
        return this.fChromeActionGroups;
    }

    private String getCurrentLocation() {
        Url url = this.fNavigator.getCurrentLocation();
        return url == null ? "" : url.toString();
    }

    @Override
    public HtmlComponentIdentifier getId() {
        return JxBrowserChromiumIdentifier.getInstance();
    }
}

