/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.FindOption;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlFindInPage;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumPanel;
import java.util.Collection;

class JxBrowserChromiumFindInPage
implements HtmlFindInPage {
    private final JxBrowserChromiumPanel fPanel;

    JxBrowserChromiumFindInPage(JxBrowserChromiumPanel jxBrowserChromiumPanel) {
        this.fPanel = jxBrowserChromiumPanel;
    }

    @Override
    public void find(String string, Collection<FindOption> collection, HtmlDataListener<Boolean> htmlDataListener) {
        String string2 = JxBrowserChromiumFindInPage.buildJavaScript(string, collection);
        this.fPanel.executeScript(string2, new FindSuccessListener(htmlDataListener));
    }

    private static String buildJavaScript(String string, Collection<FindOption> collection) {
        StringBuilder stringBuilder = new StringBuilder("window.find('");
        stringBuilder.append(string.replaceAll("([\\(\\)\\'\\/\\\\])", "\\\\$1")).append("',");
        stringBuilder.append(String.valueOf(collection.contains((Object)FindOption.MATCH_CASE)));
        stringBuilder.append(",");
        stringBuilder.append(String.valueOf(collection.contains((Object)FindOption.SEARCH_BACKWARDS)));
        stringBuilder.append(",");
        stringBuilder.append(String.valueOf(collection.contains((Object)FindOption.WRAP_AROUND)));
        stringBuilder.append(",");
        stringBuilder.append(String.valueOf(collection.contains((Object)FindOption.WHOLE_WORDS)));
        stringBuilder.append(");");
        return stringBuilder.toString();
    }

    private static class FindSuccessListener
    implements HtmlDataListener<String> {
        private final HtmlDataListener<Boolean> iRealListener;

        private FindSuccessListener(HtmlDataListener<Boolean> htmlDataListener) {
            this.iRealListener = htmlDataListener;
        }

        @Override
        public void dataRetrieved(String string) {
            this.iRealListener.dataRetrieved(string.equals("true"));
        }
    }
}

