/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserQueue;
import com.mathworks.html.jxbrowser.JxBrowserKeyAdapter;
import com.mathworks.html.jxbrowser.JxBrowserKeyEvent;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.safari.SafariBrowser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.KeyEvent;

class SafariConfig {
    static final int MIN_DEFAULT_FONT_SIZE = 10;
    static final int MAX_DEFAULT_FONT_SIZE = 72;
    private final JxBrowserSwingComponent fComponent;

    SafariConfig(JxBrowserSwingComponent jxBrowserSwingComponent) {
        this.fComponent = jxBrowserSwingComponent;
    }

    void configureBrowser(SafariBrowser safariBrowser) {
        assert (BrowserQueue.isBrowserThread()) : "We should only access the browser on the browser thread.";
        SafariConfig.checkFont((Browser)safariBrowser);
        this.attachKeyListener();
    }

    private static void checkFont(Browser browser) {
        Font font = browser.getConfigurable().getDefaultFont();
        int n = font.getSize();
        boolean bl = false;
        if (n < 10) {
            n = 10;
            bl = true;
        } else if (n > 72) {
            n = 72;
            bl = true;
        }
        if (bl) {
            Font font2 = new Font(font.getName(), font.getStyle(), n);
            browser.getConfigurable().setDefaultFont(font2);
        }
    }

    private void attachKeyListener() {
        Component component = this.fComponent.getBrowser().getComponent();
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                component2.addKeyListener(new SafariKeyAdapter());
            }
        }
    }

    private static void correctKeyCode(KeyEvent keyEvent) {
        Integer n = SafariConfig.getExpectedKeyCode(keyEvent.getKeyChar());
        if (n != null && n.intValue() != keyEvent.getKeyCode()) {
            keyEvent.setKeyCode(n);
        }
    }

    private static Integer getExpectedKeyCode(char c) {
        switch (c) {
            case '-': {
                return 45;
            }
            case '=': {
                return 61;
            }
            case '!': {
                return 517;
            }
            case '@': {
                return 512;
            }
            case '#': {
                return 520;
            }
            case '$': {
                return 515;
            }
            case '^': {
                return 514;
            }
            case '&': {
                return 150;
            }
            case '*': {
                return 151;
            }
            case '(': {
                return 519;
            }
            case ')': {
                return 522;
            }
            case '_': {
                return 523;
            }
            case '+': {
                return 107;
            }
            case '\t': {
                return 9;
            }
            case '\n': {
                return 10;
            }
            case '[': {
                return 91;
            }
            case ']': {
                return 93;
            }
            case '\\': {
                return 92;
            }
            case ';': {
                return 59;
            }
            case ':': {
                return 513;
            }
            case '\'': {
                return 222;
            }
            case '\"': {
                return 152;
            }
            case ',': {
                return 44;
            }
            case '<': {
                return 153;
            }
            case '.': {
                return 46;
            }
            case '>': {
                return 160;
            }
            case '/': {
                return 47;
            }
            case ' ': {
                return 32;
            }
        }
        return null;
    }

    private class SafariKeyAdapter
    extends JxBrowserKeyAdapter {
        private SafariKeyAdapter() {
            super(SafariConfig.this.fComponent);
        }

        @Override
        protected JxBrowserKeyEvent cloneBrowserKeyEvent(KeyEvent keyEvent) {
            SafariConfig.correctKeyCode(keyEvent);
            return super.cloneBrowserKeyEvent(keyEvent);
        }
    }
}

