/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserQueue;
import com.mathworks.html.ContextMenuTargetData;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlPanelContextMenuHandler;
import com.mathworks.html.HtmlUtils;
import com.mathworks.html.RelativeUrlBuilder;
import com.mathworks.html.Url;
import com.mathworks.html.jxbrowser.JxBrowserFocusManager;
import com.mathworks.html.jxbrowser.JxBrowserPanel;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.mathworks.html.jxbrowser.SystemUtils;
import com.teamdev.jxbrowser.ContextMenuHandler;
import com.teamdev.jxbrowser.events.ContextMenuEvent;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.concurrent.Callable;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MWContextMenuHandler
implements ContextMenuHandler {
    private final JxBrowserPanel fBrowserPanel;
    private final HtmlPanelContextMenuHandler fMenuHandler;
    private final CloseContextMenuListener fCloseContextMenuListener;

    public MWContextMenuHandler(HtmlPanelContextMenuHandler htmlPanelContextMenuHandler, JxBrowserPanel jxBrowserPanel) {
        this.fBrowserPanel = jxBrowserPanel;
        this.fMenuHandler = htmlPanelContextMenuHandler;
        JxBrowserSwingComponent jxBrowserSwingComponent = jxBrowserPanel.getComponent();
        CloseContextMenuListener closeContextMenuListener = null;
        if (jxBrowserSwingComponent != null && SystemUtils.isLinux()) {
            closeContextMenuListener = new CloseContextMenuListener();
            jxBrowserSwingComponent.addMouseListener(closeContextMenuListener);
            JxBrowserFocusManager jxBrowserFocusManager = jxBrowserSwingComponent.getFocusManager();
            if (jxBrowserFocusManager != null) {
                jxBrowserFocusManager.addFocusChangeListener(closeContextMenuListener);
            }
        }
        this.fCloseContextMenuListener = closeContextMenuListener;
    }

    public void showContextMenu(ContextMenuEvent contextMenuEvent) {
        TargetUrlCallable targetUrlCallable = new TargetUrlCallable(contextMenuEvent.getLocation(), contextMenuEvent.getTarget());
        BrowserQueue.invokeLaterAndNotify(targetUrlCallable, targetUrlCallable);
    }

    private HtmlPanelContextMenuHandler getMenuHandler() {
        return this.fMenuHandler;
    }

    public boolean equals(Object object) {
        if (object instanceof MWContextMenuHandler) {
            return this.fMenuHandler.equals(((MWContextMenuHandler)object).getMenuHandler());
        }
        return false;
    }

    private Url correctUrl(String string) {
        if (MWContextMenuHandler.needsCorrection(string)) {
            Url url = this.fBrowserPanel.getNavigator().getCurrentLocation();
            return RelativeUrlBuilder.buildRelativeUrl(url, string);
        }
        return Url.parseSilently(string);
    }

    private static boolean needsCorrection(String string) {
        if (HtmlUtils.isValidUrl(string) || new File(string).exists()) {
            return false;
        }
        Url url = Url.parseSilently(string);
        return url == null || url.getType() != Url.UrlType.CUSTOM_PROTOCOL;
    }

    private static class CloseContextMenuListener
    extends MouseAdapter
    implements HtmlDataListener<Boolean> {
        private JPopupMenu iMenu;
        private boolean iCloseMenuOnFocusLoss = false;

        private CloseContextMenuListener() {
        }

        private void setPopupMenu(JPopupMenu jPopupMenu) {
            if (jPopupMenu != null) {
                jPopupMenu.requestFocusInWindow();
            }
            if (this.iMenu != null) {
                this.iMenu.setVisible(false);
            }
            this.iCloseMenuOnFocusLoss = false;
            this.iMenu = jPopupMenu;
        }

        @Override
        public void dataRetrieved(Boolean bl) {
            if (!bl.booleanValue() && this.iCloseMenuOnFocusLoss) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (CloseContextMenuListener.this.iMenu != null && !CloseContextMenuListener.this.iMenu.hasFocus()) {
                            CloseContextMenuListener.this.setPopupMenu(null);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else {
                this.iCloseMenuOnFocusLoss = bl != false && this.iMenu != null;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.setPopupMenu(null);
        }
    }

    private class TargetUrlCallable
    implements Callable<Url>,
    HtmlDataListener<Url> {
        private final Point iPoint;
        private final Node iTarget;

        private TargetUrlCallable(Point point, Node node) {
            this.iPoint = point;
            this.iTarget = node;
        }

        @Override
        public Url call() throws Exception {
            return this.getHrefFromTarget();
        }

        @Override
        public void dataRetrieved(Url url) {
            SelectedTextListener selectedTextListener = new SelectedTextListener(this.iPoint, url);
            MWContextMenuHandler.this.fBrowserPanel.getSelectedText(selectedTextListener);
        }

        private Url getHrefFromTarget() {
            Node node = this.iTarget;
            int n = 0;
            do {
                String string;
                Node node2;
                NamedNodeMap namedNodeMap;
                if (node.hasAttributes() && (namedNodeMap = node.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem("href")) != null && (string = node2.getNodeValue()) != null && !this.isInvalidHref(string)) {
                    return MWContextMenuHandler.this.correctUrl(string);
                }
                node = node.getParentNode();
            } while (++n < 3 && node != null);
            return null;
        }

        private boolean isInvalidHref(String string) {
            return string.startsWith("matlab:") || string.startsWith("javascript:") || string.endsWith("#");
        }
    }

    private class SelectedTextListener
    implements HtmlDataListener<String> {
        private final Point iPoint;
        private final Url iTargetUrl;

        private SelectedTextListener(Point point, Url url) {
            this.iPoint = point;
            this.iTargetUrl = url;
        }

        @Override
        public void dataRetrieved(final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ContextMenuTargetData contextMenuTargetData = new ContextMenuTargetData(SelectedTextListener.this.iTargetUrl, string);
                    JPopupMenu jPopupMenu = MWContextMenuHandler.this.fMenuHandler.showContextMenu(((SelectedTextListener)SelectedTextListener.this).iPoint.x, ((SelectedTextListener)SelectedTextListener.this).iPoint.y, contextMenuTargetData);
                    if (MWContextMenuHandler.this.fCloseContextMenuListener != null) {
                        MWContextMenuHandler.this.fCloseContextMenuListener.setPopupMenu(jPopupMenu);
                    }
                }
            });
        }
    }
}

