/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.JxBrowserFocusManager;
import com.mathworks.html.jxbrowser.JxBrowserKeyAdapter;
import com.mathworks.html.jxbrowser.JxBrowserKeyEvent;
import com.mathworks.html.jxbrowser.JxBrowserMouseAdapter;
import com.mathworks.html.jxbrowser.JxBrowserZoomHandler;
import com.mathworks.html.jxbrowser.SystemUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class JxBrowserSwingComponent
extends JPanel {
    private final BrowserHolder fBrowser;
    private final Component fBrowserComponent;
    private JxBrowserFocusManager fFocusManager;
    private JxBrowserZoomHandler fJxBrowserZoomHandler;

    public JxBrowserSwingComponent(BrowserHolder browserHolder) {
        super(new BorderLayout());
        this.fBrowser = browserHolder;
        this.fBrowserComponent = browserHolder.getComponent();
    }

    void dispose() {
        if (this.fFocusManager != null) {
            this.fFocusManager.remove();
        }
    }

    public BrowserHolder getBrowser() {
        return this.fBrowser;
    }

    void initialize() {
        this.fFocusManager = new JxBrowserFocusManager(this);
        this.fFocusManager.install();
        JxBrowserMouseAdapter.install(this);
        this.fJxBrowserZoomHandler = new JxBrowserZoomHandler(this.fBrowser);
        this.addKeyListener(this.fJxBrowserZoomHandler);
        this.fBrowser.getComponent().addKeyListener(new JxBrowserKeyAdapter(this));
    }

    JxBrowserFocusManager getFocusManager() {
        return this.fFocusManager;
    }

    @Override
    public void addNotify() {
        this.addBrowserComponent();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.removeBrowserComponent();
        super.removeNotify();
    }

    void addBrowserComponent() {
        if (!this.isAncestorOf(this.fBrowserComponent)) {
            this.add(this.fBrowserComponent, "Center");
        }
    }

    private void removeBrowserComponent() {
        if (this.isAncestorOf(this.fBrowserComponent)) {
            this.remove(this.fBrowserComponent);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (JxBrowserSwingComponent.acceptForKeyBindings(keyEvent)) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
        return true;
    }

    private static boolean acceptForKeyBindings(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = JxBrowserSwingComponent.isClonedKeyEvent(keyEvent);
        return bl2 != (bl = SystemUtils.isLinux());
    }

    private static boolean isClonedKeyEvent(KeyEvent keyEvent) {
        return keyEvent instanceof JxBrowserKeyEvent;
    }

    JxBrowserZoomHandler getJxBrowserZoomHandler() {
        return this.fJxBrowserZoomHandler;
    }
}

