/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserListeners;
import com.mathworks.html.BrowserNavigator;
import com.mathworks.html.BrowserQueue;
import com.mathworks.html.CharsetDetectionStrategy;
import com.mathworks.html.HtmlActionGroups;
import com.mathworks.html.HtmlComponentIdentifier;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlFileWriter;
import com.mathworks.html.HtmlFindInPage;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.HtmlPanelContextMenuHandler;
import com.mathworks.html.HtmlPanelSupport;
import com.mathworks.html.HtmlSourceReader;
import com.mathworks.html.PopupWindowListener;
import com.mathworks.html.TextUrlRequestHandler;
import com.mathworks.html.Url;
import com.mathworks.html.jxbrowser.AggregateNewWindowManager;
import com.mathworks.html.jxbrowser.BrowserAccessCallable;
import com.mathworks.html.jxbrowser.BrowserBuilder;
import com.mathworks.html.jxbrowser.BrowserConfig;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.CommonBrowserCallable;
import com.mathworks.html.jxbrowser.CommonBrowserRunnable;
import com.mathworks.html.jxbrowser.CompoundPrintStrategy;
import com.mathworks.html.jxbrowser.DefaultBrowserConfig;
import com.mathworks.html.jxbrowser.DesktopPrintStrategy;
import com.mathworks.html.jxbrowser.IEFindInPage;
import com.mathworks.html.jxbrowser.JxBrowserNavigator;
import com.mathworks.html.jxbrowser.JxBrowserPopupHandler;
import com.mathworks.html.jxbrowser.JxBrowserProxyBridge;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.mathworks.html.jxbrowser.JxBrowserZoomHandler;
import com.mathworks.html.jxbrowser.MWContextMenuHandler;
import com.mathworks.html.jxbrowser.Mozilla15FindInPage;
import com.mathworks.html.jxbrowser.MozillaFindInPage;
import com.mathworks.html.jxbrowser.PrintStrategy;
import com.mathworks.html.jxbrowser.RequestHandlerPolicyDelegate;
import com.mathworks.html.jxbrowser.SafariFindInPage;
import com.mathworks.html.jxbrowser.StreamingTextHandler;
import com.mathworks.html.jxbrowser.SystemBrowserPrintStrategy;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.ContextMenuHandler;
import com.teamdev.jxbrowser.ie.IEBrowser;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import com.teamdev.jxbrowser.safari.SafariBrowser;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.JComponent;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;

public class JxBrowserPanel
implements HtmlPanelSupport {
    private static boolean sInitialized = false;
    private final BrowserNavigator fNavigator;
    private final BrowserConfig fConfig;
    private final PrintStrategy fPrintStrategy;
    private HtmlActionGroups fHtmlActionGroups;

    private static void disableJxBrowserLogging() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"com.jniwrapper", "com.teamdev"}) {
            Logger logger = Logger.getLogger((String)string);
            logger.addAppender((Appender)new NullAppender());
            logger.setLevel(Level.OFF);
        }
    }

    static JxBrowserPanel createJxBrowserPanel(BrowserListeners browserListeners) {
        return JxBrowserPanel.createJxBrowserPanel(BrowserBuilder.createBrowser(), browserListeners);
    }

    static JxBrowserPanel createJxBrowserPanel(Browser browser, BrowserListeners browserListeners) {
        JxBrowserPanel.initOnce(browser.getType());
        DefaultBrowserConfig defaultBrowserConfig = new DefaultBrowserConfig(browser, browserListeners);
        BrowserHolder browserHolder = defaultBrowserConfig.getSwingComponent().getBrowser();
        StreamingTextHandler streamingTextHandler = defaultBrowserConfig.getStreamingTextHandler();
        RequestHandlerPolicyDelegate requestHandlerPolicyDelegate = defaultBrowserConfig.getRequestHandlerPolicyDelegate();
        JxBrowserNavigator jxBrowserNavigator = new JxBrowserNavigator(browserHolder, streamingTextHandler, requestHandlerPolicyDelegate);
        PrintStrategy printStrategy = JxBrowserPanel.getPrintStrategy();
        JxBrowserPanel jxBrowserPanel = new JxBrowserPanel(defaultBrowserConfig, jxBrowserNavigator, printStrategy);
        browserListeners.getRequestHandler().addRequestHandler(new TextUrlRequestHandler(jxBrowserNavigator, streamingTextHandler));
        browser.getComponent().addFocusListener(new JxBrowserFocusAdapter(defaultBrowserConfig.getSwingComponent()));
        defaultBrowserConfig.finishSetup();
        return jxBrowserPanel;
    }

    public JxBrowserPanel(BrowserConfig browserConfig, BrowserNavigator browserNavigator, PrintStrategy printStrategy) {
        this.fConfig = browserConfig;
        this.fNavigator = browserNavigator;
        this.fPrintStrategy = printStrategy;
    }

    private static synchronized void initOnce(final BrowserType browserType) {
        if (!sInitialized) {
            BrowserQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JxBrowserProxyBridge.init(browserType);
                    DefaultBrowserConfig.initOnce();
                }
            });
            sInitialized = true;
        }
    }

    @Override
    public HtmlPanel.BrowserType getBrowserType() {
        return HtmlPanel.BrowserType.JXBROWSER;
    }

    @Override
    public JxBrowserSwingComponent getComponent() {
        return this.fConfig.getSwingComponent();
    }

    @Override
    public HtmlActionGroups getBrowserSuppliedActions() {
        if (this.fHtmlActionGroups == null) {
            this.fHtmlActionGroups = new HtmlActionGroups();
            JxBrowserZoomHandler jxBrowserZoomHandler = this.fConfig.getSwingComponent().getJxBrowserZoomHandler();
            if (jxBrowserZoomHandler != null) {
                this.fHtmlActionGroups.addCustomActionGroup(jxBrowserZoomHandler.getZoomActionGroup());
            }
        }
        return this.fHtmlActionGroups;
    }

    BrowserHolder getBrowser() {
        return this.fConfig.getSwingComponent().getBrowser();
    }

    @Override
    public BrowserNavigator getNavigator() {
        return this.fNavigator;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.getBrowser().invokeAndReturn(new CommonBrowserCallable<String>(){

            @Override
            public String handleBrowser(Browser browser) {
                return JxBrowserPanel.this.isDisposed() ? null : browser.getTitle();
            }
        }, null);
    }

    @Override
    public void executeScript(final String string, HtmlDataListener<String> htmlDataListener) {
        CommonBrowserCallable<String> commonBrowserCallable = new CommonBrowserCallable<String>(){

            @Override
            public String handleBrowser(Browser browser) {
                return browser.executeScript(string);
            }
        };
        this.getBrowser().invokeLaterAndNotify(commonBrowserCallable, htmlDataListener, null);
    }

    @Override
    public void getSelectedText(HtmlDataListener<String> htmlDataListener) {
        this.executeScript(this.fConfig.getTextSelectionScript(), htmlDataListener);
    }

    @Override
    public String getHtmlText() {
        if (this.isDisposed()) {
            return null;
        }
        String string = this.getCurrentLocation();
        return JxBrowserPanel.getSourceForUrl(string);
    }

    protected static String getSourceForUrl(String string) {
        return HtmlSourceReader.getSource(string, CharsetDetectionStrategy.getAutoDetectStrategy());
    }

    @Override
    public boolean isPrintingSupported() {
        return true;
    }

    @Override
    public void print(final HtmlDataListener<Boolean> htmlDataListener) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JxBrowserPanel.this.fPrintStrategy.print(JxBrowserPanel.this, htmlDataListener);
            }
        };
        new Thread(runnable).start();
    }

    private static PrintStrategy getPrintStrategy() {
        return new CompoundPrintStrategy(new DesktopPrintStrategy(true), new SystemBrowserPrintStrategy());
    }

    @Override
    public void saveAs(File file) {
        if (!this.isDisposed()) {
            new HtmlFileWriter(file, this.getHtmlText(), this.getCurrentLocation(), true).saveFile();
        }
    }

    private String getCurrentLocation() {
        Url url = this.fNavigator.getCurrentLocation();
        return url == null ? "" : url.toString();
    }

    @Override
    public void dispose() {
        this.fConfig.disposeBrowser(false);
    }

    @Override
    public void setContextMenuHandler(final HtmlPanelContextMenuHandler htmlPanelContextMenuHandler) {
        BrowserHolder browserHolder = this.getBrowser();
        JxBrowserSwingComponent jxBrowserSwingComponent = this.getComponent();
        if (browserHolder.getType() != BrowserHolder.Type.Safari) {
            browserHolder.invokeLater(new CommonBrowserRunnable(){

                @Override
                public void handleBrowser(Browser browser) {
                    browser.setContextMenuHandler((ContextMenuHandler)new MWContextMenuHandler(htmlPanelContextMenuHandler, JxBrowserPanel.this));
                }
            });
        }
    }

    @Override
    public HtmlFindInPage getFindInPage() {
        return this.getBrowser().invokeAndReturn(new BrowserAccessCallable<HtmlFindInPage>(){

            @Override
            public HtmlFindInPage handleMozillaBrowser(MozillaBrowser mozillaBrowser) {
                return new MozillaFindInPage(mozillaBrowser);
            }

            @Override
            public HtmlFindInPage handleMozilla15Browser(com.teamdev.jxbrowser.mozilla15.MozillaBrowser mozillaBrowser) {
                return new Mozilla15FindInPage(mozillaBrowser);
            }

            @Override
            public HtmlFindInPage handleIEBrowser(IEBrowser iEBrowser) {
                return new IEFindInPage(JxBrowserPanel.this);
            }

            @Override
            public HtmlFindInPage handleSafariBrowser(SafariBrowser safariBrowser) {
                return new SafariFindInPage(JxBrowserPanel.this);
            }
        }, null);
    }

    @Override
    public void setPopupWindowListener(final PopupWindowListener popupWindowListener) {
        if (!this.isDisposed()) {
            CommonBrowserRunnable commonBrowserRunnable = new CommonBrowserRunnable(){

                @Override
                public void handleBrowser(Browser browser) {
                    AggregateNewWindowManager aggregateNewWindowManager = JxBrowserPanel.this.fConfig.getNewWindowManager();
                    JxBrowserPopupHandler jxBrowserPopupHandler = new JxBrowserPopupHandler(popupWindowListener);
                    aggregateNewWindowManager.addBrowserWindowManager(browser, jxBrowserPopupHandler);
                }
            };
            if (BrowserQueue.isBrowserThread()) {
                this.getBrowser().invokeAndWait(commonBrowserRunnable);
            } else {
                this.getBrowser().invokeLater(commonBrowserRunnable);
            }
        }
    }

    boolean isDisposed() {
        return this.getBrowser().isDisposed();
    }

    public StreamingTextHandler getStreamingTextHandler() {
        return this.fConfig.getStreamingTextHandler();
    }

    @Override
    public HtmlComponentIdentifier getId() {
        return this.getBrowser().getType();
    }

    static {
        JxBrowserPanel.disableJxBrowserLogging();
    }

    private static class JxBrowserFocusAdapter
    extends FocusAdapter {
        private final JComponent iPanel;

        private JxBrowserFocusAdapter(JComponent jComponent) {
            this.iPanel = jComponent;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.iPanel.revalidate();
            this.iPanel.repaint();
        }
    }
}

