/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlComponentIdentifier;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.jxbrowser.BrowserAccessCallable;
import com.mathworks.html.jxbrowser.BrowserAccessRunnable;
import com.mathworks.html.jxbrowser.BrowserTypeCallable;
import com.mathworks.html.jxbrowser.BrowserTypeRunnable;
import com.mathworks.html.jxbrowser.JxBrowserSettings;
import com.mathworks.html.jxbrowser.SystemUtils;
import com.teamdev.jxbrowser.BrowserType;
import java.awt.Component;

public interface BrowserHolder {
    public Type getType();

    public Component getComponent();

    public boolean isDisposed();

    public void invokeNow(BrowserTypeRunnable var1);

    public <T> T invokeNow(BrowserTypeCallable<T> var1);

    public void invokeLater(BrowserAccessRunnable var1);

    public <V> void invokeLaterAndNotify(BrowserAccessCallable<V> var1, HtmlDataListener<V> var2, V var3);

    public void invokeAndWait(BrowserAccessRunnable var1);

    public <V> V invokeAndReturn(BrowserAccessCallable<V> var1, V var2);

    public void disposeBrowser(Runnable var1, boolean var2);

    public static final class Type
    extends Enum<Type>
    implements HtmlComponentIdentifier {
        public static final /* enum */ Type Mozilla = new Type(BrowserType.Mozilla);
        public static final /* enum */ Type Mozilla15 = new Type(BrowserType.Mozilla15);
        public static final /* enum */ Type IE = new Type(BrowserType.IE);
        public static final /* enum */ Type Safari = new Type(BrowserType.Safari);
        private final BrowserType iBrowserType;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        private Type(BrowserType browserType) {
            this.iBrowserType = browserType;
        }

        BrowserType getBrowserType() {
            return this.iBrowserType;
        }

        static Type fromBrowserType(BrowserType browserType) {
            for (Type type : Type.values()) {
                if (!type.getBrowserType().equals(browserType)) continue;
                return type;
            }
            assert (false) : "Unexpected browser type: " + browserType.getName();
            return null;
        }

        @Override
        public String getUniqueId() {
            return "JxBrowser_3_" + this.toString();
        }

        @Override
        public boolean isSupported() {
            switch (this) {
                case IE: {
                    if (SystemUtils.is64Bit()) break;
                    return false;
                }
                case Mozilla: {
                    if (SystemUtils.isLinux()) break;
                    return false;
                }
            }
            return this.iBrowserType.isSupported();
        }

        @Override
        public boolean beforeSetAsDefault() {
            return this.isSupported() && JxBrowserSettings.setDefaultBrowserType(this);
        }

        static {
            $VALUES = new Type[]{Mozilla, Mozilla15, IE, Safari};
        }
    }
}

