/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.CommonBrowserRunnable;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.WebPolicyDelegate;
import com.teamdev.jxbrowser.events.NavigationEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class AggregateWebPolicyDelegate
implements WebPolicyDelegate {
    private final WebPolicyDelegate fOriginalDelegate;
    private final Map<BrowserHolder, List<WebPolicyDelegate>> fDelegates = new WeakHashMap<BrowserHolder, List<WebPolicyDelegate>>();
    private final Map<Browser, BrowserHolder> fBrowserHolderMap = new WeakHashMap<Browser, BrowserHolder>();

    public AggregateWebPolicyDelegate(WebPolicyDelegate webPolicyDelegate) {
        this.fOriginalDelegate = webPolicyDelegate;
    }

    public void addDelegate(final BrowserHolder browserHolder, WebPolicyDelegate webPolicyDelegate) {
        List<WebPolicyDelegate> list = this.fDelegates.get(browserHolder);
        if (list == null) {
            list = new LinkedList<WebPolicyDelegate>();
            this.fDelegates.put(browserHolder, list);
            CommonBrowserRunnable commonBrowserRunnable = new CommonBrowserRunnable(){

                @Override
                public void handleBrowser(Browser browser) {
                    AggregateWebPolicyDelegate.this.fBrowserHolderMap.put(browser, browserHolder);
                }
            };
            browserHolder.invokeLater(commonBrowserRunnable);
        }
        list.add(webPolicyDelegate);
    }

    public void clearBrowserDelegates(BrowserHolder browserHolder) {
        this.fDelegates.remove(browserHolder);
    }

    public List<WebPolicyDelegate> getBrowserDelegates(BrowserHolder browserHolder) {
        List<WebPolicyDelegate> list = this.fDelegates.get(browserHolder);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    private List<WebPolicyDelegate> getBrowserDelegates(Browser browser) {
        BrowserHolder browserHolder = this.fBrowserHolderMap.get(browser);
        if (browserHolder != null) {
            return this.getBrowserDelegates(browserHolder);
        }
        return Collections.emptyList();
    }

    public boolean allowNavigation(NavigationEvent navigationEvent) {
        List<WebPolicyDelegate> list = this.getBrowserDelegates(navigationEvent.getBrowser());
        for (WebPolicyDelegate webPolicyDelegate : list) {
            if (webPolicyDelegate.allowNavigation(navigationEvent)) continue;
            return false;
        }
        return this.fOriginalDelegate == null || this.fOriginalDelegate.allowNavigation(navigationEvent);
    }

    public boolean allowMimeType(String string, NavigationEvent navigationEvent) {
        List<WebPolicyDelegate> list = this.getBrowserDelegates(navigationEvent.getBrowser());
        for (WebPolicyDelegate webPolicyDelegate : list) {
            if (webPolicyDelegate.allowMimeType(string, navigationEvent)) continue;
            return false;
        }
        return this.fOriginalDelegate == null || this.fOriginalDelegate.allowMimeType(string, navigationEvent);
    }
}

