/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.BrowserNavigator;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolRequestHandler;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.StreamingTextUrlManager;
import com.mathworks.html.Url;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextUrlRequestHandler
extends CustomProtocolRequestHandler {
    private static final Pattern TEXT_INDEX_PATTERN = Pattern.compile("^(\\d+)/?$");
    private final BrowserNavigator fNavigator;
    private final StreamingTextUrlManager fUrlManager;

    public TextUrlRequestHandler(BrowserNavigator browserNavigator, StreamingTextUrlManager streamingTextUrlManager) {
        super("text", new String[0]);
        this.fNavigator = browserNavigator;
        this.fUrlManager = streamingTextUrlManager;
    }

    @Override
    protected void handleMatchedRequest(BrowserRequest browserRequest, CustomProtocolUrl customProtocolUrl) {
        String string = customProtocolUrl.getCommand();
        Url url = this.getCachedStreamingTextUrl(string);
        if (url != null) {
            this.fNavigator.setCurrentLocation(url);
        } else {
            this.fNavigator.setHtmlText(string);
        }
    }

    private Url getCachedStreamingTextUrl(String string) {
        Matcher matcher = TEXT_INDEX_PATTERN.matcher(string);
        if (matcher.find()) {
            int n = Integer.parseInt(matcher.group(1));
            return this.fUrlManager.getUrlForIndex(n);
        }
        return null;
    }
}

