/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class SelectedTextUtils {
    private static final String SELECTED_TEXT_MENU_PROPERTY = "HtmlPanel.SelectedText";

    private SelectedTextUtils() {
    }

    public static void getSelectedTextForEvent(ActionEvent actionEvent, HtmlComponent htmlComponent, HtmlDataListener<String> htmlDataListener) {
        String string = SelectedTextUtils.getSelectedTextFromEvent(actionEvent);
        if (string != null) {
            htmlDataListener.dataRetrieved(string);
        } else {
            htmlComponent.getSelectedText(htmlDataListener);
        }
    }

    public static void setSelectedTextForContextMenu(JPopupMenu jPopupMenu, String string) {
        jPopupMenu.putClientProperty(SELECTED_TEXT_MENU_PROPERTY, SelectedTextUtils.correctSelectedTextWhitespace(string));
    }

    public static String getSelectedTextFromContextMenu(JPopupMenu jPopupMenu) {
        Object object = jPopupMenu.getClientProperty(SELECTED_TEXT_MENU_PROPERTY);
        return object == null ? null : object.toString();
    }

    private static String getSelectedTextFromEvent(ActionEvent actionEvent) {
        JComponent jComponent;
        JPopupMenu jPopupMenu;
        Object object = actionEvent.getSource();
        if (object != null && object instanceof JComponent && (jPopupMenu = SelectedTextUtils.findPopupMenu(jComponent = (JComponent)object)) != null) {
            return SelectedTextUtils.getSelectedTextFromContextMenu(jPopupMenu);
        }
        return null;
    }

    private static JPopupMenu findPopupMenu(JComponent jComponent) {
        return (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, jComponent);
    }

    public static String correctSelectedTextWhitespace(String string) {
        return string == null ? "" : string.replace('\u00a0', ' ');
    }
}

