/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CharsetDetectionStrategy;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;

public class HtmlSourceReader {
    public static String getSource(String string) {
        return HtmlSourceReader.getSource(string, CharsetDetectionStrategy.getAutoDetectStrategy());
    }

    public static String getSource(String string, Charset charset) {
        CharsetDetectionStrategy charsetDetectionStrategy = CharsetDetectionStrategy.getCharsetStrategy(charset);
        return HtmlSourceReader.getSource(string, charsetDetectionStrategy);
    }

    public static String getSource(String string, String string2) throws UnsupportedEncodingException {
        CharsetDetectionStrategy charsetDetectionStrategy = CharsetDetectionStrategy.getCharsetStrategy(string2);
        return HtmlSourceReader.getSource(string, charsetDetectionStrategy);
    }

    public static String getSource(String string, CharsetDetectionStrategy charsetDetectionStrategy) {
        Charset charset = charsetDetectionStrategy.getCharset(string);
        InputStream inputStream = HtmlSourceReader.getInputStreamForUrl(string);
        if (inputStream != null) {
            return HtmlSourceReader.readInputStream(inputStream, charset);
        }
        return null;
    }

    static InputStream getInputStreamForUrl(String string) {
        Url url = Url.parseSilently(string);
        if (url != null) {
            InputStreamUrlResolver inputStreamUrlResolver = new InputStreamUrlResolver();
            return (InputStream)inputStreamUrlResolver.transformUrl(url);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInputStream(InputStream inputStream, Charset charset) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuilder.append(string).append('\n');
                string = bufferedReader.readLine();
            }
            string = stringBuilder.toString();
            return string;
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            try {
                bufferedReader.close();
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    static interface HtmlSourceStream {
        public InputStream getInputStream();

        public void close();
    }

    private static class InputStreamUrlResolver
    extends UrlTransformer<InputStream> {
        private InputStreamUrlResolver() {
        }

        @Override
        protected InputStream transformWebUrl(WebUrl webUrl) {
            try {
                return webUrl.toURL().openStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        protected InputStream transformFileUrl(FileUrl fileUrl) {
            try {
                return new FileInputStream(fileUrl.getFile());
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        protected InputStream transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            try {
                URL uRL = new URL(customProtocolUrl.toString());
                return uRL.openStream();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }
}

