/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.BrowserNavigator;
import com.mathworks.html.LoadFailure;
import com.mathworks.html.LoadFailureHandlerMap;
import com.mathworks.html.PageLoadFailureHandler;
import com.mathworks.html.Url;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;

public class HtmlPanelLoadFailureHandlerMap
implements LoadFailureHandlerMap {
    private static final ResourceBundle LABEL_BUNDLE = ResourceBundle.getBundle("com.mathworks.html.resources.RES_HtmlPanel");
    private final List<LoadFailureHandlerMap> fOverrides = new LinkedList<LoadFailureHandlerMap>();

    @Override
    public PageLoadFailureHandler getHandler(LoadFailure loadFailure) {
        for (LoadFailureHandlerMap loadFailureHandlerMap : this.fOverrides) {
            PageLoadFailureHandler pageLoadFailureHandler = loadFailureHandlerMap.getHandler(loadFailure);
            if (pageLoadFailureHandler == null) continue;
            return pageLoadFailureHandler;
        }
        return new HtmlTextFailureHandler();
    }

    public void addOverrides(LoadFailureHandlerMap loadFailureHandlerMap) {
        this.fOverrides.add(0, loadFailureHandlerMap);
    }

    protected String getResourceString(String string) {
        return LABEL_BUNDLE.getString(string);
    }

    private static String getMessageKey(LoadFailure loadFailure) {
        if (loadFailure == LoadFailure.PROXY_CONNECTION_FAILED) {
            return "load_failure.proxy";
        }
        return "load_failure.not_found";
    }

    private class HtmlTextFailureHandler
    implements PageLoadFailureHandler {
        private HtmlTextFailureHandler() {
        }

        @Override
        public void handleLoadFailure(LoadFailure loadFailure, BrowserNavigator browserNavigator, Url url) {
            String string = HtmlPanelLoadFailureHandlerMap.getMessageKey(loadFailure);
            String string2 = HtmlPanelLoadFailureHandlerMap.this.getResourceString(string);
            String string3 = MessageFormat.format(string2, url);
            browserNavigator.setHtmlText(string3);
        }
    }
}

