/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.FindOption;
import com.mathworks.html.HtmlActionGroups;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlComponentIdentifier;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlSourceReader;
import com.mathworks.html.LoadFailureHandlerMap;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.StatusTextListener;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class DummyHtmlComponent
implements HtmlComponent {
    public static final HtmlComponentIdentifier ID = new HtmlComponentIdentifier(){

        @Override
        public String getUniqueId() {
            return "DummyHtmlComponent";
        }

        @Override
        public boolean isSupported() {
            return true;
        }

        @Override
        public boolean beforeSetAsDefault() {
            return true;
        }
    };
    private final JTextComponent fTextComponent;
    private final Component fComponent;
    private HtmlActions fActions;
    private final List<PageChangedListener> fPageChangedListeners = new LinkedList<PageChangedListener>();
    private Url fLastUrl;
    public static final String textName = "DummyHtmlComponent.TextComponent";

    public DummyHtmlComponent(Component component, JTextComponent jTextComponent) {
        this.fComponent = component;
        this.fTextComponent = jTextComponent;
        this.fTextComponent.setName(textName);
    }

    @Override
    public Component getComponent() {
        return this.fComponent;
    }

    @Override
    public String getTitle() {
        String string = this.getHtmlText();
        if (string == null || string.length() == 0) {
            return "";
        }
        Pattern pattern = Pattern.compile("<title>([^<]+?)</title>");
        Matcher matcher = pattern.matcher(string);
        String string2 = matcher.group();
        return string2;
    }

    @Override
    public void getSelectedText(HtmlDataListener<String> htmlDataListener) {
        String string = this.fTextComponent.getSelectedText();
        htmlDataListener.dataRetrieved(string);
    }

    @Override
    public boolean canGoBack() {
        return false;
    }

    @Override
    public void goBack() {
    }

    @Override
    public boolean canGoForward() {
        return false;
    }

    @Override
    public void goForward() {
    }

    @Override
    public void reload() {
        this.fTextComponent.setText(this.readFile(this.fLastUrl));
    }

    @Override
    public String getHomeUrl() {
        return null;
    }

    @Override
    public boolean isPrintingSupported() {
        return false;
    }

    @Override
    public void print(HtmlDataListener<Boolean> htmlDataListener) {
        htmlDataListener.dataRetrieved(true);
    }

    @Override
    public void saveAs(File file) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void findInPage(String string, Collection<FindOption> collection, HtmlDataListener<Boolean> htmlDataListener) {
        htmlDataListener.dataRetrieved(false);
    }

    @Override
    public void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.fPageChangedListeners.add(pageChangedListener);
    }

    @Override
    public void removePageChangedListener(PageChangedListener pageChangedListener) {
        this.fPageChangedListeners.remove(pageChangedListener);
    }

    @Override
    public void addStatusTextListener(StatusTextListener statusTextListener) {
    }

    @Override
    public void removeStatusTextListener(StatusTextListener statusTextListener) {
    }

    @Override
    public void addTitleChangedListener(HtmlDataListener<String> htmlDataListener) {
    }

    @Override
    public void removeTitleChangedListener(HtmlDataListener<String> htmlDataListener) {
    }

    @Override
    public void disableNavigation() {
    }

    public void setActions(HtmlActions htmlActions) {
        this.fActions = htmlActions;
    }

    @Override
    public HtmlActions getActions() {
        return this.fActions;
    }

    @Override
    public HtmlActionGroups getBrowserSuppliedActions() {
        return null;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void setCurrentLocation(String string) {
        this.setCurrentLocation(Url.parseSilently(string));
    }

    @Override
    public void setCurrentLocation(Url url) {
        final PageChangedEvent pageChangedEvent = new PageChangedEvent(url.toString(), url, this.fLastUrl);
        this.fLastUrl = url;
        this.setHtmlText(this.readFile(url));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (PageChangedListener pageChangedListener : DummyHtmlComponent.this.fPageChangedListeners) {
                    pageChangedListener.pageChanged(pageChangedEvent);
                }
            }
        });
    }

    @Override
    public String getCurrentLocation() {
        if (this.fLastUrl == null) {
            return null;
        }
        return this.fLastUrl.toString();
    }

    @Override
    public void setHtmlText(String string) {
        this.fTextComponent.setText(string);
    }

    @Override
    public String getHtmlText() {
        return this.fTextComponent.getText();
    }

    @Override
    public void executeScript(String string) {
    }

    @Override
    public void executeScript(String string, HtmlDataListener<String> htmlDataListener) {
        htmlDataListener.dataRetrieved("");
    }

    @Override
    public void addLoadFailureHandlers(LoadFailureHandlerMap loadFailureHandlerMap) {
    }

    private String readFile(final Url url) {
        UrlTransformer<String> urlTransformer = new UrlTransformer<String>(){

            @Override
            protected String transformWebUrl(WebUrl webUrl) {
                return "No web access implemented in DummyHtmlComponent. Attempted to access: '" + url.toString() + "'.";
            }

            @Override
            protected String transformFileUrl(FileUrl fileUrl) {
                return HtmlSourceReader.getSource(fileUrl.toString());
            }

            @Override
            protected String transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
                return customProtocolUrl.toString();
            }
        };
        return (String)urlTransformer.transformUrl(url);
    }

    @Override
    public HtmlComponentIdentifier getId() {
        return ID;
    }
}

