/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.jxbrowser.JxBrowserSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BrowserSettings {
    private static final Map<String, String> BROWSER_PROPERTIES = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Collection<String>> ALL_SUPPORTED_PROPERTIES = new LinkedHashMap<String, Collection<String>>();

    public static void setProperty(String string, String string2) {
        Collection<String> collection = ALL_SUPPORTED_PROPERTIES.get(string);
        if (collection == null) {
            System.out.println("Unknown browser property \"" + string + "\"; this setting may have no effect.");
        } else if (!collection.isEmpty() && !collection.contains(string2)) {
            System.out.println("Unexpected value \"value\" for browser property \"" + string + "\"; this setting may have no effect.");
        }
        BROWSER_PROPERTIES.put(string, string2);
    }

    public static void removeProperty(String string) {
        BROWSER_PROPERTIES.remove(string);
    }

    public static void setProperties(Map<String, String> map, boolean bl) {
        if (bl) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                BrowserSettings.setProperty(entry.getKey(), entry.getValue());
            }
        } else {
            BROWSER_PROPERTIES.putAll(map);
        }
    }

    public static String getProperty(String string) {
        String string2 = BROWSER_PROPERTIES.get(string);
        return string2 == null ? "" : string2;
    }

    private static Collection<BrowserSettings> getAllSettingsInstances() {
        ArrayList<BrowserSettings> arrayList = new ArrayList<BrowserSettings>();
        arrayList.add(JxBrowserSettings.getInstance());
        return arrayList;
    }

    public static Map<String, Collection<String>> getAllSupportedProperties() {
        return Collections.unmodifiableMap(ALL_SUPPORTED_PROPERTIES);
    }

    public static Collection<String> getSupportedValues(String string) {
        Collection<String> collection = ALL_SUPPORTED_PROPERTIES.get(string);
        return collection == null ? Collections.emptyList() : Collections.unmodifiableCollection(collection);
    }

    protected abstract Map<String, Collection<String>> getSupportedProperties();

    static {
        Collection<BrowserSettings> collection = BrowserSettings.getAllSettingsInstances();
        for (BrowserSettings browserSettings : collection) {
            ALL_SUPPORTED_PROPERTIES.putAll(browserSettings.getSupportedProperties());
        }
    }
}

