/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BrowserRequestManager {
    private Url fPendingUrl;
    private BrowserRequest.Origin fPendingOrigin;
    private Url fLastUrl;

    public void setPendingRequest(Url url, BrowserRequest.Origin origin) {
        this.fPendingUrl = url;
        this.fPendingOrigin = origin;
    }

    public BrowserRequest getRequestForUrl(Url url) {
        if (BrowserRequestManager.shouldBypassHandlers(url)) {
            return null;
        }
        BrowserRequest.Origin origin = this.isPendingRequest(url) ? this.fPendingOrigin : BrowserRequest.Origin.USER_INTERACTION;
        BrowserRequest browserRequest = new BrowserRequest(origin, url, this.fLastUrl);
        this.fPendingOrigin = null;
        this.fPendingUrl = null;
        return browserRequest;
    }

    private boolean isPendingRequest(Url url) {
        if (this.fPendingOrigin == null || url == null) {
            return false;
        }
        switch (this.fPendingOrigin) {
            case GO_BACK: 
            case GO_FORWARD: 
            case REFRESH: {
                return true;
            }
            case SET_LOCATION: 
            case SET_HTML_TEXT: {
                return this.fPendingUrl == null || this.fPendingUrl.isTargetOnSamePage(url);
            }
        }
        return this.fPendingUrl != null && this.fPendingUrl.isTargetOnSamePage(url);
    }

    public void requestCompleted(Url url) {
        this.fLastUrl = url;
        if (!BrowserRequestManager.shouldBypassHandlers(url)) {
            this.reset();
        }
    }

    private void reset() {
        this.fPendingUrl = null;
        this.fPendingOrigin = null;
    }

    private static boolean shouldBypassHandlers(Url url) {
        if (url == null) {
            return true;
        }
        BypassHandlersTransformer bypassHandlersTransformer = new BypassHandlersTransformer();
        return (Boolean)bypassHandlersTransformer.transformUrl(url);
    }

    public Url getPendingUrl() {
        return this.fPendingUrl;
    }

    public BrowserRequest.Origin getPendingOrigin() {
        return this.fPendingOrigin;
    }

    private static class BypassHandlersTransformer
    extends UrlTransformer<Boolean> {
        private final String[] iBypassProtocols = new String[]{"javascript", "about"};
        private final Set<String> iBypassProtocolsSet = new HashSet<String>(Arrays.asList(this.iBypassProtocols));

        private BypassHandlersTransformer() {
        }

        @Override
        protected Boolean transformWebUrl(WebUrl webUrl) {
            return false;
        }

        @Override
        protected Boolean transformFileUrl(FileUrl fileUrl) {
            File file = new File("about:blank");
            return fileUrl.getFile().equals(file);
        }

        @Override
        protected Boolean transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return this.iBypassProtocolsSet.contains(customProtocolUrl.getProtocol());
        }
    }
}

