/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.beans.EnumPair;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.page.plottool.PropertyEditor;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.event.CellEditorListener;

public class RadioControl
extends PropertyControl {
    protected MJPanel fPanel = new MJPanel();
    protected ButtonGroup fBtnGroup;
    protected Icon[] fIcons;
    protected int fOrientation = 1;

    public RadioControl(String string, CellEditorListener cellEditorListener, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper();
        this.fPanel.setName(string2 + "." + string);
    }

    public RadioControl(String string, EnumPair[] enumPairArray, String string2) {
        this.constructorHelper(enumPairArray);
        this.fPanel.setName(string2 + "." + string);
    }

    public RadioControl(String string, CellEditorListener cellEditorListener, EnumPair[] enumPairArray, String[] stringArray, int n, String string2) {
        super(string, cellEditorListener);
        this.fIcons = new Icon[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.fIcons[i] = PropertyEditor.makeImage(stringArray[i]);
        }
        this.fOrientation = n;
        this.setCustomEditor((JComponent)this.fPanel);
        this.fPanel.setName(string2 + "." + string);
        this.constructorHelper(enumPairArray);
    }

    private void constructorHelper() {
        this.setCustomEditor((JComponent)this.fPanel);
    }

    private void constructorHelper(EnumPair[] enumPairArray) {
        this.constructorHelper();
        Object[] objectArray = new Object[enumPairArray.length];
        String[] stringArray = new String[enumPairArray.length];
        for (int i = 0; i < enumPairArray.length; ++i) {
            objectArray[i] = enumPairArray[i].getObjectValue();
            stringArray[i] = enumPairArray[i].getName();
        }
        this.setOptions(objectArray, stringArray);
    }

    @Override
    public String getName() {
        if (this.fPanel != null) {
            return this.fPanel.getName() + "." + this.getClass().getSimpleName();
        }
        return null;
    }

    public void setOptions(Object[] objectArray, String[] stringArray) {
        this.fPanel.setLayout((LayoutManager)new BoxLayout((Container)this.fPanel, this.fOrientation));
        this.fBtnGroup = new ButtonGroup();
        this.fBtnGroup.add((AbstractButton)new MJRadioButton("mixed"));
        for (int i = 0; i < objectArray.length; ++i) {
            MJRadioButton mJRadioButton;
            String string = null;
            if (stringArray != null) {
                this.putValueString(stringArray[i], objectArray[i]);
                string = stringArray[i];
            } else {
                string = objectArray[i].toString();
            }
            if (this.fIcons != null) {
                mJRadioButton = new MJToggleButton(this.fIcons[i]);
                mJRadioButton.setToolTipText(string);
                mJRadioButton.setMargin(new Insets(2, 2, 2, 2));
                mJRadioButton.setFocusPainted(false);
            } else {
                mJRadioButton = new MJRadioButton(string);
            }
            mJRadioButton.setName("RadioBtn" + Integer.toString(i));
            mJRadioButton.setActionCommand(string);
            this.fBtnGroup.add((AbstractButton)mJRadioButton);
            this.fPanel.add((Component)mJRadioButton);
        }
    }

    @Override
    public void addEditStoppedSupport() {
        Enumeration<AbstractButton> enumeration = this.fBtnGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            abstractButton.addActionListener(this.action);
        }
    }

    @Override
    public void setDisplayedValue(Object object) {
        String string = "";
        string = object == PropertyControl.MIXED_VALUES ? "mixed" : (this.valueToString(object) != null ? this.valueToString(object) : object.toString());
        Enumeration<AbstractButton> enumeration = this.fBtnGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            if (!jToggleButton.getActionCommand().equals(string)) continue;
            jToggleButton.setSelected(true);
        }
    }

    @Override
    public Object getDisplayedValue() {
        String string = this.fBtnGroup.getSelection().getActionCommand();
        Object object = this.stringToValue(string);
        return object != null ? object : string;
    }
}

