/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.plotbrowser;

import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGDouble;
import com.mathworks.hg.types.HGMeshColor;
import com.mathworks.hg.types.HGStyledColor;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.PlotBrowser;
import com.mathworks.page.plottool.PropertyEditor;
import com.mathworks.page.plottool.plotbrowser.MLPropertyTypeConverter;
import com.mathworks.page.plottool.plotbrowser.PlotBrowserResources;
import com.mathworks.util.CategoricalVariable;
import com.mathworks.util.Log;
import com.mathworks.util.StyledColor;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.Arrays;

public class ChartObjectProxyFactory {
    public static SeriesProxy createSeriesProxy(Object object, String string) {
        if (object == null) {
            return null;
        }
        String string2 = string.replace('.', '_');
        return ChartObjectProxyFactory.createSeriesProxyFromClassName(object, string2);
    }

    public static SeriesProxy createHG2SeriesProxy(Object object, String string) {
        return ChartObjectProxyFactory.createSeriesProxy(object, string);
    }

    private static SeriesProxy createSeriesProxyFromClassName(Object object, String string) {
        SeriesProxy seriesProxy = null;
        if (string.startsWith("graph2d_lineseries") || string.startsWith("matlab_graphics_chart_primitive_Line") || string.startsWith("matlab_graphics_chart_primitive_ConstantLine") || string.startsWith("matlab_graphics_chart_primitive_FunctionLine")) {
            seriesProxy = new LineSeriesProxy(object);
        } else if (string.startsWith("specgraph_bar") || string.startsWith("matlab_graphics_chart_primitive_Bar")) {
            seriesProxy = new BarAreaSeriesProxy(object);
        } else if (string.startsWith("matlab_graphics_chart_primitive_Histogram")) {
            seriesProxy = new BarAreaSeriesProxy(object);
        } else if (string.startsWith("specgraph_stem") || string.startsWith("matlab_graphics_chart_primitive_Stem")) {
            seriesProxy = new StemSeriesProxy(object);
        } else if (string.startsWith("specgraph_stair") || string.startsWith("matlab_graphics_chart_primitive_Stair")) {
            seriesProxy = new StairSeriesProxy(object);
        } else if (string.startsWith("specgraph_area") || string.startsWith("matlab_graphics_chart_primitive_Area")) {
            seriesProxy = new BarAreaSeriesProxy(object);
        } else if (string.startsWith("specgraph_errorbar") || string.startsWith("matlab_graphics_chart_primitive_ErrorBar")) {
            seriesProxy = new ErrorbarSeriesProxy(object);
        } else if (string.startsWith("specgraph_scatter") || string.startsWith("matlab_graphics_chart_primitive_Scatter")) {
            seriesProxy = new ScatterSeriesProxy(object);
        } else if (string.startsWith("specgraph_contour") || string.startsWith("matlab_graphics_chart_primitive_Contour")) {
            seriesProxy = new ContourSeriesProxy(object);
        } else if (string.startsWith("specgraph_quiver") || string.startsWith("matlab_graphics_chart_primitive_Quiver")) {
            seriesProxy = new QuiverSeriesProxy(object);
        } else if (string.startsWith("graph3d_surfaceplot") || string.startsWith("matlab_graphics_chart_primitive_Surface")) {
            seriesProxy = new SurfaceProxy(object);
        } else if (string.startsWith("surface") || string.startsWith("matlab_graphics_primitive_Surface")) {
            seriesProxy = new SurfaceProxy(object);
        } else if (string.startsWith("image") || string.startsWith("matlab_graphics_primitive_Image")) {
            seriesProxy = new ImageProxy(object);
        } else if (string.startsWith("line") || string.startsWith("matlab_graphics_primitive_Line")) {
            seriesProxy = new LineProxy(object);
        } else if (string.startsWith("patch") || string.startsWith("matlab_graphics_primitive_Patch")) {
            seriesProxy = new PatchProxy(object);
        }
        return seriesProxy;
    }

    public static SeriesProxy[] createSeriesProxyArray(int n) {
        return new SeriesProxy[n];
    }

    public static void setProperty(ChartObjectProxy chartObjectProxy, String string, Object object) {
        if (string.equalsIgnoreCase("HandleVisibility")) {
            chartObjectProxy.setHandleVisibility("on".equals(object));
        } else if (string.equalsIgnoreCase("Visible")) {
            chartObjectProxy.setVisible("on".equals(object));
        } else if (string.equalsIgnoreCase("DisplayName")) {
            chartObjectProxy.setDisplayName(object == null ? "" : object.toString());
        } else if (string.equalsIgnoreCase("XDataSource")) {
            chartObjectProxy.setXDataSource(object == null ? "" : object.toString());
        } else if (string.equalsIgnoreCase("YDataSource")) {
            chartObjectProxy.setYDataSource(object == null ? "" : object.toString());
        } else if (string.equalsIgnoreCase("ZDataSource")) {
            chartObjectProxy.setZDataSource(object == null ? "" : object.toString());
        } else if (string.equalsIgnoreCase("Name")) {
            chartObjectProxy.setName(object == null ? "" : object.toString());
        } else if (string.equalsIgnoreCase("Title")) {
            chartObjectProxy.setTitle(PlotBrowser.createTitleString(object, PlotBrowserResources.getBundle().getString("item.axes.notitle")));
        } else if (string.equalsIgnoreCase("Tag")) {
            chartObjectProxy.setTag(object == null ? "" : object.toString());
        } else if (string.equalsIgnoreCase("Color")) {
            chartObjectProxy.setColor(ChartObjectProxyFactory.createColor(object));
        } else if (string.equalsIgnoreCase("FaceColor")) {
            chartObjectProxy.setFaceColor(ChartObjectProxyFactory.createColor(object));
        } else if (string.equalsIgnoreCase("EdgeColor")) {
            chartObjectProxy.setEdgeColor(ChartObjectProxyFactory.createColor(object));
        } else if (string.equalsIgnoreCase("LineColor")) {
            chartObjectProxy.setLineColor(ChartObjectProxyFactory.createColor(object));
        } else if (string.equalsIgnoreCase("LineWidth")) {
            chartObjectProxy.setLineWidth((Double)object);
        } else if (string.equalsIgnoreCase("LineStyle")) {
            chartObjectProxy.setLineStyle(object == null ? "" : object.toString());
        } else if (string.equalsIgnoreCase("Marker")) {
            chartObjectProxy.setMarker(object == null ? "" : object.toString());
        } else if (string.equalsIgnoreCase("MarkerFaceColor")) {
            chartObjectProxy.setMarkerFaceColor(ChartObjectProxyFactory.createColor(object));
        } else if (string.equalsIgnoreCase("MarkerEdgeColor")) {
            chartObjectProxy.setMarkerEdgeColor(ChartObjectProxyFactory.createColor(object));
        }
    }

    private static Color createColor(Object object) {
        double[] dArray = (double[])object;
        if (dArray != null) {
            if (dArray.length == 3) {
                return new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
            }
            return new Color((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3]);
        }
        return null;
    }

    public static void updateProperty(ChartObjectProxy chartObjectProxy, String string) {
        if (string.equalsIgnoreCase("HandleVisibility")) {
            chartObjectProxy.updateHandleVisibility();
        } else if (string.equalsIgnoreCase("Visible")) {
            chartObjectProxy.updateVisible();
        } else if (string.equalsIgnoreCase("DisplayName")) {
            chartObjectProxy.updateDisplayName();
        } else if (string.equalsIgnoreCase("XDataSource")) {
            chartObjectProxy.updateXDataSource();
        } else if (string.equalsIgnoreCase("YDataSource")) {
            chartObjectProxy.updateYDataSource();
        } else if (string.equalsIgnoreCase("ZDataSource")) {
            chartObjectProxy.updateZDataSource();
        } else if (string.equalsIgnoreCase("Name")) {
            chartObjectProxy.updateName();
        } else if (string.equalsIgnoreCase("Title")) {
            chartObjectProxy.updateTitle();
        } else if (string.equalsIgnoreCase("Tag")) {
            chartObjectProxy.updateTag();
        } else if (string.equalsIgnoreCase("Color")) {
            chartObjectProxy.updateColor();
        } else if (string.equalsIgnoreCase("FaceColor")) {
            chartObjectProxy.updateFaceColor();
        } else if (string.equalsIgnoreCase("EdgeColor")) {
            chartObjectProxy.updateEdgeColor();
        } else if (string.equalsIgnoreCase("LineColor")) {
            chartObjectProxy.updateLineColor();
        } else if (string.equalsIgnoreCase("LineWidth")) {
            chartObjectProxy.updateLineWidth();
        } else if (string.equalsIgnoreCase("LineStyle")) {
            chartObjectProxy.updateLineStyle();
        } else if (string.equalsIgnoreCase("Marker")) {
            chartObjectProxy.updateMarker();
        } else if (string.equalsIgnoreCase("MarkerFaceColor")) {
            chartObjectProxy.updateMarkerFaceColor();
        } else if (string.equalsIgnoreCase("MarkerEdgeColor")) {
            chartObjectProxy.updateMarkerEdgeColor();
        }
    }

    public static class ImageProxy
    extends SeriesProxy {
        protected Color color1 = new Color(255, 255, 255);
        protected Color color2 = new Color(231, 231, 255);
        protected Color color3 = new Color(198, 198, 255);
        protected Color color4 = new Color(156, 156, 255);
        protected Color color5 = new Color(132, 132, 255);
        protected Color color6 = new Color(16, 16, 255);

        ImageProxy(Object object) {
            super(object);
        }

        public Color getColor1() {
            return this.color1;
        }

        public Color getColor2() {
            return this.color2;
        }

        public Color getColor3() {
            return this.color3;
        }

        public Color getColor4() {
            return this.color4;
        }

        public Color getColor5() {
            return this.color5;
        }

        public Color getColor6() {
            return this.color6;
        }
    }

    public static class SurfaceProxy
    extends SeriesProxy {
        protected Color edgeColor;
        protected Color faceColor;

        public SurfaceProxy(Object object) {
            super(object);
        }

        public Color getFaceColor() {
            return this.faceColor;
        }

        public Color getEdgeColor() {
            return this.edgeColor;
        }

        @Override
        public void updateDisplayName() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("DisplayName");
            this.name = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateXDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("XDataSource");
            this.xDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateYDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("YDataSource");
            this.yDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateZDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("ZDataSource");
            this.zDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateEdgeColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("EdgeColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, HGMeshColor.NONE_FLAT_INTERP);
            }
            this.edgeColor = object == null || !(object instanceof HGMeshColor) ? Color.black : (((HGMeshColor)object).getStyle() != -1 ? new Color(16, 16, 255) : HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)));
        }

        @Override
        protected void setEdgeColor(Color color) {
            this.edgeColor = color;
        }

        @Override
        public void updateFaceColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("FaceColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, HGMeshColor.NONE_FLAT_INTERP_TEXTURE);
            }
            this.faceColor = object == null || !(object instanceof HGMeshColor) || ((HGMeshColor)object).getStyle() == 0 ? SystemColor.text : (((HGMeshColor)object).getStyle() != -1 ? new Color(16, 16, 255) : HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)));
        }

        @Override
        protected void setFaceColor(Color color) {
            this.faceColor = color;
        }
    }

    public static class PatchProxy
    extends SeriesProxy {
        protected Color edgeColor;
        protected Color faceColor;

        public PatchProxy(Object object) {
            super(object);
        }

        public Color getFaceColor() {
            return this.faceColor;
        }

        public Color getEdgeColor() {
            return this.edgeColor;
        }

        @Override
        public void updateFaceColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("FaceColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, HGMeshColor.NONE_FLAT_INTERP);
            }
            if (object == null || !(object instanceof HGMeshColor) || ((HGMeshColor)object).getStyle() == 0) {
                this.faceColor = SystemColor.text;
            } else if (((HGMeshColor)object).getStyle() != -1) {
                this.faceColor = new Color(16, 16, 255);
                try {
                    Object object2 = Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"getBarAreaColor", this.chartObject}, (int)1);
                    if (object2 != null && object2 instanceof double[]) {
                        double[] dArray = (double[])object2;
                        this.faceColor = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
                    }
                }
                catch (Exception exception) {
                    Log.log((String)exception.toString());
                }
            } else {
                this.faceColor = HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object));
            }
        }

        @Override
        protected void setFaceColor(Color color) {
            this.faceColor = color;
        }

        @Override
        public void updateEdgeColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("EdgeColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, HGMeshColor.NONE_FLAT_INTERP);
            }
            this.edgeColor = object == null || !(object instanceof HGMeshColor) ? Color.black : (((HGMeshColor)object).getStyle() != -1 ? new Color(16, 16, 255) : HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)));
        }

        @Override
        protected void setEdgeColor(Color color) {
            this.edgeColor = color;
        }

        @Override
        public void updateDisplayName() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("DisplayName");
            this.name = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }
    }

    public static class ContourSeriesProxy
    extends SeriesProxy {
        protected Color outerColor;
        protected Color innerColor;

        ContourSeriesProxy(Object object) {
            super(object);
        }

        public void setColorProperty(String string, Color color) {
            switch (string.toLowerCase()) {
                case "innercolor": {
                    this.innerColor = color;
                    break;
                }
                case "outercolor": {
                    this.outerColor = color;
                }
            }
        }

        public Color getOuterColor() {
            return this.outerColor;
        }

        public Color getInnerColor() {
            return this.innerColor;
        }

        @Override
        public void updateDisplayName() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("DisplayName");
            this.name = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateXDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("XDataSource");
            this.xDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateYDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("YDataSource");
            this.yDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateZDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("ZDataSource");
            this.zDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateLineColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("LineColor");
            if (object instanceof MLArrayRef) {
                object = PropertyEditor.isHGUsingMATLABClasses() ? MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, HGMeshColor.NONE_FLAT_INTERP) : MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, HGMeshColor.NONE_AUTO);
            }
            if (object instanceof HGMeshColor && PropertyEditor.isHGUsingMATLABClasses() && (((HGMeshColor)object).getStyle() == 0 || ((HGMeshColor)object).getStyle() == 1)) {
                this.outerColor = Color.blue;
                this.innerColor = Color.red;
            } else if (object instanceof HGMeshColor && !PropertyEditor.isHGUsingMATLABClasses() && ((HGMeshColor)object).getStyle() == 4) {
                this.outerColor = Color.blue;
                this.innerColor = Color.red;
            } else {
                Color color;
                this.outerColor = color = HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object));
                this.innerColor = color;
            }
        }

        @Override
        protected void setLineColor(Color color) {
            if (color == null) {
                this.outerColor = Color.blue;
                this.innerColor = Color.red;
            } else {
                this.outerColor = color;
                this.innerColor = color;
            }
        }
    }

    public static class BarAreaSeriesProxy
    extends SeriesProxy {
        protected Color faceColor;
        protected Color edgeColor;

        BarAreaSeriesProxy(Object object) {
            super(object);
        }

        public void setColorProperty(String string, Color color) {
            switch (string.toLowerCase()) {
                case "facecolor": {
                    this.faceColor = color;
                    break;
                }
                case "edgecolor": {
                    this.edgeColor = color;
                }
            }
        }

        public Color getFaceColor() {
            return this.faceColor;
        }

        public Color getEdgeColor() {
            return this.edgeColor;
        }

        @Override
        public void updateDisplayName() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("DisplayName");
            this.name = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateXDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("XDataSource");
            this.xDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateYDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("YDataSource");
            this.yDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateFaceColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("FaceColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, HGMeshColor.NONE_FLAT_INTERP);
            }
            if (object == null || !(object instanceof HGMeshColor)) {
                this.faceColor = Color.black;
            } else if (((HGMeshColor)object).getStyle() != -1) {
                Color color = new Color(16, 16, 255);
                try {
                    Object object2 = Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"getBarAreaColor", this.chartObject}, (int)1);
                    if (object2 != null && object2 instanceof double[]) {
                        double[] dArray = (double[])object2;
                        color = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.showJavaException("getBarAreaColor", exception);
                }
                this.faceColor = color;
            } else {
                this.faceColor = HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object));
            }
        }

        @Override
        protected void setFaceColor(Color color) {
            this.faceColor = color;
        }

        @Override
        public void updateEdgeColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("EdgeColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, HGMeshColor.NONE_FLAT_INTERP);
            }
            this.edgeColor = object == null || !(object instanceof HGMeshColor) ? Color.black : (((HGMeshColor)object).getStyle() != -1 ? this.faceColor : HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)));
        }

        @Override
        protected void setEdgeColor(Color color) {
            this.edgeColor = color;
        }

        @Override
        protected void setDisplayName(String string) {
            this.name = string;
        }
    }

    public static class LineProxy
    extends OneDimSeriesProxy {
        LineProxy(Object object) {
            super(object);
        }

        @Override
        public void updateTag() {
            Object object;
            this.name = this.chartObject.getClass().getName().startsWith("graph2d_constantline") || this.chartObject.getClass().getName().startsWith("matlab_graphics_chart_primitive_ConstantLine") || this.chartObject.getClass().getName().startsWith("matlab_graphics_chart_primitive_FunctionLine") ? ((object = ((UDDObject)this.chartObject).getPropertyValue("Tag")) instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object) : "";
        }

        @Override
        protected void setTag(String string) {
            this.name = string;
        }
    }

    public static class ErrorbarSeriesProxy
    extends OneDimSeriesProxy {
        ErrorbarSeriesProxy(Object object) {
            super(object);
        }
    }

    public static class QuiverSeriesProxy
    extends OneDimSeriesProxy {
        QuiverSeriesProxy(Object object) {
            super(object);
        }
    }

    public static class ScatterSeriesProxy
    extends OneDimSeriesProxy {
        public ScatterSeriesProxy(Object object) {
            super(object);
        }
    }

    public static class StairSeriesProxy
    extends OneDimSeriesProxy {
        StairSeriesProxy(Object object) {
            super(object);
        }
    }

    public static class StemSeriesProxy
    extends OneDimSeriesProxy {
        StemSeriesProxy(Object object) {
            super(object);
        }
    }

    public static class LineSeriesProxy
    extends OneDimSeriesProxy {
        LineSeriesProxy(Object object) {
            super(object);
        }
    }

    public static abstract class OneDimSeriesProxy
    extends SeriesProxy {
        private static final String HGSTYLED_COLOR_AUTO = "auto";
        private static final String HGSTYLED_COLOR_FLAT = "flat";
        protected Color lineColor;
        protected Object lineStyle = 4;
        protected double lineWidth;
        protected Object marker = 13;
        protected Color markerFaceColor;
        protected Color markerEdgeColor;

        OneDimSeriesProxy(Object object) {
            super(object);
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public Object getLineStyle() {
            return this.lineStyle;
        }

        public double getLineWidth() {
            return this.lineWidth;
        }

        public Object getMarker() {
            return this.marker;
        }

        public Color getMarkerFaceColor() {
            return this.markerFaceColor;
        }

        public Color getMarkerEdgeColor() {
            return this.markerEdgeColor;
        }

        @Override
        public void updateDisplayName() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("DisplayName");
            this.name = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        protected void setDisplayName(String string) {
            this.name = string;
        }

        @Override
        public void updateXDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("XDataSource");
            this.xDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateYDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("YDataSource");
            this.yDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateZDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("ZDataSource");
            this.zDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("Color");
            this.lineColor = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseColor((MLArrayRef)object) : this.setupColorValue(object);
            this.updateMarkerEdgeColor();
        }

        @Override
        protected void setColor(Color color) {
            this.lineColor = color;
        }

        @Override
        public void updateLineWidth() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("LineWidth");
            if (object instanceof MLArrayRef) {
                this.lineWidth = MLPropertyTypeConverter.parseDouble((MLArrayRef)object);
            } else if (object instanceof HGDouble) {
                this.lineWidth = ((HGDouble)object).getValue();
            } else if (object instanceof Double) {
                this.lineWidth = (Double)object;
            }
        }

        @Override
        protected void setLineWidth(double d) {
            this.lineWidth = d;
        }

        @Override
        public void updateLineStyle() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("LineStyle");
            if (object instanceof MLArrayRef) {
                this.lineStyle = MLPropertyTypeConverter.parseLineStyle((MLArrayRef)object);
            } else if (object instanceof CategoricalVariable) {
                this.lineStyle = ((CategoricalVariable)object).getValue();
            } else if (object instanceof Integer) {
                this.lineStyle = object;
            }
        }

        @Override
        protected void setLineStyle(String string) {
            this.lineStyle = string;
        }

        @Override
        public void updateMarker() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("Marker");
            if (object instanceof MLArrayRef) {
                this.marker = MLPropertyTypeConverter.parseMarker((MLArrayRef)object);
            } else if (object instanceof CategoricalVariable) {
                this.marker = ((CategoricalVariable)object).getValue();
            } else if (object instanceof Integer) {
                this.marker = object;
            }
        }

        @Override
        protected void setMarker(String string) {
            this.marker = string;
        }

        @Override
        public void updateMarkerFaceColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("MarkerFaceColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, HGMeshColor.NONE_AUTO);
            }
            this.markerFaceColor = object != null && object instanceof HGMeshColor && ((HGMeshColor)object).getStyle() == 4 ? null : this.setupColorValue(object);
        }

        @Override
        protected void setMarkerFaceColor(Color color) {
            this.markerFaceColor = color;
        }

        @Override
        public void updateMarkerEdgeColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("MarkerEdgeColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, HGMeshColor.NONE_AUTO);
            }
            if (object instanceof MLArrayRef) {
                this.markerFaceColor = MLPropertyTypeConverter.parseAutoManColor((MLArrayRef)object);
                return;
            }
            this.markerEdgeColor = object != null && object instanceof HGMeshColor && ((HGMeshColor)object).getStyle() == 4 ? this.lineColor : this.setupColorValue(object);
        }

        @Override
        protected void setMarkerEdgeColor(Color color) {
            this.markerEdgeColor = color;
        }

        public Color setupColorValue(Object object) {
            Color color = null;
            if (object == null) {
                return null;
            }
            if (object instanceof HGStyledColor) {
                StyledColor styledColor = ((HGStyledColor)object).colorValue();
                color = styledColor.isColor() ? styledColor : (styledColor.getStyleName().equalsIgnoreCase(HGSTYLED_COLOR_AUTO) ? this.lineColor : (styledColor.getStyleName().equalsIgnoreCase(HGSTYLED_COLOR_FLAT) ? this.getCDataColor(new Color(16, 16, 255)) : new Color(255, 255, 255, 0)));
            } else if (object instanceof HGColor) {
                color = HGColor.getColor((HGColor)((HGColor)object));
            } else if (object instanceof HGMeshColor) {
                if (((HGMeshColor)object).getStyle() == 0) {
                    return null;
                }
                color = ((HGMeshColor)object).getStyle() == -1 ? HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)) : (((HGMeshColor)object).getStyle() == 1 ? this.getCDataColor(new Color(16, 16, 255)) : new Color(16, 16, 255));
            }
            return color;
        }

        public Color getCDataColor(Color color) {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("CData");
            if (object instanceof MLArrayRef && ((MLArrayRef)object).isDouble() && Arrays.equals(new int[]{1, 3}, ((MLArrayRef)object).getDimensions())) {
                double[] dArray = (double[])((MLArrayRef)object).getData();
                return new Color((int)(dArray[0] * 255.0), (int)(dArray[1] * 255.0), (int)(dArray[2] * 255.0));
            }
            return color;
        }
    }

    public static abstract class SeriesProxy
    extends ChartObjectProxy {
        SeriesProxy(Object object) {
            super(object);
        }
    }

    public static abstract class ChartObjectProxy
    extends PlotBrowser.BrowserItem {
        public Object chartObject;
        public String name;
        public String xDataSource;
        public String yDataSource;
        public String zDataSource;
        public Boolean isVisible = Boolean.TRUE;
        protected boolean isHandleVisible = true;
        public ChartObjectProxy parent;

        public ChartObjectProxy(Object object) {
            this.chartObject = object;
        }

        public Object getChartObject() {
            return this.chartObject;
        }

        public String getName() {
            return this.name;
        }

        public Boolean getVisible() {
            return this.isVisible;
        }

        public Boolean getHandleVisibility() {
            return this.isHandleVisible;
        }

        public String getXDataSource() {
            return this.xDataSource;
        }

        public String getYDataSource() {
            return this.yDataSource;
        }

        public String getZDataSource() {
            return this.zDataSource;
        }

        public void updateHandleVisibility() {
            Boolean bl;
            Object object = ((UDDObject)this.chartObject).getPropertyValue("HandleVisibility");
            Integer n = -1;
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            } else {
                if (object instanceof MLArrayRef) {
                    this.isHandleVisible = MLPropertyTypeConverter.parseOnOff((MLArrayRef)object);
                    return;
                }
                if (object instanceof CategoricalVariable) {
                    n = (Integer)((CategoricalVariable)object).getValue();
                } else if (object instanceof Integer) {
                    n = (Integer)object;
                }
                Boolean bl2 = bl = n.equals(2) ? Boolean.FALSE : Boolean.TRUE;
            }
            if (Boolean.valueOf(this.isHandleVisible).equals(bl)) {
                return;
            }
            this.isHandleVisible = bl;
        }

        protected void setHandleVisibility(boolean bl) {
            this.isHandleVisible = bl;
        }

        public void updateVisible() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("Visible");
            Integer n = -1;
            if (object instanceof Boolean) {
                this.isVisible = (Boolean)object;
                return;
            }
            if (object instanceof MLArrayRef) {
                this.isVisible = MLPropertyTypeConverter.parseOnOff((MLArrayRef)object);
                return;
            }
            if (object instanceof CategoricalVariable) {
                n = (Integer)((CategoricalVariable)object).getValue();
            } else if (object instanceof Integer) {
                n = (Integer)object;
            }
            this.isVisible = n.equals(1) ? Boolean.TRUE : Boolean.FALSE;
        }

        protected void setVisible(boolean bl) {
            this.isVisible = bl;
        }

        protected void setXDataSource(String string) {
            this.xDataSource = string;
        }

        protected void setYDataSource(String string) {
            this.yDataSource = string;
        }

        protected void setZDataSource(String string) {
            this.zDataSource = string;
        }

        protected void setName(String string) {
            this.name = string;
        }

        public void updateDisplayName() {
        }

        public void updateXDataSource() {
        }

        public void updateYDataSource() {
        }

        public void updateZDataSource() {
        }

        public void updateName() {
        }

        public void updateTitle() {
        }

        public void updateTag() {
        }

        public void updateColor() {
        }

        public void updateFaceColor() {
        }

        public void updateEdgeColor() {
        }

        public void updateLineColor() {
        }

        public void updateLineWidth() {
        }

        public void updateLineStyle() {
        }

        public void updateMarker() {
        }

        public void updateMarkerFaceColor() {
        }

        public void updateMarkerEdgeColor() {
        }

        protected void setDisplayName(String string) {
        }

        public void setTitle(String string) {
        }

        protected void setTag(String string) {
        }

        protected void setColor(Color color) {
        }

        protected void setFaceColor(Color color) {
        }

        protected void setEdgeColor(Color color) {
        }

        protected void setLineColor(Color color) {
        }

        protected void setLineWidth(double d) {
        }

        protected void setLineStyle(String string) {
        }

        protected void setMarker(String string) {
        }

        protected void setMarkerEdgeColor(Color color) {
        }

        protected void setMarkerFaceColor(Color color) {
        }

        public String toString() {
            return this.name;
        }
    }
}

