/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool;

import com.mathworks.hg.types.HGCallback;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJProgressBar;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.page.plottool.propertyeditor.BeanManager;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyDescriptor;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class WaitBar
extends MJFrame {
    private static volatile WaitBar sInstance = null;
    public static volatile boolean sExists = false;
    public Object fFigure;
    private MJLabel fMessageLabel;
    private MJProgressBar fProgressBar;
    private Timer fTimer;
    private String[] fMessages;
    private int[] fValues;
    private int fCurrentMessagePosition;

    private WaitBar(int n, int n2, Object object) {
        super(PropertyEditorResources.getBundle().getString("waitbar.title"));
        this.setAlwaysOnTop(true);
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.fMessageLabel = new MJLabel(PropertyEditorResources.getBundle().getString("waitbar.title"));
        this.fMessageLabel.setHorizontalAlignment(0);
        mJPanel.add((Component)this.fMessageLabel, (Object)"North");
        this.fMessageLabel.setFont(this.fMessageLabel.getFont().deriveFont(13.0f));
        this.fProgressBar = new MJProgressBar();
        this.fProgressBar.setValue(0);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        mJPanel2.add((Component)this.fProgressBar, (Object)"North");
        mJPanel.add((Component)mJPanel2, (Object)"Center");
        this.fProgressBar.setPreferredSize(new Dimension((int)((double)this.fProgressBar.getPreferredSize().width * 2.2), (int)((double)this.fProgressBar.getPreferredSize().height * 1.1)));
        this.fProgressBar.setForeground(Color.red);
        this.add((Component)mJPanel, "Center");
        this.pack();
        this.setLocation(n, n2);
        this.fMessages = new String[]{PropertyEditorResources.getBundle().getString("waitbar.msg1"), PropertyEditorResources.getBundle().getString("waitbar.msg2"), PropertyEditorResources.getBundle().getString("waitbar.msg3"), PropertyEditorResources.getBundle().getString("waitbar.msg4"), PropertyEditorResources.getBundle().getString("waitbar.msg5")};
        this.fValues = new int[]{21, 45, 67, 90, 95};
        this.fTimer = new Timer(800, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WaitBar.this.fCurrentMessagePosition < WaitBar.this.fValues.length) {
                    WaitBar.this.postStatus(WaitBar.this.fValues[WaitBar.this.fCurrentMessagePosition], WaitBar.this.fMessages[WaitBar.this.fCurrentMessagePosition]);
                    WaitBar.this.fCurrentMessagePosition++;
                } else {
                    WaitBar.this.stop();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WaitBar.this.clear();
            }
        });
        this.fFigure = object;
    }

    public static boolean hasOpened() {
        return sExists;
    }

    public void stop() {
        this.fTimer.stop();
    }

    public void start() {
        this.fCurrentMessagePosition = 0;
        this.setVisible(true);
        this.fTimer.start();
    }

    private void postStatus(int n, String string) {
        this.fProgressBar.setValue(n);
        this.fMessageLabel.setText(string);
    }

    public static void open(double[] dArray, final Object object) {
        if (sExists) {
            return;
        }
        sExists = true;
        PropertyDescriptor propertyDescriptor = BeanManager.getProperty(object, "CloseRequestFcn");
        Object object2 = BeanManager.getPropertyValue(object, propertyDescriptor);
        if (object2 != null && object2 instanceof HGCallback) {
            try {
                Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"preventFigureClose", "set", object}, (int)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Rectangle rectangle = WindowUtils.getScreenBounds();
        final int n = (int)(dArray[0] + dArray[2] / 2.0);
        final int n2 = (int)((double)rectangle.height - (dArray[1] + dArray[3] / 2.0));
        if (SwingUtilities.isEventDispatchThread()) {
            WaitBar.utOpen(n, n2, object);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitBar.utOpen(n, n2, object);
                }
            });
        }
    }

    private void clear() {
        if (Matlab.isMatlabAvailable()) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (WaitBar.this.fFigure != null) {
                        Object object;
                        PropertyDescriptor propertyDescriptor = BeanManager.getProperty(WaitBar.this.fFigure, "CloseRequestFcn");
                        if (propertyDescriptor != null && (object = BeanManager.getPropertyValue(WaitBar.this.fFigure, propertyDescriptor)) != null && object instanceof HGCallback && ((HGCallback)object).getCallback().equals("")) {
                            try {
                                Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"preventFigureClose", "restore", WaitBar.this.fFigure}, (int)0);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        WaitBar.this.fFigure = null;
                    }
                }
            });
        }
    }

    static void utOpen(int n, int n2, Object object) {
        sInstance = new WaitBar(n, n2, object);
        sInstance.start();
    }

    public static void close() {
        if (sInstance == null) {
            return;
        }
        sInstance.clear();
        if (SwingUtilities.isEventDispatchThread()) {
            sInstance.dispose();
            sInstance = null;
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (sInstance == null) {
                        return;
                    }
                    sInstance.dispose();
                    sInstance = null;
                }
            });
        }
    }

    public static void setHasOpened(boolean bl) {
        sExists = bl;
    }
}

