/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.export.pagesetup;

import com.mathworks.hg.peer.UnitPos;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.page.export.pagesetup.PSOrientImagePanel;
import com.mathworks.page.export.pagesetup.PageSetupDialog;
import com.mathworks.page.export.print.PagePrintSettings;
import com.mathworks.page.utils.VertFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PSTabPaper
extends MJPanel
implements ChangeListener,
ActionListener,
PropertyChangeListener {
    private PagePrintSettings fPrintSettings;
    private MJComboBox fComboPaperType;
    private MJSpinner fTextPaperWidth;
    private MJSpinner fTextPaperHeight;
    private MJComboBox fComboUnits;
    private MJRadioButton fRadBtnPortrait;
    private MJRadioButton fRadBtnLandscape;
    private MJRadioButton fRadBtnRotated;
    private PSOrientImagePanel fPnlOrientImage;

    public PSTabPaper(PagePrintSettings pagePrintSettings) {
        this.fPrintSettings = pagePrintSettings;
        this.fPrintSettings.addPropertyChangeListener(this);
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        MJPanel mJPanel = new MJPanel();
        this.add((Component)mJPanel, "Center");
        mJPanel.setLayout((LayoutManager)new GridBagLayout());
        MJLabel mJLabel = new MJLabel(PageSetupDialog.sResHandle.getString("label.papersize"));
        this.fComboPaperType = new MJComboBox();
        this.fComboPaperType.addActionListener((ActionListener)this);
        mJPanel.add((Component)mJLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 6, 3, 3), 0, 0));
        mJPanel.add((Component)this.fComboPaperType, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(18, 3, 3, 6), 0, 0));
        MJLabel mJLabel2 = new MJLabel(PageSetupDialog.sResHandle.getString("spin.width"));
        MJLabel mJLabel3 = new MJLabel(PageSetupDialog.sResHandle.getString("spin.height"));
        MJLabel mJLabel4 = new MJLabel(PageSetupDialog.sResHandle.getString("label.units"));
        this.fTextPaperWidth = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 0.5));
        this.fTextPaperHeight = new MJSpinner((SpinnerModel)new SpinnerNumberModel(0.0, -2.147483648E9, 2.147483647E9, 0.5));
        this.fTextPaperWidth.setEditor((JComponent)new JSpinner.NumberEditor((JSpinner)this.fTextPaperWidth, "###0.00"));
        this.fTextPaperHeight.setEditor((JComponent)new JSpinner.NumberEditor((JSpinner)this.fTextPaperHeight, "###0.00"));
        this.fComboUnits = new MJComboBox();
        for (int i = 0; i < UnitPos.UNITS.length - 3; ++i) {
            this.fComboUnits.addItem((Object)UnitPos.UNITS[i]);
        }
        this.fComboUnits.setSelectedItem((Object)UnitPos.unitsToString((int)0));
        this.fTextPaperWidth.addChangeListener((ChangeListener)this);
        this.fTextPaperHeight.addChangeListener((ChangeListener)this);
        this.fComboUnits.addActionListener((ActionListener)this);
        Dimension dimension = this.fTextPaperWidth.getPreferredSize();
        dimension.width = 60;
        this.fTextPaperWidth.setPreferredSize(dimension);
        this.fTextPaperHeight.setPreferredSize(dimension);
        this.fComboUnits.setPreferredSize(dimension);
        mJPanel.add((Component)mJLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 6, 3, 3), 0, 0));
        mJPanel.add((Component)mJLabel3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 6, 3, 3), 0, 0));
        mJPanel.add((Component)mJLabel4, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 6, 6, 3), 0, 0));
        mJPanel.add((Component)this.fTextPaperWidth, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 12, 2, new Insets(3, 3, 3, 6), 0, 0));
        mJPanel.add((Component)this.fTextPaperHeight, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 12, 2, new Insets(3, 3, 3, 6), 0, 0));
        mJPanel.add((Component)this.fComboUnits, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 12, 2, new Insets(3, 3, 6, 6), 0, 0));
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBorder((Border)new TitledBorder(PageSetupDialog.sResHandle.getString("groupbox.orientation")));
        mJPanel.add((Component)mJPanel2, (Object)new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 18, 1, new Insets(6, 6, 6, 6), 0, 0));
        mJPanel2.setLayout((LayoutManager)new BorderLayout());
        MJPanel mJPanel3 = new MJPanel();
        mJPanel2.add((Component)mJPanel3, (Object)"West");
        mJPanel3.setLayout((LayoutManager)new VertFlowLayout(3));
        this.fRadBtnPortrait = new MJRadioButton(PageSetupDialog.sResHandle.getString("checkbox.por"));
        this.fRadBtnLandscape = new MJRadioButton(PageSetupDialog.sResHandle.getString("checkbox.lan"));
        this.fRadBtnRotated = new MJRadioButton(PageSetupDialog.sResHandle.getString("checkbox.rot"));
        this.fRadBtnPortrait.addActionListener((ActionListener)this);
        this.fRadBtnLandscape.addActionListener((ActionListener)this);
        this.fRadBtnRotated.addActionListener((ActionListener)this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fRadBtnPortrait);
        buttonGroup.add((AbstractButton)this.fRadBtnLandscape);
        buttonGroup.add((AbstractButton)this.fRadBtnRotated);
        mJPanel3.add((Component)this.fRadBtnPortrait);
        mJPanel3.add((Component)this.fRadBtnLandscape);
        mJPanel3.add((Component)this.fRadBtnRotated);
        this.fPnlOrientImage = new PSOrientImagePanel(this.fPrintSettings);
        mJPanel2.add((Component)((Object)this.fPnlOrientImage), (Object)"Center");
        MJPanel mJPanel4 = new MJPanel();
        mJPanel.add((Component)mJPanel4, (Object)new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fComboPaperType.setName("Combo_PaperType");
        this.fTextPaperWidth.setName("Spinner_PaperWidth");
        this.fTextPaperHeight.setName("Spinner_PaperHeight");
        this.fComboUnits.setName("Combo_PaperUnits");
        this.fRadBtnPortrait.setName("RadBtn_OrientPortrait");
        this.fRadBtnLandscape.setName("RadBtn_OrientLandscape");
        this.fRadBtnRotated.setName("RadBtn_OrientRotated");
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object.equals(this.fTextPaperWidth)) {
            this.onPaperSizeChanged();
        } else if (object.equals(this.fTextPaperHeight)) {
            this.onPaperSizeChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.fComboPaperType)) {
            this.onPaperTypeChanged();
        } else if (object.equals(this.fComboUnits)) {
            this.onUnitsChanged();
        } else if (object.equals(this.fRadBtnPortrait)) {
            this.onPaperOrientationChanged();
        } else if (object.equals(this.fRadBtnLandscape)) {
            this.onPaperOrientationChanged();
        } else if (object.equals(this.fRadBtnRotated)) {
            this.onPaperOrientationChanged();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getSource() != this.fPrintSettings) {
            return;
        }
        if (string.equals("PaperType")) {
            this.setPaperType((String)object);
        } else if (string.equals("PaperSize")) {
            this.setPaperSize((double[])object);
        } else if (string.equals("PaperUnits")) {
            this.setUnits((String)object);
        } else if (string.equals("PaperOrientation")) {
            this.setPaperOrientation((String)object);
        } else if (string.equals("PaperNames")) {
            String[] stringArray = (String[])object;
            this.fComboPaperType.removeActionListener((ActionListener)this);
            for (int i = 0; i < stringArray.length; ++i) {
                this.fComboPaperType.addItem((Object)stringArray[i]);
            }
            this.fComboPaperType.addActionListener((ActionListener)this);
        }
    }

    private void onPaperTypeChanged() {
        String string = (String)this.fComboPaperType.getSelectedItem();
        this.fPrintSettings.setPaperType(this, string);
        this.fComboPaperType.removeItem((Object)"<custom>");
    }

    private void onPaperSizeChanged() {
        double[] dArray = new double[]{((Number)this.fTextPaperWidth.getValue()).doubleValue(), ((Number)this.fTextPaperHeight.getValue()).doubleValue()};
        this.fPrintSettings.setPaperSize(this, dArray);
    }

    private void onPaperOrientationChanged() {
        String string = "portrait";
        if (this.fRadBtnLandscape.isSelected()) {
            string = "landscape";
        } else if (this.fRadBtnRotated.isSelected()) {
            string = "rotated";
        }
        this.setPaperOrientation(string);
        this.fPrintSettings.setPaperOrientation(this, string);
    }

    private void onUnitsChanged() {
        String string = (String)this.fComboUnits.getSelectedItem();
        this.fPrintSettings.setUnits(this, string);
    }

    private void setPaperType(String string) {
        this.fComboPaperType.removeActionListener((ActionListener)this);
        if (string.equals("<custom>")) {
            int n = this.fComboPaperType.getItemCount();
            if (!this.fComboPaperType.getItemAt(n - 1).equals("<custom>")) {
                this.fComboPaperType.addItem((Object)"<custom>");
            }
        } else {
            this.fComboPaperType.removeItem((Object)"<custom>");
        }
        this.fComboPaperType.setSelectedItem((Object)string);
        this.fComboPaperType.addActionListener((ActionListener)this);
    }

    private void setPaperSize(double[] dArray) {
        this.fTextPaperWidth.removeChangeListener((ChangeListener)this);
        this.fTextPaperHeight.removeChangeListener((ChangeListener)this);
        this.fTextPaperWidth.setValue((Object)new Double(dArray[0]));
        this.fTextPaperHeight.setValue((Object)new Double(dArray[1]));
        this.fTextPaperWidth.addChangeListener((ChangeListener)this);
        this.fTextPaperHeight.addChangeListener((ChangeListener)this);
    }

    private void setUnits(String string) {
        this.fComboUnits.removeActionListener((ActionListener)this);
        this.fComboUnits.setSelectedItem((Object)string);
        this.fComboUnits.addActionListener((ActionListener)this);
    }

    private void setPaperOrientation(String string) {
        if (string.equals("landscape")) {
            this.fRadBtnLandscape.setSelected(true);
        } else if (string.equals("rotated")) {
            this.fRadBtnRotated.setSelected(true);
        } else {
            this.fRadBtnPortrait.setSelected(true);
        }
        this.fPnlOrientImage.repaint();
        this.fPnlOrientImage.invalidate();
    }
}

