/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.basicfit;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.page.utils.VertFlowLayout;
import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.DTWindowHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DataStatistics
extends MJFrame
implements ActionListener {
    static Vector<Double> sFigHandles;
    static Vector<DataStatistics> sDataStats;
    private Matlab fMatlab;
    private CustomModel fStatsTableModel;
    private CustomStringRenderer fCustomStringRender;
    private MJComboBox fDataChoice;
    private MJButton fSaveToWorkspace;
    private MJButton fHelpBut;
    private MJButton fCloseBut;
    private JTableX fStatsTable;
    private static final int NUM_ROWS = 7;
    private static final int COL_XSTATS = 1;
    private static final int COL_XCHECKS = 2;
    private static final int COL_YSTATS = 3;
    private static final int COL_YCHECKS = 4;
    private static final int RANGE_ROW = 6;
    private static final int ROW_LABEL_BUFFER = 10;
    private static final int DEFAULT_MAX_LABEL_COL_WIDTH = 55;
    private static final int CHECK_COL_WIDTH = 10;
    private static ResourceBundle fRes;
    private Object[] fHandleList;
    private double[] fCurrentData;
    private double[] fCurrentFigure;
    private String[] plotoptions = new String[]{"min", "max", "mean", "median", "mode", "std", "range"};
    private String[] plotoptionsRowNames = new String[]{this.getRes("label.min"), this.getRes("label.max"), this.getRes("label.mean"), this.getRes("label.median"), this.getRes("label.mode"), this.getRes("label.std"), this.getRes("label.range")};
    private Color fHeaderColor;
    private DataChoiceListener fDataChoiceListener = new DataChoiceListener();
    private TableListener fTableListener = new TableListener();
    private String[] columnNames = new String[]{" ", "X", "XCheck", "Y", "YCheck"};
    private TableColumn XCheckCol;
    private TableColumn YCheckCol;
    private TableColumn firstCol;
    private TableColumn XCol;
    private TableColumn YCol;
    private int maxWidth;
    private Dimension fMinSize = null;
    private Rectangle fOldBounds = null;
    private ResizeListener fResizeListener;
    private DataStatistics dataStats;
    private DataChangedCallback fDataChangedCallback = new DataChangedCallback();
    private CloseDataStatsCallback fCloseDataStatsCallback = new CloseDataStatsCallback();

    public static DataStatistics showDataStats(double d) {
        DataStatistics dataStatistics = null;
        if (d == 0.0) {
            return null;
        }
        Double d2 = d;
        int n = sFigHandles.indexOf(d2);
        if (n == -1) {
            double d3 = d;
            sFigHandles.addElement(d2);
            dataStatistics = new DataStatistics(d3);
            sDataStats.addElement(dataStatistics);
        } else {
            final DataStatistics dataStatistics2 = dataStatistics = sDataStats.elementAt(n);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    dataStatistics2.toFront();
                }
            };
            try {
                AWTUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Throwable throwable) {
                Log.logThrowable((Throwable)throwable);
            }
        }
        return dataStatistics;
    }

    DataStatistics(final double d) {
        this.dataStats = this;
        this.fCurrentFigure = new double[1];
        this.fCurrentFigure[0] = d;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataStatistics.this.setTitle(DataStatistics.this.getRes("frame.title") + " - " + (int)d);
                DataStatistics.this.layoutDataStats();
                DataStatistics.this.setNames();
                DataStatistics.this.fMatlab = new Matlab();
                DataStatistics.this.fStatsTable.setPreferredScrollableViewportSize(new Dimension(300, DataStatistics.this.fStatsTable.getRowHeight() * 7));
                DataStatistics.this.pack();
                Dimension dimension = DataStatistics.this.getSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                int n = Prefs.getIntegerPref((String)"DataStatistics.XLocation", (int)20);
                int n2 = Prefs.getIntegerPref((String)"DataStatistics.YLocation", (int)40);
                if (n < 0) {
                    n = 10;
                } else if (n + dimension.width > dimension2.width && (n = dimension2.width - dimension.width - 8) < 0) {
                    n = 10;
                }
                if (n2 < 0) {
                    n2 = 10;
                } else if (n2 + dimension.height > dimension2.height && (n2 = dimension2.height - dimension.height - 30) < 0) {
                    n2 = 10;
                }
                DataStatistics.this.setLocation(n, n2);
                DataStatistics.this.setMinimumSize(DataStatistics.this.getSize(), DataStatistics.this.getBounds());
                DataStatistics.this.show();
                new DTWindowHandler((Window)((Object)DataStatistics.this.dataStats)){

                    public void close() {
                        DataStatistics.this.closeDataStats();
                    }
                };
            }
        });
        try {
            Object object = Matlab.mtFeval((String)"basicfitdatastat", (Object[])new Object[]{"bfitopen", this.fCurrentFigure, "ds"}, (int)8);
            SwingUtilities.invokeLater(new RunnableInit(object));
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void setNames() {
        AccessibleContext accessibleContext = this.fDataChoice.getAccessibleContext();
        this.fDataChoice.setName("DataSelectorChoice");
        accessibleContext.setAccessibleName(this.getRes("accessName.DataSelectorChoice"));
        accessibleContext.setAccessibleDescription(this.getRes("accessDesc.DataSelectorChoice"));
        this.fSaveToWorkspace.setName("Save");
        this.fHelpBut.setName("Help");
        this.fCloseBut.setName("Close");
        this.fStatsTable.setName("Table");
        accessibleContext = this.fStatsTable.getAccessibleContext();
        accessibleContext.setAccessibleName(this.getRes("accessName.Table"));
        accessibleContext.setAccessibleDescription(this.getRes("accessDesc.Table"));
        this.setName("Data Statistics");
        accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(this.getRes("accessName.Panel"));
        accessibleContext.setAccessibleDescription(this.getRes("accessDesc.Panel"));
    }

    private void layoutDataStats() {
        Object[] objectArray;
        Container container = this.getContentPane();
        AccessibleContext accessibleContext = container.getAccessibleContext();
        accessibleContext.setAccessibleName(this.getRes("accessName.Panel"));
        accessibleContext.setAccessibleDescription(this.getRes("accessDesc.Panel"));
        container.setLayout(new BorderLayout());
        VertFlowLayout vertFlowLayout = new VertFlowLayout();
        vertFlowLayout.setVgap(0);
        MJPanel mJPanel = new MJPanel((LayoutManager)vertFlowLayout);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FlowLayout(0));
        MJLabel mJLabel = new MJLabel(this.getRes("label.StatisticsFor"));
        mJPanel2.add((Component)mJLabel);
        this.fDataChoice = new MJComboBox();
        mJLabel.setLabelFor((Component)this.fDataChoice);
        mJPanel2.add((Component)this.fDataChoice);
        mJPanel.add((Component)mJPanel2);
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new FlowLayout(0));
        MJLabel mJLabel2 = new MJLabel(this.getRes("label.CheckPlots"));
        mJPanel3.add((Component)mJLabel2);
        mJPanel.add((Component)mJPanel3);
        accessibleContext = mJPanel.getAccessibleContext();
        accessibleContext.setAccessibleName(this.getRes("accessName.Panel"));
        accessibleContext.setAccessibleDescription(this.getRes("accessDesc.Panel"));
        container.add((Component)mJPanel, "North");
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel4.setBorder((Border)new EmptyBorder(0, 10, 10, 10));
        this.fStatsTableModel = new CustomModel();
        this.fCustomStringRender = new CustomStringRenderer();
        this.fStatsTable = new JTableX(this.fStatsTableModel);
        mJLabel2.setLabelFor((Component)((Object)this.fStatsTable));
        this.fStatsTableModel.setColumnIdentifiers(this.columnNames);
        this.fStatsTable.getTableHeader().setReorderingAllowed(false);
        accessibleContext = this.fStatsTable.getTableHeader().getAccessibleContext();
        accessibleContext.setAccessibleName(this.getRes("accessName.TableHeader"));
        accessibleContext.setAccessibleDescription(this.getRes("accessDesc.TableHeader"));
        this.fHeaderColor = this.fStatsTable.getTableHeader().getBackground();
        this.XCheckCol = this.fStatsTable.getColumn("XCheck");
        this.YCheckCol = this.fStatsTable.getColumn("YCheck");
        this.firstCol = this.fStatsTable.getColumn(" ");
        this.XCol = this.fStatsTable.getColumn("X");
        this.YCol = this.fStatsTable.getColumn("Y");
        this.XCheckCol.setHeaderValue("");
        this.YCheckCol.setHeaderValue("");
        this.XCheckCol.setMaxWidth(10);
        this.YCheckCol.setMaxWidth(10);
        this.maxWidth = 55;
        Font font = this.fStatsTable.getFont();
        if (font != null) {
            objectArray = this.getFontMetrics(font);
            this.maxWidth = 0;
            for (String string : this.plotoptionsRowNames) {
                this.maxWidth = Math.max(this.maxWidth, objectArray.stringWidth(string));
            }
            this.maxWidth += 10;
        }
        this.firstCol.setMaxWidth(this.maxWidth);
        this.firstCol.setMinWidth(this.maxWidth);
        this.fStatsTable.sizeColumnsToFit(0);
        this.fStatsTable.setSelectionBackground(this.fStatsTable.getBackground());
        this.fStatsTable.setRowSelectionAllowed(true);
        this.fStatsTable.setColumnSelectionAllowed(true);
        objectArray = new Object[5];
        objectArray[1] = "";
        objectArray[2] = false;
        objectArray[3] = "";
        objectArray[4] = false;
        for (int i = 0; i < this.plotoptionsRowNames.length - 1; ++i) {
            objectArray[0] = " " + this.plotoptionsRowNames[i];
            this.fStatsTableModel.addRow(objectArray);
        }
        objectArray[0] = " " + this.plotoptionsRowNames[6];
        objectArray[2] = "";
        objectArray[3] = "";
        objectArray[4] = "";
        this.fStatsTableModel.addRow(objectArray);
        mJPanel4.add((Component)new MJScrollPane((Component)((Object)this.fStatsTable)), (Object)"Center");
        accessibleContext = mJPanel4.getAccessibleContext();
        accessibleContext.setAccessibleName(this.getRes("accessName.Panel"));
        accessibleContext.setAccessibleDescription(this.getRes("accessDesc.Panel"));
        container.add((Component)mJPanel4, "Center");
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new FlowLayout(1));
        this.fSaveToWorkspace = new MJButton(this.getRes("button.saveToWorkspace"));
        this.fSaveToWorkspace.addActionListener((ActionListener)this);
        this.fHelpBut = new MJButton(this.getRes("button.help"));
        this.fHelpBut.addActionListener((ActionListener)this);
        this.fCloseBut = new MJButton(this.getRes("button.close"));
        this.fCloseBut.addActionListener((ActionListener)this);
        mJPanel5.add((Component)this.fSaveToWorkspace);
        mJPanel5.add((Component)this.fHelpBut);
        mJPanel5.add((Component)this.fCloseBut);
        accessibleContext = mJPanel5.getAccessibleContext();
        accessibleContext.setAccessibleName(this.getRes("accessName.Panel"));
        accessibleContext.setAccessibleDescription(this.getRes("accessDesc.Panel"));
        container.add((Component)mJPanel5, "South");
        this.fSaveToWorkspace.setToolTipText(this.getRes("tooltip.save2work"));
        this.fHelpBut.setToolTipText(this.getRes("tooltip.help"));
        this.fCloseBut.setToolTipText(this.getRes("tooltip.closeDS"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fSaveToWorkspace) {
            Object[] objectArray = new Object[]{"bfitsavedatastats", this.fCurrentData[0]};
            this.fMatlab.fevalConsoleOutput("basicfitdatastat", objectArray, 0, (CompletionObserver)null);
        } else if (actionEvent.getSource() == this.fCloseBut) {
            this.closeDataStats();
        } else if (actionEvent.getSource() == this.fHelpBut) {
            this.fMatlab.fevalConsoleOutput("basicfitdatastat", new Object[]{"bfithelp", "ds"}, 0, (CompletionObserver)null);
        }
    }

    public void dataModified(String[] stringArray, String[] stringArray2, String string, String string2) {
        SwingUtilities.invokeLater(new RunnableDataModified(stringArray, stringArray2, string, string2));
    }

    public void enableDataStatsFromM() {
        SwingUtilities.invokeLater(new RunnableEnableDataStats());
    }

    public void enableDataStats(boolean bl) {
        this.fStatsTable.setEnabled(bl);
        this.fSaveToWorkspace.setEnabled(bl);
    }

    private void updateStats(String[] stringArray, String[] stringArray2) {
        this.fStatsTable.getModel().removeTableModelListener(this.fTableListener);
        for (int i = 0; i < stringArray.length; ++i) {
            this.fStatsTable.setValueAt(stringArray[i] + " ", i, 1);
            this.fStatsTable.setValueAt(stringArray2[i] + " ", i, 3);
        }
        this.fStatsTable.getModel().addTableModelListener(this.fTableListener);
    }

    public void updateColumnNames(String string, String string2) {
        this.fStatsTable.getModel().removeTableModelListener(this.fTableListener);
        this.XCol.setHeaderValue(string);
        this.YCol.setHeaderValue(string2);
        this.firstCol.setMaxWidth(this.maxWidth);
        this.firstCol.setMinWidth(this.maxWidth);
        this.XCheckCol.setMaxWidth(10);
        this.YCheckCol.setMaxWidth(10);
        this.fStatsTable.sizeColumnsToFit(0);
        this.dataStats.repaint();
        this.fStatsTable.getModel().addTableModelListener(this.fTableListener);
    }

    private void updateChecks(boolean[] blArray, boolean[] blArray2) {
        this.fStatsTable.getModel().removeTableModelListener(this.fTableListener);
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) {
                this.fStatsTable.setValueAt(true, i, 2);
            } else {
                this.fStatsTable.setValueAt(false, i, 2);
            }
            if (blArray2[i]) {
                this.fStatsTable.setValueAt(true, i, 4);
                continue;
            }
            this.fStatsTable.setValueAt(false, i, 4);
        }
        this.fStatsTable.getModel().addTableModelListener(this.fTableListener);
    }

    private void clearDataStats() {
        this.fStatsTable.getModel().removeTableModelListener(this.fTableListener);
        this.fDataChoice.removeAllItems();
        for (int i = 0; i < 6; ++i) {
            this.fStatsTable.setValueAt(" ", i, 1);
            this.fStatsTable.setValueAt(" ", i, 3);
            this.fStatsTable.setValueAt(false, i, 2);
            this.fStatsTable.setValueAt(false, i, 4);
        }
        this.fStatsTable.setValueAt(" ", 6, 1);
        this.fStatsTable.setValueAt(" ", 6, 3);
        this.fStatsTable.getModel().addTableModelListener(this.fTableListener);
        this.updateColumnNames("X", "Y");
    }

    public void addData(Object[] objectArray, String[] stringArray, int n, String[] stringArray2, String[] stringArray3, boolean[] blArray, boolean[] blArray2) {
        SwingUtilities.invokeLater(new RunnableAddData(objectArray, stringArray, n, stringArray2, stringArray3, blArray, blArray2));
    }

    public void removeData(Object[] objectArray, String[] stringArray, int n, String[] stringArray2, String[] stringArray3, boolean[] blArray, boolean[] blArray2, String string, String string2) {
        SwingUtilities.invokeLater(new RunnableRemoveData(objectArray, stringArray, n, stringArray2, stringArray3, blArray, blArray2, string, string2));
    }

    public void removeStatLine(boolean[] blArray, boolean[] blArray2) {
        SwingUtilities.invokeLater(new RunnableRemoveStatLine(blArray, blArray2));
    }

    public void closeDataStats() {
        int n = sDataStats.indexOf(this);
        if (n != -1) {
            sDataStats.removeElementAt(n);
            sFigHandles.removeElementAt(n);
            Object[] objectArray = new Object[]{"bfitdatastatcleanup", this.fCurrentFigure[0]};
            this.fMatlab.fevalConsoleOutput("basicfitdatastat", objectArray, 0, (CompletionObserver)this.fCloseDataStatsCallback);
        }
    }

    private void setMinimumSize(Dimension dimension, Rectangle rectangle) {
        this.fMinSize = dimension;
        this.fOldBounds = rectangle;
        this.fResizeListener = new ResizeListener();
        this.addComponentListener(this.fResizeListener);
    }

    private void resize() {
        this.removeComponentListener(this.fResizeListener);
        Rectangle rectangle = this.getBounds();
        if (rectangle.width < this.fMinSize.width || rectangle.height < this.fMinSize.height) {
            Rectangle rectangle2 = new Rectangle();
            if (rectangle.width < this.fMinSize.width) {
                rectangle2.width = this.fMinSize.width;
                rectangle2.x = rectangle.x == this.fOldBounds.x ? this.fOldBounds.x : rectangle.x + rectangle.width - this.fMinSize.width;
            } else {
                rectangle2.width = rectangle.width;
                rectangle2.x = rectangle.x;
            }
            if (rectangle.height < this.fMinSize.height) {
                rectangle2.height = this.fMinSize.height;
                rectangle2.y = rectangle.y == this.fOldBounds.y ? this.fOldBounds.y : rectangle.y + rectangle.height - this.fMinSize.height;
            } else {
                rectangle2.height = rectangle.height;
                rectangle2.y = rectangle.y;
            }
            this.setBounds(rectangle2);
            this.validate();
        }
        this.fOldBounds = this.getBounds();
        this.addComponentListener(this.fResizeListener);
    }

    private String getRes(String string) {
        String string2;
        try {
            string2 = fRes.getString(string);
        }
        catch (Exception exception) {
            string2 = "MISSING RESOURCE: " + string;
        }
        return string2;
    }

    static /* synthetic */ double[] access$1002(DataStatistics dataStatistics, double[] dArray) {
        dataStatistics.fCurrentData = dArray;
        return dArray;
    }

    static /* synthetic */ Object[] access$1102(DataStatistics dataStatistics, Object[] objectArray) {
        dataStatistics.fHandleList = objectArray;
        return objectArray;
    }

    static {
        fRes = ResourceBundle.getBundle("com.mathworks.page.basicfit.resources.RES_BFDS");
        sFigHandles = new Vector();
        sDataStats = new Vector();
    }

    public class JTableX
    extends MJTable {
        protected RowEditorModel rm;

        public JTableX() {
            this.rm = null;
        }

        public JTableX(TableModel tableModel) {
            super(tableModel);
            this.rm = null;
        }

        public JTableX(TableModel tableModel, TableColumnModel tableColumnModel) {
            super(tableModel, tableColumnModel);
            this.rm = null;
        }

        public JTableX(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
            super(tableModel, tableColumnModel, listSelectionModel);
            this.rm = null;
        }

        public JTableX(int n, int n2) {
            super(n, n2);
            this.rm = null;
        }

        public JTableX(Vector vector, Vector vector2) {
            super(vector, vector2);
            this.rm = null;
        }

        public JTableX(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
            this.rm = null;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n != 6 && (n2 == 2 || n2 == 4)) {
                return this.getDefaultRenderer(Boolean.class);
            }
            return DataStatistics.this.fCustomStringRender;
        }
    }

    public class RowEditorModel {
        private Hashtable<Integer, TableCellEditor> data = new Hashtable();

        public void addEditorForRow(int n, TableCellEditor tableCellEditor) {
            this.data.put(n, tableCellEditor);
        }

        public void removeEditorForRow(int n) {
            this.data.remove(new Integer(n));
        }

        public TableCellEditor getEditor(int n) {
            return this.data.get(new Integer(n));
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            DataStatistics.this.resize();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            DataStatistics.this.resize();
        }
    }

    private class CustomStringRenderer
    extends DefaultTableCellRenderer {
        private CustomStringRenderer() {
        }

        @Override
        public synchronized Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                if (n2 != 0) {
                    this.setHorizontalAlignment(4);
                    this.setBackground(jTable.getBackground());
                } else {
                    this.setHorizontalAlignment(2);
                    this.setBackground(DataStatistics.this.fHeaderColor);
                }
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class CustomModel
    extends DefaultTableModel {
        public CustomModel() {
        }

        public CustomModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        public CustomModel(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        public Class getColumnClass(int n) {
            Class clazz = Object.class;
            int n2 = this.getRowCount();
            for (int i = 0; i < n2; ++i) {
                Object object = this.getValueAt(i, n);
                if (object == null) continue;
                clazz = object.getClass();
                break;
            }
            return clazz;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n != 6 && (n2 == 2 || n2 == 4);
        }
    }

    private class CloseDataStatsCallback
    implements CompletionObserver {
        private CloseDataStatsCallback() {
        }

        public void completed(int n, Object object) {
            Point point = DataStatistics.this.getLocation();
            Prefs.setIntegerPref((String)"DataStatistics.XLocation", (int)point.x);
            Prefs.setIntegerPref((String)"DataStatistics.YLocation", (int)point.y);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DataStatistics.this.dispose();
                }
            };
            try {
                AWTUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Throwable throwable) {
                Log.logThrowable((Throwable)throwable);
            }
        }
    }

    private class RunnableRemoveStatLine
    implements Runnable {
        boolean[] xchecks;
        boolean[] ychecks;

        public RunnableRemoveStatLine(boolean[] blArray, boolean[] blArray2) {
            this.xchecks = blArray;
            this.ychecks = blArray2;
        }

        @Override
        public void run() {
            DataStatistics.this.updateChecks(this.xchecks, this.ychecks);
        }
    }

    private class RunnableRemoveData
    implements Runnable {
        Object[] handles;
        String[] datanames;
        int index;
        String[] xstats;
        String[] ystats;
        boolean[] xchecks;
        boolean[] ychecks;
        String xcolname;
        String ycolname;

        public RunnableRemoveData(Object[] objectArray, String[] stringArray, int n, String[] stringArray2, String[] stringArray3, boolean[] blArray, boolean[] blArray2, String string, String string2) {
            this.handles = objectArray;
            this.datanames = stringArray;
            this.index = n;
            this.xstats = stringArray2;
            this.ystats = stringArray3;
            this.xchecks = blArray;
            this.ychecks = blArray2;
            this.xcolname = string;
            this.ycolname = string2;
        }

        @Override
        public void run() {
            DataStatistics.this.fDataChoice.removeActionListener((ActionListener)DataStatistics.this.fDataChoiceListener);
            DataStatistics.this.fDataChoice.removeAllItems();
            if (this.index > 0) {
                DataStatistics.access$1102(DataStatistics.this, new Object[this.datanames.length]);
                for (int i = 0; i < this.datanames.length; ++i) {
                    DataStatistics.this.fDataChoice.addItem((Object)this.datanames[i]);
                    double[] dArray = new double[]{(Double)this.handles[i]};
                    ((DataStatistics)DataStatistics.this).fHandleList[i] = dArray;
                }
                DataStatistics.this.fDataChoice.setSelectedIndex(this.index - 1);
                if (this.xstats != null) {
                    double[] dArray = (double[])DataStatistics.this.fHandleList[this.index - 1];
                    ((DataStatistics)DataStatistics.this).fCurrentData[0] = dArray[0];
                    DataStatistics.this.updateStats(this.xstats, this.ystats);
                    DataStatistics.this.updateChecks(this.xchecks, this.ychecks);
                    DataStatistics.this.updateColumnNames(this.xcolname, this.ycolname);
                }
            } else {
                DataStatistics.this.clearDataStats();
                DataStatistics.this.enableDataStats(false);
            }
            DataStatistics.this.fDataChoice.addActionListener((ActionListener)DataStatistics.this.fDataChoiceListener);
        }
    }

    private class RunnableAddData
    implements Runnable {
        Object[] handles;
        String[] datanames;
        int index;
        String[] xstats;
        String[] ystats;
        boolean[] xchecks;
        boolean[] ychecks;

        public RunnableAddData(Object[] objectArray, String[] stringArray, int n, String[] stringArray2, String[] stringArray3, boolean[] blArray, boolean[] blArray2) {
            this.handles = objectArray;
            this.datanames = stringArray;
            this.index = n;
            this.xstats = stringArray2;
            this.ystats = stringArray3;
            this.xchecks = blArray;
            this.ychecks = blArray2;
        }

        @Override
        public void run() {
            DataStatistics.this.fDataChoice.removeActionListener((ActionListener)DataStatistics.this.fDataChoiceListener);
            DataStatistics.this.fDataChoice.removeAllItems();
            DataStatistics.access$1102(DataStatistics.this, new Object[this.datanames.length]);
            for (int i = 0; i < this.datanames.length; ++i) {
                DataStatistics.this.fDataChoice.addItem((Object)this.datanames[i]);
                double[] dArray = new double[]{(Double)this.handles[i]};
                ((DataStatistics)DataStatistics.this).fHandleList[i] = dArray;
            }
            DataStatistics.this.fDataChoice.setSelectedIndex(this.index - 1);
            DataStatistics.this.fDataChoice.repaint();
            if (this.xstats != null) {
                double[] dArray = (double[])DataStatistics.this.fHandleList[this.index - 1];
                ((DataStatistics)DataStatistics.this).fCurrentData[0] = dArray[0];
                DataStatistics.this.updateStats(this.xstats, this.ystats);
                DataStatistics.this.updateChecks(this.xchecks, this.ychecks);
                if (this.datanames.length == 1) {
                    DataStatistics.this.enableDataStats(true);
                }
            }
            DataStatistics.this.fDataChoice.addActionListener((ActionListener)DataStatistics.this.fDataChoiceListener);
        }
    }

    private class RunnableEnableDataStats
    implements Runnable {
        private RunnableEnableDataStats() {
        }

        @Override
        public void run() {
            DataStatistics.this.enableDataStats(true);
        }
    }

    private class TableListener
    implements TableModelListener {
        private TableListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                Object[] objectArray = new Object[5];
                objectArray[0] = "bfitplotdatastats";
                objectArray[1] = DataStatistics.this.fCurrentData[0];
                objectArray[2] = DataStatistics.this.plotoptions[n];
                objectArray[3] = n2 == 2 ? "x" : "y";
                Boolean bl = (Boolean)DataStatistics.this.fStatsTableModel.getValueAt(n, n2);
                objectArray[4] = bl != false ? Integer.valueOf(1) : Integer.valueOf(0);
                DataStatistics.this.fMatlab.fevalConsoleOutput("basicfitdatastat", objectArray, 0, (CompletionObserver)null);
            }
        }
    }

    private class RunnableDataModified
    implements Runnable {
        String[] xstats;
        String[] ystats;
        String xlabel;
        String ylabel;

        public RunnableDataModified(String[] stringArray, String[] stringArray2, String string, String string2) {
            this.xstats = stringArray;
            this.ystats = stringArray2;
            this.xlabel = string;
            this.ylabel = string2;
        }

        @Override
        public void run() {
            DataStatistics.this.fStatsTable.getModel().removeTableModelListener(DataStatistics.this.fTableListener);
            for (int i = 0; i < 6; ++i) {
                DataStatistics.this.fStatsTable.setValueAt(false, i, 2);
                DataStatistics.this.fStatsTable.setValueAt(false, i, 4);
            }
            DataStatistics.this.fStatsTable.getModel().addTableModelListener(DataStatistics.this.fTableListener);
            DataStatistics.this.updateStats(this.xstats, this.ystats);
            DataStatistics.this.updateColumnNames(this.xlabel, this.ylabel);
        }
    }

    private class DataChangedRunnable
    implements Runnable {
        Object[] Result;

        public DataChangedRunnable(Object object) {
            this.Result = (Object[])object;
        }

        @Override
        public void run() {
            String[] stringArray = (String[])this.Result[0];
            String[] stringArray2 = (String[])this.Result[1];
            boolean[] blArray = (boolean[])this.Result[2];
            boolean[] blArray2 = (boolean[])this.Result[3];
            String string = (String)this.Result[4];
            String string2 = (String)this.Result[5];
            DataStatistics.this.updateStats(stringArray, stringArray2);
            DataStatistics.this.updateChecks(blArray, blArray2);
            DataStatistics.this.updateColumnNames(string, string2);
            DataStatistics.this.enableDataStats(true);
        }
    }

    class DataChangedCallback
    implements CompletionObserver {
        DataChangedCallback() {
        }

        public void completed(int n, Object object) {
            SwingUtilities.invokeLater(new DataChangedRunnable(object));
        }
    }

    private class DataChoiceListener
    implements ActionListener {
        private DataChoiceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataStatistics.this.enableDataStats(false);
            MJComboBox mJComboBox = (MJComboBox)actionEvent.getSource();
            int n = mJComboBox.getSelectedIndex();
            if (n >= 0) {
                double[] dArray = (double[])DataStatistics.this.fHandleList[n];
                ((DataStatistics)DataStatistics.this).fCurrentData[0] = dArray[0];
                DataStatistics.this.fDataChoice.repaint();
                Object[] objectArray = new Object[]{"bfitdatastatupdate", DataStatistics.this.fCurrentFigure[0], DataStatistics.this.fCurrentData[0]};
                DataStatistics.this.fMatlab.fevalConsoleOutput("basicfitdatastat", objectArray, 6, (CompletionObserver)DataStatistics.this.fDataChangedCallback);
            }
        }
    }

    private class RunnableInit
    implements Runnable {
        Object[] Result;

        public RunnableInit(Object object) {
            this.Result = (Object[])object;
        }

        @Override
        public void run() {
            DataStatistics.access$1002(DataStatistics.this, new double[1]);
            String[] stringArray = new String[]{};
            String[] stringArray2 = new String[]{};
            String[] stringArray3 = new String[]{};
            boolean[] blArray = new boolean[]{};
            boolean[] blArray2 = new boolean[]{};
            String string = "";
            String string2 = "";
            DataStatistics.access$1102(DataStatistics.this, (Object[])this.Result[0]);
            if (DataStatistics.this.fHandleList.length > 0) {
                stringArray = (String[])this.Result[1];
                stringArray2 = (String[])this.Result[2];
                stringArray3 = (String[])this.Result[3];
                blArray = (boolean[])this.Result[4];
                blArray2 = (boolean[])this.Result[5];
                string = (String)this.Result[6];
                string2 = (String)this.Result[7];
                double[] dArray = (double[])DataStatistics.this.fHandleList[0];
                ((DataStatistics)DataStatistics.this).fCurrentData[0] = dArray[0];
            }
            Dimension dimension = DataStatistics.this.fDataChoice.getPreferredSize();
            dimension.width = 180;
            DataStatistics.this.fDataChoice.setPreferredSize(dimension);
            if (DataStatistics.this.fHandleList.length > 0) {
                DataStatistics.this.fDataChoice.removeAllItems();
                for (String string3 : stringArray) {
                    DataStatistics.this.fDataChoice.addItem((Object)string3);
                }
                DataStatistics.this.fDataChoice.setSelectedIndex(0);
                DataStatistics.this.fDataChoice.addActionListener((ActionListener)DataStatistics.this.fDataChoiceListener);
                DataStatistics.this.fStatsTable.getModel().addTableModelListener(DataStatistics.this.fTableListener);
                DataStatistics.this.updateStats(stringArray2, stringArray3);
                DataStatistics.this.updateChecks(blArray, blArray2);
                DataStatistics.this.updateColumnNames(string, string2);
            } else {
                DataStatistics.this.enableDataStats(false);
            }
        }
    }
}

