/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.wizard;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.wizard.ICodeGenerator;
import com.mathworks.widgets.wizard.IWizardContents;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

public class WizardFrame
extends MJFrame
implements ActionListener {
    private static ResourceBundle sBundle = ResourceBundle.getBundle("com.mathworks.widgets.wizard.resources.RES_Wizard");
    protected MJAbstractAction fCancelAction = null;
    protected MJAbstractAction fBackAction = null;
    protected MJAbstractAction fNextAction = null;
    protected MJAbstractAction fFinishAction = null;
    protected MJAbstractAction fHelpAction = null;
    protected IWizardContents fContents = null;
    protected ICodeGenerator fCodeGenerator = null;
    private static final String CANCEL = sBundle.getString("wf.cancel");
    private static final String NEXT = sBundle.getString("wf.next");
    private static final String BACK = sBundle.getString("wf.back");
    private static final String FINISH = sBundle.getString("wf.finish");
    private static final String HELP = sBundle.getString("wf.help");
    private static final String GENERATE_CODE = sBundle.getString("wf.generate_code");
    private JPanel fCurrentPanel = null;
    private MJButton fNextButton;
    private MJButton fFinishButton;
    private MJCheckBox fGenerateCodeCheckBox = null;
    private WindowListener fWindowListener;

    public WizardFrame(IWizardContents iWizardContents) {
        super(iWizardContents.getName());
        this.fContents = iWizardContents;
        this.fCancelAction = new NavigationAction(CANCEL, "Cancel");
        this.fBackAction = new NavigationAction(BACK, "Back");
        this.fNextAction = new NavigationAction(NEXT, "Next");
        if (this.fContents.needsBothNextAndFinish()) {
            this.fFinishAction = new NavigationAction(FINISH, "Finish");
        }
        if (this.fContents.isHelpAvailable()) {
            this.fHelpAction = new NavigationAction(HELP, "Help");
        }
        WizardFrame.setActionEnabled(this.fCancelAction, true);
        MJButton mJButton = new MJButton((Action)this.fBackAction);
        mJButton.setToolTipText(null);
        MJButton mJButton2 = new MJButton((Action)this.fNextAction);
        mJButton2.setToolTipText(null);
        MJButton mJButton3 = null;
        if (this.fFinishAction != null) {
            mJButton3 = new MJButton((Action)this.fFinishAction);
            mJButton3.setToolTipText(null);
        }
        MJButton mJButton4 = new MJButton((Action)this.fCancelAction);
        mJButton4.setToolTipText(null);
        MJButton mJButton5 = null;
        if (this.fHelpAction != null) {
            mJButton5 = new MJButton((Action)this.fHelpAction);
            mJButton5.setToolTipText(null);
        }
        if (this.fContents instanceof ICodeGenerator) {
            this.fCodeGenerator = (ICodeGenerator)this.fContents;
            this.fGenerateCodeCheckBox = new MJCheckBox(GENERATE_CODE, this.fCodeGenerator.getGenerateCodeOnFinish());
            this.fGenerateCodeCheckBox.setName("GenerateMCodeCheckBox");
            this.fGenerateCodeCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    WizardFrame.this.fCodeGenerator.setGenerateCodeOnFinish(itemEvent.getStateChange() == 1);
                }
            });
        }
        MJPanel mJPanel = new MJPanel();
        MJPanel mJPanel2 = new MJPanel();
        mJPanel.add((Component)mJButton);
        mJPanel.add((Component)mJButton2);
        if (mJButton3 != null) {
            mJPanel.add((Component)mJButton3);
        }
        if (this.fGenerateCodeCheckBox != null) {
            mJPanel.add((Component)this.fGenerateCodeCheckBox);
        } else {
            mJPanel.add(Box.createHorizontalStrut(12));
        }
        mJPanel.add((Component)mJButton4);
        mJPanel2.setLayout((LayoutManager)new BorderLayout());
        Dimension dimension = mJPanel2.getPreferredSize();
        Dimension dimension2 = this.fContents.getPreferredSize();
        this.setSize(Math.max(dimension2.width, dimension.width + 32), dimension2.height + dimension.height);
        if (mJButton5 != null) {
            MJPanel mJPanel3 = new MJPanel();
            mJPanel3.add((Component)mJButton5);
            mJPanel2.add((Component)mJPanel3, (Object)"West");
        }
        mJPanel2.add((Component)mJPanel, (Object)"East");
        this.fNextButton = mJButton2;
        this.fFinishButton = mJButton3 != null ? mJButton3 : mJButton2;
        this.setContentsTo(this.fContents.getStartupPanel());
        this.getContentPane().add((Component)mJPanel2, "South");
        this.fContents.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WizardFrame.this.cancel();
            }
        };
        this.addWindowListener(this.fWindowListener);
        this.updateNavigationControls();
    }

    private static void setActionEnabled(MJAbstractAction mJAbstractAction, boolean bl) {
        if (mJAbstractAction != null) {
            mJAbstractAction.setEnabled(bl);
        }
    }

    protected void updateNavigationControls() {
        WizardFrame.setActionEnabled(this.fNextAction, this.fContents.isNextAvailable());
        WizardFrame.setActionEnabled(this.fBackAction, this.fContents.isBackAvailable());
        if (this.fContents.needsBothNextAndFinish()) {
            WizardFrame.setActionEnabled(this.fNextAction, this.fContents.isNextAvailable());
            WizardFrame.setActionEnabled(this.fFinishAction, this.fContents.isFinishAvailable());
        } else {
            if (this.fContents.isFinishAvailable()) {
                this.fNextAction.setName(FINISH);
            } else {
                this.fNextAction.setName(NEXT);
            }
            WizardFrame.setActionEnabled(this.fNextAction, this.fContents.isFinishAvailable() || this.fContents.isNextAvailable());
        }
        if (this.fNextButton.isEnabled()) {
            this.getRootPane().setDefaultButton((JButton)this.fNextButton);
            this.fNextButton.requestFocus();
        } else if (this.fFinishButton.isEnabled()) {
            this.getRootPane().setDefaultButton((JButton)this.fFinishButton);
            this.fFinishButton.requestFocus();
        }
    }

    private void cancel() {
        this.fContents.cancel();
        this.goAway();
    }

    private void finish() {
        if (this.fContents.finish()) {
            this.goAway();
        }
    }

    private void goAway() {
        this.fContents.removeActionListener(this);
        this.fContents = null;
        if (this.fGenerateCodeCheckBox != null) {
            ItemListener[] itemListenerArray = this.fGenerateCodeCheckBox.getItemListeners();
            for (int i = 0; i < itemListenerArray.length; ++i) {
                this.fGenerateCodeCheckBox.removeItemListener(itemListenerArray[i]);
            }
            this.fGenerateCodeCheckBox = null;
        }
        this.getRootPane().setDefaultButton(null);
        this.fNextButton = null;
        this.fFinishButton = null;
        this.fCancelAction = null;
        this.fBackAction = null;
        this.fNextAction = null;
        this.fFinishAction = null;
        this.fHelpAction = null;
        this.removeWindowListener(this.fWindowListener);
        this.fWindowListener = null;
        this.fCurrentPanel = null;
        this.setTitle("___gone___");
        this.getContentPane().removeAll();
        this.dispose();
    }

    private void showNextPanel() {
        this.setContentsTo(this.fContents.getNextPanel());
        this.updateNavigationControls();
    }

    private void showPreviousPanel() {
        this.setContentsTo(this.fContents.getPreviousPanel());
        this.updateNavigationControls();
    }

    private void showHelp() {
        this.fContents.showHelp();
    }

    private void setContentsTo(JPanel jPanel) {
        Container container = this.getContentPane();
        jPanel.setOpaque(true);
        if (this.fCurrentPanel != null) {
            container.remove(this.fCurrentPanel);
        }
        container.add((Component)jPanel, "Center");
        this.setContentPane(new JPanel());
        this.setContentPane(container);
        this.fCurrentPanel = jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.equals(IWizardContents.NAVIGATION_UPDATE_EVENT)) {
            this.updateNavigationControls();
        }
    }

    private class NavigationAction
    extends MJAbstractAction {
        NavigationAction(String string, String string2) {
            super(string);
            this.setComponentName(string2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            if (string.equals(NEXT)) {
                WizardFrame.this.showNextPanel();
            } else if (string.equals(BACK)) {
                WizardFrame.this.showPreviousPanel();
            } else if (string.equals(FINISH)) {
                WizardFrame.this.finish();
            } else if (string.equals(CANCEL)) {
                WizardFrame.this.cancel();
            } else if (string.equals(HELP)) {
                WizardFrame.this.showHelp();
            }
        }
    }
}

