/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.simscape;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorLanguagePriority;
import com.mathworks.widgets.text.simscape.SimscapeKit;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.text.Document;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.ext.plain.PlainSyntax;

public class SimscapeLanguage
implements EditorLanguage {
    public static final EditorLanguage INSTANCE = new SimscapeLanguage();
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(SimscapeLanguage.class.getPackage().getName() + ".resources.RES_simscape");

    public boolean isMatchingExtension(String string) {
        return this.getDefaultExtensions().contains(string);
    }

    public String getInternalName() {
        return "Simscape";
    }

    public List<String> getDefaultExtensions() {
        return Arrays.asList("ssc");
    }

    public EditorLanguagePriority getPriority() {
        return EditorLanguagePriority.PRODUCT;
    }

    public String getMimeType() {
        return "text/ssc-MATLAB";
    }

    public String getName() {
        return "Simscape";
    }

    public String getDescription() {
        return BUNDLE.getString("description");
    }

    public SimscapeKit createDefaultKit() {
        SimscapeKit simscapeKit;
        try {
            Class<?> clazz = Class.forName("com.mathworks.physmod.simscape.simscape.editor.SimscapeEditorKit");
            simscapeKit = (SimscapeKit)((Object)clazz.newInstance());
        }
        catch (Exception exception) {
            simscapeKit = new DefaultSimscapeKit();
        }
        return simscapeKit;
    }

    private static final class DefaultSimscapeKit
    extends SimscapeKit {
        private DefaultSimscapeKit() {
        }

        @Override
        public String getContentType() {
            return INSTANCE.getMimeType();
        }

        public Syntax createSyntax(Document document) {
            return new PlainSyntax();
        }

        @Override
        public boolean isModifiable() {
            return false;
        }

        @Override
        public boolean hasFullLanguageSupport() {
            return false;
        }
    }
}

