/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.print;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.services.ColorPrefs;
import com.mathworks.util.NativeJava;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.print.GraphicsUtils;
import com.mathworks.widgets.text.print.MultiHeaderUtils;
import com.mathworks.widgets.text.print.PrintSettings;
import com.mathworks.widgets.text.print.Scale;
import com.mathworks.widgets.text.print.TextPrintable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sun.awt.FontConfiguration;

public class PrintUtils {
    private static ResourceBundle sBundle = ResourceBundle.getBundle("com.mathworks.widgets.text.print.resources.RES_Print");

    private PrintUtils() {
    }

    public static String getResource(String string) {
        return sBundle.getString(string);
    }

    static String getResource(String string, String string2) {
        return MessageFormat.format(PrintUtils.getResource(string), string2);
    }

    public static void processPrint(final Printable printable, String string, final Component component, final Component component2) {
        PrintSettings printSettings = PrintSettings.getInstance();
        final PrintRequestAttributeSet printRequestAttributeSet = printSettings.getLastPrintRequestAttributes(string);
        component2.setCursor(Cursor.getPredefinedCursor(3));
        final PrinterJob printerJob = printSettings.showPrintDialog(DocFlavor.SERVICE_FORMATTED.PRINTABLE, MJFrame.getFrame((Component)component), printRequestAttributeSet);
        if (printerJob != null) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (PrintSettings.useNativeDialogs()) {
                            printerJob.setPrintable(printable);
                            printerJob.print(printRequestAttributeSet);
                        } else {
                            DocPrintJob docPrintJob;
                            PrintService printService = printerJob.getPrintService();
                            if (printService != null && (docPrintJob = printService.createPrintJob()) != null) {
                                SimpleDoc simpleDoc = new SimpleDoc(printable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, new HashDocAttributeSet());
                                docPrintJob.print(simpleDoc, printRequestAttributeSet);
                            }
                        }
                    }
                    catch (PrintException printException) {
                        PrintUtils.showPrintError(printException, component);
                    }
                    catch (PrinterException printerException) {
                        PrintUtils.showPrintError(printerException, component);
                    }
                    finally {
                        component2.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }
        component2.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void showPrintError(Exception exception, Component component) {
        if (!(exception.getCause() instanceof PrinterAbortException)) {
            MJOptionPane.showMessageDialog((Component)MJFrame.getFrame((Component)component), (Object)(SyntaxTextPaneUtilities.intlString("errorPrinting") + "\n\n" + exception.getLocalizedMessage()), (String)SyntaxTextPaneUtilities.intlString("errorPrintingTitle"), (int)0);
        }
    }

    public static void showPageSetupDialog(String string) {
        PageSetupThread pageSetupThread = new PageSetupThread(string);
        Thread thread = new Thread(pageSetupThread);
        thread.start();
    }

    private static SyntaxTextPane createSyntaxTextPane(String string, Component component, boolean bl) {
        SyntaxTextPane syntaxTextPane = new SyntaxTextPane();
        syntaxTextPane.setName(component.getName());
        syntaxTextPane.getDocument().putProperty("__EndOfLine__", "\n");
        syntaxTextPane.registerEditorKit(MLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new MColorCodeKit()));
        syntaxTextPane.setContentType(MLanguage.INSTANCE.getMimeType());
        syntaxTextPane.setHighlightCaretRow(false, false);
        syntaxTextPane.enableDelimiterMatchForArrows(false, false);
        syntaxTextPane.setFont(component.getFont(), false);
        syntaxTextPane.setSyntaxHighlightingEnabled(MLanguage.INSTANCE, bl);
        syntaxTextPane.setTextColor(ColorPrefs.getTextColor(), false);
        syntaxTextPane.setBackgroundColor(ColorPrefs.getBackgroundColor(), false);
        syntaxTextPane.setText(string);
        return syntaxTextPane;
    }

    public static void printHighlightedText(String string, JComponent jComponent, Font font, String string2, String string3) {
        PrintUtils.printText(string, jComponent, font, string2, string3, true);
    }

    public static void printPlainText(String string, JComponent jComponent, Font font, String string2, String string3) {
        PrintUtils.printText(string, jComponent, font, string2, string3, false);
    }

    private static void printText(String string, JComponent jComponent, Font font, String string2, String string3, boolean bl) {
        SyntaxTextPane syntaxTextPane = PrintUtils.createSyntaxTextPane(string, jComponent, bl);
        Document document = syntaxTextPane.getDocument();
        PrintUtils.processPrint(new TextAndHeaderPrintable(document, font, PrintUtils.getMainHeader(string3), PrintUtils.getSubHeader()), string2, jComponent, jComponent);
        syntaxTextPane.cleanup();
    }

    private static MessageFormat getMainHeader(String string) {
        return new MessageFormat(string);
    }

    private static MessageFormat getSubHeader() {
        Object[] objectArray = new Object[]{new Date()};
        return new MessageFormat(MessageFormat.format(MultiHeaderUtils.getDateAndTimeHeaderText(), objectArray));
    }

    public static class FontHelper {
        private static Map<String, String> sLogicalFontMap = new HashMap<String, String>();
        public static final String LOGICAL_FONT_MAP = "JavaLogicalFontMap";
        private static final String FONT_FAMILY = "JavaFontFamily";
        private static final String FONT_NAME = "JavaFontName";
        private static final String FONT_SIZE = "JavaFontSize";
        private static final String FONT_FACE = "JavaFontFace";

        private FontHelper() {
        }

        public static Map<String, String> getLogicalFontMap() {
            if (sLogicalFontMap.isEmpty()) {
                String[] stringArray;
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (String string : stringArray = graphicsEnvironment.getAvailableFontFamilyNames()) {
                    if (!FontConfiguration.isLogicalFontFamilyName(string)) continue;
                    Font font = new Font(string, 0, 10);
                    String string2 = NativeJava.getPhysicalFontName((Font)font);
                    String string3 = string + "-" + "Plain";
                    sLogicalFontMap.put(string3, string2);
                    Font font2 = new Font(string, 1, 10);
                    string2 = NativeJava.getPhysicalFontName((Font)font2);
                    string3 = string + "-" + "Bold";
                    sLogicalFontMap.put(string3, string2);
                    Font font3 = new Font(string, 2, 10);
                    string2 = NativeJava.getPhysicalFontName((Font)font3);
                    string3 = string + "-" + "Italic";
                    sLogicalFontMap.put(string3, string2);
                    Font font4 = new Font(string, 0, 10);
                    string2 = NativeJava.getPhysicalFontName((Font)font4);
                    string3 = string + "-" + "BoldItalic";
                    sLogicalFontMap.put(string3, string2);
                }
            }
            return Collections.unmodifiableMap(sLogicalFontMap);
        }

        public static Map<String, Object> fontToMap(Font font) {
            HashMap<String, Object> hashMap = null;
            if (font != null) {
                hashMap = new HashMap<String, Object>();
                if (FontConfiguration.isLogicalFontFaceName(font.getFontName())) {
                    hashMap.put(FONT_FAMILY, font.getFontName());
                    hashMap.put(FONT_FACE, font.getStyle());
                } else {
                    hashMap.put(FONT_NAME, font.getFontName());
                }
                hashMap.put(FONT_SIZE, font.getSize());
            }
            return hashMap;
        }

        public static Font mapToFont(Map<String, Object> map) {
            Font font = null;
            if (map != null) {
                int n = 0;
                if (map.containsKey(FONT_FACE)) {
                    n = (Integer)map.get(FONT_FACE);
                }
                double d = 0.0;
                if (map.containsKey(FONT_SIZE)) {
                    d = (Double)map.get(FONT_SIZE);
                }
                String string = null;
                if (map.containsKey(FONT_NAME)) {
                    string = (String)map.get(FONT_NAME);
                }
                String string2 = null;
                if (map.containsKey(FONT_FAMILY)) {
                    string2 = (String)map.get(FONT_FAMILY);
                }
                if (string != null) {
                    font = new Font(string, n, (int)d);
                } else if (string2 != null) {
                    font = new Font(string2, n, (int)d);
                }
            }
            return font;
        }
    }

    public static class PListSerializer {
        private PListSerializer() {
        }

        public static String hashMapToPListString(Map<String, Object> map) {
            String string = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                org.w3c.dom.Document document = documentBuilder.newDocument();
                Element element = document.createElement("plist");
                document.appendChild(element);
                element.appendChild(PListSerializer.toXMLNode(map, document));
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "no");
                transformer.setOutputProperty("doctype-public", "-//Apple Computer//DTD PLIST 1.0//EN");
                transformer.setOutputProperty("doctype-system", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
                StreamResult streamResult = new StreamResult(new StringWriter());
                transformer.transform(new DOMSource(document), streamResult);
                string = streamResult.getWriter().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        private static Element toXMLNode(Object object, org.w3c.dom.Document document) {
            if (Map.class.isAssignableFrom(object.getClass())) {
                return PListSerializer.hashMaptoXMLNode((Map)object, document);
            }
            if (Iterable.class.isAssignableFrom(object.getClass())) {
                return PListSerializer.arrayListtoXMLNode((Iterable)object, document);
            }
            return PListSerializer.primitivetoXMLNode(object, document);
        }

        private static Element hashMaptoXMLNode(Map<String, Object> map, org.w3c.dom.Document document) {
            Element element = document.createElement("dict");
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Element element2 = document.createElement("key");
                element2.setTextContent(entry.getKey());
                element.appendChild(element2);
                element.appendChild(PListSerializer.toXMLNode(entry.getValue(), document));
            }
            return element;
        }

        private static Element arrayListtoXMLNode(Iterable<Object> iterable, org.w3c.dom.Document document) {
            Element element = document.createElement("array");
            for (Object object : iterable) {
                element.appendChild(PListSerializer.toXMLNode(object, document));
            }
            return element;
        }

        private static Element primitivetoXMLNode(Object object, org.w3c.dom.Document document) {
            Element element = null;
            if (object.getClass() == String.class) {
                element = document.createElement("string");
                element.setTextContent((String)object);
            }
            if (object.getClass() == Double.class) {
                element = document.createElement("real");
                element.setTextContent(object.toString());
            }
            if (object.getClass() == Integer.class) {
                element = document.createElement("integer");
                element.setTextContent(object.toString());
            }
            if (object.getClass() == Boolean.class) {
                element = object == Boolean.TRUE ? document.createElement("true") : document.createElement("false");
            }
            return element;
        }

        public static Map<String, Object> plistStringToHashMap(String string) {
            if (string.isEmpty()) {
                throw new IllegalArgumentException();
            }
            org.w3c.dom.Document document = PListSerializer.xmlDocumentFromString(string);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            Object object = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("dict")) {
                    throw new IllegalArgumentException("");
                }
                object = PListSerializer.parseElement(node);
            }
            assert (object != null);
            return (Map)object;
        }

        private static org.w3c.dom.Document xmlDocumentFromString(String string) {
            org.w3c.dom.Document document;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream(new StringReader(string));
                document = documentBuilder.parse(inputSource);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                return null;
            }
            catch (SAXException sAXException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            return document;
        }

        private static Object parseElement(Node node) {
            Object object = null;
            if (node != null) {
                if ("dict".equalsIgnoreCase(node.getNodeName())) {
                    object = PListSerializer.parseDictElement(node);
                } else if ("array".equalsIgnoreCase(node.getNodeName())) {
                    object = PListSerializer.parseArrayElement(node);
                } else if ("integer".equalsIgnoreCase(node.getNodeName())) {
                    object = Integer.parseInt(node.getTextContent());
                } else if ("string".equalsIgnoreCase(node.getNodeName())) {
                    object = node.getTextContent();
                } else if ("real".equalsIgnoreCase(node.getNodeName())) {
                    object = Double.parseDouble(node.getTextContent());
                } else if ("false".equalsIgnoreCase(node.getNodeName())) {
                    object = Boolean.FALSE;
                } else if ("true".equalsIgnoreCase(node.getNodeName())) {
                    object = Boolean.TRUE;
                }
            }
            return object;
        }

        private static Map<String, Object> parseDictElement(Node node) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength() - 1; i += 2) {
                Node node2 = nodeList.item(i);
                Node node3 = nodeList.item(i + 1);
                String string = node2.getTextContent();
                hashMap.put(string, PListSerializer.parseElement(node3));
            }
            return hashMap;
        }

        private static List<Object> parseArrayElement(Node node) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(PListSerializer.parseElement(nodeList.item(i)));
            }
            return arrayList;
        }
    }

    public static class PageAttributesHelper {
        public static final String PAGE_ATTRIBUTES = "PageAttributes";
        private static final String PAGE_ORIENTATION = "PageOrientation";
        private static final String PAGE_SETUP = "PageSetUp";
        private static final String PAPER_NAME = "PaperName";
        private static final String PAPER_SIZE = "PaperSize";
        private static final String PAPER_MARGINS = "PaperMargins";
        private static final String SCALE = "Scale";
        private static final float PRINTER_DPI = 72.0f;
        private static final List<String> MEDIA_STRING_LIST = Collections.unmodifiableList(Arrays.asList("a", "b", "c", "d", "e", "iso-a0", "iso-a1", "iso-a2", "iso-a3", "iso-a4", "iso-a5", "iso-a6", "iso-a7", "iso-a8", "iso-a9", "iso-a10", "iso-b0", "iso-b1", "iso-b2", "iso-b3", "iso-b4", "iso-b5", "iso-b6", "iso-b7", "iso-b8", "iso-b9", "iso-b10", "iso-c0", "iso-c1", "iso-c2", "iso-c3", "iso-c4", "iso-c5", "iso-c6", "iso-designated-long", "jis-b0", "jis-b1", "jis-b2", "jis-b3", "jis-b4", "jis-b5", "jis-b6", "jis-b7", "jis-b8", "jis-b9", "jis-b10", "na-letter", "na-legal", "na-5x7", "na-8x10", "na-number-9-envelope", "na-number-10-envelope", "na-number-11-envelope", "na-number-12-envelope", "na-number-14-envelope", "na-6x9-envelope", "na-7x9-envelope", "na-9x11-envelope", "na-9x12-envelope", "na-10x13-envelope", "na-10x14-envelope", "na-10x15-envelope", "executive", "ledger", "tabloid", "invoice", "folio", "quarto", "italian-envelope", "monarch-envelope", "personal-envelope", "japanese-postcard", "oufuko-postcard"));
        private static final List<MediaSizeName> MEDIA_VALUE_LIST = Collections.unmodifiableList(Arrays.asList(MediaSizeName.A, MediaSizeName.B, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, MediaSizeName.JIS_B9, MediaSizeName.JIS_B10, MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.NA_5X7, MediaSizeName.NA_8X10, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.EXECUTIVE, MediaSizeName.LEDGER, MediaSizeName.TABLOID, MediaSizeName.INVOICE, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.JAPANESE_DOUBLE_POSTCARD));

        private PageAttributesHelper() {
        }

        private static MediaSizeName findApproxMedia(float f, float f2, int n) {
            if (f <= 0.0f || f2 <= 0.0f || n < 1) {
                throw new IllegalArgumentException("args must be +ve values");
            }
            double d = f * f + f2 * f2;
            MediaSize mediaSize = null;
            for (MediaSizeName mediaSizeName : MEDIA_VALUE_LIST) {
                MediaSize mediaSize2 = MediaSize.getMediaSizeForName(mediaSizeName);
                if (mediaSize2 == null) continue;
                float[] fArray = mediaSize2.getSize(n);
                if (Math.abs(f - fArray[0]) < 0.01f && Math.abs(f2 - fArray[1]) < 0.01f) {
                    mediaSize = mediaSize2;
                    break;
                }
                float f3 = f - fArray[0];
                float f4 = f2 - fArray[1];
                double d2 = f3 * f3 + f4 * f4;
                if (!(d2 < d)) continue;
                d = d2;
                mediaSize = mediaSize2;
            }
            assert (mediaSize != null);
            return mediaSize.getMediaSizeName();
        }

        private static String mediaToString(Media media) {
            String string = null;
            if (MediaSizeName.class.isAssignableFrom(media.getClass())) {
                string = media.toString();
            } else if (MediaName.class.isAssignableFrom(media.getClass())) {
                if (media.equals(MediaName.ISO_A4_TRANSPARENT) || media.equals(MediaName.ISO_A4_WHITE)) {
                    string = MediaSizeName.ISO_A4.toString();
                } else if (media.equals(MediaName.NA_LETTER_TRANSPARENT) || media.equals(MediaName.NA_LETTER_WHITE)) {
                    string = MediaSizeName.NA_LETTER.toString();
                }
            }
            return string;
        }

        private static MediaSizeName stringToMedia(String string) {
            int n = MEDIA_STRING_LIST.indexOf(string);
            MediaSizeName mediaSizeName = null;
            if (n != -1) {
                mediaSizeName = MEDIA_VALUE_LIST.get(n);
            }
            return mediaSizeName;
        }

        private static MediaSize lookupMediaSize(Media media) {
            if (MediaSizeName.class.isAssignableFrom(media.getClass())) {
                return MediaSize.getMediaSizeForName((MediaSizeName)media);
            }
            if (MediaName.class.isAssignableFrom(media.getClass())) {
                if (media.equals(MediaName.ISO_A4_TRANSPARENT) || media.equals(MediaName.ISO_A4_WHITE)) {
                    return MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
                }
                if (media.equals(MediaName.NA_LETTER_TRANSPARENT) || media.equals(MediaName.NA_LETTER_WHITE)) {
                    return MediaSize.getMediaSizeForName(MediaSizeName.NA_LETTER);
                }
            }
            return null;
        }

        private static double inchToDPI(double d) {
            return d * 72.0;
        }

        private static double dpiToInch(double d) {
            return d / 72.0;
        }

        private static String mediaPrintableAreaToString(MediaPrintableArea mediaPrintableArea, MediaSize mediaSize, OrientationRequested orientationRequested) {
            String string = null;
            if (mediaPrintableArea != null) {
                double d = mediaPrintableArea.getY(25400);
                double d2 = mediaPrintableArea.getX(25400);
                double d3 = (double)mediaSize.getY(25400) - (d + (double)mediaPrintableArea.getHeight(25400));
                double d4 = (double)mediaSize.getX(25400) - (d2 + (double)mediaPrintableArea.getWidth(25400));
                double d5 = PageAttributesHelper.inchToDPI(d);
                double d6 = PageAttributesHelper.inchToDPI(d2);
                double d7 = PageAttributesHelper.inchToDPI(d3);
                double d8 = PageAttributesHelper.inchToDPI(d4);
                if (orientationRequested == OrientationRequested.PORTRAIT || orientationRequested == OrientationRequested.REVERSE_PORTRAIT) {
                    string = Double.toString(d5) + "," + Double.toString(d6) + "," + Double.toString(d7) + "," + Double.toString(d8);
                } else if (orientationRequested == OrientationRequested.LANDSCAPE || orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                    string = Double.toString(d6) + "," + Double.toString(d7) + "," + Double.toString(d8) + "," + Double.toString(d5);
                }
            }
            return string;
        }

        private static MediaPrintableArea stringToMediaPrintableArea(String string, MediaSize mediaSize, OrientationRequested orientationRequested) {
            MediaPrintableArea mediaPrintableArea = null;
            if (string != null) {
                String string2 = string.replace("{", "").replace("}", "");
                String[] stringArray = string2.split(",");
                double d = PageAttributesHelper.dpiToInch(Float.parseFloat(stringArray[0]));
                double d2 = PageAttributesHelper.dpiToInch(Float.parseFloat(stringArray[1]));
                double d3 = PageAttributesHelper.dpiToInch(Float.parseFloat(stringArray[2]));
                double d4 = PageAttributesHelper.dpiToInch(Float.parseFloat(stringArray[3]));
                if (orientationRequested == OrientationRequested.PORTRAIT || orientationRequested == OrientationRequested.REVERSE_PORTRAIT) {
                    mediaPrintableArea = new MediaPrintableArea((float)d2, (float)d, (float)((double)mediaSize.getX(25400) - (d2 + d4)), (float)((double)mediaSize.getY(25400) - (d + d3)), 25400);
                } else if (orientationRequested == OrientationRequested.LANDSCAPE || orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                    mediaPrintableArea = new MediaPrintableArea((float)d, (float)d4, (float)((double)mediaSize.getX(25400) - (d + d3)), (float)((double)mediaSize.getY(25400) - (d2 + d4)), 25400);
                }
            }
            return mediaPrintableArea;
        }

        private static String mediaSizeToString(MediaSize mediaSize) {
            if (mediaSize == null) {
                return null;
            }
            double d = PageAttributesHelper.inchToDPI(mediaSize.getX(25400));
            double d2 = PageAttributesHelper.inchToDPI(mediaSize.getY(25400));
            return "{" + Double.toString(d) + "," + Double.toString(d2) + "}";
        }

        private static MediaSize stringToMediaSize(String string) {
            if (string == null) {
                return null;
            }
            String string2 = string.replace("{", "").replace("}", "");
            String[] stringArray = string2.split(",");
            double d = PageAttributesHelper.dpiToInch(Float.parseFloat(stringArray[0]));
            double d2 = PageAttributesHelper.dpiToInch(Float.parseFloat(stringArray[1]));
            return new MediaSize((float)Math.min(d, d2), (float)Math.max(d, d2), 25400);
        }

        private static OrientationRequested stringToOrientation(String string) {
            if (string == null) {
                return null;
            }
            if (string.equalsIgnoreCase(OrientationRequested.LANDSCAPE.toString())) {
                return OrientationRequested.LANDSCAPE;
            }
            if (string.equalsIgnoreCase(OrientationRequested.PORTRAIT.toString())) {
                return OrientationRequested.PORTRAIT;
            }
            if (string.equalsIgnoreCase(OrientationRequested.REVERSE_LANDSCAPE.toString())) {
                return OrientationRequested.REVERSE_LANDSCAPE;
            }
            if (string.equalsIgnoreCase(OrientationRequested.REVERSE_PORTRAIT.toString())) {
                return OrientationRequested.REVERSE_PORTRAIT;
            }
            return null;
        }

        public static Map<String, Object> getLastUsedPageAttributes() {
            Cloneable cloneable;
            Object object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            PrintRequestAttributeSet printRequestAttributeSet = PrintSettings.getInstance().getLastPrintRequestAttributes(null);
            OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
            if (orientationRequested == null) {
                orientationRequested = OrientationRequested.PORTRAIT;
            }
            hashMap.put(PAGE_ORIENTATION, orientationRequested.toString());
            Media media = (Media)printRequestAttributeSet.get(Media.class);
            MediaSize mediaSize = (MediaSize)printRequestAttributeSet.get(MediaSize.class);
            if (mediaSize == null && media != null) {
                mediaSize = PageAttributesHelper.lookupMediaSize(media);
            }
            if (media == null && mediaSize == null) {
                object = PrinterJob.getPrinterJob().defaultPage();
                cloneable = ((PageFormat)object).getPaper();
                float f = (float)PageAttributesHelper.dpiToInch(((Paper)cloneable).getWidth());
                float f2 = (float)PageAttributesHelper.dpiToInch(((Paper)cloneable).getHeight());
                mediaSize = new MediaSize(f, f2, 25400);
                media = MediaSize.findMedia(f, f2, 25400);
            }
            if (media != null) {
                hashMap.put(PAPER_NAME, PageAttributesHelper.mediaToString(media));
            }
            if (mediaSize == null) {
                throw new IllegalStateException("Could not determine media size");
            }
            hashMap.put(PAPER_SIZE, PageAttributesHelper.mediaSizeToString(mediaSize));
            object = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
            if (object != null) {
                hashMap.put(PAPER_MARGINS, PageAttributesHelper.mediaPrintableAreaToString((MediaPrintableArea)object, mediaSize, orientationRequested));
            }
            if ((cloneable = (Scale)printRequestAttributeSet.get(Scale.class)) != null) {
                hashMap.put(SCALE, (double)((IntegerSyntax)cloneable).getValue() / 100.0);
            }
            return hashMap;
        }

        public static void setLastUsedPageAttributes(HashMap<String, Object> hashMap) {
            if (hashMap != null) {
                PrintSettings printSettings = PrintSettings.getInstance();
                PrintRequestAttributeSet printRequestAttributeSet = printSettings.getLastPrintRequestAttributes(null);
                if (!hashMap.containsKey(PAGE_ORIENTATION)) {
                    throw new IllegalStateException("Orientation not returned from cocoa");
                }
                OrientationRequested orientationRequested = PageAttributesHelper.stringToOrientation((String)hashMap.get(PAGE_ORIENTATION));
                printRequestAttributeSet.add(orientationRequested);
                if (!hashMap.containsKey(PAPER_NAME)) {
                    throw new IllegalStateException("Media name not returned from cocoa");
                }
                MediaSizeName mediaSizeName = PageAttributesHelper.stringToMedia((String)hashMap.get(PAPER_NAME));
                MediaSize mediaSize = null;
                if (mediaSizeName != null) {
                    mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                }
                if (mediaSize == null) {
                    if (hashMap.containsKey(PAPER_SIZE)) {
                        mediaSize = PageAttributesHelper.stringToMediaSize((String)hashMap.get(PAPER_SIZE));
                        if (mediaSize != null && mediaSizeName == null && (mediaSizeName = PageAttributesHelper.findApproxMedia(mediaSize.getX(25400), mediaSize.getY(25400), 25400)) == null) {
                            // empty if block
                        }
                    } else {
                        throw new IllegalStateException("Media size not returned from cocoa");
                    }
                }
                if (mediaSizeName != null) {
                    printRequestAttributeSet.add(mediaSizeName);
                }
                if (hashMap.containsKey(PAPER_MARGINS)) {
                    MediaPrintableArea mediaPrintableArea = PageAttributesHelper.stringToMediaPrintableArea((String)hashMap.get(PAPER_MARGINS), mediaSize, orientationRequested);
                    if (mediaPrintableArea != null) {
                        printRequestAttributeSet.add(mediaPrintableArea);
                    }
                } else {
                    throw new IllegalStateException("Margins not returned from cocoa");
                }
                if (hashMap.containsKey(SCALE)) {
                    double d = (Double)hashMap.get(SCALE);
                    printRequestAttributeSet.add(new Scale((int)(100.0 * d)));
                }
                printSettings.setLastPrintRequestAttributes(printRequestAttributeSet);
            }
        }
    }

    private static class TextAndHeaderPrintable
    implements Printable {
        private TextPrintable iTextPrintable;
        private MessageFormat iHeaderFormat;
        private MessageFormat iSubHeaderFormat;
        private Font iFont;
        private boolean iSetPaper;
        private PageFormat iShortPage;

        TextAndHeaderPrintable(Document document, Font font, MessageFormat messageFormat, MessageFormat messageFormat2) {
            this.iTextPrintable = new TextPrintable(document, document.getStartPosition().getOffset(), document.getEndPosition().getOffset(), null);
            this.iHeaderFormat = messageFormat;
            this.iSubHeaderFormat = messageFormat2;
            this.iFont = FontUtils.getPrinterFont((Font)font);
            this.iSetPaper = false;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GraphicsUtils.applyPrintScale(graphics2D);
            graphics2D.setFont(this.iFont);
            if (!this.iSetPaper) {
                this.iShortPage = (PageFormat)pageFormat.clone();
                Paper paper = this.iShortPage.getPaper();
                int n2 = pageFormat.getOrientation();
                double d = PrintSettings.useMacNativeFixes() ? ((Graphics2D)graphics).getTransform().getScaleY() : 1.0;
                double d2 = 40.0 * d;
                double d3 = n2 == 1 ? pageFormat.getImageableWidth() : pageFormat.getImageableHeight() - d2;
                double d4 = n2 == 1 ? pageFormat.getImageableHeight() - d2 : pageFormat.getImageableWidth();
                paper.setImageableArea(pageFormat.getImageableX(), pageFormat.getImageableY() + d2, d3, d4);
                this.iShortPage.setPaper(paper);
                this.iSetPaper = true;
            }
            this.iTextPrintable.setPrintHeader(false);
            int n3 = this.iTextPrintable.print(graphics, this.iShortPage, n);
            if (n3 == 0) {
                MultiHeaderUtils.addHeaderToGraphics(graphics2D, pageFormat, this.iHeaderFormat, this.iSubHeaderFormat, n);
            }
            return n3;
        }
    }

    private static class MColorCodeKit
    extends MKit {
        private MColorCodeKit() {
        }

        @Override
        public String getContentType() {
            return MLanguage.INSTANCE.getMimeType();
        }
    }

    private static class PageSetupThread
    implements Runnable {
        private String fTitle;

        private PageSetupThread(String string) {
            this.fTitle = string;
        }

        @Override
        public void run() {
            if (PrintSettings.useMacNativeFixes()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("PageAttributes", PageAttributesHelper.getLastUsedPageAttributes());
                String string = PListSerializer.hashMapToPListString(hashMap);
                String string2 = NativeJava.showPageSetupDialog((String)string);
                if (string2 != null) {
                    Map<String, Object> map = PListSerializer.plistStringToHashMap(string2);
                    PageAttributesHelper.setLastUsedPageAttributes((HashMap)map.get("PageAttributes"));
                }
            } else {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PrintSettings printSettings = PrintSettings.getInstance();
                PrintRequestAttributeSet printRequestAttributeSet = printSettings.getLastPrintRequestAttributes(this.fTitle);
                PrintService printService = printSettings.getLastSelectedPrinter();
                try {
                    if (printService != null) {
                        printerJob.setPrintService(printService);
                    }
                }
                catch (PrinterException printerException) {
                    JOptionPane.showMessageDialog(null, printerException, PrintUtils.getResource("printing.error.unsupported"), 0);
                }
                PageFormat pageFormat = printerJob.pageDialog(printRequestAttributeSet);
                if (pageFormat != null && printService != null) {
                    printSettings.setLastSelectedPrinter(printerJob.getPrintService());
                    printSettings.setLastPrintRequestAttributes(printRequestAttributeSet);
                }
            }
        }
    }
}

