/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.print;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.Prefs;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;
import org.apache.commons.io.IOUtils;
import sun.print.DialogOwner;
import sun.print.SunPageSelection;

public final class PrintSettings {
    static final long serialVersionUID = -9102470021814206818L;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 0;
    public static final String PROP_PAGE_FORMAT = "pageFormat";
    public static final String PROP_WRAP = "wrap";
    public static final String PROP_HEADER_FORMAT = "headerFormat";
    public static final String PROP_FOOTER_FORMAT = "footerFormat";
    public static final String PROP_HEADER_FONT = "headerFont";
    public static final String PROP_FOOTER_FONT = "footerFont";
    public static final String PROP_HEADER_ALIGNMENT = "headerAlignment";
    public static final String PROP_FOOTER_ALIGNMENT = "footerAlignment";
    public static final String PROP_LINE_ASCENT_CORRECTION = "lineAscentCorrection";
    private static final String HELP_ID = "editing.printing";
    private static PageFormat pageFormat;
    private static boolean wrap;
    private static String headerFormat;
    private static String footerFormat;
    private static Font headerFont;
    private static Font footerFont;
    private static int headerAlignment;
    private static int footerAlignment;
    private int fPrintOptions;
    private static float lineAscentCorrection;
    private static PrintSettings sInstance;
    private static PrintService sLastPrintService;
    private static PrintRequestAttributeSet sLastPrintRequestAttributes;
    private static final File sSerializeFile;
    private static final String PRINTER_NAME = "TextPrintingPrinterName";
    private static ResourceBundle sRes;

    private PrintSettings() {
    }

    public static synchronized PrintSettings getInstance() {
        if (sInstance == null) {
            sInstance = new PrintSettings();
        }
        return sInstance;
    }

    public static boolean useNativeDialogs() {
        boolean bl = false;
        if (PlatformInfo.isWindows()) {
            bl = Prefs.getBooleanPref((String)"com.mathworks.mde.printdialog.usenative", (boolean)true);
        } else if (PlatformInfo.isMacintosh()) {
            bl = !LanguageUtils.isCJK() && Prefs.getBooleanPref((String)"com.mathworks.mde.printdialog.usenative", (boolean)true);
        }
        return bl;
    }

    public static boolean useMacNativeFixes() {
        return PlatformInfo.isMacintosh() && PrintSettings.useNativeDialogs();
    }

    private static PageFormat internalizePageFormat(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        PageFormat pageFormat = new PageFormat();
        Paper paper = pageFormat.getPaper();
        int n = objectInput.readInt();
        if (n == 3) {
            return null;
        }
        pageFormat.setOrientation(n);
        paper.setSize(objectInput.readDouble(), objectInput.readDouble());
        paper.setImageableArea(objectInput.readDouble(), objectInput.readDouble(), objectInput.readDouble(), objectInput.readDouble());
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public String displayName() {
        return PrintSettings.getString("CTL_Print_settings");
    }

    public static PageFormat getPageFormat(PrinterJob printerJob) {
        if (pageFormat == null) {
            pageFormat = printerJob.defaultPage();
            Paper paper = pageFormat.getPaper();
            double d = 72.0;
            paper.setImageableArea(0.5 * d, 0.5 * d, paper.getWidth() - d, paper.getHeight() - d);
            pageFormat.setPaper(paper);
        }
        return pageFormat;
    }

    public PageFormat getPageFormat() {
        if (pageFormat == null) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            pageFormat = printerJob.defaultPage(new PageFormat());
            printerJob.cancel();
        }
        return pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        if (pageFormat == null) {
            return;
        }
        if (pageFormat.equals(PrintSettings.pageFormat)) {
            return;
        }
        PageFormat pageFormat2 = PrintSettings.pageFormat;
        PrintSettings.pageFormat = pageFormat;
    }

    public PrintService getLastSelectedPrinter() {
        if (sLastPrintService == null) {
            String string = Prefs.getStringPref((String)PRINTER_NAME, (String)"");
            if (!string.equals("")) {
                PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
                for (int i = 0; i < printServiceArray.length; ++i) {
                    if (!string.equals(printServiceArray[i].getName())) continue;
                    return printServiceArray[i];
                }
            }
            return PrintServiceLookup.lookupDefaultPrintService();
        }
        return sLastPrintService;
    }

    public void setLastSelectedPrinter(PrintService printService) {
        sLastPrintService = printService;
        if (sLastPrintService != null) {
            Prefs.setStringPref((String)PRINTER_NAME, (String)sLastPrintService.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintRequestAttributeSet getLastPrintRequestAttributes(String string) {
        Object object;
        Object object2;
        PrintRequestAttributeSet printRequestAttributeSet;
        block13: {
            block11: {
                block10: {
                    printRequestAttributeSet = null;
                    if (sLastPrintRequestAttributes != null) break block11;
                    object2 = null;
                    try {
                        if (!sSerializeFile.exists() || (printRequestAttributeSet = (PrintRequestAttributeSet)((ObjectInputStream)(object2 = new ObjectInputStream(new FileInputStream(sSerializeFile)))).readObject()) == null) break block10;
                        this.clearJobSpecificOptions(printRequestAttributeSet);
                    }
                    catch (Exception exception) {
                        try {
                            Log.logException((Exception)exception);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(object2);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)object2);
                    }
                }
                IOUtils.closeQuietly(object2);
                if (printRequestAttributeSet == null) {
                    printRequestAttributeSet = new HashPrintRequestAttributeSet();
                    object = PrinterJob.getPrinterJob().getPrintService();
                    if (object != null) {
                        Object object3 = object.getDefaultAttributeValue(Media.class);
                        if (!(object3 instanceof MediaSizeName)) {
                            PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
                            float f = 72.0f;
                            printRequestAttributeSet.add(new MediaPrintableArea(0.5f, 0.5f, (float)pageFormat.getWidth() / f - 1.0f, (float)pageFormat.getHeight() / f - 1.0f, 25400));
                        } else {
                            MediaSizeName mediaSizeName = (MediaSizeName)object3;
                            MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                            if (mediaSize != null && mediaSize.getX(25400) > 1.0f && mediaSize.getY(25400) > 1.0f) {
                                printRequestAttributeSet.add(new MediaPrintableArea(0.5f, 0.5f, mediaSize.getX(25400) - 1.0f, mediaSize.getY(25400) - 1.0f, 25400));
                                printRequestAttributeSet.add(mediaSizeName);
                            }
                        }
                    }
                }
                break block13;
            }
            printRequestAttributeSet = sLastPrintRequestAttributes;
        }
        if (string != null && !((JobName)(object = new JobName(string, null))).equals(object2 = printRequestAttributeSet.get(JobName.class))) {
            this.clearJobSpecificOptions(printRequestAttributeSet);
            printRequestAttributeSet.add(new JobName(string, null));
        }
        return printRequestAttributeSet;
    }

    private void clearJobSpecificOptions(PrintRequestAttributeSet printRequestAttributeSet) {
        printRequestAttributeSet.add(new Copies(1));
        printRequestAttributeSet.add(new PageRanges(1, Integer.MAX_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastPrintRequestAttributes(PrintRequestAttributeSet printRequestAttributeSet) {
        block10: {
            sLastPrintRequestAttributes = printRequestAttributeSet;
            if (printRequestAttributeSet == null) break block10;
            ObjectOutputStream objectOutputStream = null;
            try {
                ObjectOutputStream objectOutputStream2 = null;
                try {
                    objectOutputStream2 = new ObjectOutputStream(new ByteArrayOutputStream());
                    for (Attribute attribute : printRequestAttributeSet.toArray()) {
                        try {
                            objectOutputStream2.writeObject(attribute);
                        }
                        catch (Exception exception) {
                            printRequestAttributeSet.remove(attribute);
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(objectOutputStream2);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)objectOutputStream2);
                printRequestAttributeSet.remove(DialogOwner.class);
                objectOutputStream = new ObjectOutputStream(new FileOutputStream(sSerializeFile));
                objectOutputStream.writeObject(printRequestAttributeSet);
                IOUtils.closeQuietly((OutputStream)objectOutputStream);
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
            finally {
                IOUtils.closeQuietly(objectOutputStream);
            }
        }
    }

    public boolean getWrap() {
        return wrap;
    }

    public void setWrap(boolean bl) {
        if (wrap == bl) {
            return;
        }
        wrap = bl;
    }

    public String getHeaderFormat() {
        if (headerFormat == null) {
            headerFormat = PrintSettings.getString("CTL_Header_format");
        }
        return headerFormat;
    }

    public void setHeaderFormat(String string) {
        if (string == null) {
            return;
        }
        if (string.equals(headerFormat)) {
            return;
        }
        String string2 = headerFormat;
        headerFormat = string;
    }

    public String getFooterFormat() {
        if (footerFormat == null) {
            footerFormat = PrintSettings.getString("CTL_Footer_format");
        }
        return footerFormat;
    }

    public void setFooterFormat(String string) {
        if (string == null) {
            return;
        }
        if (string.equals(footerFormat)) {
            return;
        }
        String string2 = footerFormat;
        footerFormat = string;
    }

    public Font getHeaderFont() {
        if (headerFont == null) {
            headerFont = FontPrefs.DEFAULT_CODE_FONT;
        }
        return headerFont;
    }

    public void setHeaderFont(Font font) {
        if (font == null) {
            return;
        }
        if (font.equals(headerFont)) {
            return;
        }
        Font font2 = headerFont;
        headerFont = font;
    }

    public Font getFooterFont() {
        if (footerFont == null) {
            footerFont = this.getHeaderFont();
        }
        return footerFont;
    }

    public void setFooterFont(Font font) {
        if (font == null) {
            return;
        }
        if (font.equals(footerFont)) {
            return;
        }
        Font font2 = headerFont;
        footerFont = font;
    }

    public int getHeaderAlignment() {
        return headerAlignment;
    }

    public void setHeaderAlignment(int n) {
        if (n == headerAlignment) {
            return;
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        int n2 = headerAlignment;
        headerAlignment = n;
    }

    public int getFooterAlignment() {
        return footerAlignment;
    }

    public void setFooterAlignment(int n) {
        if (n == footerAlignment) {
            return;
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        int n2 = footerAlignment;
        footerAlignment = n;
    }

    public float getLineAscentCorrection() {
        return lineAscentCorrection;
    }

    public void setLineAscentCorrection(float f) {
        if (f == lineAscentCorrection) {
            return;
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException();
        }
        float f2 = lineAscentCorrection;
        lineAscentCorrection = f;
    }

    public static String getString(String string) {
        return sRes.getString(string);
    }

    public void setPrintOptions(int n) {
        this.fPrintOptions = n;
    }

    public boolean isPrintHeader() {
        return (this.fPrintOptions & 1) != 0;
    }

    public boolean isPrintShadedBox() {
        return (this.fPrintOptions & 0xF000000) == 0x4000000;
    }

    public boolean isPrintBox() {
        return (this.fPrintOptions & 0xF000000) == 0x3000000;
    }

    public boolean isPrintSingleLine() {
        return (this.fPrintOptions & 0xF000000) == 0x1000000;
    }

    public boolean isPrintDoubleLine() {
        return (this.fPrintOptions & 0xF000000) == 0x2000000;
    }

    public boolean isPrintTwoLineHeader() {
        return this.isPrintHeader2Style() || this.isPrintHeader4Style();
    }

    public boolean isPrintHeader1Style() {
        return (this.fPrintOptions & 0xF00000) == 0x100000;
    }

    public boolean isPrintHeader2Style() {
        return (this.fPrintOptions & 0xF00000) == 0x200000;
    }

    public boolean isPrintHeader3Style() {
        return (this.fPrintOptions & 0xF00000) == 0x300000;
    }

    public boolean isPrintHeader4Style() {
        return (this.fPrintOptions & 0xF00000) == 0x400000;
    }

    public boolean isPageNum2Style() {
        return (this.fPrintOptions & 0xF0000000) == 0x20000000;
    }

    public boolean isPageNum3Style() {
        return (this.fPrintOptions & 0xF0000000) == 0x30000000;
    }

    public PrinterJob showPrintDialog(DocFlavor docFlavor, MJFrame mJFrame, PrintRequestAttributeSet printRequestAttributeSet) {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(docFlavor, new HashPrintRequestAttributeSet());
        if (printServiceArray == null || printServiceArray.length == 0) {
            PrintSettings.showNoPrintersMessage((Component)mJFrame);
            return null;
        }
        PrintService printService = this.getLastSelectedPrinter();
        boolean bl = false;
        for (PrintService printService2 : printServiceArray) {
            if (!printService2.equals(printService)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            printService = printServiceArray[0];
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        try {
            printerJob.setPrintService(printService);
        }
        catch (PrinterException printerException) {
            Log.logException((Exception)printerException);
        }
        if (PrintSettings.useNativeDialogs()) {
            printRequestAttributeSet.add(DialogTypeSelection.NATIVE);
        } else {
            printRequestAttributeSet.add(DialogTypeSelection.COMMON);
        }
        if (PrintSettings.useNativeDialogs() || PlatformInfo.isMacintosh()) {
            printRequestAttributeSet.add((Attribute)new DialogOwner((Frame)mJFrame));
            printRequestAttributeSet.remove(SunPageSelection.class);
            printerJob.setPrintable(PrintSettings.createDummyPrintable());
        }
        PrinterJob printerJob2 = null;
        try {
            if (printerJob.printDialog(printRequestAttributeSet)) {
                PrintService printService3 = printerJob.getPrintService();
                if (printService3 != null) {
                    this.setLastSelectedPrinter(printService3);
                    printRequestAttributeSet.remove(DialogTypeSelection.class);
                    if (PrintSettings.useMacNativeFixes()) {
                        printRequestAttributeSet.add(new Copies(printerJob.getCopies()));
                    }
                    this.setLastPrintRequestAttributes(printRequestAttributeSet);
                }
                printerJob2 = printerJob;
            }
        }
        catch (HeadlessException headlessException) {
            printerJob2 = null;
        }
        if (mJFrame != null && PrintSettings.useMacNativeFixes()) {
            mJFrame.toFront();
        }
        return printerJob2;
    }

    private static Printable createDummyPrintable() {
        return new Printable(){

            @Override
            public int print(Graphics graphics, PageFormat pageFormat, int n) {
                return 0;
            }
        };
    }

    public static void showNoPrintersMessage(Component component) {
        MJOptionPane.showMessageDialog((Component)component, (Object)sRes.getString("errorNoPrinters"), (String)sRes.getString("errorPrintingTitle"), (int)0);
    }

    static {
        wrap = true;
        headerAlignment = 1;
        footerAlignment = 1;
        lineAscentCorrection = 1.0f;
        sSerializeFile = new File(Prefs.getPropertyDirectory(), "TextPrintSettings.ser");
        sRes = ResourceBundle.getBundle("com.mathworks.widgets.text.resources.RES_text");
    }
}

